/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Future;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.core5.concurrent.CallbackContribution;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.function.Resolver;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.nio.command.ShutdownCommand;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.http2.nio.AsyncPingHandler;
import org.apache.hc.core5.http2.nio.command.PingCommand;
import org.apache.hc.core5.http2.nio.support.BasicPingHandler;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.ModalCloseable;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.reactor.AbstractIOSessionPool;
import org.apache.hc.core5.reactor.Command;
import org.apache.hc.core5.reactor.ConnectionInitiator;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.ssl.TransportSecurityLayer;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

class InternalH2ConnPool
implements ModalCloseable {
    private final SessionPool sessionPool;
    private volatile Resolver<HttpHost, ConnectionConfig> connectionConfigResolver;

    InternalH2ConnPool(ConnectionInitiator connectionInitiator, Resolver<HttpHost, InetSocketAddress> addressResolver, TlsStrategy tlsStrategy) {
        this.sessionPool = new SessionPool(connectionInitiator, addressResolver, tlsStrategy);
    }

    public void close(CloseMode closeMode) {
        this.sessionPool.close(closeMode);
    }

    public void close() {
        this.sessionPool.close();
    }

    private ConnectionConfig resolveConnectionConfig(HttpHost httpHost) {
        Resolver<HttpHost, ConnectionConfig> resolver = this.connectionConfigResolver;
        ConnectionConfig connectionConfig = resolver != null ? (ConnectionConfig)resolver.resolve((Object)httpHost) : null;
        return connectionConfig != null ? connectionConfig : ConnectionConfig.DEFAULT;
    }

    public Future<IOSession> getSession(HttpRoute route, Timeout connectTimeout, final FutureCallback<IOSession> callback) {
        final ConnectionConfig connectionConfig = this.resolveConnectionConfig(route.getTargetHost());
        return this.sessionPool.getSession(route, connectTimeout != null ? connectTimeout : connectionConfig.getConnectTimeout(), (FutureCallback)new CallbackContribution<IOSession>(callback){

            public void completed(IOSession ioSession) {
                Timeout socketTimeout = connectionConfig.getSocketTimeout();
                if (socketTimeout != null) {
                    ioSession.setSocketTimeout(socketTimeout);
                }
                callback.completed((Object)ioSession);
            }
        });
    }

    public void closeIdle(TimeValue idleTime) {
        this.sessionPool.closeIdle(idleTime);
    }

    public void setConnectionConfigResolver(Resolver<HttpHost, ConnectionConfig> connectionConfigResolver) {
        this.connectionConfigResolver = connectionConfigResolver;
    }

    public TimeValue getValidateAfterInactivity() {
        return this.sessionPool.validateAfterInactivity;
    }

    public void setValidateAfterInactivity(TimeValue timeValue) {
        this.sessionPool.validateAfterInactivity = timeValue;
    }

    static class SessionPool
    extends AbstractIOSessionPool<HttpRoute> {
        private final ConnectionInitiator connectionInitiator;
        private final Resolver<HttpHost, InetSocketAddress> addressResolver;
        private final TlsStrategy tlsStrategy;
        private volatile TimeValue validateAfterInactivity = TimeValue.NEG_ONE_MILLISECOND;

        SessionPool(ConnectionInitiator connectionInitiator, Resolver<HttpHost, InetSocketAddress> addressResolver, TlsStrategy tlsStrategy) {
            this.connectionInitiator = connectionInitiator;
            this.addressResolver = addressResolver;
            this.tlsStrategy = tlsStrategy;
        }

        protected Future<IOSession> connectSession(final HttpRoute route, final Timeout connectTimeout, final FutureCallback<IOSession> callback) {
            final HttpHost target = route.getTargetHost();
            InetSocketAddress localAddress = route.getLocalSocketAddress();
            InetSocketAddress remoteAddress = (InetSocketAddress)this.addressResolver.resolve((Object)target);
            return this.connectionInitiator.connect((NamedEndpoint)target, (SocketAddress)remoteAddress, (SocketAddress)localAddress, connectTimeout, null, (FutureCallback)new CallbackContribution<IOSession>(callback){

                public void completed(final IOSession ioSession) {
                    if (tlsStrategy != null && URIScheme.HTTPS.same(target.getSchemeName()) && ioSession instanceof TransportSecurityLayer) {
                        HttpHost tlsName = route.getTargetName() != null ? route.getTargetName() : target;
                        tlsStrategy.upgrade((TransportSecurityLayer)ioSession, (NamedEndpoint)tlsName, null, connectTimeout, (FutureCallback)new CallbackContribution<TransportSecurityLayer>(callback){

                            public void completed(TransportSecurityLayer transportSecurityLayer) {
                                callback.completed((Object)ioSession);
                            }
                        });
                        ioSession.setSocketTimeout(connectTimeout);
                    } else {
                        callback.completed((Object)ioSession);
                    }
                }
            });
        }

        protected void validateSession(IOSession ioSession, Callback<Boolean> callback) {
            if (ioSession.isOpen()) {
                long lastAccessTime;
                long deadline;
                TimeValue timeValue = this.validateAfterInactivity;
                if (TimeValue.isNonNegative((TimeValue)timeValue) && (deadline = (lastAccessTime = Math.min(ioSession.getLastReadTime(), ioSession.getLastWriteTime())) + timeValue.toMilliseconds()) <= System.currentTimeMillis()) {
                    Timeout socketTimeoutMillis = ioSession.getSocketTimeout();
                    ioSession.enqueue((Command)new PingCommand((AsyncPingHandler)new BasicPingHandler(result -> {
                        ioSession.setSocketTimeout(socketTimeoutMillis);
                        callback.execute(result);
                    })), Command.Priority.NORMAL);
                    return;
                }
                callback.execute((Object)true);
            } else {
                callback.execute((Object)false);
            }
        }

        protected void closeSession(IOSession ioSession, CloseMode closeMode) {
            if (closeMode == CloseMode.GRACEFUL) {
                ioSession.enqueue((Command)ShutdownCommand.GRACEFUL, Command.Priority.NORMAL);
            } else {
                ioSession.close(closeMode);
            }
        }
    }
}

