/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.config.provider;

import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.core.config.ConfigurationProperties;

public class PropertiesAdapter
implements ConfigurationProperties {
    @Nonnull
    private Properties properties;

    public PropertiesAdapter(@Nonnull Properties wrappedProperties) {
        this.properties = Constraint.isNotNull(wrappedProperties, "Wrapped Properties was null");
    }

    @Override
    @Nullable
    public String getProperty(@Nonnull String key) {
        Constraint.isNotNull(key, "Key was null");
        return this.properties.getProperty(key);
    }

    @Override
    @Nonnull
    public String getProperty(@Nonnull String key, @Nonnull String defaultValue) {
        Constraint.isNotNull(key, "Key was null");
        Constraint.isNotNull(defaultValue, "Default value was null");
        String value = this.properties.getProperty(key, defaultValue);
        assert (value != null);
        return value;
    }
}

