﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/rolesanywhere/RolesAnywhere_EXPORTS.h>
#include <aws/rolesanywhere/model/SubjectSummary.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace RolesAnywhere {
namespace Model {
class ListSubjectsResult {
 public:
  AWS_ROLESANYWHERE_API ListSubjectsResult() = default;
  AWS_ROLESANYWHERE_API ListSubjectsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_ROLESANYWHERE_API ListSubjectsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>A list of subjects.</p>
   */
  inline const Aws::Vector<SubjectSummary>& GetSubjects() const { return m_subjects; }
  template <typename SubjectsT = Aws::Vector<SubjectSummary>>
  void SetSubjects(SubjectsT&& value) {
    m_subjectsHasBeenSet = true;
    m_subjects = std::forward<SubjectsT>(value);
  }
  template <typename SubjectsT = Aws::Vector<SubjectSummary>>
  ListSubjectsResult& WithSubjects(SubjectsT&& value) {
    SetSubjects(std::forward<SubjectsT>(value));
    return *this;
  }
  template <typename SubjectsT = SubjectSummary>
  ListSubjectsResult& AddSubjects(SubjectsT&& value) {
    m_subjectsHasBeenSet = true;
    m_subjects.emplace_back(std::forward<SubjectsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A token that indicates where the output should continue from, if a previous
   * request did not show all results. To get the next results, make the request
   * again with this value.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListSubjectsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListSubjectsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<SubjectSummary> m_subjects;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_subjectsHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace RolesAnywhere
}  // namespace Aws
