/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.save.xml;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import tim.prune.data.DataPoint;
import tim.prune.data.Field;
import tim.prune.data.FieldGpx;
import tim.prune.data.FieldXml;
import tim.prune.data.FileInfo;
import tim.prune.data.FileType;
import tim.prune.data.MediaObject;
import tim.prune.gui.ProgressDialog;
import tim.prune.save.SettingsForExport;
import tim.prune.save.xml.GpxVersion;
import tim.prune.save.xml.GpxWriter;
import tim.prune.save.xml.HeaderCombiner;

public class GpxWriter10
extends GpxWriter {
    public GpxWriter10(ProgressDialog progressDialog, SettingsForExport settingsForExport) {
        super(progressDialog, settingsForExport);
    }

    @Override
    protected String getDefaultGpxHeader() {
        return "<gpx version=\"1.0\" creator=\"GpsPrune v26.1 activityworkshop.net\"\n xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n xmlns=\"http://www.topografix.com/GPX/1/0\" xsi:schemaLocation=\"http://www.topografix.com/GPX/1/0 http://www.topografix.com/GPX/1/0/gpx.xsd\">";
    }

    private String getDefaultSchemaLocation() {
        return "http://www.topografix.com/GPX/1/0 http://www.topografix.com/GPX/1/0/gpx.xsd";
    }

    @Override
    protected String getGpxHeader(FileInfo fileInfo) {
        HeaderCombiner headerCombiner = new HeaderCombiner(GpxVersion.GPX_1_0);
        int n = 0;
        while (n < fileInfo.getNumFiles()) {
            headerCombiner.addSourceInfo(fileInfo.getSource(n));
            ++n;
        }
        return "<gpx version=\"1.0\" creator=\"GpsPrune v26.1 activityworkshop.net\"\n xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n xmlns=\"http://www.topografix.com/GPX/1/0\"\n xsi:schemaLocation=\"" + headerCombiner.getAllLocations(this.getDefaultSchemaLocation()) + "\"\n" + headerCombiner.getNamespaces() + ">";
    }

    @Override
    protected void writeMetadata(OutputStreamWriter outputStreamWriter, String string, String string2) throws IOException {
        GpxWriter10.writeNameAndDescription(outputStreamWriter, string, string2, "\t");
    }

    @Override
    protected boolean versionSupportsPointLinks() {
        return false;
    }

    @Override
    protected boolean versionSupportsTag(FieldGpx fieldGpx) {
        return true;
    }

    @Override
    protected String makeMediaLink(MediaObject mediaObject) {
        if (mediaObject.getFile() != null) {
            return "<url>" + mediaObject.getFile().getAbsolutePath() + "</url>";
        }
        if (mediaObject.getUrl() != null) {
            return "<url>" + mediaObject.getUrl() + "</url>";
        }
        return "";
    }

    @Override
    protected void exportWaypointExtensions(DataPoint dataPoint, Writer writer) throws IOException {
        for (Field field : dataPoint.getFieldList().getFields(FileType.GPX)) {
            FieldXml fieldXml;
            String string;
            if (!(field instanceof FieldXml) || GpxWriter10.isEmpty(string = dataPoint.getFieldValue(fieldXml = (FieldXml)field))) continue;
            writer.write("\t\t\t\t");
            writer.write(fieldXml.getTag(string));
            writer.write("\n");
        }
    }

    @Override
    protected void exportTrackpointExtensions(DataPoint dataPoint, Writer writer) throws IOException {
        this.exportWaypointExtensions(dataPoint, writer);
    }
}

