/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.internal.metadata;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Writer;
import org.gradle.api.publish.internal.metadata.ModuleMetadataJsonWriter;
import org.gradle.api.publish.internal.metadata.ModuleMetadataSpec;
import org.gradle.internal.hash.ChecksumService;
import org.gradle.internal.scopeids.id.BuildInvocationScopeId;

public class GradleModuleMetadataWriter {
    private final BuildInvocationScopeId buildInvocationScopeId;
    private final ChecksumService checksumService;

    public GradleModuleMetadataWriter(BuildInvocationScopeId buildInvocationScopeId, ChecksumService checksumService) {
        this.buildInvocationScopeId = buildInvocationScopeId;
        this.checksumService = checksumService;
    }

    public void writeTo(Writer writer, ModuleMetadataSpec metadata) throws IOException {
        JsonWriter jsonWriter = new JsonWriter(writer);
        jsonWriter.setHtmlSafe(false);
        jsonWriter.setIndent("  ");
        new ModuleMetadataJsonWriter(jsonWriter, metadata, metadata.mustIncludeBuildId ? this.buildInvocationScopeId.getId().asString() : null, this.checksumService).write();
        jsonWriter.flush();
        writer.append('\n');
    }
}

