/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Modifier;
import javax.tools.Diagnostic;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.support.FixFactory;
import org.openide.util.NbBundle;

public class RemoveInvalidModifier
implements ErrorRule<Void> {
    public static final String ERROR_PATTERN = "modifier (.+?) not allowed here";
    private static final Set<String> CODES = new HashSet<String>(Arrays.asList("compiler.err.mod.not.allowed.here"));

    public Set<String> getCodes() {
        return CODES;
    }

    public List<Fix> run(CompilationInfo compilationInfo, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        EnumSet<Tree.Kind[]> supportedKinds = EnumSet.of(Tree.Kind.ANNOTATION_TYPE, new Tree.Kind[]{Tree.Kind.CLASS, Tree.Kind.ENUM, Tree.Kind.VARIABLE, Tree.Kind.INTERFACE, Tree.Kind.METHOD});
        boolean isSupported = supportedKinds.contains((Object)treePath.getLeaf().getKind());
        if (!isSupported) {
            return null;
        }
        String invalidMod = this.getInvalidModifier(compilationInfo, treePath, CODES);
        if (null == invalidMod) {
            return null;
        }
        Collection<Modifier> modss = this.convertToModifiers(invalidMod.split(","));
        TreePath modifierTreePath = TreePath.getPath(treePath, (Tree)this.getModifierTree(treePath));
        EnumSet<Modifier> modifiers = EnumSet.noneOf(Modifier.class);
        modifiers.addAll(modss);
        Fix removeModifiersFix = FixFactory.removeModifiersFix((CompilationInfo)compilationInfo, (TreePath)modifierTreePath, modifiers, (String)NbBundle.getMessage(RemoveInvalidModifier.class, (String)"FIX_RemoveInvalidModifier", (Object)invalidMod, (Object)modss.size()));
        return Arrays.asList(removeModifiersFix);
    }

    public void cancel() {
    }

    public String getId() {
        return RemoveInvalidModifier.class.getName();
    }

    public String getDisplayName() {
        return NbBundle.getMessage(RemoveInvalidModifier.class, (String)"DN_RemoveInvalidModifier");
    }

    public String getDescription() {
        return NbBundle.getMessage(RemoveInvalidModifier.class, (String)"DESC_RemoveInvalidModifier");
    }

    private Diagnostic getDiagnostic(CompilationInfo compilationInfo, long start, Set<String> errorCodes) {
        Diagnostic result = null;
        for (Diagnostic d : compilationInfo.getDiagnostics()) {
            if (start != d.getStartPosition() || !errorCodes.contains(d.getCode())) continue;
            result = d;
        }
        return result;
    }

    private String getInvalidModifier(CompilationInfo compilationInfo, TreePath treePath, Set<String> codes) {
        long start = compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), treePath.getLeaf());
        Diagnostic diagnostic = this.getDiagnostic(compilationInfo, start, codes);
        if (null == diagnostic) {
            return null;
        }
        String message = diagnostic.getMessage(Locale.ENGLISH);
        Matcher matcher = Pattern.compile(ERROR_PATTERN).matcher(message);
        if (!matcher.find()) {
            return null;
        }
        return matcher.group(1);
    }

    private Collection<Modifier> convertToModifiers(String ... mods) {
        HashMap<String, Modifier> map = new HashMap<String, Modifier>();
        for (Modifier modifier : Modifier.values()) {
            map.put(modifier.toString(), modifier);
        }
        ArrayList<Modifier> result = new ArrayList<Modifier>();
        for (String string : mods) {
            result.add((Modifier)((Object)map.get(string)));
        }
        return result;
    }

    private ModifiersTree getModifierTree(TreePath treePath) {
        Tree.Kind kind = treePath.getLeaf().getKind();
        switch (kind) {
            case ANNOTATION_TYPE: 
            case CLASS: 
            case ENUM: 
            case INTERFACE: {
                return ((ClassTree)treePath.getLeaf()).getModifiers();
            }
            case VARIABLE: {
                return ((VariableTree)treePath.getLeaf()).getModifiers();
            }
            case METHOD: {
                return ((MethodTree)treePath.getLeaf()).getModifiers();
            }
        }
        throw new UnsupportedOperationException("kind " + String.valueOf((Object)kind) + " not yet suppported");
    }
}

