/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jdk;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.CodeStyle;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.editor.java.Utilities;
import org.netbeans.modules.java.hints.jdk.Bundle;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.netbeans.spi.java.hints.MatcherUtilities;
import org.openide.filesystems.FileObject;

public class ConvertToPatternInstanceOf {
    public static ErrorDescription trivial(final HintContext ctx) {
        if (!MatcherUtilities.matches((HintContext)ctx, (TreePath)ctx.getPath(), (String)"if ($expr instanceof $typeI) { $typeV $var = ($typeC) $expr; $other$;} else $else$;", (boolean)true)) {
            final HashSet<TreePath> convertPath = new HashSet<TreePath>();
            new TreePathScanner<Void, Void>(){

                @Override
                public Void visitTypeCast(TypeCastTree node, Void p) {
                    if (MatcherUtilities.matches((HintContext)ctx, (TreePath)this.getCurrentPath(), (String)"($typeI) $expr")) {
                        convertPath.add(this.getCurrentPath());
                    }
                    return (Void)super.visitTypeCast(node, p);
                }
            }.scan(ctx.getPath(), (Void)null);
            if (!convertPath.isEmpty()) {
                TreePath typeI = (TreePath)ctx.getVariables().get("$typeI");
                TypeMirror typeITM = ctx.getInfo().getTrees().getTypeMirror(typeI);
                List varNameCandidates = Utilities.varNamesSuggestions((TypeMirror)typeITM, (ElementKind)ElementKind.LOCAL_VARIABLE, EnumSet.noneOf(Modifier.class), null, null, (Types)ctx.getInfo().getTypes(), (Elements)ctx.getInfo().getElements(), Collections.emptyList(), (CodeStyle)CodeStyle.getDefault((FileObject)ctx.getInfo().getFileObject()));
                String varName = org.netbeans.modules.java.hints.errors.Utilities.makeNameUnique(ctx.getInfo(), ctx.getInfo().getTrees().getScope(ctx.getPath()), (String)varNameCandidates.get(0));
                Fix fix = new FixImpl(ctx.getInfo(), ctx.getPath(), varName, false, convertPath).toEditorFix();
                return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)Bundle.ERR_ConvertToPatternInstanceOf(), (Fix[])new Fix[]{fix});
            }
            return null;
        }
        if (((Collection)ctx.getMultiVariables().get("$other$")).isEmpty()) {
            return null;
        }
        TypeMirror typeI = ctx.getInfo().getTrees().getTypeMirror((TreePath)ctx.getVariables().get("$typeI"));
        TypeMirror typeC = ctx.getInfo().getTrees().getTypeMirror((TreePath)ctx.getVariables().get("$typeC"));
        if (!ctx.getInfo().getTypes().isSameType(typeI, typeC)) {
            System.err.println("different types (" + String.valueOf(typeI) + ", " + String.valueOf(typeC) + ") in " + String.valueOf(ctx.getInfo().getFileObject()));
            return null;
        }
        IfTree it = (IfTree)ctx.getPath().getLeaf();
        BlockTree bt = (BlockTree)it.getThenStatement();
        VariableTree var = (VariableTree)bt.getStatements().get(0);
        Fix fix = new FixImpl(ctx.getInfo(), ctx.getPath(), var.getName().toString(), true, Collections.emptySet()).toEditorFix();
        return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)Bundle.ERR_ConvertToPatternInstanceOf(), (Fix[])new Fix[]{fix});
    }

    private static final class FixImpl
    extends JavaFix {
        private final String varName;
        private final boolean removeFirst;
        private final Set<TreePathHandle> replaceOccurrences;

        public FixImpl(CompilationInfo info, TreePath main, String varName, boolean removeFirst, Set<TreePath> replaceOccurrences) {
            super(info, main);
            this.varName = varName;
            this.removeFirst = removeFirst;
            this.replaceOccurrences = replaceOccurrences.stream().map(tp -> TreePathHandle.create((TreePath)tp, (CompilationInfo)info)).collect(Collectors.toSet());
        }

        protected String getText() {
            return Bundle.FIX_ConvertToPatternInstanceOf();
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) {
            WorkingCopy wc = ctx.getWorkingCopy();
            TreePath main = ctx.getPath();
            IfTree it = (IfTree)main.getLeaf();
            InstanceOfTree iot = (InstanceOfTree)((ParenthesizedTree)it.getCondition()).getExpression();
            StatementTree bt = it.getThenStatement();
            InstanceOfTree cond = wc.getTreeMaker().InstanceOf(iot.getExpression(), wc.getTreeMaker().BindingPattern(wc.getTreeMaker().Variable(wc.getTreeMaker().Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)this.varName, iot.getType(), null)));
            StatementTree thenBlock = this.removeFirst ? wc.getTreeMaker().removeBlockStatement((BlockTree)bt, 0) : bt;
            wc.rewrite((Tree)it, (Tree)wc.getTreeMaker().If((ExpressionTree)wc.getTreeMaker().Parenthesized((ExpressionTree)cond), thenBlock, it.getElseStatement()));
            this.replaceOccurrences.stream().map(tph -> tph.resolve((CompilationInfo)wc)).forEach(tp -> {
                if (!this.removeFirst && tp.getParentPath().getLeaf().getKind() == Tree.Kind.PARENTHESIZED) {
                    tp = tp.getParentPath();
                }
                wc.rewrite(tp.getLeaf(), (Tree)wc.getTreeMaker().Identifier((CharSequence)this.varName));
            });
        }
    }
}

