/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.breadcrumb;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.breadcrumb.BreadCrumb;
import org.primefaces.component.menu.AbstractMenu;
import org.primefaces.component.menu.BaseMenuRenderer;
import org.primefaces.model.menu.MenuElement;
import org.primefaces.model.menu.MenuItem;

public class BreadCrumbRenderer
extends BaseMenuRenderer {
    protected void encodeMarkup(FacesContext context, AbstractMenu menu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        BreadCrumb breadCrumb = (BreadCrumb)menu;
        String clientId = breadCrumb.getClientId(context);
        String styleClass = breadCrumb.getStyleClass();
        styleClass = styleClass == null ? "ui-breadcrumb ui-module ui-widget ui-widget-header ui-helper-clearfix ui-corner-all" : "ui-breadcrumb ui-module ui-widget ui-widget-header ui-helper-clearfix ui-corner-all " + styleClass;
        int elementCount = menu.getElementsCount();
        List menuElements = menu.getElements();
        boolean isIconHome = breadCrumb.getHomeDisplay().equals("icon");
        if (isIconHome && elementCount > 0) {
            ((MenuItem)menuElements.get(0)).setStyleClass("ui-icon ui-icon-home");
        }
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.writeAttribute("role", (Object)"menu", null);
        if (breadCrumb.getStyle() != null) {
            writer.writeAttribute("style", (Object)breadCrumb.getStyle(), null);
        }
        if (elementCount > 0) {
            writer.startElement("ul", null);
            for (int i = 0; i < elementCount; ++i) {
                MenuElement element = (MenuElement)menuElements.get(i);
                if (!element.isRendered() || !(element instanceof MenuItem)) continue;
                MenuItem item = (MenuItem)element;
                if (i != 0) {
                    writer.startElement("li", null);
                    writer.writeAttribute("class", (Object)"ui-breadcrumb-chevron ui-icon ui-icon-triangle-1-e", null);
                    writer.endElement("li");
                }
                writer.startElement("li", null);
                writer.writeAttribute("role", (Object)"menuitem", null);
                if (item.isDisabled()) {
                    this.encodeDisabledMenuItem(context, item);
                } else {
                    this.encodeMenuItem(context, menu, item);
                }
                writer.endElement("li");
            }
            writer.endElement("ul");
        }
        writer.endElement("div");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void encodeScript(FacesContext context, AbstractMenu abstractMenu) throws IOException {
    }

    private void encodeDisabledMenuItem(FacesContext context, MenuItem menuItem) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String style = menuItem.getStyle();
        String styleClass = menuItem.getStyleClass();
        styleClass = styleClass == null ? "ui-menuitem-link ui-corner-all" : "ui-menuitem-link ui-corner-all " + styleClass;
        styleClass = styleClass + " ui-state-disabled";
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-menuitem-text", null);
        writer.writeText((Object)((String)menuItem.getValue()), "value");
        writer.endElement("span");
        writer.endElement("span");
    }
}

