/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Action;
import org.netbeans.api.debugger.jpda.Field;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.TreeModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public class VariablesTreeModelFilterSI
implements TreeModelFilter,
NodeModel,
TableModel,
NodeActionsProvider {
    public static final String INHERITED = "org/netbeans/modules/debugger/resources/watchesView/SuperVariable";
    public static final String STATIC = "org/netbeans/modules/debugger/resources/watchesView/SuperVariable";
    private static final Set ignore = new HashSet<String>(Arrays.asList("java.lang.String", "java.lang.StringBuffer", "java.lang.Character", "java.lang.Integer", "java.lang.Float", "java.lang.Byte", "java.lang.Boolean", "java.lang.Double", "java.lang.Long", "java.lang.Short", "java.util.ArrayList", "java.util.HashSet", "java.util.LinkedHashSet", "java.util.LinkedList", "java.util.Stack", "java.util.TreeSet", "java.util.Vector", "java.util.Hashtable", "java.util.Hashtable$Entry", "java.util.HashMap", "java.util.HashMap$Entry", "java.util.IdentityHashMap", "java.util.AbstractMap$SimpleEntry", "java.util.TreeMap", "java.util.TreeMap$Entry", "java.util.WeakHashMap", "java.util.LinkedHashMap", "java.util.LinkedHashMap$Entry"));
    private ContextProvider lookupProvider;

    public VariablesTreeModelFilterSI(ContextProvider lookupProvider) {
        this.lookupProvider = lookupProvider;
    }

    public Object getRoot(TreeModel original) {
        return original.getRoot();
    }

    public Object[] getChildren(TreeModel original, Object parent, int from, int to) throws UnknownTypeException {
        if (parent instanceof ObjectVariable) {
            ObjectVariable variable = (ObjectVariable)parent;
            if (ignore.contains(variable.getType())) {
                return original.getChildren(parent, from, to);
            }
            int tto = Math.min(to, original.getChildrenCount(parent));
            ArrayList<Object> l = new ArrayList<Object>(Arrays.asList(original.getChildren(parent, from, tto)));
            if (l.size() < to && variable.getAllStaticFields(0, 0).length > 0) {
                l.add(new StaticNode(variable));
            }
            if (l.size() < to && variable.getInheritedFields(0, 0).length > 0) {
                l.add(new InheritedNode(variable));
            }
            return l.toArray();
        }
        if (parent instanceof SpecialNode) {
            return ((SpecialNode)parent).getChildren(0, 0);
        }
        return original.getChildren(parent, from, to);
    }

    public int getChildrenCount(TreeModel original, Object parent) throws UnknownTypeException {
        if (parent instanceof ObjectVariable) {
            ObjectVariable variable = (ObjectVariable)parent;
            if (ignore.contains(variable.getType())) {
                return original.getChildrenCount(parent);
            }
            int i = original.getChildrenCount(parent);
            if (i == Integer.MAX_VALUE) {
                return i;
            }
            if (variable.getAllStaticFields(0, 0).length > 0) {
                ++i;
            }
            if (variable.getInheritedFields(0, 0).length > 0) {
                ++i;
            }
            return i;
        }
        if (parent instanceof SpecialNode) {
            return ((SpecialNode)parent).getChildren(0, 0).length;
        }
        return original.getChildrenCount(parent);
    }

    public boolean isLeaf(TreeModel original, Object node) throws UnknownTypeException {
        return node instanceof SpecialNode ? false : original.isLeaf(node);
    }

    public void addModelListener(ModelListener l) {
    }

    public void removeModelListener(ModelListener l) {
    }

    public String getDisplayName(Object node) throws UnknownTypeException {
        if (node instanceof SpecialNode) {
            return ((SpecialNode)node).getDisplayName();
        }
        throw new UnknownTypeException(node);
    }

    public String getIconBase(Object node) throws UnknownTypeException {
        if (node instanceof SpecialNode) {
            return ((SpecialNode)node).getIconBase();
        }
        throw new UnknownTypeException(node);
    }

    public String getShortDescription(Object node) throws UnknownTypeException {
        if (node instanceof SpecialNode) {
            return null;
        }
        throw new UnknownTypeException(node);
    }

    public Action[] getActions(Object node) throws UnknownTypeException {
        if (node instanceof SpecialNode) {
            return new Action[0];
        }
        throw new UnknownTypeException(node);
    }

    public void performDefaultAction(Object node) throws UnknownTypeException {
        if (node instanceof SpecialNode) {
            return;
        }
        throw new UnknownTypeException(node);
    }

    public Object getValueAt(Object row, String columnID) throws UnknownTypeException {
        if (row instanceof SpecialNode) {
            return "";
        }
        throw new UnknownTypeException(row);
    }

    public boolean isReadOnly(Object row, String columnID) throws UnknownTypeException {
        if (row instanceof SpecialNode) {
            return true;
        }
        throw new UnknownTypeException(row);
    }

    public void setValueAt(Object row, String columnID, Object value) throws UnknownTypeException {
        if (row instanceof SpecialNode) {
            return;
        }
        throw new UnknownTypeException(row);
    }

    private static class StaticNode
    extends SpecialNode {
        StaticNode(ObjectVariable parent) {
            super(parent);
        }

        @Override
        Field[] getChildren(int from, int to) {
            return this.object.getAllStaticFields(0, 0);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StaticNode)) {
                return false;
            }
            return this.object.equals((Object)((StaticNode)o).object);
        }

        @Override
        String getDisplayName() {
            return NbBundle.getBundle(VariablesTreeModelFilterSI.class).getString("MSG_VariablesFilter_StaticNode");
        }

        @Override
        String getIconBase() {
            return "org/netbeans/modules/debugger/resources/watchesView/SuperVariable";
        }
    }

    private static class InheritedNode
    extends SpecialNode {
        InheritedNode(ObjectVariable object) {
            super(object);
        }

        @Override
        Field[] getChildren(int from, int to) {
            return this.object.getInheritedFields(0, 0);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof InheritedNode)) {
                return false;
            }
            return this.object.equals((Object)((InheritedNode)o).object);
        }

        @Override
        String getDisplayName() {
            return NbBundle.getBundle(VariablesTreeModelFilterSI.class).getString("MSG_VariablesFilter_InheritedNode");
        }

        @Override
        String getIconBase() {
            return "org/netbeans/modules/debugger/resources/watchesView/SuperVariable";
        }
    }

    private static abstract class SpecialNode {
        protected ObjectVariable object;

        protected SpecialNode(ObjectVariable parent) {
            this.object = parent;
        }

        public int hashCode() {
            return this.object.hashCode();
        }

        abstract Field[] getChildren(int var1, int var2);

        abstract String getDisplayName();

        abstract String getIconBase();
    }
}

