/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.pull;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import org.netbeans.modules.mercurial.FileInformation;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.commit.CommitAction;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.ui.merge.MergeAction;
import org.netbeans.modules.mercurial.ui.pull.Bundle;
import org.netbeans.modules.mercurial.ui.pull.FetchAction;
import org.netbeans.modules.mercurial.ui.queues.QGoToPatchAction;
import org.netbeans.modules.mercurial.ui.queues.QPatch;
import org.netbeans.modules.mercurial.ui.rebase.RebaseAction;
import org.netbeans.modules.mercurial.ui.repository.HgURL;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgProjectUtils;
import org.netbeans.modules.mercurial.util.HgRepositoryContextCache;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.SystemActionBridge;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public class PullAction
extends ContextAction {
    private static final String CHANGESET_FILES_PREFIX = "files:";

    private static void logCommand(String fromPrjName, OutputLogger logger, HgURL pullSource, String toPrjName, File root) throws MissingResourceException {
        if (fromPrjName != null) {
            logger.outputInRed(NbBundle.getMessage(PullAction.class, (String)"MSG_PULL_FROM", (Object)fromPrjName, (Object)HgUtils.stripDoubleSlash(pullSource.toString())));
        } else {
            logger.outputInRed(NbBundle.getMessage(PullAction.class, (String)"MSG_PULL_FROM_NONAME", (Object)HgUtils.stripDoubleSlash(pullSource.toString())));
        }
        if (toPrjName != null) {
            logger.outputInRed(NbBundle.getMessage(PullAction.class, (String)"MSG_PULL_TO", (Object)toPrjName, (Object)root));
        } else {
            logger.outputInRed(NbBundle.getMessage(PullAction.class, (String)"MSG_PULL_TO_NONAME", (Object)root));
        }
    }

    @Override
    protected boolean enable(Node[] nodes) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        return HgUtils.isFromHgRepository(context);
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_PullLocal";
    }

    @Override
    public String getName(String role, Node[] activatedNodes) {
        VCSContext ctx = HgUtils.getCurrentContext(activatedNodes);
        Set<File> roots = HgUtils.getRepositoryRoots(ctx);
        String name = roots.size() == 1 ? "CTL_MenuItem_PullRoot" : "CTL_MenuItem_PullLocal";
        return roots.size() == 1 ? NbBundle.getMessage(PullAction.class, (String)name, (Object)roots.iterator().next().getName()) : NbBundle.getMessage(PullAction.class, (String)name);
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        final Set<File> repositoryRoots = HgUtils.getRepositoryRoots(context);
        Mercurial.getInstance().getRequestProcessor().post(new Runnable(){
            final /* synthetic */ PullAction this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                Iterator iterator = repositoryRoots.iterator();
                while (iterator.hasNext()) {
                    File repositoryRoot;
                    final File repository = repositoryRoot = (File)iterator.next();
                    RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(repository);
                    HgProgressSupport support = new HgProgressSupport(this){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void perform() {
                            PullAction.getDefaultAndPerformPull(repository, null, null, this);
                        }
                    };
                    support.start(rp, repository, NbBundle.getMessage(PullAction.class, (String)"MSG_PULL_PROGRESS")).waitFinished();
                    if (!support.isCanceled()) continue;
                    break;
                }
            }
        });
    }

    public static boolean confirmWithLocalChanges(File rootFile, Class bundleLocation, String title, String query, List<String> listIncoming, OutputLogger logger) {
        FileStatusCache cache = Mercurial.getInstance().getFileStatusCache();
        File[] roots = HgUtils.splitIntoSeenRoots(rootFile);
        File[] localModNewFiles = cache.listFiles(roots, 84);
        ArrayList<String> listIncomingAndLocalMod = new ArrayList<String>();
        HashSet<String> setFiles = new HashSet<String>();
        String root = rootFile.getAbsolutePath();
        for (String s : listIncoming) {
            String filesStr;
            String[] aFileStr;
            String[] stringArray;
            int n;
            int n2;
            if (s.indexOf(CHANGESET_FILES_PREFIX) != 0 || (n2 = 0) >= (n = (stringArray = (aFileStr = (filesStr = s.substring(CHANGESET_FILES_PREFIX.length()).trim()).split(" "))).length)) continue;
            String fileStr = stringArray[n2];
            setFiles.add(root + File.separator + fileStr);
        }
        for (File f : localModNewFiles) {
            for (String s : setFiles) {
                if (!s.equals(f.getAbsolutePath())) continue;
                listIncomingAndLocalMod.add(s);
            }
        }
        if (listIncomingAndLocalMod.size() > 0) {
            logger.outputInRed(NbBundle.getMessage(PullAction.class, (String)"MSG_PULL_OVERWRITE_LOCAL"));
            logger.output(listIncomingAndLocalMod);
            int response = JOptionPane.showOptionDialog(Utilities.findDialogParent(), NbBundle.getMessage((Class)bundleLocation, (String)query), NbBundle.getMessage((Class)bundleLocation, (String)title), 0, 3, null, null, null);
            if (response == 1) {
                return false;
            }
        }
        return true;
    }

    static void annotateChangeSets(List<String> list, Class bundleLocation, String title, OutputLogger logger) {
        logger.outputInRed(NbBundle.getMessage((Class)bundleLocation, (String)title));
        for (String s : list) {
            if (s.indexOf("changeset:") == 0) {
                logger.outputInRed(s);
                continue;
            }
            if (s.equals("")) continue;
            logger.output(s);
        }
        logger.output("");
    }

    public static void getDefaultAndPerformPull(File root, String revision, String branch, HgProgressSupport supp) {
        PullType pullType;
        String fromPrjName;
        HgURL pullSource;
        OutputLogger logger = supp.getLogger();
        String pullSourceString = HgRepositoryContextCache.getInstance().getPullDefault(root);
        if (HgUtils.isNullOrEmpty(pullSourceString)) {
            PullAction.notifyDefaultPullUrlNotSpecified(logger);
            return;
        }
        try {
            pullSource = new HgURL(pullSourceString);
        }
        catch (URISyntaxException ex) {
            File sourceRoot = new File(root, pullSourceString);
            if (sourceRoot.isDirectory()) {
                pullSource = new HgURL(FileUtil.normalizeFile((File)sourceRoot));
            }
            PullAction.notifyDefaultPullUrlInvalid(pullSourceString, ex.getReason(), logger);
            return;
        }
        if (pullSource.isFile()) {
            fromPrjName = HgProjectUtils.getProjectName(new File(pullSource.getPath()));
            pullType = fromPrjName != null ? PullType.LOCAL : PullType.OTHER;
        } else {
            fromPrjName = null;
            pullType = PullType.OTHER;
        }
        String toPrjName = HgProjectUtils.getProjectName(root);
        PullAction.performPull(pullType, root, pullSource, fromPrjName, toPrjName, revision, branch, supp);
    }

    private static void notifyDefaultPullUrlNotSpecified(OutputLogger logger) {
        String title = PullAction.getMessage("MSG_PULL_TITLE", new String[0]);
        logger.outputInRed(title);
        logger.outputInRed(PullAction.getMessage("MSG_PULL_TITLE_SEP", new String[0]));
        logger.output(PullAction.getMessage("MSG_NO_DEFAULT_PULL_SET_MSG", new String[0]));
        logger.outputInRed(PullAction.getMessage("MSG_PULL_DONE", new String[0]));
        logger.output("");
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)PullAction.getMessage("MSG_NO_DEFAULT_PULL_SET", new String[0])));
    }

    private static void notifyDefaultPullUrlInvalid(String pullUrl, String reason, OutputLogger logger) {
        String title = PullAction.getMessage("MSG_PULL_TITLE", new String[0]);
        String msg = PullAction.getMessage("MSG_DEFAULT_PULL_INVALID", pullUrl);
        logger.outputInRed(title);
        logger.outputInRed(PullAction.getMessage("MSG_PULL_TITLE_SEP", new String[0]));
        logger.output(msg);
        logger.outputInRed(PullAction.getMessage("MSG_PULL_DONE", new String[0]));
        logger.output("");
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void performPull(PullType type, File root, HgURL pullSource, String fromPrjName, String toPrjName, String revision, String branch, HgProgressSupport supp) {
        if (root == null || pullSource == null) {
            return;
        }
        File bundleFile = null;
        OutputLogger logger = supp.getLogger();
        try {
            List<String> listIncoming;
            logger.outputInRed(NbBundle.getMessage(PullAction.class, (String)"MSG_PULL_TITLE"));
            logger.outputInRed(NbBundle.getMessage(PullAction.class, (String)"MSG_PULL_TITLE_SEP"));
            PullAction.logCommand(fromPrjName, logger, pullSource, toPrjName, root);
            supp.setDisplayName(Bundle.MSG_PullAction_progress_incoming());
            if (type == PullType.LOCAL) {
                listIncoming = HgCommand.doIncoming(root, revision, branch, logger);
            } else {
                for (int i = 0; i < 10000; ++i) {
                    if (new File(root.getParentFile(), root.getName() + "_bundle" + i).exists()) continue;
                    bundleFile = new File(root.getParentFile(), root.getName() + "_bundle" + i);
                    break;
                }
                listIncoming = HgCommand.doIncoming(root, pullSource, revision, branch, bundleFile, logger, false);
            }
            if (listIncoming == null || listIncoming.isEmpty()) {
                return;
            }
            boolean bNoChanges = false;
            ListIterator<String> it = listIncoming.listIterator(listIncoming.size());
            while (it.hasPrevious() && !(bNoChanges = HgCommand.isNoChanges(it.previous()))) {
            }
            Boolean localChangesConfirmed = false;
            if (!bNoChanges && Boolean.getBoolean("versioning.mercurial.checkForModificationsBeforePull") && Boolean.FALSE.equals(localChangesConfirmed = PullAction.confirmOverallModifications(root, supp))) {
                logger.outputInRed(Bundle.MSG_PULL_LOCALMODS_CANCEL());
                logger.output("");
                return;
            }
            if (!(bNoChanges || Boolean.TRUE.equals(localChangesConfirmed) || PullAction.confirmWithLocalChanges(root, PullAction.class, "MSG_PULL_LOCALMODS_CONFIRM_TITLE", "MSG_PULL_LOCALMODS_CONFIRM_QUERY", listIncoming, logger))) {
                logger.outputInRed(Bundle.MSG_PULL_LOCALMODS_CANCEL());
                logger.output("");
                return;
            }
            if (bNoChanges || supp.isCanceled()) {
                logger.output(HgUtils.replaceHttpPassword(listIncoming));
            } else {
                HgUtils.runWithoutIndexing(new PullImpl(supp, root, type, revision, branch, bundleFile, listIncoming), root);
            }
        }
        catch (HgException.HgCommandCanceledException listIncoming) {
        }
        catch (HgException ex) {
            HgUtils.notifyException(ex);
        }
        finally {
            if (bundleFile != null) {
                bundleFile.delete();
            }
            logger.outputInRed(NbBundle.getMessage(PullAction.class, (String)"MSG_PULL_DONE"));
            logger.output("");
            pullSource.clearPassword();
        }
    }

    private static Boolean confirmOverallModifications(File root, HgProgressSupport supp) {
        Boolean confirmed = null;
        supp.setDisplayName(Bundle.MSG_PullAction_progress_checkForModifications());
        int interestingStatus = 6608;
        try {
            Map<File, FileInformation> statuses = HgCommand.getStatus(root, Collections.singletonList(root), null, null, false);
            for (Map.Entry<File, FileInformation> e : statuses.entrySet()) {
                FileInformation info = e.getValue();
                if ((info.getStatus() & interestingStatus) == 0) continue;
                confirmed = 0 == JOptionPane.showConfirmDialog(Utilities.findDialogParent(), Bundle.MSG_PullAction_localModifications_text(), Bundle.LBL_PullAction_localModifications_title(), 0, 3);
                break;
            }
        }
        catch (HgException ex) {
            Mercurial.LOG.log(Level.INFO, null, ex);
        }
        return confirmed;
    }

    private static String getMessage(String msgKey, String ... args) {
        return NbBundle.getMessage(PullAction.class, (String)msgKey, (Object[])args);
    }

    private static boolean isRebaseAllowed(File reposiory, List<HgLogMessage> parents) {
        try {
            if (parents.size() == 1 && parents.get(0).getCSetShortID().equals(HgCommand.getParents(reposiory, null, null).get(0).getCSetShortID())) {
                return true;
            }
        }
        catch (HgException.HgCommandCanceledException hgCommandCanceledException) {
        }
        catch (HgException ex) {
            Logger.getLogger(PullAction.class.getName()).log(Level.INFO, null, ex);
        }
        return false;
    }

    public static enum PullType {
        LOCAL,
        OTHER;

    }

    private static class PullImpl
    implements Callable<Void> {
        private QPatch topPatch;
        private final HgProgressSupport supp;
        private final File root;
        private final PullType type;
        private final String revision;
        private final String branch;
        private final File fileToUnbundle;
        private final List<String> listIncoming;
        private boolean rebaseAccepted;
        private boolean mergeAccepted;

        public PullImpl(HgProgressSupport supp, File root, PullType type, String revision, String branch, File fileToUnbundle, List<String> listIncoming) {
            this.supp = supp;
            this.root = root;
            this.type = type;
            this.revision = revision;
            this.branch = branch;
            this.fileToUnbundle = fileToUnbundle;
            this.listIncoming = listIncoming;
        }

        @Override
        public Void call() throws HgException {
            List<String> list;
            OutputLogger logger = this.supp.getLogger();
            this.topPatch = FetchAction.selectPatch(this.root);
            if (this.topPatch != null) {
                this.supp.setDisplayName(Bundle.MSG_PullAction_popingPatches());
                ((QGoToPatchAction)SystemAction.get(QGoToPatchAction.class)).popAllPatches(this.root, logger);
                this.supp.setDisplayName(Bundle.MSG_PullAction_pulling());
                logger.output("");
            }
            if (this.supp.isCanceled()) {
                return null;
            }
            if (this.type == PullType.LOCAL) {
                this.supp.setDisplayName(Bundle.MSG_PullAction_progress_pullingFromLocal());
                list = HgCommand.doPull(this.root, this.revision, this.branch, logger);
            } else {
                this.supp.setDisplayName(Bundle.MSG_PullAction_progress_unbundling());
                list = HgCommand.doUnbundle(this.root, this.fileToUnbundle, false, logger);
            }
            if (list != null && !list.isEmpty()) {
                PullAction.annotateChangeSets(HgUtils.replaceHttpPassword(this.listIncoming), PullAction.class, "MSG_CHANGESETS_TO_PULL", logger);
                this.handlePulledChangesets(list);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handlePulledChangesets(List<String> list) throws HgException {
            OutputLogger logger = this.supp.getLogger();
            boolean bMergeNeeded = false;
            boolean updateNeeded = false;
            boolean update = true;
            for (String s : list) {
                logger.output(HgUtils.replaceHttpPassword(s));
                if (HgCommand.isMergeNeededMsg(s)) {
                    bMergeNeeded = true;
                    continue;
                }
                if (!HgCommand.isUpdateNeededMsg(s) && !HgCommand.isHeadsNeededMsg(s)) continue;
                updateNeeded = true;
            }
            this.mergeAccepted = false;
            this.rebaseAccepted = false;
            boolean warnMoreHeads = true;
            if (!this.supp.isCanceled()) {
                if (bMergeNeeded) {
                    List<HgLogMessage> parents = HgCommand.getParents(this.root, null, null);
                    this.askForMerge(parents);
                    warnMoreHeads = false;
                } else if (updateNeeded) {
                    String currentBranch = null;
                    try {
                        currentBranch = HgCommand.getBranch(this.root);
                    }
                    catch (HgException ex) {
                        Mercurial.LOG.log(Level.FINE, null, ex);
                    }
                    update = HgModuleConfig.getDefault().isPullWithUpdate();
                    if (currentBranch == null) {
                        this.supp.setDisplayName(Bundle.MSG_PullAction_progress_updating());
                    } else if (update) {
                        this.supp.setDisplayName(Bundle.MSG_PullAction_progress_updatingBranch(currentBranch));
                    }
                    if (update) {
                        list = HgCommand.doUpdateAll(this.root, false, currentBranch);
                        logger.output(list);
                    }
                }
            }
            boolean finished = !bMergeNeeded;
            try {
                if (this.rebaseAccepted) {
                    logger.output("");
                    logger.outputInRed(Bundle.MSG_PULL_REBASE_DO());
                    finished = RebaseAction.doRebase(this.root, null, null, null, this.supp);
                } else if (this.mergeAccepted) {
                    logger.output("");
                    logger.outputInRed(Bundle.MSG_PULL_MERGE_DO());
                    this.supp.setDisplayName(Bundle.MSG_PullAction_progress_merging());
                    list = MergeAction.doMergeAction(this.root, null, logger);
                    if (MergeAction.handleMergeOutput(this.root, list, logger, false)) {
                        SystemActionBridge commitAction = SystemActionBridge.createAction((Action)SystemAction.get(CommitAction.class), (String)"commit", (Lookup)Lookups.fixed((Object[])new Object[]{new AbstractNode(Children.LEAF, Lookups.fixed((Object[])new Object[]{this.root}))}));
                        EventQueue.invokeLater(new Runnable(){
                            final /* synthetic */ Action val$commitAction;
                            final /* synthetic */ PullImpl this$0;
                            {
                                this.val$commitAction = action;
                                this.this$0 = this$0;
                            }

                            @Override
                            public void run() {
                                this.val$commitAction.actionPerformed(new ActionEvent(this.this$0.root, 1001, null));
                            }
                        });
                    }
                }
                if (!this.supp.isCanceled() && finished && this.topPatch != null) {
                    logger.output("");
                    this.supp.setDisplayName(Bundle.MSG_PullAction_pushingPatches());
                    ((QGoToPatchAction)SystemAction.get(QGoToPatchAction.class)).applyPatch(this.root, this.topPatch.getId(), logger);
                    HgLogMessage parent = HgCommand.getParents(this.root, null, null).get(0);
                    logger.output("");
                    HgUtils.logHgLog(parent, logger);
                }
                this.supp.setDisplayName(Bundle.MSG_PullAction_progress_finishing());
            }
            catch (Throwable throwable) {
                this.supp.setDisplayName(Bundle.MSG_PullAction_progress_finishing());
                HgLogMessage[] heads = HgCommand.getHeadRevisionsInfo(this.root, false, OutputLogger.getLogger(null));
                Map<String, Collection<HgLogMessage>> branchHeads = HgUtils.sortByBranch(heads);
                if (!branchHeads.isEmpty()) {
                    MergeAction.displayMergeWarning(branchHeads, logger, warnMoreHeads && !this.supp.isCanceled());
                }
                Mercurial.getInstance().historyChanged(this.root);
                if (update) {
                    HgUtils.notifyUpdatedFiles(this.root, list);
                    HgUtils.forceStatusRefresh(this.root);
                }
                throw throwable;
            }
            HgLogMessage[] heads = HgCommand.getHeadRevisionsInfo(this.root, false, OutputLogger.getLogger(null));
            Map<String, Collection<HgLogMessage>> branchHeads = HgUtils.sortByBranch(heads);
            if (!branchHeads.isEmpty()) {
                MergeAction.displayMergeWarning(branchHeads, logger, warnMoreHeads && !this.supp.isCanceled());
            }
            Mercurial.getInstance().historyChanged(this.root);
            if (update) {
                HgUtils.notifyUpdatedFiles(this.root, list);
                HgUtils.forceStatusRefresh(this.root);
            }
        }

        private void askForMerge(List<HgLogMessage> parents) {
            if (PullAction.isRebaseAllowed(this.root, parents)) {
                if (Boolean.getBoolean("versioning.mercurial.pullwithrebase")) {
                    this.mergeAccepted = false;
                    this.rebaseAccepted = true;
                    return;
                }
                JButton btnMerge = new JButton();
                Mnemonics.setLocalizedText((AbstractButton)btnMerge, (String)Bundle.CTL_PullAction_mergeButton_text());
                btnMerge.setToolTipText(Bundle.CTL_PullAction_mergeButton_TTtext());
                JButton btnRebase = new JButton();
                Mnemonics.setLocalizedText((AbstractButton)btnRebase, (String)Bundle.CTL_PullAction_rebaseButton_text());
                btnRebase.setToolTipText(Bundle.CTL_PullAction_rebaseButton_TTtext());
                JButton btnKeep = new JButton();
                Mnemonics.setLocalizedText((AbstractButton)btnKeep, (String)Bundle.CTL_PullAction_keepButton_text());
                btnKeep.setToolTipText(Bundle.CTL_PullAction_keepButton_TTtext());
                Object value = DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)Bundle.MSG_PullAction_mergeNeeded_text(), Bundle.LBL_PullAction_mergeNeeded_title(), -1, 3, new Object[]{btnMerge, btnRebase, btnKeep}, (Object)btnMerge));
                this.mergeAccepted = value == btnMerge;
                this.rebaseAccepted = value == btnRebase;
            } else {
                this.mergeAccepted = HgUtils.confirmDialog(PullAction.class, "MSG_PULL_MERGE_CONFIRM_TITLE", "MSG_PULL_MERGE_CONFIRM_QUERY");
            }
        }
    }
}

