/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.eecommon.api.config;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;

public enum JavaEEModule {
    CAR(ModuleType.CAR),
    EAR(ModuleType.EAR),
    EJB(ModuleType.EJB),
    RAR(ModuleType.RAR),
    WAR(ModuleType.WAR);

    private static final Logger LOGGER;
    public static final int length;
    public static final String WEB_INF = "WEB-INF";
    public static final String META_INF = "META-INF";
    private static final Map<J2eeModule.Type, JavaEEModule> j2eeModuleTypeToValue;
    private final ModuleType moduleType;

    public static final String getConfigDir(J2eeModule.Type type) {
        JavaEEModule configDir = JavaEEModule.toValue(type);
        return type != null ? configDir.getConfigDir() : null;
    }

    public static JavaEEModule toValue(J2eeModule.Type type) {
        return j2eeModuleTypeToValue.get(type);
    }

    private JavaEEModule(ModuleType moduleType) {
        this.moduleType = moduleType;
    }

    private ModuleType getModuleType() {
        return this.moduleType;
    }

    public String getConfigDir() {
        switch (this.ordinal()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return META_INF;
            }
            case 4: {
                return WEB_INF;
            }
        }
        throw new IllegalArgumentException("Unknown Java EE module type.");
    }

    static {
        LOGGER = Logger.getLogger("payara-eecommon");
        length = JavaEEModule.values().length;
        j2eeModuleTypeToValue = new HashMap<J2eeModule.Type, JavaEEModule>(2 * length);
        j2eeModuleTypeToValue.put(J2eeModule.Type.CAR, CAR);
        j2eeModuleTypeToValue.put(J2eeModule.Type.EAR, EAR);
        j2eeModuleTypeToValue.put(J2eeModule.Type.EJB, EJB);
        j2eeModuleTypeToValue.put(J2eeModule.Type.RAR, RAR);
        j2eeModuleTypeToValue.put(J2eeModule.Type.WAR, WAR);
    }
}

