/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localhistory.store;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.localhistory.LocalHistory;
import org.netbeans.modules.localhistory.store.LocalHistoryStore;
import org.netbeans.modules.localhistory.store.StoreEntry;
import org.netbeans.modules.localhistory.utils.FileUtils;
import org.netbeans.modules.turbo.CustomProviders;
import org.netbeans.modules.turbo.Turbo;
import org.netbeans.modules.turbo.TurboProvider;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.ui.history.HistorySettings;
import org.netbeans.modules.versioning.util.ListenersSupport;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.openide.modules.Places;
import org.openide.util.RequestProcessor;

class LocalHistoryStoreImpl
implements LocalHistoryStore {
    private static final int DELETED = 0;
    private static final int TOUCHED = 1;
    private static final String DATA_FILE = "data";
    private static final String HISTORY_FILE = "history";
    private static final String LABELS_FILE = "labels";
    private static final String STORAGE_FILE = "storage";
    private static final String STORAGE_VERSION = "1.0";
    private File storage;
    private Turbo turbo;
    private DataFilesTurboProvider cacheProvider;
    private final ListenersSupport listenersSupport;
    private static List<HistoryEntry> emptyHistory = new ArrayList<HistoryEntry>(0);
    private static Map<Long, String> emptyLabels = new HashMap<Long, String>();
    private static StoreEntry[] emptyStoreEntryArray = new StoreEntry[0];
    private Set<File> lockedFolders = Collections.synchronizedSet(new HashSet(5));
    private static long LOCK_TIMEOUT = 30L;
    private final RequestProcessor rp = new RequestProcessor("LocalHistoryStore", 50);
    private final Map<VCSFileProxy, Semaphore> proccessedFiles = new HashMap<VCSFileProxy, Semaphore>();
    static final Logger LOG = Logger.getLogger(LocalHistoryStoreImpl.class.getName());
    private static FilenameFilter fileEntriesFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String fileName) {
            return !fileName.endsWith(LocalHistoryStoreImpl.DATA_FILE) && !fileName.endsWith(LocalHistoryStoreImpl.HISTORY_FILE) && !fileName.endsWith(LocalHistoryStoreImpl.LABELS_FILE) && !fileName.endsWith(LocalHistoryStoreImpl.STORAGE_FILE);
        }
    };

    LocalHistoryStoreImpl() {
        this.initStorage();
        this.listenersSupport = new ListenersSupport((Object)this);
        this.cacheProvider = new DataFilesTurboProvider();
        this.turbo = Turbo.createCustom((CustomProviders)new CustomProviders(){
            private final Set providers;
            {
                this.providers = Collections.singleton(LocalHistoryStoreImpl.this.cacheProvider);
            }

            public Iterator providers() {
                return this.providers.iterator();
            }
        }, (int)20, (int)-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fileCreate(VCSFileProxy file, long ts) {
        Semaphore s = this.lock(file, "fileCreate");
        try {
            this.fileCreateImpl(file, ts, null, FileUtils.getPath(file));
        }
        catch (IOException ioe) {
            LocalHistory.LOG.log(Level.WARNING, null, ioe);
        }
        finally {
            if (s != null) {
                s.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fileCreateImpl(VCSFileProxy file, long ts, String from, String to) throws IOException {
        if (this.lastModified(file) > 0L) {
            return;
        }
        String tsString = Long.toString(ts);
        File storeFile = null;
        if (file.isFile()) {
            try {
                storeFile = this.getStoreFile(file, tsString, true);
                FileUtils.copy(file, StoreEntry.createStoreFileOutputStream(storeFile));
            }
            finally {
                this.lockedFolders.remove(storeFile.getParentFile());
            }
            LocalHistory.logCreate(file, storeFile, ts, from, to);
        }
        this.touch(file, new StoreDataFile(FileUtils.getPath(file), 1, ts, file.isFile()));
        VCSFileProxy parent = file.getParentFile();
        if (parent != null) {
            this.writeHistoryForFile(parent, new HistoryEntry[]{new HistoryEntry(ts, from, to, 1)}, true);
        }
        this.fireChanged(file, ts);
    }

    @Override
    public void fileChange(final VCSFileProxy file) {
        final Semaphore s = this.lock(file, "fileChange");
        this.rp.post(new Runnable(){
            final /* synthetic */ LocalHistoryStoreImpl this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long ts = file.lastModified();
                try {
                    long lastModified = this.this$0.lastModified(file);
                    if (lastModified == ts) {
                        LocalHistory.LOG.log(Level.FINE, "skipping fileChange for file {0} because timestap already exists.", new Object[]{FileUtils.getPath(file), ts});
                        return;
                    }
                    if (file.isFile()) {
                        this.this$0.storeChangedSync(file, ts);
                    } else {
                        try {
                            this.this$0.touch(file, new StoreDataFile(FileUtils.getPath(file), 1, ts, false));
                        }
                        catch (IOException ioe) {
                            LocalHistory.LOG.log(Level.WARNING, null, ioe);
                        }
                    }
                }
                finally {
                    if (s != null) {
                        s.release();
                    }
                    Map map = this.this$0.proccessedFiles;
                    synchronized (map) {
                        this.this$0.proccessedFiles.remove(file);
                    }
                }
                this.this$0.fireChanged(file, ts);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void storeChangedSync(VCSFileProxy file, long ts) {
        File storeFile = this.getStoreFile(file, Long.toString(ts), true);
        try {
            try {
                FileUtils.copy(file, StoreEntry.createStoreFileOutputStream(storeFile));
                LocalHistory.LOG.log(Level.FINE, "copied file {0} into storage file {1}", new Object[]{FileUtils.getPath(file), storeFile});
                LocalHistory.logChange(file, storeFile, ts);
                this.touch(file, new StoreDataFile(FileUtils.getPath(file), 1, ts, true));
            }
            finally {
                this.lockedFolders.remove(storeFile.getParentFile());
            }
        }
        catch (FileNotFoundException ioe) {
            LocalHistory.LOG.log(Level.INFO, "exception while copying file " + file + " to " + storeFile, ioe);
            LocalHistory.LOG.log(Level.FINE, "finnished copy file {0} into storage file {1}", new Object[]{FileUtils.getPath(file), storeFile});
        }
        catch (IOException ioe2) {
            LocalHistory.LOG.log(Level.WARNING, null, ioe2);
            {
                catch (Throwable throwable) {
                    LocalHistory.LOG.log(Level.FINE, "finnished copy file {0} into storage file {1}", new Object[]{FileUtils.getPath(file), storeFile});
                    throw throwable;
                }
            }
            LocalHistory.LOG.log(Level.FINE, "finnished copy file {0} into storage file {1}", new Object[]{FileUtils.getPath(file), storeFile});
        }
        LocalHistory.LOG.log(Level.FINE, "finnished copy file {0} into storage file {1}", new Object[]{FileUtils.getPath(file), storeFile});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fileDelete(VCSFileProxy file, long ts) {
        Semaphore s = this.lock(file, "fileDelete");
        try {
            this.fileDeleteImpl(file, null, FileUtils.getPath(file), ts);
        }
        catch (IOException ioe) {
            LocalHistory.LOG.log(Level.WARNING, null, ioe);
        }
        finally {
            if (s != null) {
                s.release();
            }
        }
        this.fireChanged(file, ts);
    }

    private void fileDeleteImpl(VCSFileProxy file, String from, String to, long ts) throws IOException {
        StoreDataFile data = this.readStoreData(file);
        if (data == null) {
            LocalHistory.log("deleting without data for file : " + file);
            return;
        }
        long lastModified = data.getLastModified();
        boolean isFile = data.isFile();
        if (!LocalHistory.LOG.isLoggable(Level.FINE)) {
            File storeFile = this.getDataFile(file);
            LocalHistory.logDelete(file, storeFile, ts);
        }
        this.touch(file, new StoreDataFile(FileUtils.getPath(file), 0, lastModified, isFile));
        VCSFileProxy parent = file.getParentFile();
        if (parent != null) {
            this.writeHistoryForFile(parent, new HistoryEntry[]{new HistoryEntry(ts, from, to, 0)}, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fileCreateFromMove(VCSFileProxy from, VCSFileProxy to, long ts) {
        Semaphore s = this.lock(from, "fileCreateFromMove");
        try {
            if (this.lastModified(to) > 0L) {
                return;
            }
            this.fileCreateImpl(to, ts, FileUtils.getPath(from), FileUtils.getPath(to));
        }
        catch (IOException ioe) {
            LocalHistory.LOG.log(Level.WARNING, null, ioe);
        }
        finally {
            if (s != null) {
                s.release();
            }
        }
        this.fireChanged(to, ts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fileDeleteFromMove(VCSFileProxy from, VCSFileProxy to, long ts) {
        Semaphore s = this.lock(from, "fileDeleteFromMove");
        try {
            this.fileDeleteImpl(from, FileUtils.getPath(from), FileUtils.getPath(to), ts);
        }
        catch (IOException ioe) {
            LocalHistory.LOG.log(Level.WARNING, null, ioe);
        }
        finally {
            if (s != null) {
                s.release();
            }
        }
        this.fireChanged(from, ts);
    }

    static File getStorageRootFile() {
        return new File(new File(Places.getUserDirectory(), "var"), "filehistory");
    }

    private long lastModified(VCSFileProxy file) {
        StoreDataFile data = this.readStoreData(file);
        return data != null && data.getStatus() != 0 ? data.getLastModified() : -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StoreEntry[] getStoreEntries(VCSFileProxy file) {
        Semaphore s = this.lock(file, "getStoreEntries");
        try {
            StoreEntry[] storeEntryArray = this.getStoreEntriesImpl(file);
            return storeEntryArray;
        }
        finally {
            if (s != null) {
                s.release();
            }
        }
    }

    private StoreEntry[] getStoreEntriesImpl(VCSFileProxy file) {
        File storeFolder = this.getStoreFolder(file);
        File[] storeFiles = storeFolder.listFiles(fileEntriesFilter);
        if (storeFiles != null && storeFiles.length > 0) {
            ArrayList<StoreEntry> ret = new ArrayList<StoreEntry>(storeFiles.length);
            if (storeFiles.length > 0) {
                Map<Long, String> labels = this.getLabels(this.getLabelsFile(file));
                for (int i = 0; i < storeFiles.length; ++i) {
                    long ts = Long.parseLong(storeFiles[i].getName());
                    String label = labels.get(ts);
                    ret.add(StoreEntry.createStoreEntry(file, storeFiles[i], ts, label));
                }
                return ret.toArray(new StoreEntry[storeFiles.length]);
            }
            return emptyStoreEntryArray;
        }
        return emptyStoreEntryArray;
    }

    @Override
    public StoreEntry[] getFolderState(VCSFileProxy root, VCSFileProxy[] files, long ts) {
        return new StoreEntry[0];
    }

    private boolean wasDeleted(VCSFileProxy file, List<HistoryEntry> history, long ts) {
        String path = FileUtils.getPath(file);
        boolean deleted = false;
        for (int i = 0; i < history.size(); ++i) {
            HistoryEntry he = history.get(i);
            if (he.getTo().equals(path)) {
                deleted = he.getStatus() == 0;
            }
            if (he.ts >= ts) break;
        }
        return deleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StoreEntry getStoreEntry(VCSFileProxy file, long ts) {
        Semaphore s = this.lock(file, "getStoreEntry");
        try {
            StoreEntry storeEntry = this.getStoreEntryIntern(file, ts);
            return storeEntry;
        }
        finally {
            if (s != null) {
                s.release();
            }
        }
    }

    private StoreEntry getStoreEntryIntern(VCSFileProxy file, long ts) {
        return this.getStoreEntryImpl(file, ts, this.readStoreData(file));
    }

    private StoreEntry getStoreEntryImpl(VCSFileProxy file, long ts, StoreDataFile data) {
        StoreEntry entry = null;
        if (data == null) {
            return null;
        }
        if (data.isFile()) {
            StoreEntry[] entries;
            for (StoreEntry se : entries = this.getStoreEntriesImpl(file)) {
                if (se.getTimestamp() > ts || entry != null && se.getTimestamp() <= entry.getTimestamp()) continue;
                entry = se;
            }
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteEntry(VCSFileProxy file, long ts) {
        Semaphore s = this.lock(file, "deleteEntry");
        try {
            File storeFile = this.getStoreFile(file, Long.toString(ts), false);
            if (storeFile.exists()) {
                storeFile.delete();
            }
            this.fireDeleted(file, ts);
        }
        finally {
            if (s != null) {
                s.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StoreEntry[] getDeletedFiles(VCSFileProxy root) {
        Semaphore s = this.lock(root, "getDeletedFiles");
        try {
            StoreEntry[] storeEntryArray = this.getDeletedFilesIntern(root);
            return storeEntryArray;
        }
        finally {
            if (s != null) {
                s.release();
            }
        }
    }

    private StoreEntry[] getDeletedFilesIntern(VCSFileProxy root) {
        if (root.isFile()) {
            return null;
        }
        if (root.toFile() == null) {
            // empty if block
        }
        HashMap<String, StoreEntry> deleted = new HashMap<String, StoreEntry>();
        List<HistoryEntry> historyEntries = this.readHistoryForFile(root);
        for (HistoryEntry he : historyEntries) {
            StoreDataFile data;
            String filePath;
            if (he.getStatus() != 0 || deleted.containsKey(filePath = he.getTo()) || (data = this.readStoreData(FileUtils.createProxy(he.getTo()))) == null || data.getStatus() != 0) continue;
            File storeFile = data.isFile ? this.getStoreFile(FileUtils.createProxy(data.getAbsolutePath()), Long.toString(data.getLastModified()), false) : this.getStoreFolder(root);
            deleted.put(filePath, StoreEntry.createStoreEntry(FileUtils.createProxy(data.getAbsolutePath()), storeFile, data.getLastModified(), ""));
        }
        List<VCSFileProxy> lostFiles = this.getLostFiles();
        for (VCSFileProxy lostFile : lostFiles) {
            StoreEntry[] storeEntries;
            if (deleted.containsKey(FileUtils.getPath(lostFile)) || !root.equals((Object)lostFile.getParentFile()) || (storeEntries = this.getStoreEntriesImpl(lostFile)) == null || storeEntries.length == 0) continue;
            StoreEntry storeEntry = storeEntries[0];
            for (int i = 1; i < storeEntries.length; ++i) {
                if (storeEntry.getTimestamp() >= storeEntries[i].getTimestamp()) continue;
                storeEntry = storeEntries[i];
            }
            deleted.put(FileUtils.getPath(lostFile), storeEntry);
        }
        return deleted.values().toArray(new StoreEntry[deleted.size()]);
    }

    private List<VCSFileProxy> getLostFiles() {
        ArrayList<VCSFileProxy> files = new ArrayList<VCSFileProxy>();
        File[] topLevelFiles = this.storage.listFiles();
        if (topLevelFiles == null || topLevelFiles.length == 0) {
            return files;
        }
        for (File topLevelFile : topLevelFiles) {
            File[] secondLevelFiles = topLevelFile.listFiles();
            if (secondLevelFiles == null || secondLevelFiles.length == 0) continue;
            for (File storeFile : secondLevelFiles) {
                VCSFileProxy file;
                StoreDataFile data = this.readStoreFile(new File(storeFile, DATA_FILE));
                if (data == null || (file = FileUtils.createProxy(data.getAbsolutePath())).exists()) continue;
                files.add(file);
            }
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StoreEntry setLabel(VCSFileProxy file, long ts, String label) {
        Semaphore s = this.lock(file, "setLabel");
        try {
            StoreEntry storeEntry = this.setLabelIntern(file, ts, label);
            return storeEntry;
        }
        finally {
            if (s != null) {
                s.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StoreEntry setLabelIntern(VCSFileProxy file, long ts, String label) {
        File labelsFile = this.getLabelsFile(file);
        File parent = labelsFile.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        File labelsNew = null;
        FilterInputStream dis = null;
        FilterOutputStream oos = null;
        boolean foundLabel = false;
        try {
            block36: {
                if (!labelsFile.exists()) {
                    oos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(labelsFile)));
                    ((DataOutputStream)oos).writeLong(ts);
                    LocalHistoryStoreImpl.writeString((DataOutputStream)oos, label);
                } else {
                    labelsNew = new File(labelsFile.getParentFile(), labelsFile.getName() + ".new");
                    oos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(labelsNew)));
                    dis = LocalHistoryStoreImpl.getInputStream(labelsFile);
                    long readTs = -1L;
                    try {
                        while (true) {
                            if ((readTs = ((DataInputStream)dis).readLong()) == ts) {
                                foundLabel = true;
                                if (label != null) {
                                    ((DataOutputStream)oos).writeLong(readTs);
                                    LocalHistoryStoreImpl.writeString((DataOutputStream)oos, label);
                                    int len = ((DataInputStream)dis).readInt();
                                    LocalHistoryStoreImpl.skip(dis, len * 2);
                                    LocalHistoryStoreImpl.copyStreams(oos, dis);
                                    continue;
                                }
                                int len = ((DataInputStream)dis).readInt();
                                LocalHistoryStoreImpl.skip(dis, len * 2);
                                continue;
                            }
                            ((DataOutputStream)oos).writeLong(readTs);
                            String l = LocalHistoryStoreImpl.readString((DataInputStream)dis);
                            LocalHistoryStoreImpl.writeString((DataOutputStream)oos, l);
                        }
                    }
                    catch (EOFException e) {
                        if (foundLabel || label == null) break block36;
                        ((DataOutputStream)oos).writeLong(ts);
                        LocalHistoryStoreImpl.writeString((DataOutputStream)oos, label);
                    }
                }
            }
            ((DataOutputStream)oos).flush();
        }
        catch (EOFException readTs) {
        }
        catch (Exception e) {
            LocalHistory.LOG.log(Level.INFO, null, e);
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException e) {}
            }
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException e) {}
            }
        }
        try {
            if (labelsNew != null) {
                FileUtils.renameFile(labelsNew, labelsFile);
            }
        }
        catch (IOException ex) {
            LocalHistory.LOG.log(Level.SEVERE, null, ex);
        }
        return this.getStoreEntryIntern(file, ts);
    }

    @Override
    public void addVersioningListener(VersioningListener l) {
        this.listenersSupport.addListener(l);
    }

    @Override
    public void removeVersioningListener(VersioningListener l) {
        this.listenersSupport.removeListener(l);
    }

    @Override
    public void cleanUp(final long ttl) {
        LocalHistory.getInstance().getParallelRequestProcessor().post(new Runnable(){
            final /* synthetic */ LocalHistoryStoreImpl this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                LocalHistory.log("Cleanup Start");
                long t = System.currentTimeMillis();
                this.this$0.cleanUpImpl(ttl);
                LocalHistory.log("Cleanup End in " + (System.currentTimeMillis() - t) + " millis.");
            }
        });
    }

    private void cleanUpImpl(long ttl) {
        int maxC = Integer.getInteger("netbeans.localhistory.maxCleanupCount", -1);
        long maxT = Long.getLong("netbeans.localhistory.maxCleanupTime", -1L) * 1000L;
        long now = System.currentTimeMillis();
        int count = 0;
        File[] files = this.storage.listFiles();
        if (files == null || files.length == 0) {
            return;
        }
        List<File> topLevelFiles = Arrays.asList(files);
        if (maxC > -1 || maxT > -1L) {
            Collections.shuffle(topLevelFiles);
        }
        for (File topLevelFile : topLevelFiles) {
            if (topLevelFile.getName().equals(STORAGE_FILE)) continue;
            files = topLevelFile.listFiles();
            if (files == null || files.length == 0) {
                this.deleteRecursivelly(topLevelFile);
                continue;
            }
            List<File> secondLevelFiles = Arrays.asList(files);
            if (maxC > -1 || maxT > -1L) {
                Collections.shuffle(secondLevelFiles);
            }
            boolean allEmpty = true;
            for (File secondLevelFile : secondLevelFiles) {
                boolean empty;
                ++count;
                boolean bl = empty = !this.lockedFolders.contains(secondLevelFile) && this.cleanUpFolder(secondLevelFile, ttl, now);
                if (empty) {
                    if (!secondLevelFile.exists()) continue;
                    this.deleteRecursivelly(secondLevelFile);
                    continue;
                }
                allEmpty = false;
            }
            if (allEmpty) {
                this.deleteRecursivelly(topLevelFile);
            }
            if ((maxC <= 0 || count < maxC) && (maxT <= 0L || System.currentTimeMillis() - now < maxT)) continue;
            break;
        }
    }

    private synchronized boolean cleanUpFolder(File folder, long ttl, long now) {
        File dataFile = new File(folder, DATA_FILE);
        if (!dataFile.exists()) {
            return this.cleanUpStoredFolder(folder, ttl, now);
        }
        StoreDataFile data = this.readStoreFile(dataFile);
        if (data == null || data.getAbsolutePath() == null) {
            return true;
        }
        if (data.isFile()) {
            return this.cleanUpStoredFile(folder, ttl, now);
        }
        return this.cleanUpStoredFolder(folder, ttl, now);
    }

    public void deleteRecursivelly(File file) {
        if (!this.lockedFolders.contains(file)) {
            FileUtils.deleteRecursively(file);
        }
    }

    private boolean cleanUpStoredFile(File store, long ttl, long now) {
        File dataFile = new File(store, DATA_FILE);
        if (!dataFile.exists()) {
            return true;
        }
        if (dataFile.lastModified() < now - ttl) {
            this.purgeDataFile(dataFile);
            return true;
        }
        File[] files = store.listFiles(fileEntriesFilter);
        boolean skipped = false;
        File labelsFile = new File(store, LABELS_FILE);
        Map<Long, String> labels = emptyLabels;
        if (labelsFile.exists()) {
            labels = this.getLabels(labelsFile);
        }
        if (files != null) {
            for (File f : files) {
                long ts;
                try {
                    ts = Long.parseLong(f.getName());
                }
                catch (NumberFormatException ex) {
                    continue;
                }
                if (ts < now - ttl) {
                    if (labels.size() > 0) {
                        if (HistorySettings.getInstance().getCleanUpLabeled()) {
                            labels.remove(ts);
                            f.delete();
                            continue;
                        }
                        if (labels.containsKey(ts)) continue;
                        f.delete();
                        continue;
                    }
                    f.delete();
                    continue;
                }
                skipped = true;
            }
        }
        if (!skipped) {
            labelsFile.delete();
            this.writeStoreFile(dataFile, null);
        } else if (labels.size() > 0) {
            this.writeLabels(labelsFile, labels);
        } else {
            labelsFile.delete();
        }
        return !skipped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLabels(File labelsFile, Map<Long, String> labels) {
        File parent = labelsFile.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        FilterInputStream dis = null;
        DataOutputStream oos = null;
        try {
            oos = LocalHistoryStoreImpl.getOutputStream(labelsFile, false);
            for (Map.Entry<Long, String> label : labels.entrySet()) {
                oos.writeLong(label.getKey());
                LocalHistoryStoreImpl.writeString(oos, label.getValue());
            }
            oos.flush();
        }
        catch (Exception e) {
            LocalHistory.LOG.log(Level.INFO, null, e);
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException iOException) {}
            }
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private boolean cleanUpStoredFolder(File store, long ttl, long now) {
        boolean historyObsolete;
        File historyFile = new File(store, HISTORY_FILE);
        File dataFile = new File(store, DATA_FILE);
        boolean dataObsolete = !dataFile.exists() || dataFile.lastModified() < now - ttl;
        boolean bl = historyObsolete = !historyFile.exists() || historyFile.lastModified() < now - ttl;
        if (!historyObsolete) {
            List<HistoryEntry> entries = this.readHistory(historyFile);
            ArrayList<HistoryEntry> newEntries = new ArrayList<HistoryEntry>();
            for (HistoryEntry entry : entries) {
                if (entry.getTimestamp() <= now - ttl) continue;
                newEntries.add(entry);
            }
            if (newEntries.size() > 0) {
                this.writeHistory(historyFile, newEntries.toArray(new HistoryEntry[0]), false);
            } else {
                historyFile.delete();
                historyObsolete = true;
            }
        }
        if (dataObsolete) {
            this.purgeDataFile(dataFile);
        }
        if (historyObsolete) {
            historyFile.delete();
        }
        return dataObsolete && historyObsolete;
    }

    private void purgeDataFile(File dataFile) {
        if (dataFile.exists()) {
            this.writeStoreFile(dataFile, null);
        }
    }

    private void fireChanged(VCSFileProxy file, long ts) {
        this.listenersSupport.fireVersioningEvent(EVENT_HISTORY_CHANGED, new Object[]{file, ts});
    }

    private void fireDeleted(VCSFileProxy file, long ts) {
        this.listenersSupport.fireVersioningEvent(EVENT_ENTRY_DELETED, new Object[]{file, ts});
    }

    private void touch(VCSFileProxy file, StoreDataFile data) throws IOException {
        this.writeStoreData(file, data);
    }

    private void initStorage() {
        this.storage = LocalHistoryStoreImpl.getStorageRootFile();
        if (!this.storage.exists()) {
            this.storage.mkdirs();
        }
        this.writeStorage();
    }

    private File getStoreFolder(VCSFileProxy file) {
        StoreDataFile data;
        String filePath = FileUtils.getPath(file);
        File storeFolder = this.getStoreFolderName(filePath);
        int i = 0;
        while (storeFolder.exists() && (data = this.readStoreFile(new File(storeFolder, DATA_FILE))) != null && !data.getAbsolutePath().equals(filePath)) {
            storeFolder = this.getStoreFolderName(filePath + "." + i++);
        }
        return storeFolder;
    }

    private File getStoreFolderName(String filePath) {
        int fileHash = filePath.hashCode();
        String storeFileName = this.getMD5(filePath);
        String storeIndex = this.storage.getAbsolutePath() + "/" + Integer.toString(fileHash % 173 + 172);
        return new File(storeIndex + "/" + storeFileName);
    }

    private String getMD5(String name) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        digest.update(name.getBytes());
        byte[] hash = digest.digest();
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < hash.length; ++i) {
            String hex = Integer.toHexString(hash[i] & 0xFF);
            if (hex.length() == 1) {
                hex = "0" + hex;
            }
            ret.append(hex);
        }
        return ret.toString();
    }

    private File getStoreFile(VCSFileProxy file, String name, boolean forceCreate) {
        File storeFolder = this.getStoreFolder(file);
        if (forceCreate) {
            this.lockedFolders.add(storeFolder);
            if (!storeFolder.exists()) {
                storeFolder.mkdirs();
            }
        }
        return new File(storeFolder, name);
    }

    private File getHistoryFile(VCSFileProxy file) {
        File storeFolder = this.getStoreFolder(file);
        if (!storeFolder.exists()) {
            storeFolder.mkdirs();
        }
        return new File(storeFolder, HISTORY_FILE);
    }

    private File getDataFile(VCSFileProxy file) {
        File storeFolder = this.getStoreFolder(file);
        return new File(storeFolder, DATA_FILE);
    }

    private File getLabelsFile(VCSFileProxy file) {
        File storeFolder = this.getStoreFolder(file);
        return new File(storeFolder, LABELS_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Long, String> getLabels(File labelsFile) {
        if (!labelsFile.exists()) {
            return emptyLabels;
        }
        DataInputStream dis = null;
        HashMap<Long, String> ret = new HashMap<Long, String>();
        try {
            dis = LocalHistoryStoreImpl.getInputStream(labelsFile);
            while (true) {
                long ts = dis.readLong();
                String label = LocalHistoryStoreImpl.readString(dis);
                ret.put(ts, label);
            }
        }
        catch (EOFException e) {
            HashMap<Long, String> hashMap = ret;
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return hashMap;
        }
        catch (Exception e) {
            try {
                LocalHistory.LOG.log(Level.INFO, null, e);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (dis != null) {
                    try {
                        dis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return emptyLabels;
    }

    private void writeHistoryForFile(VCSFileProxy file, HistoryEntry[] entries, boolean append) {
        if (!LocalHistory.LOG.isLoggable(Level.FINE) && this.getDataFile(file) == null) {
            LocalHistory.log("writing history for file without data : " + file);
        }
        File history = this.getHistoryFile(file);
        this.writeHistory(history, entries, append);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHistory(File history, HistoryEntry[] entries, boolean append) {
        DataOutputStream dos = null;
        try {
            dos = LocalHistoryStoreImpl.getOutputStream(history, append);
            for (HistoryEntry entry : entries) {
                dos.writeLong(entry.getTimestamp());
                LocalHistoryStoreImpl.writeString(dos, entry.getFrom());
                LocalHistoryStoreImpl.writeString(dos, entry.getTo());
                dos.writeInt(entry.getStatus());
            }
            dos.flush();
        }
        catch (Exception e) {
            LocalHistory.LOG.log(Level.INFO, null, e);
        }
        finally {
            if (dos != null) {
                try {
                    dos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private List<HistoryEntry> readHistoryForFile(VCSFileProxy file) {
        return this.readHistory(this.getHistoryFile(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<HistoryEntry> readHistory(File history) {
        if (!history.exists()) {
            return emptyHistory;
        }
        DataInputStream dis = null;
        ArrayList<HistoryEntry> entries = new ArrayList<HistoryEntry>();
        try {
            dis = LocalHistoryStoreImpl.getInputStream(history);
            while (true) {
                long ts = dis.readLong();
                String from = LocalHistoryStoreImpl.readString(dis);
                String to = LocalHistoryStoreImpl.readString(dis);
                int action = dis.readInt();
                entries.add(new HistoryEntry(ts, from, to, action));
            }
        }
        catch (EOFException e) {
            ArrayList<HistoryEntry> arrayList = entries;
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return arrayList;
        }
        catch (Exception e) {
            try {
                LocalHistory.LOG.log(Level.INFO, null, e);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (dis != null) {
                    try {
                        dis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return emptyHistory;
    }

    private StoreDataFile readStoreData(VCSFileProxy file) {
        return this.readStoreFile(this.getDataFile(file));
    }

    private StoreDataFile readStoreFile(File file) {
        return (StoreDataFile)this.turbo.readEntry((Object)file, "localhistory.ATTR_DATA_FILES");
    }

    private void writeStorage() {
        FilterOutputStream dos = null;
        try {
            dos = LocalHistoryStoreImpl.getOutputStream(new File(this.storage, STORAGE_FILE), false);
            LocalHistoryStoreImpl.writeString((DataOutputStream)dos, STORAGE_VERSION);
            ((DataOutputStream)dos).flush();
        }
        catch (Exception e) {
            LocalHistory.LOG.log(Level.INFO, null, e);
        }
        finally {
            if (dos != null) {
                try {
                    dos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void writeStoreData(VCSFileProxy file, StoreDataFile data) {
        this.writeStoreFile(this.getDataFile(file), data);
    }

    private void writeStoreFile(File file, StoreDataFile data) {
        this.turbo.writeEntry((Object)file, "localhistory.ATTR_DATA_FILES", (Object)data);
    }

    private static void writeString(DataOutputStream dos, String str) throws IOException {
        if (str != null) {
            dos.writeInt(str.length());
            dos.writeChars(str);
        } else {
            dos.writeInt(0);
        }
    }

    private static String readString(DataInputStream dis) throws IOException {
        int len = dis.readInt();
        if (len == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        while (len-- > 0) {
            char c = dis.readChar();
            sb.append(c);
        }
        return sb.toString();
    }

    private static void skip(InputStream is, long len) throws IOException {
        while (len > 0L) {
            long n = is.skip(len);
            if (n < 0L) {
                throw new EOFException("Missing " + len + " bytes.");
            }
            len -= n;
        }
    }

    private static void copyStreams(OutputStream out, InputStream in) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        while ((n = in.read(buffer)) >= 0) {
            out.write(buffer, 0, n);
        }
    }

    private static DataOutputStream getOutputStream(File file, boolean append) throws IOException, InterruptedException {
        int retry = 0;
        while (true) {
            try {
                return new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file, append)));
            }
            catch (IOException ioex) {
                if (++retry > 7) {
                    throw ioex;
                }
                Thread.sleep(retry * 30);
                continue;
            }
            break;
        }
    }

    private static DataInputStream getInputStream(File file) throws IOException, InterruptedException {
        int retry = 0;
        while (true) {
            try {
                return new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            }
            catch (IOException ioex) {
                if (++retry > 7) {
                    throw ioex;
                }
                Thread.sleep(retry * 30);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForProcessedStoring(VCSFileProxy file, String caller) {
        Semaphore s;
        Map<VCSFileProxy, Semaphore> map = this.proccessedFiles;
        synchronized (map) {
            s = this.proccessedFiles.get(file);
        }
        if (s != null) {
            long l;
            block10: {
                l = System.currentTimeMillis();
                try {
                    long t9Timeout = this.getT9LockReleaseTimeOut();
                    long timeout = t9Timeout >= 0L ? t9Timeout : LOCK_TIMEOUT;
                    boolean aquired = s.tryAcquire(timeout, TimeUnit.SECONDS);
                    if (aquired) {
                        s.release();
                        break block10;
                    }
                    LOG.log(Level.WARNING, "{0} Releasing lock on file: {1}", new Object[]{caller, FileUtils.getPath(file)});
                    Map<VCSFileProxy, Semaphore> map2 = this.proccessedFiles;
                    synchronized (map2) {
                        this.proccessedFiles.remove(file);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            LOG.log(Level.FINER, "{0} for file {1} was blocked {2} millis.", new Object[]{caller, FileUtils.getPath(file), System.currentTimeMillis() - l});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Semaphore lock(VCSFileProxy file, String caller) {
        Semaphore s;
        Map<VCSFileProxy, Semaphore> map = this.proccessedFiles;
        synchronized (map) {
            s = this.proccessedFiles.get(file);
            if (s == null) {
                s = new Semaphore(1, true);
                this.proccessedFiles.put(file, s);
            }
        }
        try {
            long t9Timeout = this.getT9LockTimeOut();
            long timeout = t9Timeout >= 0L ? t9Timeout : LOCK_TIMEOUT;
            long taken = System.currentTimeMillis();
            boolean acquired = s.tryAcquire(timeout, TimeUnit.SECONDS);
            taken = System.currentTimeMillis() - taken;
            if (t9Timeout > 0L) assert (acquired);
            if (acquired) {
                LOG.log(Level.FINE, "{0} acquired lock for {1}", new Object[]{caller, FileUtils.getPath(file)});
            } else {
                LOG.log(Level.WARNING, "{0} Releasing lock on file: {1}", new Object[]{caller, FileUtils.getPath(file)});
            }
            if (taken > 3000L) {
                LOG.log(Level.WARNING, "{0} acquiring lock for {1} took too long {2}", new Object[]{caller, FileUtils.getPath(file), taken});
            }
        }
        catch (InterruptedException ex) {
            return null;
        }
        return s;
    }

    private long getT9LockReleaseTimeOut() {
        String t9yLockTimeOut = System.getProperty("netbeans.t9y.localhistory.release-lock.timeout", "-1");
        try {
            long l = Long.parseLong(t9yLockTimeOut);
            return l;
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    private long getT9LockTimeOut() {
        String t9yLockTimeOut = System.getProperty("netbeans.t9y.localhistory.lock.timeout", "-1");
        try {
            long l = Long.parseLong(t9yLockTimeOut);
            return l;
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    private static class StoreDataFile {
        private final int status;
        private final long lastModified;
        private final String absolutePath;
        private final boolean isFile;

        private StoreDataFile(String absolutePath, int action, long lastModified, boolean isFile) {
            this.status = action;
            this.lastModified = lastModified;
            this.absolutePath = absolutePath;
            this.isFile = isFile;
        }

        int getStatus() {
            return this.status;
        }

        long getLastModified() {
            return this.lastModified;
        }

        String getAbsolutePath() {
            return this.absolutePath;
        }

        boolean isFile() {
            return this.isFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static synchronized StoreDataFile read(File storeFile) {
            DataInputStream dis = null;
            try {
                dis = LocalHistoryStoreImpl.getInputStream(storeFile);
                boolean isFile = dis.readBoolean();
                int action = dis.readInt();
                long modified = dis.readLong();
                String fileName = LocalHistoryStoreImpl.readString(dis);
                StoreDataFile storeDataFile = new StoreDataFile(fileName, action, modified, isFile);
                return storeDataFile;
            }
            catch (Exception e) {
                LocalHistory.LOG.log(Level.INFO, null, e);
            }
            finally {
                if (dis != null) {
                    try {
                        dis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static synchronized void write(File storeFile, StoreDataFile value) {
            DataOutputStream dos = null;
            try {
                dos = LocalHistoryStoreImpl.getOutputStream(storeFile, false);
                StoreDataFile data = value;
                dos.writeBoolean(data.isFile);
                dos.writeInt(data.getStatus());
                dos.writeLong(data.getLastModified());
                dos.writeInt(data.getAbsolutePath().length());
                dos.writeChars(data.getAbsolutePath());
                dos.flush();
            }
            catch (Exception e) {
                LocalHistory.LOG.log(Level.INFO, null, e);
            }
            finally {
                if (dos != null) {
                    try {
                        dos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private class DataFilesTurboProvider
    implements TurboProvider {
        static final String ATTR_DATA_FILES = "localhistory.ATTR_DATA_FILES";

        private DataFilesTurboProvider() {
        }

        public boolean recognizesAttribute(String name) {
            return ATTR_DATA_FILES.equals(name);
        }

        public boolean recognizesEntity(Object key) {
            return key instanceof File;
        }

        public synchronized Object readEntry(Object key, String name, TurboProvider.MemoryCache memoryCache) {
            assert (key instanceof File);
            assert (name != null);
            File storeFile = (File)key;
            if (!storeFile.exists()) {
                return null;
            }
            return StoreDataFile.read(storeFile);
        }

        public synchronized boolean writeEntry(Object key, String name, Object value) {
            assert (key instanceof File);
            assert (value == null || value instanceof StoreDataFile);
            assert (name != null);
            File storeFile = (File)key;
            if (value == null) {
                if (storeFile.exists()) {
                    storeFile.delete();
                }
                return true;
            }
            File parent = storeFile.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            StoreDataFile.write(storeFile, (StoreDataFile)value);
            return true;
        }
    }

    private class HistoryEntry {
        private long ts;
        private String from;
        private String to;
        private int status;

        HistoryEntry(long ts, String from, String to, int action) {
            this.ts = ts;
            this.from = from;
            this.to = to;
            this.status = action;
        }

        long getTimestamp() {
            return this.ts;
        }

        String getFrom() {
            return this.from;
        }

        String getTo() {
            return this.to;
        }

        int getStatus() {
            return this.status;
        }
    }
}

