/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.requirejs.editor;

import java.util.Arrays;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.javascript2.editor.spi.DeclarationFinder;
import org.netbeans.modules.javascript2.lexer.api.JsTokenId;
import org.netbeans.modules.javascript2.lexer.api.LexUtilities;
import org.netbeans.modules.javascript2.requirejs.RequireJsPreferences;
import org.netbeans.modules.javascript2.requirejs.editor.EditorUtils;
import org.netbeans.modules.javascript2.requirejs.editor.FSCompletionUtils;
import org.netbeans.modules.parsing.api.Source;
import org.openide.filesystems.FileObject;

public class RequireJsDeclarationFinder
implements DeclarationFinder {
    private boolean isSupportEnabled(FileObject fo) {
        if (fo == null) {
            return false;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        if (project == null) {
            return false;
        }
        return RequireJsPreferences.getBoolean(project, RequireJsPreferences.ENABLED);
    }

    public DeclarationFinder.DeclarationLocation findDeclaration(ParserResult info, int caretOffset) {
        FileObject fo = info.getSnapshot().getSource().getFileObject();
        if (!this.isSupportEnabled(fo)) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        TokenSequence ts = LexUtilities.getJsTokenSequence((TokenHierarchy)info.getSnapshot().getTokenHierarchy(), (int)caretOffset);
        int jsOffset = info.getSnapshot().getEmbeddedOffset(caretOffset);
        if (ts != null) {
            ts.move(jsOffset);
            if (ts.moveNext() && ts.token().id() == JsTokenId.STRING && EditorUtils.isFileReference(info.getSnapshot(), ts.offset())) {
                ts.move(jsOffset);
                ts.moveNext();
                String path = FSCompletionUtils.removePlugin(ts.token().text().toString());
                FileObject targetFO = FSCompletionUtils.findMappedFileObject(path, fo);
                if (targetFO != null) {
                    return new DeclarationFinder.DeclarationLocation(targetFO, 0);
                }
            } else if (ts != null && ts.token() != null && ts.token().id() == JsTokenId.IDENTIFIER) {
                Token token;
                int commaNumber = 0;
                do {
                    if ((token = LexUtilities.findPrevious((TokenSequence)ts, Arrays.asList(JsTokenId.IDENTIFIER, JsTokenId.WHITESPACE, JsTokenId.EOL, JsTokenId.BLOCK_COMMENT, JsTokenId.LINE_COMMENT))).id() == JsTokenId.OPERATOR_COMMA) {
                        ++commaNumber;
                        continue;
                    }
                    if (token.id() == JsTokenId.OPERATOR_DOT) break;
                } while (ts.movePrevious() && token.id() != JsTokenId.BRACKET_LEFT_BRACKET && token.id() != JsTokenId.BRACKET_LEFT_PAREN);
                if (token.id() == JsTokenId.BRACKET_LEFT_PAREN && (token = LexUtilities.findPreviousToken((TokenSequence)ts, Arrays.asList(JsTokenId.IDENTIFIER))).id() == JsTokenId.IDENTIFIER && ("define".equals(token.text().toString()) || "require".equals(token.text().toString()) || "requirejs".equals(token.text().toString())) && (token = LexUtilities.findNextToken((TokenSequence)ts, Arrays.asList(JsTokenId.BRACKET_LEFT_BRACKET, JsTokenId.KEYWORD_FUNCTION, JsTokenId.BRACKET_LEFT_CURLY, JsTokenId.BRACKET_RIGHT_PAREN))).id() == JsTokenId.BRACKET_LEFT_BRACKET) {
                    FileObject targetFO;
                    int commaInArray = 0;
                    String path = null;
                    do {
                        if ((token = LexUtilities.findNextToken((TokenSequence)ts, Arrays.asList(JsTokenId.STRING, JsTokenId.OPERATOR_COMMA, JsTokenId.BRACKET_RIGHT_PAREN))).id() == JsTokenId.OPERATOR_COMMA) {
                            ++commaInArray;
                            continue;
                        }
                        if (token.id() != JsTokenId.STRING || commaInArray != commaNumber) continue;
                        path = token.text().toString();
                    } while (path == null && ts.moveNext() && token.id() != JsTokenId.BRACKET_RIGHT_PAREN);
                    if (path != null && (targetFO = FSCompletionUtils.findMappedFileObject(path = FSCompletionUtils.removePlugin(path), fo)) != null) {
                        return new DeclarationFinder.DeclarationLocation(targetFO, 0);
                    }
                }
            }
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    public OffsetRange getReferenceSpan(final Document doc, final int caretOffset) {
        final OffsetRange[] value = new OffsetRange[]{OffsetRange.NONE};
        doc.render(new Runnable(){
            final /* synthetic */ RequireJsDeclarationFinder this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                TokenSequence ts = LexUtilities.getJsTokenSequence((Document)doc, (int)caretOffset);
                if (ts != null) {
                    ts.move(caretOffset);
                    if (ts.moveNext() && ts.token().id() == JsTokenId.STRING && EditorUtils.isFileReference(Source.create((Document)doc).createSnapshot(), ts.offset())) {
                        ts.move(caretOffset);
                        ts.moveNext();
                        String path = ts.token().text().toString();
                        int start = ts.offset();
                        int end = ts.offset() + path.length();
                        if (FSCompletionUtils.containsPlugin(path)) {
                            String withoutPlugin = FSCompletionUtils.removePlugin(path);
                            start = start + path.length() - withoutPlugin.length();
                        }
                        value[0] = new OffsetRange(start, end);
                    }
                }
            }
        });
        return value[0];
    }
}

