/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.tooling.admin;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.netbeans.modules.payara.tooling.PayaraIdeException;
import org.netbeans.modules.payara.tooling.admin.Command;
import org.netbeans.modules.payara.tooling.admin.ResultString;
import org.netbeans.modules.payara.tooling.admin.RunnerHttpClass;
import org.netbeans.modules.payara.tooling.admin.RunnerHttpSetProperty;
import org.netbeans.modules.payara.tooling.admin.RunnerRestClass;
import org.netbeans.modules.payara.tooling.admin.RunnerRestSetProperty;
import org.netbeans.modules.payara.tooling.admin.ServerAdmin;
import org.netbeans.modules.payara.tooling.data.PayaraServer;

@RunnerHttpClass(runner=RunnerHttpSetProperty.class)
@RunnerRestClass(runner=RunnerRestSetProperty.class)
public class CommandSetProperty
extends Command {
    private static final String COMMAND = "set";
    private static final String ERROR_MESSAGE_PREFIX = "Could not set value ";
    private static final String ERROR_MESSAGE_MIDDLE = " of property ";
    final String property;
    final String value;
    final String format;

    private static String errorMessage(CommandSetProperty command) {
        int valueLen = command.value != null ? command.value.length() : 0;
        int propertyLen = command.property != null ? command.property.length() : 0;
        StringBuilder sb = new StringBuilder(ERROR_MESSAGE_PREFIX.length() + ERROR_MESSAGE_MIDDLE.length() + valueLen + propertyLen);
        sb.append(ERROR_MESSAGE_PREFIX);
        sb.append(valueLen > 0 ? command.value : "");
        sb.append(ERROR_MESSAGE_MIDDLE);
        sb.append(propertyLen > 0 ? command.property : "");
        return sb.toString();
    }

    public static ResultString setProperty(PayaraServer server, CommandSetProperty command) throws PayaraIdeException {
        Future future = ServerAdmin.exec(server, command);
        try {
            return (ResultString)future.get();
        }
        catch (InterruptedException | CancellationException | ExecutionException ee) {
            throw new PayaraIdeException(CommandSetProperty.errorMessage(command), ee);
        }
    }

    public static ResultString setProperty(PayaraServer server, CommandSetProperty command, long timeout) throws PayaraIdeException {
        Future future = ServerAdmin.exec(server, command);
        try {
            return (ResultString)future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | CancellationException | ExecutionException ee) {
            throw new PayaraIdeException(CommandSetProperty.errorMessage(command), ee);
        }
        catch (TimeoutException te) {
            throw new PayaraIdeException(CommandSetProperty.errorMessage(command) + " in " + timeout + "ms", te);
        }
    }

    public CommandSetProperty(String property, String value, String format) {
        super(COMMAND);
        this.property = property;
        this.value = value;
        this.format = format;
    }

    public CommandSetProperty(String property, String value) {
        super(COMMAND);
        this.property = property;
        this.value = value;
        this.format = "DEFAULT={0}={1}";
    }

    public String getProperty() {
        return this.property;
    }

    public String getValue() {
        return this.value;
    }
}

