/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.query;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.bugtracking.commons.SaveQueryPanel;
import org.netbeans.modules.bugtracking.commons.UIUtils;
import org.netbeans.modules.bugtracking.issuetable.Filter;
import org.netbeans.modules.bugtracking.issuetable.IssueTable;
import org.netbeans.modules.bugtracking.issuetable.QueryTableCellRenderer;
import org.netbeans.modules.bugtracking.spi.QueryController;
import org.netbeans.modules.bugtracking.spi.QueryProvider;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.BugzillaConfig;
import org.netbeans.modules.bugzilla.issue.BugzillaIssue;
import org.netbeans.modules.bugzilla.query.BugzillaQuery;
import org.netbeans.modules.bugzilla.query.BugzillaQueryCellRenderer;
import org.netbeans.modules.bugzilla.query.Bundle;
import org.netbeans.modules.bugzilla.query.QueryNotifyListener;
import org.netbeans.modules.bugzilla.query.QueryPanel;
import org.netbeans.modules.bugzilla.query.QueryParameter;
import org.netbeans.modules.bugzilla.repository.BugzillaConfiguration;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.netbeans.modules.bugzilla.util.BugzillaUtil;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.util.Cancellable;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class QueryController
implements org.netbeans.modules.bugtracking.spi.QueryController,
ItemListener,
ListSelectionListener,
ActionListener,
FocusListener,
KeyListener,
ChangeListener {
    protected QueryPanel panel;
    private static final String CHANGED_NOW = "Now";
    private final QueryParameter.ComboParameter summaryParameter;
    private final QueryParameter.ComboParameter commentsParameter;
    private final QueryParameter.ComboParameter whiteboardParameter;
    private final QueryParameter.ComboParameter keywordsParameter;
    private final QueryParameter.ComboParameter peopleParameter;
    private final QueryParameter.ListParameter productParameter;
    private final QueryParameter.ListParameter componentParameter;
    private final QueryParameter.ListParameter versionParameter;
    private final QueryParameter.ListParameter statusParameter;
    private final QueryParameter.ListParameter resolutionParameter;
    private final QueryParameter.ListParameter priorityParameter;
    private final QueryParameter.ListParameter changedFieldsParameter;
    private final QueryParameter.ListParameter severityParameter;
    private final QueryParameter.ListParameter issueTypeParameter;
    private QueryParameter.ListParameter tmParameter;
    private final Map<String, QueryParameter> parameters;
    private final RequestProcessor rp = new RequestProcessor("Bugzilla query", 1, true);
    private final BugzillaRepository repository;
    protected BugzillaQuery query;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private QueryTask refreshTask;
    private final IssueTable issueTable;
    private final boolean isNetbeans;
    private final Object REFRESH_LOCK = new Object();
    private final Semaphore querySemaphore = new Semaphore(1);
    private boolean populated = false;
    private boolean wasOpened;
    private boolean wasModeShow;
    private QueryProvider.IssueContainer<BugzillaIssue> delegatingIssueContainer;
    private boolean ignoreChanges = false;
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);

    public QueryController(BugzillaRepository repository, BugzillaQuery query, String urlParameters, boolean urlDef) {
        this(repository, query, urlParameters, urlDef, true);
    }

    public QueryController(BugzillaRepository repository, BugzillaQuery query, String urlParameters, boolean urlDef, boolean populate) {
        this.repository = repository;
        this.query = query;
        this.issueTable = new IssueTable(repository.getID(), query.getDisplayName(), (org.netbeans.modules.bugtracking.spi.QueryController)this, query.getColumnDescriptors(), query.isSaved());
        this.setupRenderer(this.issueTable);
        this.panel = new QueryPanel(this.issueTable.getComponent());
        this.isNetbeans = BugzillaUtil.isNbRepository(repository);
        this.panel.setNBFieldsVisible(this.isNetbeans);
        this.panel.productList.addListSelectionListener(this);
        this.panel.filterComboBox.addItemListener(this);
        this.panel.searchButton.addActionListener(this);
        this.panel.keywordsButton.addActionListener(this);
        this.panel.cancelChangesButton.addActionListener(this);
        this.panel.saveChangesButton.addActionListener(this);
        this.panel.gotoIssueButton.addActionListener(this);
        this.panel.webButton.addActionListener((ActionListener)this);
        this.panel.urlToggleButton.addActionListener((ActionListener)this);
        this.panel.refreshButton.addActionListener((ActionListener)this);
        this.panel.modifyButton.addActionListener((ActionListener)this);
        this.panel.seenButton.addActionListener((ActionListener)this);
        this.panel.removeButton.addActionListener((ActionListener)this);
        this.panel.refreshConfigurationButton.addActionListener((ActionListener)this);
        this.panel.cloneQueryButton.addActionListener((ActionListener)this);
        this.panel.changedFromTextField.addFocusListener(this);
        this.panel.idTextField.addActionListener(this);
        this.panel.productList.addKeyListener(this);
        this.panel.componentList.addKeyListener(this);
        this.panel.versionList.addKeyListener(this);
        this.panel.statusList.addKeyListener(this);
        this.panel.resolutionList.addKeyListener(this);
        this.panel.severityList.addKeyListener(this);
        this.panel.priorityList.addKeyListener(this);
        this.panel.changedList.addKeyListener(this);
        this.panel.tmList.addKeyListener(this);
        this.panel.summaryTextField.addActionListener(this);
        this.panel.commentTextField.addActionListener(this);
        this.panel.whiteboardTextField.addActionListener(this);
        this.panel.keywordsTextField.addActionListener(this);
        this.panel.peopleTextField.addActionListener(this);
        this.panel.changedFromTextField.addActionListener(this);
        this.panel.changedToTextField.addActionListener(this);
        this.panel.changedToTextField.addActionListener(this);
        this.parameters = new LinkedHashMap<String, QueryParameter>();
        this.summaryParameter = this.createQueryParameter(QueryParameter.ComboParameter.class, this.panel.summaryComboBox, "short_desc_type");
        this.commentsParameter = this.createQueryParameter(QueryParameter.ComboParameter.class, this.panel.commentComboBox, "long_desc_type");
        this.whiteboardParameter = this.createQueryParameter(QueryParameter.ComboParameter.class, this.panel.whiteboardComboBox, "status_whiteboard_type");
        this.keywordsParameter = this.createQueryParameter(QueryParameter.ComboParameter.class, this.panel.keywordsComboBox, "keywords_type");
        this.peopleParameter = this.createQueryParameter(QueryParameter.ComboParameter.class, this.panel.peopleComboBox, "emailtype1");
        this.productParameter = this.createQueryParameter(QueryParameter.ListParameter.class, this.panel.productList, "product");
        this.componentParameter = this.createQueryParameter(QueryParameter.ListParameter.class, this.panel.componentList, "component");
        this.versionParameter = this.createQueryParameter(QueryParameter.ListParameter.class, this.panel.versionList, "version");
        this.statusParameter = this.createQueryParameter(QueryParameter.ListParameter.class, this.panel.statusList, "bug_status");
        this.resolutionParameter = this.createQueryParameter(QueryParameter.ListParameter.class, this.panel.resolutionList, "resolution");
        this.priorityParameter = this.createQueryParameter(QueryParameter.ListParameter.class, this.panel.priorityList, "priority");
        this.changedFieldsParameter = this.createQueryParameter(QueryParameter.EmptyValuesListParameter.class, this.panel.changedList, "chfield");
        this.tmParameter = this.createQueryParameter(QueryParameter.ListParameter.class, this.panel.tmList, "target_milestone");
        if (this.isNetbeans) {
            this.issueTypeParameter = this.createQueryParameter(QueryParameter.ListParameter.class, this.panel.issueTypeList, "cf_bug_type");
            this.severityParameter = null;
        } else {
            this.severityParameter = this.createQueryParameter(QueryParameter.ListParameter.class, this.panel.severityList, "bug_severity");
            this.issueTypeParameter = null;
        }
        this.createQueryParameter(QueryParameter.AllWordsTextFieldParameter.class, this.panel.summaryTextField, "short_desc");
        this.createQueryParameter(QueryParameter.AllWordsTextFieldParameter.class, this.panel.commentTextField, "long_desc");
        this.createQueryParameter(QueryParameter.AllWordsTextFieldParameter.class, this.panel.whiteboardTextField, "status_whiteboard");
        this.createQueryParameter(QueryParameter.TextFieldParameter.class, this.panel.keywordsTextField, "keywords");
        this.createQueryParameter(QueryParameter.TextFieldParameter.class, this.panel.peopleTextField, "email1");
        this.createQueryParameter(QueryParameter.CheckBoxParameter.class, this.panel.bugAssigneeCheckBox, "emailassigned_to1");
        this.createQueryParameter(QueryParameter.CheckBoxParameter.class, this.panel.reporterCheckBox, "emailreporter1");
        this.createQueryParameter(QueryParameter.CheckBoxParameter.class, this.panel.ccCheckBox, "emailcc1");
        this.createQueryParameter(QueryParameter.CheckBoxParameter.class, this.panel.commenterCheckBox, "emaillongdesc1");
        this.createQueryParameter(QueryParameter.TextFieldParameter.class, this.panel.changedFromTextField, "chfieldfrom");
        this.createQueryParameter(QueryParameter.TextFieldParameter.class, this.panel.changedToTextField, "chfieldto");
        this.createQueryParameter(QueryParameter.TextFieldParameter.class, this.panel.newValueTextField, "chfieldvalue");
        for (QueryParameter p : this.parameters.values()) {
            p.addChangeListener(this);
        }
        this.panel.filterComboBox.setModel(new DefaultComboBoxModel<Filter>(this.issueTable.getDefinedFilters()));
        if (query.isSaved()) {
            this.setAsSaved();
        } else {
            this.wasModeShow = true;
        }
        if (urlDef) {
            this.panel.switchQueryFields(false);
            this.panel.urlTextField.setText(urlParameters);
            this.populated = true;
            this.setChanged();
        } else {
            this.querySemaphore.acquireUninterruptibly();
            Bugzilla.LOG.log(Level.FINE, "lock aquired because populating {0}", query.getDisplayName());
            this.postPopulate(urlParameters, false);
        }
    }

    private void setupRenderer(IssueTable issueTable) {
        BugzillaQueryCellRenderer renderer = new BugzillaQueryCellRenderer((QueryTableCellRenderer)issueTable.getRenderer());
        issueTable.setRenderer((TableCellRenderer)renderer);
    }

    public boolean providesMode(QueryController.QueryMode mode) {
        return true;
    }

    public void opened() {
        this.wasOpened = true;
        if (this.query.isSaved()) {
            this.setIssueCount(this.query.getSize());
            if (!this.query.wasRun()) {
                this.onRefresh();
            }
            if (this.refreshTask != null) {
                this.refreshTask.fillTableIfNeccessary();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closed() {
        this.onCancelChanges();
        Object object = this.REFRESH_LOCK;
        synchronized (object) {
            if (this.refreshTask != null) {
                this.refreshTask.cancel();
            }
        }
        if (!this.query.isSaved()) {
            this.query.delete();
        }
    }

    private <T extends QueryParameter> T createQueryParameter(Class<T> clazz, Component c, String parameter) {
        try {
            Constructor<T> constructor = clazz.getConstructor(c.getClass(), String.class, String.class);
            QueryParameter t = (QueryParameter)constructor.newInstance(c, parameter, this.getRepository().getTaskRepository().getCharacterEncoding());
            this.parameters.put(parameter, t);
            return (T)t;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            Bugzilla.LOG.log(Level.SEVERE, parameter, ex);
            return null;
        }
    }

    public JComponent getComponent(QueryController.QueryMode mode) {
        this.setMode(mode);
        return this.panel;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.bugzilla.query.BugzillaQuery");
    }

    private void setMode(QueryController.QueryMode mode) {
        switch (mode) {
            case EDIT: {
                if (!this.query.isSaved()) break;
                this.onModify();
                break;
            }
            case VIEW: {
                this.wasModeShow = true;
                this.onCancelChanges();
                this.selectFilter(this.issueTable.getAllFilter());
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported mode " + mode);
            }
        }
    }

    public String getUrlParameters(boolean encode) {
        if (this.panel.urlPanel.isVisible()) {
            return this.panel.urlTextField.getText();
        }
        StringBuilder sb = new StringBuilder();
        for (QueryParameter qp : this.parameters.values()) {
            sb.append(qp.get(encode));
        }
        return sb.toString();
    }

    protected BugzillaRepository getRepository() {
        return this.repository;
    }

    protected void postPopulate(final String urlParameters, final boolean forceRefresh) {
        final RequestProcessor.Task[] t = new RequestProcessor.Task[1];
        Cancellable c = new Cancellable(){
            final /* synthetic */ QueryController this$0;
            {
                this.this$0 = this$0;
            }

            public boolean cancel() {
                if (t[0] != null) {
                    return t[0].cancel();
                }
                return true;
            }
        };
        final String msgPopulating = NbBundle.getMessage(QueryController.class, (String)"MSG_Populating", (Object[])new Object[]{this.repository.getDisplayName()});
        final ProgressHandle handle = ProgressHandleFactory.createHandle((String)msgPopulating, (Cancellable)c);
        EventQueue.invokeLater(new Runnable(){
            final /* synthetic */ QueryController this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.enableFields(false);
                this.this$0.panel.showRetrievingProgress(true, msgPopulating, !this.this$0.query.isSaved());
                handle.start();
            }
        });
        t[0] = this.rp.post(new Runnable(){
            final /* synthetic */ QueryController this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    if (forceRefresh) {
                        this.this$0.repository.refreshConfiguration();
                    }
                    this.this$0.populate(urlParameters);
                }
                catch (Throwable throwable) {
                    EventQueue.invokeLater(new Runnable(){
                        final /* synthetic */ ProgressHandle val$handle;
                        final /* synthetic */ 3 this$1;
                        {
                            this.val$handle = progressHandle;
                            this.this$1 = this$1;
                        }

                        @Override
                        public void run() {
                            this.this$1.this$0.enableFields(true);
                            this.this$1.this$0.setChanged();
                            this.val$handle.finish();
                            this.this$1.this$0.panel.showRetrievingProgress(false, null, !this.this$1.this$0.query.isSaved());
                        }
                    });
                    throw throwable;
                }
                EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
    }

    protected void populate(final String urlParameters) {
        BugzillaConfiguration bc;
        if (Bugzilla.LOG.isLoggable(Level.FINE)) {
            Bugzilla.LOG.log(Level.FINE, "Starting populate query controller{0}", this.query.isSaved() ? " - " + this.query.getDisplayName() : "");
        }
        if ((bc = this.repository.getConfiguration()) == null || !bc.isValid()) {
            this.querySemaphore.release();
            return;
        }
        EventQueue.invokeLater(new Runnable(){
            final /* synthetic */ QueryController this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.ignoreChanges = true;
                try {
                    this.this$0.productParameter.setParameterValues(this.this$0.toParameterValues(bc.getProducts()));
                    this.this$0.populateProductDetails(new String[0]);
                    if (this.this$0.isNetbeans) {
                        this.this$0.issueTypeParameter.setParameterValues(this.this$0.toParameterValues(bc.getIssueTypes()));
                    } else {
                        this.this$0.severityParameter.setParameterValues(this.this$0.toParameterValues(bc.getSeverities()));
                    }
                    this.this$0.statusParameter.setParameterValues(this.this$0.toParameterValues(bc.getStatusValues()));
                    this.this$0.resolutionParameter.setParameterValues(this.this$0.toParameterValues(this.this$0.getQueryResolutions(bc)));
                    this.this$0.priorityParameter.setParameterValues(this.this$0.toParameterValues(bc.getPriorities()));
                    this.this$0.changedFieldsParameter.setParameterValues(QueryParameter.PV_LAST_CHANGE);
                    this.this$0.summaryParameter.setParameterValues(QueryParameter.PV_TEXT_SEARCH_VALUES);
                    this.this$0.commentsParameter.setParameterValues(QueryParameter.PV_TEXT_SEARCH_VALUES);
                    this.this$0.whiteboardParameter.setParameterValues(QueryParameter.PV_TEXT_SEARCH_VALUES);
                    this.this$0.keywordsParameter.setParameterValues(QueryParameter.PV_KEYWORDS_VALUES);
                    this.this$0.peopleParameter.setParameterValues(QueryParameter.PV_PEOPLE_VALUES);
                    this.this$0.panel.changedToTextField.setText(QueryController.CHANGED_NOW);
                    this.this$0.setParameters(urlParameters != null ? urlParameters : this.this$0.getDefaultParameters());
                    this.this$0.populated = true;
                    Bugzilla.LOG.log(Level.FINE, "populated query {0}", this.this$0.query.getDisplayName());
                }
                catch (Throwable throwable) {
                    this.this$0.resetParameters();
                    this.this$0.ignoreChanges = false;
                    this.this$0.querySemaphore.release();
                    Bugzilla.LOG.log(Level.FINE, "released lock on query {0}", this.this$0.query.getDisplayName());
                    if (Bugzilla.LOG.isLoggable(Level.FINE)) {
                        Bugzilla.LOG.log(Level.FINE, "Finnished populate query controller {0}", this.this$0.query.isSaved() ? " - " + this.this$0.query.getDisplayName() : "");
                    }
                    throw throwable;
                }
                this.this$0.resetParameters();
                this.this$0.ignoreChanges = false;
                this.this$0.querySemaphore.release();
                Bugzilla.LOG.log(Level.FINE, "released lock on query {0}", this.this$0.query.getDisplayName());
                if (Bugzilla.LOG.isLoggable(Level.FINE)) {
                    Bugzilla.LOG.log(Level.FINE, "Finnished populate query controller {0}", this.this$0.query.isSaved() ? " - " + this.this$0.query.getDisplayName() : "");
                }
            }
        });
    }

    private String getDefaultParameters() {
        return BugzillaUtil.isNbRepository(this.repository) ? "&bug_status=NEW&bug_status=STARTED&bug_status=REOPENED" : "&bug_status=NEW&bug_status=ASSIGNED&bug_status=REOPENED";
    }

    protected void enableFields(boolean bl) {
        this.panel.enableFields(bl);
        for (Map.Entry<String, QueryParameter> e : this.parameters.entrySet()) {
            QueryParameter qp = this.parameters.get(e.getKey());
            qp.setEnabled(bl);
        }
    }

    protected void disableProduct() {
        this.productParameter.setAlwaysDisabled(true);
    }

    protected void selectFirstProduct() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (QueryController.this.panel.productList.getModel().getSize() > 0) {
                    QueryController.this.panel.productList.setSelectedIndex(0);
                }
            }
        });
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.panel.filterComboBox) {
            this.onFilterChange((Filter)e.getItem());
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.panel.productList) {
            this.onProductChanged(e);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.panel.changedFromTextField.getText().equals("")) {
            String lastChangeFrom = BugzillaConfig.getInstance().getLastChangeFrom();
            this.panel.changedFromTextField.setText(lastChangeFrom);
            this.panel.changedFromTextField.setSelectionStart(0);
            this.panel.changedFromTextField.setSelectionEnd(lastChangeFrom.length());
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.panel.searchButton) {
            this.onRefresh();
        } else if (e.getSource() == this.panel.gotoIssueButton) {
            this.onGotoIssue();
        } else if (e.getSource() == this.panel.keywordsButton) {
            this.onKeywords();
        } else if (e.getSource() == this.panel.saveChangesButton) {
            this.onSave();
        } else if (e.getSource() == this.panel.cancelChangesButton) {
            this.onCancelChanges();
        } else if (e.getSource() == this.panel.webButton) {
            this.onWeb();
        } else if (e.getSource() == this.panel.urlToggleButton) {
            this.onDefineAs();
        } else if (e.getSource() == this.panel.refreshButton) {
            this.onRefresh();
        } else if (e.getSource() == this.panel.modifyButton) {
            this.onModify();
        } else if (e.getSource() == this.panel.seenButton) {
            this.onMarkSeen();
        } else if (e.getSource() == this.panel.removeButton) {
            this.onRemove();
        } else if (e.getSource() == this.panel.refreshConfigurationButton) {
            this.onRefreshConfiguration();
        } else if (e.getSource() == this.panel.cloneQueryButton) {
            this.onCloneQuery();
        } else if (e.getSource() == this.panel.idTextField) {
            if (!this.panel.idTextField.getText().trim().equals("")) {
                this.onGotoIssue();
            }
        } else if (e.getSource() == this.panel.summaryTextField || e.getSource() == this.panel.commentTextField || e.getSource() == this.panel.keywordsTextField || e.getSource() == this.panel.peopleTextField || e.getSource() == this.panel.changedFromTextField || e.getSource() == this.panel.newValueTextField || e.getSource() == this.panel.changedToTextField) {
            this.onRefresh();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() != 10) {
            return;
        }
        if (e.getSource() == this.panel.productList || e.getSource() == this.panel.componentList || e.getSource() == this.panel.versionList || e.getSource() == this.panel.statusList || e.getSource() == this.panel.resolutionList || e.getSource() == this.panel.priorityList || e.getSource() == this.panel.changedList) {
            this.onRefresh();
        }
    }

    private void onFilterChange(Filter filter) {
        this.selectFilter(filter);
    }

    private void onSave() {
        Bugzilla.getInstance().getRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                QueryController.this.saveSynchronously(null);
            }
        });
    }

    boolean saveSynchronously(String name) {
        boolean firstTime;
        Bugzilla.LOG.fine("on save start");
        boolean bl = firstTime = !this.query.isSaved();
        if (firstTime) {
            String string = name = name == null ? this.getSaveName() : name;
            if (name == null) {
                return false;
            }
        }
        String string = name = name == null ? this.query.getDisplayName() : name;
        assert (name != null);
        Bugzilla.LOG.log(Level.FINE, "saving query ''{0}''", new Object[]{name});
        this.save(name);
        if (!firstTime) {
            Bugzilla.LOG.log(Level.FINE, "refreshing query ''{0}'' after save", new Object[]{name});
            this.onRefresh();
        }
        Bugzilla.LOG.log(Level.FINE, "query ''{0}'' saved", new Object[]{name});
        Bugzilla.LOG.fine("on save finnish");
        return true;
    }

    void save(String name) {
        this.query.setName(name);
        this.saveQuery();
        this.query.setSaved(true);
        this.setAsSaved();
        this.fireChanged();
    }

    private String getSaveName() {
        SaveQueryPanel.QueryNameValidator v = new SaveQueryPanel.QueryNameValidator(){

            public String isValid(String name) {
                Collection<BugzillaQuery> queries = QueryController.this.repository.getQueries();
                for (BugzillaQuery q : queries) {
                    if (!q.getDisplayName().equals(name)) continue;
                    return NbBundle.getMessage(QueryController.class, (String)"MSG_SAME_NAME");
                }
                return null;
            }
        };
        return SaveQueryPanel.show((SaveQueryPanel.QueryNameValidator)v, (HelpCtx)new HelpCtx("org.netbeans.modules.bugzilla.query.savePanel"));
    }

    private void onCancelChanges() {
        String urlParameters;
        if (this.query.getDisplayName() != null && (urlParameters = BugzillaConfig.getInstance().getUrlParams(this.repository, this.query.getDisplayName())) != null) {
            this.setParameters(urlParameters);
        }
        this.setAsSaved();
    }

    public void selectFilter(final Filter filter) {
        if (filter != null) {
            Collection<BugzillaIssue> issues = this.query.getIssues();
            int c = 0;
            if (issues != null) {
                for (BugzillaIssue issue : issues) {
                    if (!filter.accept(issue.getNode())) continue;
                    ++c;
                }
            }
            final int issueCount = c;
            Runnable r = new Runnable(){
                final /* synthetic */ QueryController this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    this.this$0.panel.filterComboBox.setSelectedItem(filter);
                    this.this$0.setIssueCount(issueCount);
                }
            };
            if (EventQueue.isDispatchThread()) {
                r.run();
            } else {
                EventQueue.invokeLater(r);
            }
        }
        this.issueTable.setFilter(filter);
    }

    private void setAsSaved() {
        this.panel.setSaved(this.query.getDisplayName(), this.getLastRefresh());
        this.panel.setModifyVisible(false);
        this.wasModeShow = true;
    }

    private String getLastRefresh() throws MissingResourceException {
        long l = this.query.getLastRefresh();
        return l > 0L ? this.dateFormat.format(new Date(l)) : NbBundle.getMessage(QueryController.class, (String)"LBL_Never");
    }

    private void onGotoIssue() {
        String idText = this.panel.idTextField.getText().trim();
        if (idText == null || idText.trim().equals("")) {
            return;
        }
        final String id = idText.replaceAll("\\s", "");
        final RequestProcessor.Task[] t = new RequestProcessor.Task[1];
        Cancellable c = new Cancellable(){
            final /* synthetic */ QueryController this$0;
            {
                this.this$0 = this$0;
            }

            public boolean cancel() {
                if (t[0] != null) {
                    return t[0].cancel();
                }
                return true;
            }
        };
        final ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(QueryController.class, (String)"MSG_Opening", (Object[])new Object[]{id}), (Cancellable)c);
        t[0] = Bugzilla.getInstance().getRequestProcessor().create(new Runnable(){
            final /* synthetic */ QueryController this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                handle.start();
                try {
                    this.this$0.openIssue(this.this$0.repository.getIssue(id));
                }
                finally {
                    handle.finish();
                }
            }
        });
        t[0].schedule(0);
    }

    protected void openIssue(BugzillaIssue issue) {
        if (issue != null) {
            BugzillaUtil.openIssue(issue);
        }
    }

    private void onWeb() {
        String params = this.getUrlParameters(true);
        String repoURL = this.repository.getTaskRepository().getRepositoryUrl() + "/query.cgi?format=advanced";
        final String urlString = repoURL + (params != null && !params.equals("") ? params : "");
        Bugzilla.getInstance().getRequestProcessor().post(new Runnable(){
            final /* synthetic */ QueryController this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                URL url;
                try {
                    url = new URL(urlString);
                }
                catch (MalformedURLException ex) {
                    Bugzilla.LOG.log(Level.SEVERE, null, ex);
                    return;
                }
                HtmlBrowser.URLDisplayer displayer = HtmlBrowser.URLDisplayer.getDefault();
                if (displayer != null) {
                    displayer.showURL(url);
                } else {
                    Bugzilla.LOG.warning("No URLDisplayer found.");
                }
            }
        });
    }

    private void onProductChanged(ListSelectionEvent e) {
        Object[] values = this.panel.productList.getSelectedValues();
        String[] products = null;
        if (values != null) {
            products = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                products[i] = ((QueryParameter.ParameterValue)values[i]).getValue();
            }
        }
        this.populateProductDetails(products);
    }

    private void onDefineAs() {
        this.panel.switchQueryFields(this.panel.urlPanel.isVisible());
    }

    private void onKeywords() {
        String keywords = BugzillaUtil.getKeywords(NbBundle.getMessage(QueryController.class, (String)"LBL_SelectKeywords"), this.panel.keywordsTextField.getText(), this.repository);
        if (keywords != null) {
            this.panel.keywordsTextField.setText(keywords);
        }
    }

    public void autoRefresh() {
        this.refresh(true, false);
    }

    public void refresh(boolean synchronously) {
        this.refresh(false, synchronously);
    }

    public void onRefresh() {
        if (this.query.isSaved() && this.isChanged()) {
            NotifyDescriptor.Confirmation desc = new NotifyDescriptor.Confirmation((Object)Bundle.MSG_Changed(), 1);
            Object[] choose = new Object[]{Bundle.LBL_Save(), Bundle.LBL_Discard(), NotifyDescriptor.CANCEL_OPTION};
            desc.setOptions(choose);
            Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            if (ret == choose[0]) {
                this.saveQuery();
            } else {
                if (ret == choose[1]) {
                    this.onCancelChanges();
                    return;
                }
                return;
            }
        }
        this.refresh(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh(boolean auto, boolean synchronously) {
        RequestProcessor.Task t;
        Object object = this.REFRESH_LOCK;
        synchronized (object) {
            if (this.refreshTask == null) {
                this.refreshTask = new QueryTask();
            } else {
                this.refreshTask.cancel();
            }
            t = this.refreshTask.post(auto);
        }
        if (synchronously) {
            t.waitFinished();
        }
    }

    private void onModify() {
        this.panel.setModifyVisible(true);
    }

    private void onMarkSeen() {
        Bugzilla.getInstance().getRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                Collection<BugzillaIssue> issues = QueryController.this.query.getIssues();
                for (BugzillaIssue issue : issues) {
                    issue.setUpToDate(true);
                }
            }
        });
    }

    private void onRemove() {
        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(QueryController.class, (String)"MSG_RemoveQuery", (Object[])new Object[]{this.query.getDisplayName()}), NbBundle.getMessage(QueryController.class, (String)"CTL_RemoveQuery"), 2);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)nd) == NotifyDescriptor.OK_OPTION) {
            Bugzilla.getInstance().getRequestProcessor().post(new Runnable(){

                @Override
                public void run() {
                    QueryController.this.remove();
                }
            });
        }
    }

    protected void onCloneQuery() {
        String p = this.getUrlParameters(false);
        BugzillaQuery q = new BugzillaQuery(null, this.getRepository(), p, false, this.isUrlDefined(), true);
        BugzillaUtil.openQuery(q);
    }

    private void onRefreshConfiguration() {
        this.postPopulate(this.getUrlParameters(false), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove() {
        Object object = this.REFRESH_LOCK;
        synchronized (object) {
            if (this.refreshTask != null) {
                this.refreshTask.cancel();
            }
        }
        this.query.remove();
    }

    private void populateProductDetails(String ... products) {
        BugzillaConfiguration bc = this.repository.getConfiguration();
        if (bc == null || !bc.isValid()) {
            return;
        }
        List<String> targetMilestones = bc.getTargetMilestones(null);
        final boolean usingTargetMilestones = !targetMilestones.isEmpty();
        UIUtils.runInAWT((Runnable)new Runnable(){
            final /* synthetic */ QueryController this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.panel.tmLabel.setVisible(usingTargetMilestones);
                this.this$0.panel.tmList.setVisible(usingTargetMilestones);
                this.this$0.panel.tmScrollPane.setVisible(usingTargetMilestones);
            }
        });
        if (products == null || products.length == 0) {
            products = new String[]{null};
        }
        ArrayList<String> newComponents = new ArrayList<String>();
        ArrayList<String> newVersions = new ArrayList<String>();
        ArrayList<String> newTargetMilestone = new ArrayList<String>();
        for (String p : products) {
            List<String> productComponents = bc.getComponents(p);
            for (String string : productComponents) {
                if (newComponents.contains(string)) continue;
                newComponents.add(string);
            }
            List<String> productVersions = bc.getVersions(p);
            for (String c3 : productVersions) {
                if (newVersions.contains(c3)) continue;
                newVersions.add(c3);
            }
            if (!usingTargetMilestones) continue;
            List<String> list = bc.getTargetMilestones(p);
            for (String c4 : list) {
                if (newTargetMilestone.contains(c4)) continue;
                newTargetMilestone.add(c4);
            }
        }
        Collections.sort(newComponents);
        Collections.sort(newVersions);
        this.componentParameter.setParameterValues(this.toParameterValues(newComponents));
        this.versionParameter.setParameterValues(this.toParameterValues(newVersions));
        if (usingTargetMilestones) {
            this.tmParameter.setParameterValues(this.toParameterValues(newTargetMilestone));
        }
    }

    private List<QueryParameter.ParameterValue> toParameterValues(List<String> values) {
        ArrayList<QueryParameter.ParameterValue> ret = new ArrayList<QueryParameter.ParameterValue>(values.size());
        for (String v : values) {
            ret.add(new QueryParameter.ParameterValue(v, v));
        }
        return ret;
    }

    private void setParameters(String urlParameters) {
        if (urlParameters == null) {
            return;
        }
        String[] params = urlParameters.split("&");
        if (params == null || params.length == 0) {
            return;
        }
        HashMap<String, ArrayList<QueryParameter.ParameterValue>> normalizedParams = new HashMap<String, ArrayList<QueryParameter.ParameterValue>>();
        for (String p : params) {
            int idx = p.indexOf("=");
            if (idx <= -1) continue;
            String parameter = p.substring(0, idx);
            String value = p.substring(idx + 1);
            QueryParameter.ParameterValue pv = new QueryParameter.ParameterValue(value, value);
            ArrayList<QueryParameter.ParameterValue> values = (ArrayList<QueryParameter.ParameterValue>)normalizedParams.get(parameter);
            if (values == null) {
                values = new ArrayList<QueryParameter.ParameterValue>();
                normalizedParams.put(parameter, values);
            }
            values.add(pv);
        }
        List componentPV = null;
        List versionPV = null;
        for (Map.Entry e : normalizedParams.entrySet()) {
            QueryParameter qp = this.parameters.get(e.getKey());
            if (qp == null) continue;
            if (qp == this.componentParameter) {
                componentPV = (List)e.getValue();
                continue;
            }
            if (qp == this.versionParameter) {
                versionPV = (List)e.getValue();
                continue;
            }
            List pvs = (List)e.getValue();
            qp.setValues(pvs.toArray(new QueryParameter.ParameterValue[0]));
        }
        this.setDependentParameter(this.componentParameter, componentPV);
        this.setDependentParameter(this.versionParameter, versionPV);
    }

    private void setDependentParameter(QueryParameter qp, List<QueryParameter.ParameterValue> values) {
        if (values != null) {
            qp.setValues(values.toArray(new QueryParameter.ParameterValue[0]));
        }
    }

    private void setIssueCount(final int count) {
        EventQueue.invokeLater(new Runnable(){
            final /* synthetic */ QueryController this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                String msg = count == 1 ? NbBundle.getMessage(QueryController.class, (String)"LBL_MatchingIssue", (Object[])new Object[]{count}) : NbBundle.getMessage(QueryController.class, (String)"LBL_MatchingIssues", (Object[])new Object[]{count});
                this.this$0.panel.tableSummaryLabel.setText(msg);
            }
        });
    }

    boolean isUrlDefined() {
        return this.panel.urlPanel.isVisible();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void switchToDeterminateProgress(long issuesCount) {
        Object object = this.REFRESH_LOCK;
        synchronized (object) {
            if (this.refreshTask != null) {
                this.refreshTask.switchToDeterminateProgress(issuesCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addProgressUnit(String issueDesc) {
        Object object = this.REFRESH_LOCK;
        synchronized (object) {
            if (this.refreshTask != null) {
                this.refreshTask.addProgressUnit(issueDesc);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.setChanged();
    }

    public void setChanged() {
        UIUtils.runInAWT((Runnable)new Runnable(){

            @Override
            public void run() {
                QueryController.this.panel.saveChangesButton.setEnabled(!QueryController.this.ignoreChanges && QueryController.this.isChanged() || !QueryController.this.query.isSaved());
                QueryController.this.fireChanged();
            }
        });
    }

    public boolean isChanged() {
        for (QueryParameter p : this.parameters.values()) {
            if (!p.isChanged()) continue;
            return true;
        }
        return false;
    }

    private List<String> getQueryResolutions(BugzillaConfiguration bc) {
        ArrayList<String> l = new ArrayList<String>(bc.getResolutions());
        l.add(0, "---");
        return l;
    }

    private void resetParameters() {
        for (QueryParameter p : this.parameters.values()) {
            p.reset();
        }
    }

    private void saveQuery() {
        String name = this.query.getDisplayName();
        Bugzilla.LOG.log(Level.FINE, "saving query ''{0}''", new Object[]{name});
        this.repository.saveQuery(this.query);
        this.resetParameters();
        Bugzilla.LOG.log(Level.FINE, "query ''{0}'' saved", new Object[]{name});
    }

    public boolean saveChanges(String name) {
        return this.saveSynchronously(name);
    }

    public boolean discardUnsavedChanges() {
        this.onCancelChanges();
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.support.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.support.removePropertyChangeListener(l);
    }

    private void fireChanged() {
        this.support.firePropertyChange("bugtracking.query.changed", null, null);
    }

    IssueTable getIssueTable() {
        return this.issueTable;
    }

    public void setContainer(QueryProvider.IssueContainer<BugzillaIssue> c) {
        this.delegatingIssueContainer = c;
    }

    private class QueryTask
    implements Runnable,
    Cancellable,
    QueryNotifyListener {
        private ProgressHandle handle;
        private RequestProcessor.Task task;
        private int counter;
        private boolean autoRefresh;
        private long progressMaxWorkunits;
        private int progressWorkunits;
        private final LinkedList<BugzillaIssue> notifiedIssues = new LinkedList();

        public QueryTask() {
            QueryController.this.query.addNotifyListener(this);
        }

        private void startQuery() {
            String displayName = QueryController.this.query.getDisplayName() != null ? QueryController.this.query.getDisplayName() + " (" + QueryController.this.repository.getDisplayName() + ")" : QueryController.this.repository.getDisplayName();
            this.handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(QueryController.class, (String)"MSG_SearchingQuery", (Object[])new Object[]{displayName}), (Cancellable)this);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    QueryController.this.enableFields(false);
                    QueryController.this.panel.showSearchingProgress(true, NbBundle.getMessage(QueryController.class, (String)"MSG_Searching"));
                }
            });
            if (QueryController.this.delegatingIssueContainer != null) {
                QueryController.this.delegatingIssueContainer.refreshingStarted();
            }
            this.handle.start();
        }

        private void finnishQuery() {
            this.task = null;
            if (QueryController.this.delegatingIssueContainer != null) {
                QueryController.this.delegatingIssueContainer.refreshingFinished();
            }
            if (this.handle != null) {
                this.handle.finish();
                this.handle = null;
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    QueryController.this.panel.setQueryRunning(false);
                    QueryController.this.panel.setLastRefresh(QueryController.this.getLastRefresh());
                    QueryController.this.panel.showNoContentPanel(false);
                    QueryController.this.enableFields(true);
                }
            });
        }

        void switchToDeterminateProgress(long progressMaxWorkunits) {
            if (this.handle != null) {
                this.handle.switchToDeterminate((int)progressMaxWorkunits);
                this.progressMaxWorkunits = progressMaxWorkunits;
                this.progressWorkunits = 0;
            }
        }

        void addProgressUnit(String issueDesc) {
            if (this.handle != null && (long)this.progressWorkunits < this.progressMaxWorkunits) {
                this.handle.progress(NbBundle.getMessage(QueryController.class, (String)"LBL_RetrievingIssue", (Object[])new Object[]{issueDesc}), ++this.progressWorkunits);
            }
        }

        private void executeQuery() {
            this.setQueryRunning(true);
            String lastChageFrom = QueryController.this.panel.changedFromTextField.getText().trim();
            if (lastChageFrom != null && !lastChageFrom.equals("")) {
                BugzillaConfig.getInstance().setLastChangeFrom(lastChageFrom);
            }
            try {
                if (QueryController.this.panel.urlPanel.isVisible()) {
                    QueryController.this.query.refresh(QueryController.this.panel.urlTextField.getText(), this.autoRefresh);
                } else {
                    QueryController.this.query.refresh(QueryController.this.getUrlParameters(true), this.autoRefresh);
                }
            }
            finally {
                this.setQueryRunning(false);
                this.task = null;
            }
        }

        private void setQueryRunning(final boolean running) {
            EventQueue.invokeLater(new Runnable(){
                final /* synthetic */ QueryTask this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void run() {
                    this.this$1.QueryController.this.panel.setQueryRunning(running);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.startQuery();
            try {
                Bugzilla.LOG.log(Level.FINE, "waiting until lock releases in query {0}", QueryController.this.query.getDisplayName());
                long t = System.currentTimeMillis();
                try {
                    QueryController.this.querySemaphore.acquire();
                }
                catch (InterruptedException ex) {
                    Bugzilla.LOG.log(Level.INFO, "interuped while trying to lock query", ex);
                    this.finnishQuery();
                    return;
                }
                QueryController.this.querySemaphore.release();
                Bugzilla.LOG.log(Level.FINE, "lock aquired for query {0} after {1}", new Object[]{QueryController.this.query.getDisplayName(), System.currentTimeMillis() - t});
                if (!QueryController.this.populated) {
                    Bugzilla.LOG.log(Level.WARNING, "Skipping refresh of query {0} because isn''t populated.", QueryController.this.query.getDisplayName());
                    return;
                }
                this.executeQuery();
            }
            finally {
                this.finnishQuery();
            }
        }

        RequestProcessor.Task post(boolean autoRefresh) {
            RequestProcessor.Task t = this.task;
            if (t != null) {
                t.cancel();
            }
            this.task = t = QueryController.this.rp.create((Runnable)this);
            this.autoRefresh = autoRefresh;
            t.schedule(0);
            return t;
        }

        public boolean cancel() {
            RequestProcessor.Task t = this.task;
            if (t != null) {
                t.cancel();
                this.finnishQuery();
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyDataAdded(BugzillaIssue issue) {
            if (QueryController.this.delegatingIssueContainer != null) {
                QueryController.this.delegatingIssueContainer.add((Object[])new BugzillaIssue[]{issue});
            }
            if (QueryController.this.wasOpened && QueryController.this.wasModeShow) {
                QueryController.this.issueTable.addNode(issue.getNode());
            } else {
                LinkedList<BugzillaIssue> linkedList = this.notifiedIssues;
                synchronized (linkedList) {
                    this.notifiedIssues.add(issue);
                }
            }
            QueryController.this.setIssueCount(++this.counter);
            if (this.counter == 1) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        QueryController.this.panel.showNoContentPanel(false);
                    }
                });
            }
        }

        @Override
        public void notifyDataRemoved(BugzillaIssue issue) {
            if (QueryController.this.delegatingIssueContainer != null) {
                QueryController.this.delegatingIssueContainer.remove((Object[])new BugzillaIssue[]{issue});
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void started() {
            QueryController.this.issueTable.started();
            this.counter = 0;
            LinkedList<BugzillaIssue> linkedList = this.notifiedIssues;
            synchronized (linkedList) {
                this.notifiedIssues.clear();
            }
            QueryController.this.setIssueCount(this.counter);
        }

        @Override
        public void finished() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fillTableIfNeccessary() {
            LinkedList<BugzillaIssue> linkedList = this.notifiedIssues;
            synchronized (linkedList) {
                for (BugzillaIssue issue : this.notifiedIssues) {
                    QueryController.this.issueTable.addNode(issue.getNode());
                }
                this.notifiedIssues.clear();
            }
        }
    }
}

