/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.icefaces.ui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.libraries.LibrariesCustomizer;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.web.jsf.icefaces.Icefaces2Customizer;
import org.netbeans.modules.web.jsf.icefaces.Icefaces2Implementation;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class Icefaces2CustomizerPanelVisual
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(Icefaces2CustomizerPanelVisual.class.getName());
    private static final long serialVersionUID = 1L;
    private static final RequestProcessor RP = new RequestProcessor("Icefaces Libraries Loader");
    private volatile Set<Library> icefacesLibraries = new HashSet<Library>();
    private final Icefaces2Customizer customizer;
    private ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JButton createIcefacesLibraryButton;
    private JLabel headerLabel;
    private JComboBox icefacesLibraryComboBox;
    private JLabel icefacesLibraryLabel;
    private JLabel notExistingLibraryLabel;
    private JLabel noteLabel;

    public Icefaces2CustomizerPanelVisual(Icefaces2Customizer customizer) {
        this.customizer = customizer;
        this.initComponents();
        this.noteLabel.setPreferredSize(new Dimension(1, 1));
        this.changeSupport.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Icefaces2CustomizerPanelVisual.this.customizer.fireChange();
            }
        });
        this.initLibraries(true);
        this.icefacesLibraryComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Icefaces2CustomizerPanelVisual.this.changeSupport.fireChange();
            }
        });
    }

    public final void initLibraries(final boolean setStoredValue) {
        long time = System.currentTimeMillis();
        final ArrayList registeredRichfaces = new ArrayList();
        RP.post(new Runnable(){
            final /* synthetic */ Icefaces2CustomizerPanelVisual this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                for (Library library : Icefaces2Customizer.getIcefacesLibraries()) {
                    registeredRichfaces.add(library.getDisplayName());
                    this.this$0.icefacesLibraries.add(library);
                }
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        this.this$1.this$0.setLibrariesComboBox(this.this$1.this$0.icefacesLibraryComboBox, registeredRichfaces);
                        if (setStoredValue && !this.this$1.this$0.icefacesLibraries.isEmpty()) {
                            this.this$1.this$0.setDefaultComboBoxValues();
                        } else {
                            this.this$1.this$0.customizer.setFixedLibrary(!this.this$1.this$0.icefacesLibraries.isEmpty());
                            this.this$1.this$0.changeSupport.fireChange();
                        }
                    }
                });
            }
        });
        LOGGER.log(Level.FINEST, "Time spent in {0} initLibraries = {1} ms", new Object[]{this.getClass().getName(), System.currentTimeMillis() - time});
    }

    public String getIcefacesLibrary() {
        if (this.icefacesLibraryComboBox.getSelectedItem() != null) {
            return (String)this.icefacesLibraryComboBox.getSelectedItem();
        }
        return null;
    }

    public String getErrorMessage() {
        if (this.icefacesLibraries == null || this.icefacesLibraries.isEmpty()) {
            return NbBundle.getMessage(Icefaces2CustomizerPanelVisual.class, (String)"LBL_MissingIcefacesLibraries");
        }
        return null;
    }

    public String getWarningMessage() {
        return null;
    }

    private void setDefaultComboBoxValues() {
        Preferences preferences = Icefaces2Implementation.getIcefacesPreferences();
        this.icefacesLibraryComboBox.setSelectedItem(preferences.get("preffered-library", ""));
    }

    private void setLibrariesComboBox(JComboBox comboBox, List<String> items) {
        comboBox.setModel(new DefaultComboBoxModel<Object>(items.toArray()));
        comboBox.setEnabled(!items.isEmpty());
    }

    private void initComponents() {
        this.headerLabel = new JLabel();
        this.icefacesLibraryLabel = new JLabel();
        this.icefacesLibraryComboBox = new JComboBox();
        this.notExistingLibraryLabel = new JLabel();
        this.createIcefacesLibraryButton = new JButton();
        this.noteLabel = new JLabel();
        this.headerLabel.setText(NbBundle.getMessage(Icefaces2CustomizerPanelVisual.class, (String)"Icefaces2CustomizerPanelVisual.headerLabel.text"));
        this.icefacesLibraryLabel.setText(NbBundle.getMessage(Icefaces2CustomizerPanelVisual.class, (String)"Icefaces2CustomizerPanelVisual.icefacesLibraryLabel.text"));
        this.icefacesLibraryComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Search ICEfaces Libraries..."}));
        this.notExistingLibraryLabel.setText(NbBundle.getMessage(Icefaces2CustomizerPanelVisual.class, (String)"Icefaces2CustomizerPanelVisual.notExistingLibraryLabel.text"));
        this.createIcefacesLibraryButton.setText(NbBundle.getMessage(Icefaces2CustomizerPanelVisual.class, (String)"Icefaces2CustomizerPanelVisual.createIcefacesLibraryButton.text"));
        this.createIcefacesLibraryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Icefaces2CustomizerPanelVisual.this.createIcefacesLibraryButtonActionPerformed(evt);
            }
        });
        this.noteLabel.setText(NbBundle.getMessage(Icefaces2CustomizerPanelVisual.class, (String)"Icefaces2CustomizerPanelVisual.noteLabel.text"));
        this.noteLabel.setVerticalAlignment(1);
        this.noteLabel.setVerticalTextPosition(1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.headerLabel).addGroup(layout.createSequentialGroup().addComponent(this.icefacesLibraryLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.icefacesLibraryComboBox, 0, 336, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.notExistingLibraryLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.createIcefacesLibraryButton)).addComponent(this.noteLabel, -2, 501, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.headerLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.icefacesLibraryLabel).addComponent(this.icefacesLibraryComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.notExistingLibraryLabel).addComponent(this.createIcefacesLibraryButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 28, Short.MAX_VALUE).addComponent(this.noteLabel).addContainerGap()));
    }

    private void createIcefacesLibraryButtonActionPerformed(ActionEvent evt) {
        LibrariesCustomizer.showCreateNewLibraryCustomizer((LibraryManager)LibraryManager.getDefault());
        this.initLibraries(false);
    }
}

