/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.project;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.javafx2.project.JavaFXProjectWizardIterator;
import org.netbeans.modules.javafx2.project.PanelConfigureProject;
import org.netbeans.modules.javafx2.project.PanelProjectLocationVisual;
import org.netbeans.modules.javafx2.project.PanelSourceFolders;
import org.netbeans.modules.javafx2.project.SettingsPanel;
import org.netbeans.modules.javafx2.project.WizardSettings;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class PanelProjectLocationExtSrc
extends SettingsPanel {
    private PanelConfigureProject firer;
    private WizardDescriptor wizardDescriptor;
    private boolean calculatePF;
    private static final String DEFAULT_BUILD_SCRIPT_NAME = "build.xml";
    private static final String NB_BUILD_SCRIPT_NAME = "nbbuild.xml";
    private JTextField buildScriptName;
    private JButton jButton3;
    private JLabel jLabel1;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JTextField projectLocation;
    private JTextField projectName;

    PanelProjectLocationExtSrc(PanelConfigureProject panel) {
        this.firer = panel;
        this.initComponents();
        this.projectName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                PanelProjectLocationExtSrc.this.calculateProjectFolder();
                PanelProjectLocationExtSrc.this.dataChanged();
                PanelProjectLocationExtSrc.this.firePropertyChange("projectName", null, PanelProjectLocationExtSrc.this.projectName.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                PanelProjectLocationExtSrc.this.calculateProjectFolder();
                PanelProjectLocationExtSrc.this.dataChanged();
                PanelProjectLocationExtSrc.this.firePropertyChange("projectName", null, PanelProjectLocationExtSrc.this.projectName.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PanelProjectLocationExtSrc.this.calculateProjectFolder();
                PanelProjectLocationExtSrc.this.dataChanged();
                PanelProjectLocationExtSrc.this.firePropertyChange("projectName", null, PanelProjectLocationExtSrc.this.projectName.getText());
            }
        });
        this.projectLocation.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                PanelProjectLocationExtSrc.this.setCalculateProjectFolder(false);
                PanelProjectLocationExtSrc.this.checkBuildScriptName();
                PanelProjectLocationExtSrc.this.dataChanged();
                PanelProjectLocationExtSrc.this.firePropertyChange("projectLocation", null, PanelProjectLocationExtSrc.this.projectLocation.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                PanelProjectLocationExtSrc.this.setCalculateProjectFolder(false);
                PanelProjectLocationExtSrc.this.checkBuildScriptName();
                PanelProjectLocationExtSrc.this.dataChanged();
                PanelProjectLocationExtSrc.this.firePropertyChange("projectLocation", null, PanelProjectLocationExtSrc.this.projectLocation.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PanelProjectLocationExtSrc.this.setCalculateProjectFolder(false);
                PanelProjectLocationExtSrc.this.checkBuildScriptName();
                PanelProjectLocationExtSrc.this.dataChanged();
                PanelProjectLocationExtSrc.this.firePropertyChange("projectLocation", null, PanelProjectLocationExtSrc.this.projectLocation.getText());
            }
        });
        this.buildScriptName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                PanelProjectLocationExtSrc.this.dataChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PanelProjectLocationExtSrc.this.dataChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                PanelProjectLocationExtSrc.this.dataChanged();
            }
        });
    }

    private synchronized void calculateProjectFolder() {
        if (this.calculatePF) {
            File f = ProjectChooser.getProjectsFolder();
            this.projectLocation.setText(f.getAbsolutePath() + File.separator + this.projectName.getText());
            this.calculatePF = true;
        }
    }

    private void checkBuildScriptName() {
        String path;
        File projDir;
        File buildScript;
        if (DEFAULT_BUILD_SCRIPT_NAME.equals(this.buildScriptName.getText()) && (buildScript = new File(projDir = new File(path = this.projectLocation.getText()), DEFAULT_BUILD_SCRIPT_NAME)).exists()) {
            this.buildScriptName.setText(NB_BUILD_SCRIPT_NAME);
        }
    }

    private synchronized void setCalculateProjectFolder(boolean value) {
        this.calculatePF = value;
    }

    private void dataChanged() {
        this.firer.fireChangeEvent();
    }

    @Override
    void read(WizardDescriptor settings) {
        this.wizardDescriptor = settings;
        Object path = null;
        String projectName = null;
        File projectLocation = (File)settings.getProperty("projdir");
        if (projectLocation == null) {
            File file;
            projectLocation = ProjectChooser.getProjectsFolder();
            int index = WizardSettings.getNewProjectCount();
            String formater = NbBundle.getMessage(PanelSourceFolders.class, (String)"TXT_JavaProject");
            while ((file = new File(projectLocation, projectName = MessageFormat.format(formater, ++index))).exists()) {
            }
            settings.putProperty("nameIndex", (Object)index);
            this.projectLocation.setText(projectLocation.getAbsolutePath());
            this.setCalculateProjectFolder(true);
        } else {
            projectName = (String)settings.getProperty("name");
            boolean tmpFlag = this.calculatePF;
            this.projectLocation.setText(projectLocation.getAbsolutePath());
            this.setCalculateProjectFolder(tmpFlag);
        }
        this.projectName.setText(projectName);
        this.projectName.selectAll();
        String buildScriptName = (String)settings.getProperty("buildScriptName");
        if (buildScriptName == null) {
            assert (projectLocation != null);
            buildScriptName = DEFAULT_BUILD_SCRIPT_NAME;
            File bf = new File(projectLocation, buildScriptName);
            if (bf.exists()) {
                buildScriptName = NB_BUILD_SCRIPT_NAME;
            }
        }
        this.buildScriptName.setText(buildScriptName);
    }

    @Override
    void store(WizardDescriptor settings) {
        settings.putProperty("name", (Object)this.projectName.getText());
        File projectsDir = new File(this.projectLocation.getText());
        settings.putProperty("projdir", (Object)projectsDir);
        String buildScriptName = this.buildScriptName.getText();
        if (DEFAULT_BUILD_SCRIPT_NAME.equals(buildScriptName)) {
            buildScriptName = null;
        }
        settings.putProperty("buildScriptName", (Object)buildScriptName);
    }

    @Override
    boolean valid(WizardDescriptor settings) {
        String result = PanelProjectLocationExtSrc.checkValidity(this.projectName.getText(), this.projectLocation.getText(), this.buildScriptName.getText());
        if (result == null) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"");
            return true;
        }
        this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)result);
        return false;
    }

    static String checkValidity(String projectName, String projectLocation, String buildScriptName) {
        if (JavaFXProjectWizardIterator.isIllegalProjectName(projectName)) {
            return NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_IllegalProjectName");
        }
        File projLoc = new File(projectLocation).getAbsoluteFile();
        if (JavaFXProjectWizardIterator.getCanonicalFile(projLoc) == null) {
            return NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_IllegalProjectLocation");
        }
        while (projLoc != null && !projLoc.exists()) {
            projLoc = projLoc.getParentFile();
        }
        if (projLoc == null || !projLoc.canWrite()) {
            return NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_ProjectFolderReadOnly");
        }
        if (buildScriptName.length() == 0 || buildScriptName.indexOf(File.separatorChar) >= 0 || !buildScriptName.endsWith(".xml")) {
            return NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_WrongBuildScriptName");
        }
        File destFolder = FileUtil.normalizeFile((File)new File(projectLocation));
        File[] kids = destFolder.listFiles();
        if (destFolder.exists() && kids != null && kids.length > 0) {
            String file = null;
            for (int i = 0; i < kids.length; ++i) {
                String childName = kids[i].getName();
                if ("nbproject".equals(childName)) {
                    file = NbBundle.getMessage(PanelSourceFolders.class, (String)"TXT_NetBeansProject");
                } else if ("build".equals(childName)) {
                    file = NbBundle.getMessage(PanelSourceFolders.class, (String)"TXT_BuildFolder");
                } else if ("dist".equals(childName)) {
                    file = NbBundle.getMessage(PanelSourceFolders.class, (String)"TXT_DistFolder");
                } else if (buildScriptName.equals(childName)) {
                    file = NbBundle.getMessage(PanelSourceFolders.class, (String)"TXT_BuildXML");
                }
                if (file == null) continue;
                String format = NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_ProjectFolderInvalid");
                return MessageFormat.format(format, file);
            }
        }
        if (destFolder.isDirectory()) {
            FileObject destFO = FileUtil.toFileObject((File)destFolder);
            assert (destFO != null) : "No FileObject for " + destFolder;
            Project owner = null;
            try {
                owner = ProjectManager.getDefault().findProject(destFO);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (owner != null) {
                return NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_ProjectFolderHasDeletedProject", (Object)ProjectUtils.getInformation((Project)owner).getDisplayName());
            }
        }
        return null;
    }

    @Override
    void validate(WizardDescriptor settings) throws WizardValidationException {
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.projectName = new JTextField();
        this.jLabel6 = new JLabel();
        this.projectLocation = new JTextField();
        this.jButton3 = new JButton();
        this.jLabel1 = new JLabel();
        this.buildScriptName = new JTextField();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel4.setLabelFor(this.jPanel2);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"LBL_ProjectNameAndLocationLabel"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel4.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSN_jLabel4"));
        this.jLabel4.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSD_jLabel4"));
        this.jLabel5.setLabelFor(this.projectName);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"LBL_NWP1_ProjectName_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.jPanel2.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel5.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSN_projectNameLabel"));
        this.jLabel5.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSD_projectNameLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.jPanel2.add((Component)this.projectName, gridBagConstraints);
        this.jLabel6.setDisplayedMnemonic(NbBundle.getBundle(PanelProjectLocationExtSrc.class).getString("LBL_NWP1_CreatedProjectFolder_LablelMnemonic").charAt(0));
        this.jLabel6.setLabelFor(this.projectLocation);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"LBL_NWP1_CreatedProjectFolder_Lablel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.jPanel2.add((Component)this.jLabel6, gridBagConstraints);
        this.jLabel6.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSN_projectLocationLabel"));
        this.jLabel6.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSD_projectLocationLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.jPanel2.add((Component)this.projectLocation, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton3, (String)NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"LBL_NWP1_BrowseLocation_Button3"));
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelProjectLocationExtSrc.this.browseProjectLocation(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.jPanel2.add((Component)this.jButton3, gridBagConstraints);
        this.jButton3.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSN_browseButton"));
        this.jButton3.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSD_browseButton"));
        this.jLabel1.setLabelFor(this.buildScriptName);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"MSG_BuildScriptName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"AD_BuildScriptName"));
        this.buildScriptName.setText("\n");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.jPanel2.add((Component)this.buildScriptName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSN_jPanel1"));
        this.jPanel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSD_jPanel1"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSN_PanelSourceFolders"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSD_PanelSourceFolders"));
    }

    private void browseProjectLocation(ActionEvent evt) {
        File file;
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(NbBundle.getMessage(PanelSourceFolders.class, (String)"LBL_NWP1_SelectProjectLocation"));
        chooser.setFileSelectionMode(1);
        String path = this.projectLocation.getText();
        if (path.length() > 0) {
            File f = new File(path);
            File owner = f.getParentFile();
            if (owner.exists()) {
                chooser.setCurrentDirectory(owner);
            }
            if (f.exists()) {
                chooser.setSelectedFile(f);
            }
        }
        if (chooser.showOpenDialog(this) == 0 && (file = chooser.getSelectedFile()) != null) {
            this.projectLocation.setText(FileUtil.normalizeFile((File)file).getAbsolutePath());
        }
    }
}

