/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors;

import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.netbeans.modules.form.FormAwareEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class PrimitiveTypeArrayEditor
extends PropertyEditorSupport
implements FormAwareEditor,
XMLPropertyEditor {
    private Class valueType;
    private FormProperty formProperty;
    private static String ARR_BEGIN = "[";
    private static String ARR_END = "]";
    private static String NULL_STR = "null";
    private static String XML_PROP_NAME = "PropertyValue";
    private static String XML_ATT_NAME = "value";
    private char[] escChars = new char[]{'\t', '\b', '\n', '\r', '\f', '\'', '\"', '\\'};
    private String[] escCharsStr = new String[]{"\\t", "\\b", "\\n", "\\r", "\\f", "\\'", "\\\"", "\\\\"};

    private String[] splitCharArray(String body) {
        boolean reading = false;
        String tempVal = "";
        int prevChar = 32;
        int prevPrevChar = 32;
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < body.length(); ++i) {
            char actChar = body.charAt(i);
            if (actChar == '\'' && prevChar != 92) {
                if (!reading) {
                    reading = true;
                    tempVal = "";
                } else {
                    reading = false;
                    list.add(tempVal);
                    tempVal = "";
                }
            } else if (actChar == '\'' && prevChar == 92 && prevPrevChar == 92) {
                reading = false;
                list.add(tempVal);
                tempVal = "";
            } else if (reading) {
                tempVal = tempVal + actChar;
            }
            prevPrevChar = prevChar;
            prevChar = actChar;
        }
        return list.toArray(new String[0]);
    }

    private Object[] toCharObjectArray(Object array) {
        char[] source = (char[])array;
        Object[] result = new String[source.length];
        for (int i = 0; i < source.length; ++i) {
            result[i] = this.convertChar2String(source[i]);
        }
        return result;
    }

    private String convertChar2String(char source) {
        for (int i = 0; i < this.escChars.length; ++i) {
            if (source != this.escChars[i]) continue;
            return "'" + this.escCharsStr[i] + "'";
        }
        return "'" + String.valueOf(source) + "'";
    }

    private char convertString2Char(String source) throws ParseException {
        if (source.length() > 1) {
            for (int i = 0; i < this.escCharsStr.length; ++i) {
                if (!source.equals(this.escCharsStr[i])) continue;
                return this.escChars[i];
            }
            throw new ParseException("", 0);
        }
        if (source.length() == 1) {
            return source.charAt(0);
        }
        throw new ParseException("", 0);
    }

    private String arr2Text(Object[] arr, boolean justContent) {
        StringBuilder strBuild = new StringBuilder();
        if (!justContent) {
            strBuild.append(ARR_BEGIN);
        }
        for (int i = 0; i < arr.length; ++i) {
            Object act = arr[i];
            strBuild.append(act);
            if (justContent && this.valueType.equals(float[].class)) {
                strBuild.append("f");
            }
            if (i == arr.length - 1) continue;
            strBuild.append(", ");
        }
        if (!justContent) {
            strBuild.append(ARR_END);
        }
        return strBuild.toString();
    }

    private Object text2Arr(String text) throws ParseException {
        Object[] result;
        String[] parts;
        String trimText = text.trim();
        if (trimText.length() == 0 || trimText.equalsIgnoreCase(NULL_STR)) {
            return null;
        }
        String body = trimText.charAt(0) == '[' && trimText.charAt(trimText.length() - 1) == ']' ? trimText.substring(1, trimText.length() - 1) : trimText;
        if (!this.valueType.equals(char[].class)) {
            LinkedList<String> tokens = new LinkedList<String>();
            StringTokenizer st = new StringTokenizer(body, ",");
            while (st.hasMoreTokens()) {
                tokens.add(st.nextToken());
            }
            parts = tokens.toArray(new String[0]);
        } else {
            parts = this.splitCharArray(body);
        }
        if (this.valueType.equals(boolean[].class)) {
            result = new boolean[parts.length];
            for (int i = 0; i < parts.length; ++i) {
                result[i] = Boolean.parseBoolean(parts[i].trim());
            }
            return result;
        }
        if (this.valueType.equals(byte[].class)) {
            result = new byte[parts.length];
            for (int i = 0; i < parts.length; ++i) {
                result[i] = Byte.parseByte(parts[i].trim());
            }
            return result;
        }
        if (this.valueType.equals(short[].class)) {
            result = new short[parts.length];
            for (int i = 0; i < parts.length; ++i) {
                result[i] = Short.parseShort(parts[i].trim());
            }
            return result;
        }
        if (this.valueType.equals(int[].class)) {
            result = new int[parts.length];
            for (int i = 0; i < parts.length; ++i) {
                result[i] = Integer.parseInt(parts[i].trim());
            }
            return result;
        }
        if (this.valueType.equals(long[].class)) {
            result = new long[parts.length];
            for (int i = 0; i < parts.length; ++i) {
                result[i] = Long.parseLong(parts[i].trim());
            }
            return result;
        }
        if (this.valueType.equals(float[].class)) {
            result = new float[parts.length];
            for (int i = 0; i < parts.length; ++i) {
                result[i] = Float.parseFloat(parts[i].trim());
            }
            return result;
        }
        if (this.valueType.equals(double[].class)) {
            result = new double[parts.length];
            for (int i = 0; i < parts.length; ++i) {
                result[i] = Double.parseDouble(parts[i].trim());
            }
            return result;
        }
        if (this.valueType.equals(char[].class)) {
            result = new char[parts.length];
            for (int i = 0; i < parts.length; ++i) {
                result[i] = this.convertString2Char(parts[i]);
            }
            return result;
        }
        return null;
    }

    @Override
    public String getAsText() {
        if (this.getValue() != null) {
            Object[] result = new Object[]{};
            result = this.valueType.equals(char[].class) ? this.toCharObjectArray(this.getValue()) : Utilities.toObjectArray((Object)this.getValue());
            return this.arr2Text(result, false);
        }
        return NULL_STR;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        try {
            this.setValue(this.text2Arr(text));
        }
        catch (Exception e) {
            String msg = NbBundle.getBundle(PrimitiveTypeArrayEditor.class).getString("MSG_ERR_ParseError");
            throw new IllegalArgumentException(String.format(msg, text, this.valueType.getSimpleName()), e);
        }
    }

    @Override
    public void setContext(FormModel formModel, FormProperty property) {
        this.formProperty = property;
        if (property != null) {
            this.setValueType(property.getValueType());
        }
    }

    protected void setValueType(Class valueType) {
        this.valueType = valueType;
    }

    @Override
    public void updateFormVersionLevel() {
        this.formProperty.getPropertyContext().getFormModel().raiseVersionLevel(FormModel.FormVersion.NB65, FormModel.FormVersion.NB65);
    }

    @Override
    public String getJavaInitializationString() {
        Object[] valObj = this.valueType.equals(char[].class) ? this.toCharObjectArray(this.getValue()) : Utilities.toObjectArray((Object)this.getValue());
        return "new " + this.valueType.getSimpleName() + " {" + this.arr2Text(valObj, true) + "}";
    }

    public void readFromXML(Node element) throws IOException {
        if (!XML_PROP_NAME.equals(element.getNodeName())) {
            throw new IOException();
        }
        NamedNodeMap attributes = element.getAttributes();
        try {
            String value = attributes.getNamedItem(XML_ATT_NAME).getNodeValue();
            this.setAsText(value);
        }
        catch (Exception e) {
            throw new IOException();
        }
    }

    public Node storeToXML(Document doc) {
        Element el = doc.createElement(XML_PROP_NAME);
        el.setAttribute(XML_ATT_NAME, this.getAsText());
        return el;
    }
}

