/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client.cli.commands;

import java.io.File;
import java.io.IOException;
import org.netbeans.modules.subversion.client.cli.SvnCommand;

public class PropertySetCommand
extends SvnCommand {
    private final PropType type;
    private final File file;
    private final String propName;
    private final String propValue;
    private final File propFile;
    private final boolean recursivelly;

    public PropertySetCommand(String propName, String propValue, File file, boolean recursivelly) {
        this.file = file;
        this.propName = propName;
        this.propValue = propValue;
        this.recursivelly = recursivelly;
        this.propFile = null;
        this.type = PropType.string;
    }

    public PropertySetCommand(String propName, File propFile, File file, boolean recursivelly) {
        this.file = file;
        this.propName = propName;
        this.propFile = propFile;
        this.recursivelly = recursivelly;
        this.propValue = null;
        this.type = PropType.file;
    }

    @Override
    protected int getCommand() {
        return 14;
    }

    @Override
    protected boolean notifyOutput() {
        return false;
    }

    @Override
    public void prepareCommand(SvnCommand.Arguments arguments) throws IOException {
        arguments.add("propset");
        if (this.recursivelly) {
            arguments.add("-R");
        }
        switch (this.type.ordinal()) {
            case 0: {
                arguments.add(this.propName);
                String propFileName = this.createTempCommandFile(this.propValue);
                arguments.add("-F");
                arguments.add(propFileName);
                arguments.add(this.file);
                break;
            }
            case 1: {
                arguments.add(this.propName);
                arguments.add("-F");
                arguments.add(this.propFile);
                arguments.add(this.file);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal proptype: " + (Object)((Object)this.type));
            }
        }
    }

    private static enum PropType {
        string,
        file;

    }
}

