/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.lock;

import java.io.File;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class UnlockAction
extends ContextAction {
    private static final Logger LOG = Logger.getLogger(UnlockAction.class.getName());

    @Override
    protected int getDirectoryEnabledStatus() {
        return 0;
    }

    @Override
    protected int getFileEnabledStatus() {
        return 40960;
    }

    @Override
    protected String getBaseName(Node[] activatedNodes) {
        return "CTL_Unlock_Title";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        SVNUrl url;
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        Context ctx = this.getContext(nodes);
        final File[] files = ctx.getFiles();
        if (files.length == 0) {
            return;
        }
        try {
            url = SvnUtils.getRepositoryRootUrl(files[0]);
        }
        catch (SVNClientException ex) {
            LOG.log(Level.INFO, "No url for {0}", files[0]);
            return;
        }
        new SvnProgressSupport(this){
            final /* synthetic */ UnlockAction this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            protected void perform() {
                try {
                    boolean cont;
                    SvnClient client = Subversion.getInstance().getClient(url, (SvnProgressSupport)this);
                    HashMap<File, String> paths = new HashMap<File, String>();
                    for (File f : files) {
                        paths.put(f, f.getAbsolutePath());
                    }
                    boolean force = false;
                    do {
                        LockedFilesListener list;
                        cont = false;
                        boolean resumeAuth = true;
                        do {
                            list = new LockedFilesListener(paths);
                            client.addNotifyListener(list);
                            client.unlock(files, force);
                            if (!list.isAuthError() || !(resumeAuth = SvnClientExceptionHandler.handleAuth(url))) break;
                            client.removeNotifyListener(list);
                            client = Subversion.getInstance().getClient(url, (SvnProgressSupport)this);
                        } while (resumeAuth);
                        if (!resumeAuth) break;
                        client.removeNotifyListener(list);
                        if (force || list.lockedFiles.isEmpty() || this.lockedByOther(client, list.lockedFiles).isEmpty()) continue;
                        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(UnlockAction.class, (String)"MSG_UnlockAction.lockedFiles.description"), NbBundle.getMessage(UnlockAction.class, (String)"MSG_UnlockAction.lockedFiles.title"), 0, 2);
                        if (NotifyDescriptor.YES_OPTION != DialogDisplayer.getDefault().notify((NotifyDescriptor)nd)) continue;
                        force = true;
                        cont = true;
                    } while (cont);
                    Subversion.getInstance().getStatusCache().refreshAsync(files);
                }
                catch (SVNClientException ex) {
                    SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, false);
                }
            }

            private Collection<File> lockedByOther(SvnClient client, Set<File> lockedFiles) throws SVNClientException {
                ISVNStatus[] statuses;
                LinkedList<File> lockedByOtherFiles = new LinkedList<File>();
                for (ISVNStatus status : statuses = client.getStatus(lockedFiles.toArray(new File[0]))) {
                    if (status.getLockOwner() != null) continue;
                    lockedByOtherFiles.add(status.getFile());
                }
                return lockedByOtherFiles;
            }
        }.start(Subversion.getInstance().getRequestProcessor(url), url, NbBundle.getMessage(UnlockAction.class, (String)"LBL_Unlock_Progress"));
    }

    private static class LockedFilesListener
    implements ISVNNotifyListener {
        private final Map<File, String> paths;
        private final Set<File> lockedFiles = new HashSet<File>();
        private boolean authError;

        public LockedFilesListener(Map<File, String> paths) {
            this.paths = paths;
        }

        public void setCommand(int i) {
        }

        public void logCommandLine(String string) {
        }

        public void logMessage(String string) {
        }

        public void logError(String error) {
            if (error != null) {
                if (error.contains("is not locked in this working copy")) {
                    Iterator<Map.Entry<File, String>> it = this.paths.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry<File, String> e = it.next();
                        String path = e.getValue();
                        File file = e.getKey();
                        if (error.contains(MessageFormat.format("''{0}'' is not locked in this working copy", path))) {
                            this.lockedFiles.add(new File(path));
                            it.remove();
                        } else {
                            if (!error.contains(MessageFormat.format("''{0}'' is not locked in this working copy", file.getName()))) continue;
                            this.lockedFiles.add(file);
                            it.remove();
                        }
                        break;
                    }
                } else if (SvnClientExceptionHandler.isAuthentication(error)) {
                    this.authError = true;
                }
            }
        }

        public void logRevision(long l, String string) {
        }

        public void logCompleted(String string) {
        }

        public void onNotify(File file, SVNNodeKind svnnk) {
        }

        private boolean isAuthError() {
            return this.authError;
        }
    }
}

