/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.wizards;

import java.awt.EventQueue;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.php.api.editor.EditorSupport;
import org.netbeans.modules.php.api.editor.PhpType;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.ui.wizards.NewFileNamespacePanelVisual;
import org.netbeans.modules.php.project.ui.wizards.NewFileWizardIterator;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

class NewFileNamespacePanel
implements NewFileWizardIterator.BottomPanel {
    public static final String NAMESPACE = "NAMESPACE";
    static final RequestProcessor RP = new RequestProcessor(NewFileNamespacePanel.class);
    private final RequestProcessor.Task namespaceFetcherTask = RP.create((Runnable)new NamespaceFetcher());
    NewFileNamespacePanelVisual panel;
    volatile FileObject targetFolder = null;
    volatile WizardDescriptor settings = null;

    @Override
    public boolean isPresentForProject(PhpProject project) {
        return ProjectPropertiesSupport.getPhpVersion(project).hasNamespaces();
    }

    public NewFileNamespacePanelVisual getComponent() {
        if (this.panel == null) {
            this.panel = new NewFileNamespacePanelVisual();
        }
        return this.panel;
    }

    public HelpCtx getHelp() {
        return null;
    }

    public void readSettings(WizardDescriptor settings) {
        this.settings = settings;
        this.fetchNamespaces(Templates.getTargetFolder((WizardDescriptor)settings));
    }

    public void storeSettings(WizardDescriptor settings) {
        settings.putProperty(NAMESPACE, (Object)this.getComponent().getSelectedNamespace());
    }

    public boolean isValid() {
        if (this.settings == null) {
            return false;
        }
        String namespace = this.getComponent().getSelectedNamespace();
        if (namespace == null) {
            this.settings.putProperty("WizardPanel_errorMessage", (Object)" ");
            return false;
        }
        String error = NewFileNamespacePanelVisual.validateNamespace(namespace);
        if (error != null) {
            this.settings.putProperty("WizardPanel_errorMessage", (Object)error);
            return false;
        }
        this.settings.putProperty("WizardPanel_errorMessage", (Object)" ");
        return true;
    }

    public void addChangeListener(ChangeListener listener) {
        this.getComponent().addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.getComponent().removeChangeListener(listener);
    }

    private void fetchNamespaces(FileObject folder) {
        assert (EventQueue.isDispatchThread());
        if (folder == null) {
            return;
        }
        if (folder.equals(this.targetFolder)) {
            return;
        }
        if (!folder.isFolder()) {
            return;
        }
        this.targetFolder = folder;
        this.namespaceFetcherTask.schedule(20);
    }

    @Override
    public void targetFolderChanged(FileObject targetFolder) {
        this.fetchNamespaces(targetFolder);
    }

    private final class NamespaceFetcher
    implements Runnable {
        private NamespaceFetcher() {
        }

        @Override
        public synchronized void run() {
            FileObject folder = NewFileNamespacePanel.this.targetFolder;
            final String selectedNamespace = NewFileNamespacePanel.this.panel.getSelectedNamespace();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NewFileNamespacePanel.this.panel.setPleaseWaitState();
                }
            });
            TreeSet<String> namespaces = new TreeSet<String>();
            namespaces.add("");
            EditorSupport editorSupport = (EditorSupport)Lookup.getDefault().lookup(EditorSupport.class);
            for (FileObject child : folder.getChildren()) {
                if (!folder.equals(NewFileNamespacePanel.this.targetFolder)) {
                    return;
                }
                if (child.isFolder() || !FileUtils.isPhpFile((FileObject)child)) continue;
                for (PhpType phpType : editorSupport.getTypes(child)) {
                    String namespace;
                    String name = phpType.getName();
                    String fqn = phpType.getFullyQualifiedName();
                    if (fqn == null || name.length() + 1 == fqn.length() || !StringUtils.hasText((String)(namespace = fqn.substring(1, fqn.length() - name.length() - 1)))) continue;
                    namespaces.add(namespace);
                }
            }
            if (!folder.equals(NewFileNamespacePanel.this.targetFolder)) {
                return;
            }
            if (selectedNamespace != null) {
                namespaces.add(selectedNamespace);
            }
            final CopyOnWriteArrayList namespacesCopy = new CopyOnWriteArrayList(namespaces);
            EventQueue.invokeLater(new Runnable(){
                final /* synthetic */ NamespaceFetcher this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void run() {
                    this.this$1.NewFileNamespacePanel.this.panel.setNamespaces(namespacesCopy);
                    if (StringUtils.hasText((String)selectedNamespace)) {
                        this.this$1.NewFileNamespacePanel.this.panel.setSelectedNamespace(selectedNamespace);
                    } else if (namespacesCopy.size() == 2) {
                        this.this$1.NewFileNamespacePanel.this.panel.setSelectedNamespace((String)namespacesCopy.get(1));
                    }
                }
            });
        }
    }
}

