/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.charts.xy;

import java.awt.Color;
import org.netbeans.lib.profiler.charts.ChartContext;
import org.netbeans.lib.profiler.charts.ChartItem;
import org.netbeans.lib.profiler.charts.ItemSelection;
import org.netbeans.lib.profiler.charts.swing.LongRect;
import org.netbeans.lib.profiler.charts.xy.XYItem;
import org.netbeans.lib.profiler.charts.xy.XYItemSelection;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYChartContext;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItem;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItemPainter;

public class ProfilerXYItemPainter
extends SynchronousXYItemPainter {
    public static ProfilerXYItemPainter absolutePainter(float lineWidth, Color lineColor, Color fillColor) {
        return new ProfilerXYItemPainter(lineWidth, lineColor, fillColor, 0, 0);
    }

    public static ProfilerXYItemPainter relativePainter(float lineWidth, Color lineColor, Color fillColor, int maxOffset) {
        return new ProfilerXYItemPainter(lineWidth, lineColor, fillColor, 1, maxOffset);
    }

    public ProfilerXYItemPainter(float lineWidth, Color lineColor, Color fillColor, int type, int maxValueOffset) {
        super(lineWidth, lineColor, fillColor, type, maxValueOffset);
    }

    public boolean supportsHovering(ChartItem item) {
        return true;
    }

    public LongRect getSelectionBounds(ItemSelection selection, ChartContext context) {
        XYItemSelection sel = (XYItemSelection)selection;
        XYItem item = sel.getItem();
        int selectedValueIndex = sel.getValueIndex();
        if (selectedValueIndex == -1 || selectedValueIndex >= item.getValuesCount()) {
            return new LongRect(0L, 0L, (long)context.getViewportWidth(), (long)context.getViewportHeight());
        }
        return this.getViewBounds(item, new int[]{sel.getValueIndex()}, context);
    }

    public ItemSelection getClosestSelection(ChartItem item, int viewX, int viewY, ChartContext context) {
        SynchronousXYChartContext contx = (SynchronousXYChartContext)context;
        int nearestTimestampIndex = contx.getNearestTimestampIndex(viewX, viewY);
        if (nearestTimestampIndex == -1) {
            return null;
        }
        SynchronousXYItem xyItem = (SynchronousXYItem)item;
        return new XYItemSelection.Default((XYItem)xyItem, nearestTimestampIndex, Integer.MAX_VALUE);
    }

    private LongRect getViewBounds(XYItem item, int[] valuesIndexes, ChartContext context) {
        LongRect dataBounds = new LongRect();
        if (valuesIndexes == null) {
            LongRect.set((LongRect)dataBounds, (LongRect)item.getBounds());
        } else {
            boolean firstPoint = true;
            for (int valueIndex : valuesIndexes) {
                if (valueIndex == -1) continue;
                long xValue = item.getXValue(valueIndex);
                long yValue = item.getYValue(valueIndex);
                if (firstPoint) {
                    LongRect.set((LongRect)dataBounds, (long)xValue, (long)yValue, (long)0L, (long)0L);
                    firstPoint = false;
                    continue;
                }
                LongRect.add((LongRect)dataBounds, (long)xValue, (long)yValue);
            }
        }
        if (this.type == 1) {
            return this.getViewBoundsRelative(dataBounds, item, context);
        }
        LongRect viewBounds = context.getViewRect(dataBounds);
        LongRect.addBorder((LongRect)viewBounds, (long)this.lineWidth);
        return viewBounds;
    }

    private LongRect getViewBoundsRelative(LongRect dataBounds, XYItem item, ChartContext context) {
        long viewHeight;
        LongRect itemBounds = item.getBounds();
        double itemValueFactor = ProfilerXYItemPainter.getItemValueFactor(context, this.maxValueOffset, itemBounds.height);
        double value1 = (double)context.getDataOffsetY() + itemValueFactor * (double)(dataBounds.y - itemBounds.y);
        double value2 = (double)context.getDataOffsetY() + itemValueFactor * (double)(dataBounds.y + dataBounds.height - itemBounds.y);
        long viewX = (long)Math.ceil(context.getViewX((double)dataBounds.x));
        long viewWidth = (long)Math.ceil(context.getViewWidth((double)dataBounds.width));
        if (context.isRightBased()) {
            viewX -= viewWidth;
        }
        long viewY1 = (long)Math.ceil(context.getViewY(value1));
        long viewY2 = (long)Math.ceil(context.getViewY(value2));
        long l = viewHeight = context.isBottomBased() ? viewY1 - viewY2 : viewY2 - viewY1;
        if (!context.isBottomBased()) {
            viewY2 -= viewHeight;
        }
        LongRect viewBounds = new LongRect(viewX, viewY2, viewWidth, viewHeight);
        LongRect.addBorder((LongRect)viewBounds, (long)this.lineWidth);
        return viewBounds;
    }

    private static double getItemValueFactor(ChartContext context, double maxValueOffset, double itemHeight) {
        return ((double)context.getDataHeight() - context.getDataHeight(maxValueOffset)) / itemHeight;
    }
}

