/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.cpu;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.tree.TreeNode;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.results.cpu.CPUResultsDiff;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.FlatProfileContainer;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.JExtendedSplitPane;
import org.netbeans.lib.profiler.ui.cpu.CPUTableView;
import org.netbeans.lib.profiler.ui.cpu.CPUTreeTableView;
import org.netbeans.lib.profiler.ui.cpu.CPUView;
import org.netbeans.lib.profiler.ui.cpu.ThreadsSelector;
import org.netbeans.lib.profiler.ui.results.DataView;
import org.netbeans.lib.profiler.ui.swing.FilterUtils;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTreeTable;
import org.netbeans.lib.profiler.ui.swing.SearchUtils;

public abstract class LiveCPUView
extends JPanel {
    private CPUResultsSnapshot snapshot;
    private CPUResultsSnapshot refSnapshot;
    private boolean sampled;
    private boolean mergedThreads;
    private Collection<Integer> selectedThreads;
    private DataView lastFocused;
    private CPUTableView hotSpotsView;
    private CPUTreeTableView forwardCallsView;
    private CPUTreeTableView reverseCallsView;
    private ThreadsSelector threadsSelector;
    private long lastupdate;
    private volatile boolean refreshIsRunning;
    private ExecutorService executor;

    public LiveCPUView(Set<ClientUtils.SourceCodeSelection> selection) {
        this.initUI(selection);
        this.registerActions();
    }

    public void setView(boolean forwardCalls, boolean hotSpots, boolean reverseCalls) {
        this.forwardCallsView.setVisible(forwardCalls);
        this.hotSpotsView.setVisible(hotSpots);
        this.reverseCallsView.setVisible(reverseCalls);
    }

    public ThreadsSelector createThreadSelector() {
        this.threadsSelector = new ThreadsSelector(){

            @Override
            protected CPUResultsSnapshot getSnapshot() {
                return LiveCPUView.this.snapshot;
            }

            @Override
            protected void selectionChanged(Collection<Integer> selected, boolean mergeThreads) {
                LiveCPUView.this.mergedThreads = mergeThreads;
                LiveCPUView.this.selectedThreads = selected;
                LiveCPUView.this.setData();
            }

            @Override
            void reset() {
                super.reset();
                LiveCPUView.this.mergedThreads = false;
                LiveCPUView.this.selectedThreads = null;
            }
        };
        return this.threadsSelector;
    }

    public boolean isRefreshRunning() {
        return this.refreshIsRunning;
    }

    public long getLastUpdate() {
        return this.lastupdate;
    }

    public void setData(final CPUResultsSnapshot snapshotData, final boolean sampledData) {
        if (this.refreshIsRunning) {
            return;
        }
        this.refreshIsRunning = true;
        UIUtils.runInEventDispatchThread(new Runnable(){
            final /* synthetic */ LiveCPUView this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.snapshot = snapshotData;
                this.this$0.sampled = sampledData;
                this.this$0.setData();
            }
        });
    }

    private void setData() {
        if (this.snapshot == null) {
            this.resetData();
            this.refreshIsRunning = false;
        } else {
            this.getExecutor().submit(new Runnable(){

                @Override
                public void run() {
                    final CPUResultsSnapshot _snapshot = LiveCPUView.this.refSnapshot == null ? LiveCPUView.this.snapshot : LiveCPUView.this.refSnapshot.createDiff(LiveCPUView.this.snapshot);
                    final FlatProfileContainer flatData = _snapshot.getFlatProfile(LiveCPUView.this.selectedThreads, 0);
                    final Map idMap = _snapshot.getMethodIDMap(0);
                    SwingUtilities.invokeLater(new Runnable(){
                        final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void run() {
                            try {
                                boolean diff = _snapshot instanceof CPUResultsDiff;
                                this.this$1.LiveCPUView.this.forwardCallsView.setData(_snapshot, idMap, 0, this.this$1.LiveCPUView.this.selectedThreads, this.this$1.LiveCPUView.this.mergedThreads, this.this$1.LiveCPUView.this.sampled, diff);
                                this.this$1.LiveCPUView.this.hotSpotsView.setData(flatData, idMap, this.this$1.LiveCPUView.this.sampled, diff);
                                this.this$1.LiveCPUView.this.reverseCallsView.setData(_snapshot, idMap, 0, this.this$1.LiveCPUView.this.selectedThreads, this.this$1.LiveCPUView.this.mergedThreads, this.this$1.LiveCPUView.this.sampled, diff);
                            }
                            finally {
                                this.this$1.LiveCPUView.this.refreshIsRunning = false;
                                this.this$1.LiveCPUView.this.lastupdate = System.currentTimeMillis();
                            }
                        }
                    });
                }
            });
        }
    }

    public boolean setDiffView(final boolean diff) {
        if (this.snapshot == null) {
            return false;
        }
        UIUtils.runInEventDispatchThread(new Runnable(){
            final /* synthetic */ LiveCPUView this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.refSnapshot = diff ? this.this$0.snapshot : null;
                this.this$0.setData();
            }
        });
        return true;
    }

    public void resetData() {
        UIUtils.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                LiveCPUView.this.forwardCallsView.resetData();
                LiveCPUView.this.hotSpotsView.resetData();
                LiveCPUView.this.reverseCallsView.resetData();
                LiveCPUView.this.snapshot = null;
                LiveCPUView.this.refSnapshot = null;
                LiveCPUView.this.sampled = true;
                if (LiveCPUView.this.threadsSelector != null) {
                    LiveCPUView.this.threadsSelector.reset();
                }
            }
        });
    }

    public void showSelectionColumn() {
        this.forwardCallsView.showSelectionColumn();
        this.hotSpotsView.showSelectionColumn();
        this.reverseCallsView.showSelectionColumn();
    }

    public void refreshSelection() {
        this.forwardCallsView.refreshSelection();
        this.hotSpotsView.refreshSelection();
        this.reverseCallsView.refreshSelection();
    }

    protected boolean profileMethodSupported() {
        return true;
    }

    protected boolean profileClassSupported() {
        return true;
    }

    protected abstract boolean showSourceSupported();

    protected abstract void showSource(ClientUtils.SourceCodeSelection var1);

    protected abstract void selectForProfiling(ClientUtils.SourceCodeSelection var1);

    protected void popupShowing() {
    }

    protected void popupHidden() {
    }

    protected void foundInForwardCalls() {
    }

    protected void foundInHotSpots() {
    }

    protected void foundInReverseCalls() {
    }

    private void profileMethod(ClientUtils.SourceCodeSelection value) {
        this.selectForProfiling(value);
    }

    private void profileClass(ClientUtils.SourceCodeSelection value) {
        this.selectForProfiling(new ClientUtils.SourceCodeSelection(value.getClassName(), "*", null));
    }

    private void initUI(Set<ClientUtils.SourceCodeSelection> selection) {
        this.setLayout(new BorderLayout(0, 0));
        this.forwardCallsView = new CPUTreeTableView(selection, false){

            @Override
            protected void performDefaultAction(ClientUtils.SourceCodeSelection userValue) {
                if (LiveCPUView.this.showSourceSupported()) {
                    LiveCPUView.this.showSource(userValue);
                }
            }

            @Override
            protected void populatePopup(JPopupMenu popup, Object value, ClientUtils.SourceCodeSelection userValue) {
                LiveCPUView.this.populatePopup(LiveCPUView.this.forwardCallsView, popup, value, userValue);
            }

            @Override
            protected void popupShowing() {
                LiveCPUView.this.popupShowing();
            }

            @Override
            protected void popupHidden() {
                LiveCPUView.this.popupHidden();
            }

            @Override
            protected boolean hasBottomFilterFindMargin() {
                return true;
            }
        };
        this.forwardCallsView.notifyOnFocus(new Runnable(){

            @Override
            public void run() {
                LiveCPUView.this.lastFocused = LiveCPUView.this.forwardCallsView;
            }
        });
        this.hotSpotsView = new CPUTableView(selection){

            @Override
            protected void performDefaultAction(ClientUtils.SourceCodeSelection userValue) {
                if (LiveCPUView.this.showSourceSupported()) {
                    LiveCPUView.this.showSource(userValue);
                }
            }

            @Override
            protected void populatePopup(JPopupMenu popup, Object value, ClientUtils.SourceCodeSelection userValue) {
                LiveCPUView.this.populatePopup(LiveCPUView.this.hotSpotsView, popup, value, userValue);
            }

            @Override
            protected void popupShowing() {
                LiveCPUView.this.popupShowing();
            }

            @Override
            protected void popupHidden() {
                LiveCPUView.this.popupHidden();
            }

            @Override
            protected boolean hasBottomFilterFindMargin() {
                return true;
            }
        };
        this.hotSpotsView.notifyOnFocus(new Runnable(){

            @Override
            public void run() {
                LiveCPUView.this.lastFocused = LiveCPUView.this.hotSpotsView;
            }
        });
        this.reverseCallsView = new CPUTreeTableView(selection, true){

            @Override
            protected void performDefaultAction(ClientUtils.SourceCodeSelection userValue) {
                if (LiveCPUView.this.showSourceSupported()) {
                    LiveCPUView.this.showSource(userValue);
                }
            }

            @Override
            protected void populatePopup(JPopupMenu popup, Object value, ClientUtils.SourceCodeSelection userValue) {
                LiveCPUView.this.populatePopup(LiveCPUView.this.reverseCallsView, popup, value, userValue);
            }

            @Override
            protected void popupShowing() {
                LiveCPUView.this.popupShowing();
            }

            @Override
            protected void popupHidden() {
                LiveCPUView.this.popupHidden();
            }

            @Override
            protected boolean hasBottomFilterFindMargin() {
                return true;
            }
        };
        this.reverseCallsView.notifyOnFocus(new Runnable(){

            @Override
            public void run() {
                LiveCPUView.this.lastFocused = LiveCPUView.this.reverseCallsView;
            }
        });
        JExtendedSplitPane upperSplit = new JExtendedSplitPane(0){
            {
                BasicSplitPaneDivider divider;
                super(newOrientation);
                this.setBorder(null);
                this.setDividerSize(5);
                if (this.getUI() instanceof BasicSplitPaneUI && (divider = ((BasicSplitPaneUI)this.getUI()).getDivider()) != null) {
                    Color c = UIUtils.isNimbus() || UIUtils.isAquaLookAndFeel() ? UIUtils.getDisabledLineColor() : new JSeparator().getForeground();
                    divider.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, c));
                }
            }
        };
        upperSplit.setBorder(BorderFactory.createEmptyBorder());
        ((JSplitPane)upperSplit).setTopComponent(this.forwardCallsView);
        ((JSplitPane)upperSplit).setBottomComponent(this.hotSpotsView);
        upperSplit.setDividerLocation(0.5);
        upperSplit.setResizeWeight(0.5);
        JExtendedSplitPane lowerSplit = new JExtendedSplitPane(0){
            {
                BasicSplitPaneDivider divider;
                super(newOrientation);
                this.setBorder(null);
                this.setDividerSize(5);
                if (this.getUI() instanceof BasicSplitPaneUI && (divider = ((BasicSplitPaneUI)this.getUI()).getDivider()) != null) {
                    Color c = UIUtils.isNimbus() || UIUtils.isAquaLookAndFeel() ? UIUtils.getDisabledLineColor() : new JSeparator().getForeground();
                    divider.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, c));
                }
            }
        };
        lowerSplit.setBorder(BorderFactory.createEmptyBorder());
        ((JSplitPane)lowerSplit).setTopComponent(upperSplit);
        ((JSplitPane)lowerSplit).setBottomComponent(this.reverseCallsView);
        lowerSplit.setDividerLocation(0.66);
        lowerSplit.setResizeWeight(0.66);
        this.add((Component)lowerSplit, "Center");
    }

    private void registerActions() {
        ActionMap map = this.getActionMap();
        map.put("filter-action-key", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataView active = LiveCPUView.this.getLastFocused();
                if (active != null) {
                    active.activateFilter();
                }
            }
        });
        map.put("find-action-key", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataView active = LiveCPUView.this.getLastFocused();
                if (active != null) {
                    active.activateSearch();
                }
            }
        });
    }

    private DataView getLastFocused() {
        if (this.lastFocused != null && !this.lastFocused.isShowing()) {
            this.lastFocused = null;
        }
        if (this.lastFocused == null) {
            if (this.forwardCallsView.isShowing()) {
                this.lastFocused = this.forwardCallsView;
            } else if (this.hotSpotsView.isShowing()) {
                this.lastFocused = this.hotSpotsView;
            } else if (this.reverseCallsView.isShowing()) {
                this.lastFocused = this.reverseCallsView;
            }
        }
        return this.lastFocused;
    }

    private void populatePopup(final DataView invoker, JPopupMenu popup, final Object value, final ClientUtils.SourceCodeSelection userValue) {
        JMenu threads;
        int column;
        ProfilerTreeTable ttable;
        JMenuItem[] customItems;
        if (this.showSourceSupported()) {
            popup.add(new JMenuItem(this, CPUView.ACTION_GOTOSOURCE){
                final /* synthetic */ LiveCPUView this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                    this.setEnabled(userValue != null);
                    this.setFont(this.getFont().deriveFont(1));
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    this.this$0.showSource(userValue);
                }
            });
            popup.addSeparator();
        }
        if (this.profileMethodSupported()) {
            popup.add(new JMenuItem(this, CPUView.ACTION_PROFILE_METHOD){
                final /* synthetic */ LiveCPUView this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                    this.setEnabled(userValue != null && CPUTableView.isSelectable(userValue));
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    this.this$0.profileMethod(userValue);
                }
            });
        }
        if (this.profileClassSupported()) {
            popup.add(new JMenuItem(this, CPUView.ACTION_PROFILE_CLASS){
                final /* synthetic */ LiveCPUView this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                    this.setEnabled(userValue != null);
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    this.this$0.profileClass(userValue);
                }
            });
        }
        if (this.profileMethodSupported() || this.profileClassSupported()) {
            popup.addSeparator();
        }
        if ((customItems = invoker.createCustomMenuItems(this, value, userValue)) != null) {
            for (JMenuItem customItem : customItems) {
                popup.add(customItem);
            }
            popup.addSeparator();
        }
        this.customizeNodePopup(invoker, popup, value, userValue);
        if (invoker == this.forwardCallsView) {
            ttable = (ProfilerTreeTable)this.forwardCallsView.getResultsComponent();
            column = ttable.convertColumnIndexToView(ttable.getMainColumn());
            final String searchString = ttable.getStringValue((TreeNode)value, column);
            popup.add(new JMenuItem(this, CPUView.FIND_IN_HOTSPOTS){
                final /* synthetic */ LiveCPUView this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                    this.setEnabled(userValue != null);
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    ProfilerTable table = this.this$0.hotSpotsView.getResultsComponent();
                    if (SearchUtils.findString(table, searchString)) {
                        this.this$0.hotSpotsView.setVisible(true);
                        this.this$0.foundInHotSpots();
                        table.requestFocusInWindow();
                    }
                }
            });
            popup.add(new JMenuItem(this, CPUView.FIND_IN_REVERSECALLS){
                final /* synthetic */ LiveCPUView this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                    this.setEnabled(userValue != null);
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    ProfilerTreeTable table = (ProfilerTreeTable)this.this$0.reverseCallsView.getResultsComponent();
                    if (SearchUtils.findString(table, searchString, true, true, LiveCPUView.createSearchHelper())) {
                        this.this$0.reverseCallsView.setVisible(true);
                        this.this$0.foundInReverseCalls();
                        table.requestFocusInWindow();
                    }
                }
            });
            popup.addSeparator();
            threads = new JMenu(CPUView.SHOW_MENU);
            popup.add(threads);
            threads.add(new JMenuItem(this, CPUView.SHOW_THREAD_ITEM){
                final /* synthetic */ LiveCPUView this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                    this.setEnabled(!this.this$0.mergedThreads && this.this$0.threadsSelector != null && value instanceof PrestimeCPUCCTNode && this.this$0.snapshot.getNThreads() > 1 && (this.this$0.selectedThreads == null || this.this$0.selectedThreads.size() > 1));
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    PrestimeCPUCCTNode thread = (PrestimeCPUCCTNode)value;
                    this.this$0.threadsSelector.addThread(thread.getThreadId(), true);
                }
            });
            threads.add(new JMenuItem(this, CPUView.HIDE_THREAD_ITEM){
                final /* synthetic */ LiveCPUView this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                    this.setEnabled(!this.this$0.mergedThreads && this.this$0.threadsSelector != null && value instanceof PrestimeCPUCCTNode && this.this$0.snapshot.getNThreads() > 1 && (this.this$0.selectedThreads == null || this.this$0.selectedThreads.size() > 1));
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    PrestimeCPUCCTNode thread = (PrestimeCPUCCTNode)value;
                    this.this$0.threadsSelector.removeThread(thread.getThreadId());
                }
            });
            JMenu expand = new JMenu(CPUView.EXPAND_MENU);
            popup.add(expand);
            expand.add(new JMenuItem(this, CPUView.EXPAND_PLAIN_ITEM){
                final /* synthetic */ LiveCPUView this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    ttable.expandPlainPath(ttable.getSelectedRow(), 2);
                }
            });
            expand.add(new JMenuItem(this, CPUView.EXPAND_TOPMOST_ITEM){
                final /* synthetic */ LiveCPUView this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    ttable.expandFirstPath(ttable.getSelectedRow());
                }
            });
            expand.addSeparator();
            expand.add(new JMenuItem(this, CPUView.COLLAPSE_CHILDREN_ITEM){
                final /* synthetic */ LiveCPUView this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    ttable.collapseChildren(ttable.getSelectedRow());
                }
            });
            expand.add(new JMenuItem(this, CPUView.COLLAPSE_ALL_ITEM){
                final /* synthetic */ LiveCPUView this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    ttable.collapseAll();
                }
            });
        } else if (invoker == this.hotSpotsView) {
            final String searchString = value.toString().replace("(", " (");
            popup.add(new JMenuItem(this, CPUView.FIND_IN_FORWARDCALLS){
                final /* synthetic */ LiveCPUView this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                    this.setEnabled(userValue != null);
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    ProfilerTable table = this.this$0.forwardCallsView.getResultsComponent();
                    if (SearchUtils.findString(table, searchString)) {
                        this.this$0.forwardCallsView.setVisible(true);
                        this.this$0.foundInForwardCalls();
                        table.requestFocusInWindow();
                    }
                }
            });
            popup.add(new JMenuItem(this, CPUView.FIND_IN_REVERSECALLS){
                final /* synthetic */ LiveCPUView this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                    this.setEnabled(userValue != null);
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    ProfilerTreeTable table = (ProfilerTreeTable)this.this$0.reverseCallsView.getResultsComponent();
                    if (SearchUtils.findString(table, searchString, true, true, LiveCPUView.createSearchHelper())) {
                        this.this$0.reverseCallsView.setVisible(true);
                        this.this$0.foundInReverseCalls();
                        table.requestFocusInWindow();
                    }
                }
            });
        } else if (invoker == this.reverseCallsView) {
            ttable = (ProfilerTreeTable)this.reverseCallsView.getResultsComponent();
            column = ttable.convertColumnIndexToView(ttable.getMainColumn());
            final String searchString = ttable.getStringValue((TreeNode)value, column);
            popup.add(new JMenuItem(this, CPUView.FIND_IN_FORWARDCALLS){
                final /* synthetic */ LiveCPUView this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                    this.setEnabled(userValue != null);
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    ProfilerTable table = this.this$0.forwardCallsView.getResultsComponent();
                    if (SearchUtils.findString(table, searchString)) {
                        this.this$0.forwardCallsView.setVisible(true);
                        this.this$0.foundInForwardCalls();
                        table.requestFocusInWindow();
                    }
                }
            });
            popup.add(new JMenuItem(this, CPUView.FIND_IN_HOTSPOTS){
                final /* synthetic */ LiveCPUView this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                    this.setEnabled(userValue != null);
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    ProfilerTable table = this.this$0.hotSpotsView.getResultsComponent();
                    if (SearchUtils.findString(table, searchString)) {
                        this.this$0.hotSpotsView.setVisible(true);
                        this.this$0.foundInHotSpots();
                        table.requestFocusInWindow();
                    }
                }
            });
            popup.addSeparator();
            threads = new JMenu(CPUView.SHOW_MENU);
            popup.add(threads);
            threads.add(new JMenuItem(this, CPUView.SHOW_THREAD_ITEM){
                final /* synthetic */ LiveCPUView this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                    this.setEnabled(!this.this$0.mergedThreads && this.this$0.threadsSelector != null && value instanceof PrestimeCPUCCTNode && this.this$0.snapshot.getNThreads() > 1 && (this.this$0.selectedThreads == null || this.this$0.selectedThreads.size() > 1));
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    PrestimeCPUCCTNode thread = (PrestimeCPUCCTNode)value;
                    this.this$0.threadsSelector.addThread(thread.getThreadId(), true);
                }
            });
            threads.add(new JMenuItem(this, CPUView.HIDE_THREAD_ITEM){
                final /* synthetic */ LiveCPUView this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                    this.setEnabled(!this.this$0.mergedThreads && this.this$0.threadsSelector != null && value instanceof PrestimeCPUCCTNode && this.this$0.snapshot.getNThreads() > 1 && (this.this$0.selectedThreads == null || this.this$0.selectedThreads.size() > 1));
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    PrestimeCPUCCTNode thread = (PrestimeCPUCCTNode)value;
                    this.this$0.threadsSelector.removeThread(thread.getThreadId());
                }
            });
            JMenu expand = new JMenu(CPUView.EXPAND_MENU);
            popup.add(expand);
            expand.add(new JMenuItem(this, CPUView.EXPAND_PLAIN_ITEM){
                final /* synthetic */ LiveCPUView this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    ttable.expandPlainPath(ttable.getSelectedRow(), 1);
                }
            });
            expand.add(new JMenuItem(this, CPUView.EXPAND_TOPMOST_ITEM){
                final /* synthetic */ LiveCPUView this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    ttable.expandFirstPath(ttable.getSelectedRow());
                }
            });
            expand.addSeparator();
            expand.add(new JMenuItem(this, CPUView.COLLAPSE_CHILDREN_ITEM){
                final /* synthetic */ LiveCPUView this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    ttable.collapseChildren(ttable.getSelectedRow());
                }
            });
            expand.add(new JMenuItem(this, CPUView.COLLAPSE_ALL_ITEM){
                final /* synthetic */ LiveCPUView this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    ttable.collapseAll();
                }
            });
        }
        popup.addSeparator();
        popup.add(invoker.createCopyMenuItem());
        popup.addSeparator();
        popup.add(new JMenuItem(this, FilterUtils.ACTION_FILTER){
            final /* synthetic */ LiveCPUView this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                invoker.activateFilter();
            }
        });
        popup.add(new JMenuItem(this, SearchUtils.ACTION_FIND){
            final /* synthetic */ LiveCPUView this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                invoker.activateSearch();
            }
        });
    }

    private static SearchUtils.TreeHelper createSearchHelper() {
        return new SearchUtils.TreeHelper(){

            @Override
            public int getNodeType(TreeNode tnode) {
                PrestimeCPUCCTNode node = (PrestimeCPUCCTNode)tnode;
                CCTNode parent = node.getParent();
                if (parent == null) {
                    return 100;
                }
                if (node.isThreadNode()) {
                    return 100;
                }
                if (node.isSelfTimeNode()) {
                    return 101;
                }
                if (((PrestimeCPUCCTNode)parent).isThreadNode() || parent.getParent() == null) {
                    return 11;
                }
                return 101;
            }
        };
    }

    protected void customizeNodePopup(DataView invoker, JPopupMenu popup, Object value, ClientUtils.SourceCodeSelection userValue) {
    }

    private synchronized ExecutorService getExecutor() {
        if (this.executor == null) {
            this.executor = Executors.newSingleThreadExecutor();
        }
        return this.executor;
    }
}

