/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.jdbc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.results.jdbc.JdbcResultsDiff;
import org.netbeans.lib.profiler.results.jdbc.JdbcResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.PresoObjAllocCCTNode;
import org.netbeans.lib.profiler.ui.components.ProfilerToolbar;
import org.netbeans.lib.profiler.ui.jdbc.JDBCTreeTableView;
import org.netbeans.lib.profiler.ui.jdbc.JDBCView;
import org.netbeans.lib.profiler.ui.results.DataView;
import org.netbeans.lib.profiler.ui.swing.ExportUtils;
import org.netbeans.lib.profiler.ui.swing.FilterUtils;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTreeTable;
import org.netbeans.lib.profiler.ui.swing.SearchUtils;

public abstract class SnapshotJDBCView
extends JPanel {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.jdbc.Bundle");
    private static final String COMPARE_SNAPSHOTS = messages.getString("SnapshotJDBCView_CompareSnapshots");
    private static final String RESET_COMPARE_SNAPSHOTS = messages.getString("SnapshotJDBCView_ResetCompareSnapshots");
    private JdbcResultsSnapshot snapshot;
    private JdbcResultsSnapshot refSnapshot;
    private DataView lastFocused;
    private JDBCTreeTableView jdbcCallsView;
    private JToggleButton compareButton;
    private ExecutorService executor;

    public SnapshotJDBCView(JdbcResultsSnapshot snapshot, Action saveAction, Action compareAction, Action infoAction, ExportUtils.Exportable exportProvider) {
        this.initUI(saveAction, compareAction, infoAction, exportProvider);
        this.registerActions();
        this.setSnapshot(snapshot);
    }

    public void setRefSnapshot(JdbcResultsSnapshot snapshot) {
        this.refSnapshot = snapshot;
        if (this.compareButton != null && snapshot != null) {
            this.compareButton.setSelected(true);
            this.compareButton.setToolTipText(RESET_COMPARE_SNAPSHOTS);
        }
        this.setData();
    }

    protected abstract boolean showSourceSupported();

    protected abstract void showSource(ClientUtils.SourceCodeSelection var1);

    protected abstract void showSQLQuery(String var1, String var2);

    protected abstract void selectForProfiling(ClientUtils.SourceCodeSelection var1);

    private void profileMethod(ClientUtils.SourceCodeSelection value) {
        this.selectForProfiling(value);
    }

    private void profileClass(ClientUtils.SourceCodeSelection value) {
        this.selectForProfiling(new ClientUtils.SourceCodeSelection(value.getClassName(), "*", null));
    }

    private void initUI(Action saveAction, final Action compareAction, Action infoAction, ExportUtils.Exportable exportProvider) {
        this.setLayout(new BorderLayout(0, 0));
        this.jdbcCallsView = new JDBCTreeTableView(null, false){

            @Override
            protected void installDefaultAction() {
                this.getResultsComponent().setDefaultAction(new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int row;
                        ProfilerTable t = this.getResultsComponent();
                        PresoObjAllocCCTNode node = (PresoObjAllocCCTNode)t.getValueForRow(row = t.getSelectedRow());
                        if (JDBCTreeTableView.isSQL(node)) {
                            SnapshotJDBCView.this.showQueryImpl(node);
                        } else {
                            ClientUtils.SourceCodeSelection userValue = this.getUserValueForRow(row);
                            if (userValue != null) {
                                this.performDefaultAction(userValue);
                            }
                        }
                    }
                });
            }

            @Override
            protected void performDefaultAction(ClientUtils.SourceCodeSelection value) {
                if (SnapshotJDBCView.this.showSourceSupported()) {
                    SnapshotJDBCView.this.showSource(value);
                }
            }

            @Override
            protected void populatePopup(JPopupMenu popup, Object value, ClientUtils.SourceCodeSelection userValue) {
                SnapshotJDBCView.this.populatePopup(SnapshotJDBCView.this.jdbcCallsView, popup, value, userValue);
            }
        };
        this.jdbcCallsView.notifyOnFocus(new Runnable(){

            @Override
            public void run() {
                SnapshotJDBCView.this.lastFocused = SnapshotJDBCView.this.jdbcCallsView;
            }
        });
        this.add((Component)this.jdbcCallsView, "Center");
        ProfilerToolbar toolbar = ProfilerToolbar.create(true);
        if (saveAction != null) {
            toolbar.add(saveAction);
        }
        toolbar.add(ExportUtils.exportButton(this, JDBCView.EXPORT_TOOLTIP, this.getExportables(exportProvider)));
        if (compareAction != null) {
            toolbar.addSpace(2);
            toolbar.addSeparator();
            toolbar.addSpace(2);
            Icon icon = (Icon)compareAction.getValue("SmallIcon");
            this.compareButton = new JToggleButton(this, icon){
                final /* synthetic */ SnapshotJDBCView this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    boolean sel = this.isSelected();
                    if (sel) {
                        compareAction.actionPerformed(e);
                        if (this.this$0.refSnapshot == null) {
                            this.setSelected(false);
                        }
                    } else {
                        this.this$0.setRefSnapshot(null);
                    }
                    this.setToolTipText(this.isSelected() ? RESET_COMPARE_SNAPSHOTS : COMPARE_SNAPSHOTS);
                }
            };
            this.compareButton.setToolTipText(COMPARE_SNAPSHOTS);
            toolbar.add(this.compareButton);
        }
        if (infoAction != null) {
            toolbar.addFiller();
            toolbar.add(infoAction);
        }
        this.add((Component)toolbar.getComponent(), "North");
    }

    private void registerActions() {
        ActionMap map = this.getActionMap();
        map.put("filter-action-key", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataView active = SnapshotJDBCView.this.getLastFocused();
                if (active != null) {
                    active.activateFilter();
                }
            }
        });
        map.put("find-action-key", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataView active = SnapshotJDBCView.this.getLastFocused();
                if (active != null) {
                    active.activateSearch();
                }
            }
        });
    }

    private DataView getLastFocused() {
        if (this.lastFocused != null && !this.lastFocused.isShowing()) {
            this.lastFocused = null;
        }
        if (this.lastFocused == null && this.jdbcCallsView.isShowing()) {
            this.lastFocused = this.jdbcCallsView;
        }
        return this.lastFocused;
    }

    private void showQueryImpl(PresoObjAllocCCTNode node) {
        this.showSQLQuery(node.getNodeName(), ((JDBCTreeTableView.SQLQueryNode)node).htmlName);
    }

    private void populatePopup(final DataView invoker, JPopupMenu popup, final Object value, final ClientUtils.SourceCodeSelection userValue) {
        final PresoObjAllocCCTNode node = (PresoObjAllocCCTNode)value;
        if (JDBCTreeTableView.isSQL(node)) {
            popup.add(new JMenuItem(this, JDBCView.ACTION_VIEWSQLQUERY){
                final /* synthetic */ SnapshotJDBCView this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                    this.setFont(this.getFont().deriveFont(1));
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    this.this$0.showQueryImpl((JDBCTreeTableView.SQLQueryNode)((Object)value));
                }
            });
            popup.addSeparator();
        } else if (this.showSourceSupported()) {
            popup.add(new JMenuItem(this, JDBCView.ACTION_GOTOSOURCE){
                final /* synthetic */ SnapshotJDBCView this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                    this.setEnabled(userValue != null);
                    this.setFont(this.getFont().deriveFont(1));
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    this.this$0.showSource(userValue);
                }
            });
            popup.addSeparator();
        }
        popup.add(new JMenuItem(this, JDBCView.ACTION_PROFILE_METHOD){
            final /* synthetic */ SnapshotJDBCView this$0;
            {
                this.this$0 = this$0;
                super(arg0);
                this.setEnabled(userValue != null && JDBCTreeTableView.isSelectable(node));
            }

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                this.this$0.profileMethod(userValue);
            }
        });
        popup.add(new JMenuItem(this, JDBCView.ACTION_PROFILE_CLASS){
            final /* synthetic */ SnapshotJDBCView this$0;
            {
                this.this$0 = this$0;
                super(arg0);
                this.setEnabled(userValue != null);
            }

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                this.this$0.profileClass(userValue);
            }
        });
        this.customizeNodePopup(invoker, popup, value, userValue);
        popup.addSeparator();
        final ProfilerTreeTable ttable = (ProfilerTreeTable)this.jdbcCallsView.getResultsComponent();
        JMenu expand = new JMenu(JDBCView.EXPAND_MENU);
        popup.add(expand);
        expand.add(new JMenuItem(this, JDBCView.EXPAND_PLAIN_ITEM){
            final /* synthetic */ SnapshotJDBCView this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                ttable.expandPlainPath(ttable.getSelectedRow(), 1);
            }
        });
        expand.add(new JMenuItem(this, JDBCView.EXPAND_TOPMOST_ITEM){
            final /* synthetic */ SnapshotJDBCView this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                ttable.expandFirstPath(ttable.getSelectedRow());
            }
        });
        expand.addSeparator();
        expand.add(new JMenuItem(this, JDBCView.COLLAPSE_CHILDREN_ITEM){
            final /* synthetic */ SnapshotJDBCView this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                ttable.collapseChildren(ttable.getSelectedRow());
            }
        });
        expand.add(new JMenuItem(this, JDBCView.COLLAPSE_ALL_ITEM){
            final /* synthetic */ SnapshotJDBCView this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                ttable.collapseAll();
            }
        });
        popup.addSeparator();
        popup.add(invoker.createCopyMenuItem());
        popup.addSeparator();
        popup.add(new JMenuItem(this, FilterUtils.ACTION_FILTER){
            final /* synthetic */ SnapshotJDBCView this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                invoker.activateFilter();
            }
        });
        popup.add(new JMenuItem(this, SearchUtils.ACTION_FIND){
            final /* synthetic */ SnapshotJDBCView this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                invoker.activateSearch();
            }
        });
    }

    protected void customizeNodePopup(DataView invoker, JPopupMenu popup, Object value, ClientUtils.SourceCodeSelection userValue) {
    }

    private void setData() {
        this.getExecutor().submit(new Runnable(){

            @Override
            public void run() {
                final JdbcResultsSnapshot _snapshot = SnapshotJDBCView.this.refSnapshot == null ? SnapshotJDBCView.this.snapshot : SnapshotJDBCView.this.snapshot.createDiff(SnapshotJDBCView.this.refSnapshot);
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ 16 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        boolean diff = _snapshot instanceof JdbcResultsDiff;
                        this.this$1.SnapshotJDBCView.this.jdbcCallsView.setData(_snapshot, null, -1, null, false, false, diff);
                    }
                });
            }
        });
    }

    protected final void setSnapshot(JdbcResultsSnapshot snapshot) {
        this.snapshot = snapshot;
        this.setData();
    }

    private ExportUtils.Exportable[] getExportables(final ExportUtils.Exportable snapshotExporter) {
        return new ExportUtils.Exportable[]{new ExportUtils.Exportable(this){
            final /* synthetic */ SnapshotJDBCView this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean isEnabled() {
                return this.this$0.refSnapshot == null && snapshotExporter.isEnabled();
            }

            @Override
            public String getName() {
                return snapshotExporter.getName();
            }

            @Override
            public ExportUtils.ExportProvider[] getProviders() {
                return snapshotExporter.getProviders();
            }
        }, new ExportUtils.Exportable(){

            @Override
            public boolean isEnabled() {
                return SnapshotJDBCView.this.jdbcCallsView.isVisible();
            }

            @Override
            public String getName() {
                return MessageFormat.format(JDBCView.EXPORT_LBL, JDBCView.EXPORT_QUERIES);
            }

            @Override
            public ExportUtils.ExportProvider[] getProviders() {
                return SnapshotJDBCView.this.jdbcCallsView.getExportProviders();
            }
        }};
    }

    private synchronized ExecutorService getExecutor() {
        if (this.executor == null) {
            this.executor = Executors.newSingleThreadExecutor();
        }
        return this.executor;
    }
}

