/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.api.ejbjar;

import java.io.IOException;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.openide.filesystems.FileObject;

public final class EjbReference {
    private final String ejbClass;
    private final String ejbRefType;
    private final String local;
    private final String localHome;
    private final String remote;
    private final String remoteHome;
    private final EjbJar ejbModule;
    private final ClasspathInfo cpInfo;

    private EjbReference(String ejbClass, String ejbRefType, String local, String localHome, String remote, String remoteHome, EjbJar ejbModule) {
        this.ejbClass = ejbClass;
        this.ejbRefType = ejbRefType;
        this.local = local;
        this.localHome = localHome;
        this.remote = remote;
        this.remoteHome = remoteHome;
        this.ejbModule = ejbModule;
        FileObject[] javaSources = this.getEjbModule().getJavaSources();
        this.cpInfo = javaSources.length > 0 ? ClasspathInfo.create((ClassPath)ClassPath.getClassPath((FileObject)javaSources[0], (String)"classpath/boot"), (ClassPath)ClassPath.getClassPath((FileObject)javaSources[0], (String)"classpath/compile"), (ClassPath)ClassPath.getClassPath((FileObject)javaSources[0], (String)"classpath/source")) : null;
    }

    public static EjbReference create(String ejbClass, String ejbRefType, String local, String localHome, String remote, String remoteHome, EjbJar ejbModule) {
        return new EjbReference(ejbClass, ejbRefType, local, localHome, remote, remoteHome, ejbModule);
    }

    public String getEjbClass() {
        return this.ejbClass;
    }

    public String getEjbRefType() {
        return this.ejbRefType;
    }

    public String getLocal() {
        return this.local;
    }

    public String getLocalHome() {
        return this.localHome;
    }

    public String getRemote() {
        return this.remote;
    }

    public String getRemoteHome() {
        return this.remoteHome;
    }

    public EjbJar getEjbModule() {
        return this.ejbModule;
    }

    public String getHomeName(EjbRefIType iType) {
        switch (iType.ordinal()) {
            case 1: {
                return this.getLocalHome();
            }
            case 2: {
                return this.getRemoteHome();
            }
            case 0: {
                return this.getEjbClass();
            }
        }
        return null;
    }

    public String getComponentName(EjbRefIType iType) {
        switch (iType.ordinal()) {
            case 1: {
                return this.getLocal();
            }
            case 2: {
                return this.getRemote();
            }
            case 0: {
                return this.getEjbClass();
            }
        }
        return null;
    }

    public ClasspathInfo getClasspathInfo() {
        return this.cpInfo;
    }

    public FileObject getComponentFO(EjbRefIType iType) {
        switch (iType.ordinal()) {
            case 1: {
                return this.findFileObject(this.getLocal());
            }
            case 2: {
                return this.findFileObject(this.getRemote());
            }
            case 0: {
                return this.findFileObject(this.getEjbClass());
            }
        }
        return null;
    }

    private FileObject findFileObject(final String className) {
        if (this.cpInfo == null) {
            return null;
        }
        final FileObject[] result = new FileObject[]{null};
        try {
            JavaSource.create((ClasspathInfo)this.cpInfo, (FileObject[])new FileObject[0]).runUserActionTask((Task)new Task<CompilationController>(){
                final /* synthetic */ EjbReference this$0;
                {
                    this.this$0 = this$0;
                }

                public void run(CompilationController controller) throws IOException {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement typeElement = controller.getElements().getTypeElement(className);
                    if (typeElement != null) {
                        result[0] = SourceUtils.getFile((ElementHandle)ElementHandle.create((Element)typeElement), (ClasspathInfo)controller.getClasspathInfo());
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result[0];
    }

    public static enum EjbRefIType {
        NO_INTERFACE("Bean"),
        LOCAL("Local"),
        REMOTE("Remote");

        private String name;

        private EjbRefIType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

