/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.wizards;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.lib.api.elements.Attribute;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.netbeans.modules.web.jsf.dialogs.BrowseFolders;
import org.netbeans.modules.web.jsf.wizards.Bundle;
import org.netbeans.modules.web.jsf.wizards.TemplateClientPanel;
import org.netbeans.modules.web.jsfapi.api.DefaultLibraryInfo;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public class TemplateClientPanelVisual
extends JPanel
implements HelpCtx.Provider {
    private static final long serialVersionUID = 1L;
    private WizardDescriptor wizardDescriptor;
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);
    private static final String VALUE_NAME = "name";
    Collection<String> templateData = Collections.EMPTY_SET;
    private JScrollPane SectionsScrollPane;
    private ButtonGroup bgRootTag;
    private JButton jbBrowse;
    private JLabel jlRootTag;
    private JLabel jlTemplate;
    private JRadioButton jrbComposition;
    private JRadioButton jrbHtml;
    private JTextField jtfTemplate;
    private JTable sectionsTable;
    private JLabel sectionsToGenerateLabel;

    public TemplateClientPanelVisual(WizardDescriptor wizardDescriptor) {
        this.initComponents();
        this.wizardDescriptor = wizardDescriptor;
    }

    private void initComponents() {
        this.bgRootTag = new ButtonGroup();
        this.jrbHtml = new JRadioButton();
        this.jrbComposition = new JRadioButton();
        this.jlRootTag = new JLabel();
        this.jlTemplate = new JLabel();
        this.jtfTemplate = new JTextField();
        this.jbBrowse = new JButton();
        this.sectionsToGenerateLabel = new JLabel();
        this.SectionsScrollPane = new JScrollPane();
        this.sectionsTable = new JTable();
        this.bgRootTag.add(this.jrbHtml);
        this.jrbHtml.setSelected(true);
        this.jrbHtml.setText("<html>&lt;html&gt;</html>");
        this.jrbHtml.setActionCommand("html");
        this.jrbHtml.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jrbHtml.setMargin(new Insets(0, 0, 0, 0));
        this.bgRootTag.add(this.jrbComposition);
        this.jrbComposition.setText("<ui:composition>");
        this.jrbComposition.setActionCommand("composition");
        this.jrbComposition.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jrbComposition.setMargin(new Insets(0, 0, 0, 0));
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle");
        this.jlRootTag.setText(bundle.getString("LBL_RootTag"));
        this.jlTemplate.setText(bundle.getString("LBL_SelectTemplate"));
        this.jtfTemplate.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                TemplateClientPanelVisual.this.jtfTemplateKeyReleased(evt);
            }
        });
        this.jbBrowse.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle").getString("MNE_Browse").charAt(0));
        this.jbBrowse.setText(bundle.getString("LBL_Browse"));
        this.jbBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TemplateClientPanelVisual.this.jbBrowseActionPerformed(evt);
            }
        });
        this.sectionsToGenerateLabel.setText(NbBundle.getMessage(TemplateClientPanelVisual.class, (String)"LBL_SectionsToGenerate"));
        this.sectionsTable.setModel(TemplateClientPanelVisual.getNoTemplateTableModel());
        this.sectionsTable.setEnabled(false);
        this.sectionsTable.setTableHeader(null);
        this.SectionsScrollPane.setViewportView(this.sectionsTable);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jlTemplate).addGroup(layout.createSequentialGroup().addGap(138, 138, 138).addComponent(this.jtfTemplate, -1, 313, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jbBrowse)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jlRootTag).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jrbComposition).addComponent(this.jrbHtml, -2, -1, -2))).addComponent(this.sectionsToGenerateLabel)).addContainerGap(-1, Short.MAX_VALUE)).addComponent(this.SectionsScrollPane));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jlTemplate).addComponent(this.jbBrowse).addComponent(this.jtfTemplate, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jlRootTag).addComponent(this.jrbHtml, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jrbComposition).addGap(18, 18, 18).addComponent(this.sectionsToGenerateLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.SectionsScrollPane, -1, 79, Short.MAX_VALUE)));
    }

    private void jtfTemplateKeyReleased(KeyEvent evt) {
        this.templateData = Collections.EMPTY_SET;
        this.fireChangeEvent();
    }

    private void jbBrowseActionPerformed(ActionEvent evt) {
        String projectDirPath = Templates.getProject((WizardDescriptor)this.wizardDescriptor).getProjectDirectory().getPath();
        final boolean projectNamedContracts = projectDirPath.contains("contracts");
        BrowseFolders bf = new BrowseFolders(this.getFaceletTemplateRoots(), new BrowseFolders.Naming(){
            final /* synthetic */ TemplateClientPanelVisual this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public String getName(String path, String folderName) {
                String[] split;
                boolean isContract = projectNamedContracts ? (split = path.split("contracts")).length > 2 : path.contains("contracts");
                if (isContract) {
                    return Bundle.TemplateClientPanelVisual_lbl_resource_library_contract() + " : " + folderName;
                }
                return Bundle.TemplateClientPanelVisual_lbl_web_pages();
            }
        });
        FileObject fo = bf.showDialog();
        if (fo != null) {
            String path = fo.getPath();
            if (path.contains("contracts")) {
                this.jtfTemplate.setText(TemplateClientPanelVisual.getRelativePathInsideResourceLibrary(path));
            } else {
                this.jtfTemplate.setText(path);
            }
            this.templateData = Collections.EMPTY_SET;
        }
        this.fireChangeEvent();
    }

    private FileObject[] getFaceletTemplateRoots() {
        ArrayList<FileObject> roots = new ArrayList<FileObject>();
        roots.addAll(this.getSourceRoots());
        roots.addAll(this.getProjectContractsRoots());
        roots.addAll(this.getLibContractsRoots());
        return roots.toArray(new FileObject[0]);
    }

    private SourceGroup[] getProjectDocumentSourceGroups() {
        Sources sources = ProjectUtils.getSources((Project)Templates.getProject((WizardDescriptor)this.wizardDescriptor));
        SourceGroup[] docSourceGroups = sources.getSourceGroups("doc_root");
        SourceGroup[] sourceGroups = docSourceGroups.length == 0 ? sources.getSourceGroups("java") : docSourceGroups;
        return sourceGroups;
    }

    private List<FileObject> getSourceRoots() {
        ArrayList<FileObject> roots = new ArrayList<FileObject>();
        for (SourceGroup sourceGroup : this.getProjectDocumentSourceGroups()) {
            roots.add(sourceGroup.getRootFolder());
        }
        return roots;
    }

    private List<FileObject> getLibContractsRoots() {
        ArrayList<FileObject> roots = new ArrayList<FileObject>();
        if (this.getProjectDocumentSourceGroups().length > 0) {
            ClassPathProvider cpp = (ClassPathProvider)Templates.getProject((WizardDescriptor)this.wizardDescriptor).getLookup().lookup(ClassPathProvider.class);
            for (SourceGroup sourceGroup : this.getProjectDocumentSourceGroups()) {
                ClassPath cp = cpp.findClassPath(sourceGroup.getRootFolder(), "classpath/compile");
                if (cp == null) continue;
                for (FileObject root : cp.getRoots()) {
                    FileObject contracts = root.getFileObject("META-INF/contracts");
                    if (contracts == null || !contracts.isValid() || !contracts.isFolder()) continue;
                    for (FileObject contract : contracts.getChildren()) {
                        roots.add(contract);
                    }
                }
            }
        }
        return roots;
    }

    private List<FileObject> getProjectContractsRoots() {
        ArrayList<FileObject> roots = new ArrayList<FileObject>();
        for (SourceGroup sourceGroup : this.getProjectDocumentSourceGroups()) {
            FileObject contractsRoot = sourceGroup.getRootFolder().getFileObject("contracts");
            if (contractsRoot == null || !contractsRoot.isValid() || !contractsRoot.isFolder()) continue;
            for (FileObject fileObject : contractsRoot.getChildren()) {
                if (!fileObject.isValid() || !fileObject.isFolder()) continue;
                roots.add(fileObject);
            }
        }
        return roots;
    }

    protected static String getRelativePathInsideResourceLibrary(String fullPath) {
        if (!fullPath.contains("contracts")) {
            return fullPath;
        }
        int rootIndex = fullPath.lastIndexOf("contracts") + "contracts".length() + 1;
        int nextSlashOffset = fullPath.indexOf("/", rootIndex);
        if (nextSlashOffset != -1) {
            String resourceLibraryName = fullPath.substring(rootIndex, nextSlashOffset);
            return fullPath.substring(fullPath.indexOf(resourceLibraryName) + resourceLibraryName.length());
        }
        return fullPath;
    }

    private FileObject obtainContractTemplate(String path) {
        List<FileObject> contractsRoots = this.getProjectContractsRoots();
        contractsRoots.addAll(this.getLibContractsRoots());
        for (FileObject contract : contractsRoots) {
            FileObject fileObject = contract.getFileObject(path);
            if (fileObject == null || !fileObject.isValid() || fileObject.isFolder()) continue;
            return fileObject;
        }
        return null;
    }

    protected boolean validateTemplate() {
        if (this.templateData != null && !this.templateData.isEmpty()) {
            return true;
        }
        String message = null;
        String path = this.jtfTemplate.getText();
        if (path == null || "".equals(path)) {
            message = "MSG_NoTemplateSelected";
        } else {
            File file = new File(path);
            if (file.exists()) {
                if (!file.isDirectory()) {
                    FileObject fo = FileUtil.toFileObject((File)file);
                    this.parseTemplateData(fo);
                    if (this.templateData == null || this.templateData.isEmpty()) {
                        message = "MSG_NoFaceletsTemplate";
                    }
                } else {
                    message = "MSG_TemplateHasToBeFile";
                }
            } else {
                FileObject contractFO = this.obtainContractTemplate(path);
                if (contractFO == null) {
                    message = "MSG_EneterExistingTemplate";
                } else {
                    this.parseTemplateData(contractFO);
                    if (this.templateData == null || this.templateData.isEmpty()) {
                        message = "MSG_NoFaceletsTemplate";
                    }
                }
            }
        }
        if (message != null) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(TemplateClientPanelVisual.class, (String)message));
        }
        if (message == null) {
            return true;
        }
        this.resetSectionsTable();
        return false;
    }

    private void parseTemplateData(FileObject fo) {
        Parameters.notNull((CharSequence)"fileObject", (Object)fo);
        Source source = Source.create((FileObject)fo);
        try {
            ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    TemplateClientPanelVisual.this.templateData = new LinkedHashSet<String>();
                    Parser.Result result = resultIterator.getParserResult(0);
                    if (result.getSnapshot().getMimeType().equals("text/html")) {
                        HtmlParserResult htmlResult = (HtmlParserResult)result;
                        String ns = DefaultLibraryInfo.FACELETS.getValidNamespaces().stream().filter(htmlResult.getNamespaces()::containsKey).findFirst().orElse(null);
                        if (ns == null) {
                            return;
                        }
                        String faceletsPrefix = (String)htmlResult.getNamespaces().get(ns);
                        List foundNodes = TemplateClientPanelVisual.this.findValue(htmlResult.root(ns).children(OpenTag.class), faceletsPrefix + ":insert", new ArrayList());
                        foundNodes.stream().map(node -> node.getAttribute(TemplateClientPanelVisual.VALUE_NAME)).filter(Objects::nonNull).map(Attribute::unquotedValue).filter(value -> value != null && !"".equals(value)).map(CharSequence::toString).forEach(TemplateClientPanelVisual.this.templateData::add);
                    }
                }
            });
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (!this.templateData.isEmpty()) {
            this.loadSectionsTable();
        } else {
            this.resetSectionsTable();
        }
    }

    private List<OpenTag> findValue(Collection<OpenTag> nodes, String tagName, List<OpenTag> foundNodes) {
        if (nodes == null) {
            return foundNodes;
        }
        for (OpenTag ot : nodes) {
            if (LexerUtils.equals((CharSequence)tagName, (CharSequence)ot.name(), (boolean)true, (boolean)false)) {
                foundNodes.add(ot);
                continue;
            }
            foundNodes = this.findValue(ot.children(OpenTag.class), tagName, foundNodes);
        }
        return foundNodes;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.web.jsf.wizards.TemplateClientPanelVisual");
    }

    public InputStream getTemplateClient() {
        String path = "org/netbeans/modules/web/jsf/facelets/resources/templates/";
        path = path + this.bgRootTag.getSelection().getActionCommand() + "TemplateClient.template";
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(path);
        return is;
    }

    public Collection<String> getTemplateData() {
        return this.templateData;
    }

    public Collection<String> getTemplateDataToGenerate() {
        if (this.sectionsTable.getModel() instanceof SectionsTableModel) {
            ArrayList<String> sections = new ArrayList<String>();
            for (int i = 0; i < this.sectionsTable.getRowCount(); ++i) {
                if (!((Boolean)this.sectionsTable.getValueAt(i, 0)).booleanValue()) continue;
                sections.add((String)this.sectionsTable.getValueAt(i, 1));
            }
            return sections;
        }
        return this.getTemplateData();
    }

    public TemplateClientPanel.TemplateEntry getTemplate() {
        TemplateClientPanel.TemplateEntry templateEntry = new TemplateClientPanel.TemplateEntry(null);
        String path = this.jtfTemplate.getText();
        if (path != null && !"".equals(path)) {
            File file = new File(path);
            FileObject template = FileUtil.toFileObject((File)file);
            if (template == null || !template.isValid() || template.isFolder()) {
                template = this.obtainContractTemplate(path);
                templateEntry = new TemplateClientPanel.TemplateEntry(template, true);
            } else {
                templateEntry = new TemplateClientPanel.TemplateEntry(template);
            }
        }
        return templateEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> it;
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            it = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            it.next().stateChanged(ev);
        }
    }

    private static TableModel getNoTemplateTableModel() {
        DefaultTableModel model = new DefaultTableModel(1, 1);
        model.setValueAt(Bundle.TemplateClientPanelVisual_lbl_select_valid_template(), 0, 0);
        return model;
    }

    private void resetSectionsTable() {
        this.sectionsTable.setEnabled(false);
        this.sectionsTable.setModel(TemplateClientPanelVisual.getNoTemplateTableModel());
        this.sectionsTable.repaint();
    }

    private void loadSectionsTable() {
        this.sectionsTable.setEnabled(true);
        SectionsTableModel model = new SectionsTableModel(this.templateData.size(), 2);
        int index = 0;
        for (String section : this.templateData) {
            model.setValueAt(true, index, 0);
            model.setValueAt(section, index, 1);
            ++index;
        }
        this.sectionsTable.setModel(model);
        this.sectionsTable.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.sectionsTable.getColumnModel().getColumn(1).setPreferredWidth(300);
        this.sectionsTable.repaint();
    }

    private static class SectionsTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 1L;

        public SectionsTableModel(int rowCount, int columnCount) {
            super(rowCount, columnCount);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 0;
        }
    }
}

