/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.explorer;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.java.lsp.server.explorer.api.TreeDataListener;
import org.netbeans.modules.java.lsp.server.explorer.api.TreeDataProvider;
import org.netbeans.modules.java.lsp.server.explorer.api.TreeItemData;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public class NodeLookupContextValues
implements TreeDataProvider {
    private static final Logger LOG = Logger.getLogger(NodeLookupContextValues.class.getName());
    private static final String CLASS_PREFIX = "class:";
    private static final Map<String, String> DEFAULT_PREFIXES = new HashMap<String, String>();
    private final Set<Class<?>> watchClasses;
    private final Map<String, String> mapPrefixes;
    private final Map<Class<?>, String> interfaces;
    private final Map<Node, L> listenerMap = new WeakHashMap<Node, L>();
    private final List<TreeDataListener> listeners = new ArrayList<TreeDataListener>();

    public NodeLookupContextValues(Map<Class<?>, String> interfaces, Map<String, String> mapPrefixes, Set<Class<?>> watchClasses) {
        this.interfaces = interfaces;
        this.mapPrefixes = mapPrefixes;
        this.watchClasses = watchClasses;
    }

    private String token(Class c) {
        String token = this.interfaces.get(c);
        if (token == null) {
            token = c.getName();
        }
        String longestPrefix = null;
        for (String s : this.mapPrefixes.keySet()) {
            if (!token.startsWith(s) || longestPrefix != null && longestPrefix.length() >= s.length()) continue;
            longestPrefix = s;
        }
        if (longestPrefix != null) {
            String pref = this.mapPrefixes.get(longestPrefix);
            token = pref + token.substring(longestPrefix.length());
        }
        return CLASS_PREFIX + token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] findContextValues(Node n) {
        L listener;
        ArrayList<Lookup.Result> results = null;
        NodeLookupContextValues nodeLookupContextValues = this;
        synchronized (nodeLookupContextValues) {
            listener = this.listenerMap.get(n);
            if (listener == null) {
                results = new ArrayList<Lookup.Result>();
                listener = new L(results, n);
            }
        }
        ArrayList<String> res = new ArrayList<String>();
        Lookup nl = n.getLookup();
        for (Class<?> c : this.interfaces.keySet()) {
            Lookup.Item li;
            if (results == null || !this.watchClasses.contains(c)) {
                li = nl.lookupItem(new Lookup.Template(c));
            } else {
                Lookup.Result lr = nl.lookupResult(c);
                Collection items = lr.allItems();
                results.add(lr);
                Lookup.Item item = li = items.isEmpty() ? null : (Lookup.Item)items.iterator().next();
            }
            if (li == null) continue;
            res.add(this.token(c));
        }
        if (results != null && !results.isEmpty()) {
            NodeLookupContextValues nodeLookupContextValues2 = this;
            synchronized (nodeLookupContextValues2) {
                if (this.listenerMap.putIfAbsent(n, listener) == null) {
                    for (Lookup.Result lr : results) {
                        lr.addLookupListener((LookupListener)listener);
                    }
                }
            }
        }
        return res.toArray(new String[0]);
    }

    public static NodeLookupContextValues nodeLookup(String[] classes) {
        HashSet watch = new HashSet();
        HashMap<String, String> prefixes = new HashMap<String, String>(DEFAULT_PREFIXES);
        HashMap tokens = new HashMap();
        ClassLoader ldr = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        for (String s : classes) {
            String line;
            String prefix = null;
            String toPrefix = null;
            String classToken = line = s.trim();
            int bracket = line.indexOf(91);
            if (bracket != -1) {
                int endBracket = line.indexOf(93, bracket + 1);
                if (endBracket == -1) {
                    throw new IllegalArgumentException(line);
                }
                prefix = line.substring(bracket + 1, endBracket);
                int eq = prefix.indexOf(61);
                toPrefix = eq != -1 ? ((prefix = prefix.substring(0, eq)).length() <= eq + 1 ? "" : prefix.substring(eq + 1)) : "";
                if (line.length() <= endBracket + 1) {
                    line = "";
                } else {
                    classToken = line.substring(0, bracket) + line.substring(endBracket + 1);
                    line = line.substring(0, bracket) + prefix + line.substring(endBracket + 1);
                }
            } else {
                int eq = line.indexOf(61);
                if (eq != -1) {
                    classToken = line.substring(eq + 1);
                    line = line.substring(0, eq);
                }
            }
            if (!line.isEmpty()) {
                boolean enableWatch;
                boolean bl = enableWatch = line.charAt(0) == '*';
                if (enableWatch) {
                    line = line.substring(1);
                }
                try {
                    Class<?> clazz = ldr.loadClass(line);
                    tokens.put(clazz, classToken);
                    if (!enableWatch) continue;
                    watch.add(clazz);
                }
                catch (ClassNotFoundException ex) {
                    LOG.log(Level.INFO, "Service class {0} not found.", line);
                }
                continue;
            }
            if (toPrefix == null) continue;
            prefixes.put(prefix, toPrefix);
        }
        return new NodeLookupContextValues(tokens, prefixes, watch);
    }

    @Override
    public TreeItemData createDecorations(Node n, boolean expanded) {
        String[] tokens = this.findContextValues(n);
        if (tokens != null && tokens.length > 0) {
            return new TreeItemData().setContextValues(tokens);
        }
        return null;
    }

    private void fireNodeChange(Node n) {
    }

    @Override
    public synchronized void addTreeItemDataListener(TreeDataListener l) {
        this.listeners.add(l);
    }

    @Override
    public synchronized void removeTreeItemDataListener(TreeDataListener l) {
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeReleased(Node n) {
        L l;
        NodeLookupContextValues nodeLookupContextValues = this;
        synchronized (nodeLookupContextValues) {
            l = this.listenerMap.remove(n);
        }
        if (l != null) {
            for (Lookup.Result lr : l.results) {
                lr.removeLookupListener((LookupListener)l);
            }
        }
    }

    static {
        DEFAULT_PREFIXES.put("org.openide.cookies.", "");
        DEFAULT_PREFIXES.put("org.netbeans.api.actions.", "");
    }

    class L
    extends WeakReference<Node>
    implements LookupListener {
        final List<Lookup.Result> results;

        public L(List<Lookup.Result> results, Node target) {
            super(target);
            this.results = results;
        }

        public void resultChanged(LookupEvent ev) {
            Node n = (Node)this.get();
            if (n == null) {
                Lookup.Result lr = (Lookup.Result)ev.getSource();
                lr.removeLookupListener((LookupListener)this);
            } else {
                NodeLookupContextValues.this.fireNodeChange(n);
            }
        }
    }
}

