/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2sedeploy;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.scripting.Scripting;
import org.netbeans.modules.java.j2sedeploy.Bundle;
import org.netbeans.modules.java.j2sedeploy.NativeBundleType;
import org.netbeans.modules.java.j2seproject.api.J2SEPropertyEvaluator;
import org.netbeans.spi.project.ActionProgress;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public class J2SEDeployActionProvider
implements ActionProvider {
    private static final String TARGET_BUILD_NATIVE = "build-native";
    private static final String NOSCRIPT_SUFFIX = "-noscript";
    private static final String PROP_PACKAGE_TYPE = "native.bundling.type";
    private static final String PROP_DISABLE_JAR_CREATION = "jar.archive.disabled";
    private static final String PROP_BUILD_FILE = "buildfile";
    private static final RequestProcessor RP = new RequestProcessor(J2SEDeployActionProvider.class);
    private final Listener listener;
    private boolean isJSAvailable = true;
    private boolean isJSAvailableChecked = false;

    public J2SEDeployActionProvider(@NonNull Project prj) {
        this.listener = new Listener(prj);
    }

    public String[] getSupportedActions() {
        Set<NativeBundleType> nbts = NativeBundleType.getSupported();
        ArrayDeque<String> res = new ArrayDeque<String>(nbts.size());
        for (NativeBundleType nbt : nbts) {
            res.add(nbt.getCommand());
        }
        return res.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeAction(String command, Lookup context) throws IllegalArgumentException {
        Project prj = (Project)context.lookup(Project.class);
        if (prj == null) {
            throw new IllegalArgumentException(String.format("The context %s has no Project.", context));
        }
        NativeBundleType nbt = NativeBundleType.forCommand(command);
        if (nbt == null) {
            throw new IllegalArgumentException(String.format("Unsupported command %s.", command));
        }
        FileObject buildScript = J2SEDeployActionProvider.findBuildScript(this.listener.getProject());
        if (buildScript == null || !buildScript.isValid()) {
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)Bundle.LBL_No_Build_XML_Found(J2SEDeployActionProvider.getBuildXmlName(this.listener.getProject())), 2);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            return;
        }
        final ActionProgress listener = ActionProgress.start((Lookup)context);
        boolean success = false;
        try {
            Properties p = new Properties();
            p.setProperty(PROP_PACKAGE_TYPE, nbt.getAntProperyValue());
            p.setProperty(PROP_DISABLE_JAR_CREATION, Boolean.TRUE.toString());
            String noScript = this.isJavaScriptAvailable() ? "" : NOSCRIPT_SUFFIX;
            final ExecutorTask task = ActionUtils.runTarget((FileObject)buildScript, (String[])new String[]{TARGET_BUILD_NATIVE.concat(noScript)}, (Properties)p);
            task.addTaskListener(new TaskListener(){
                final /* synthetic */ J2SEDeployActionProvider this$0;
                {
                    this.this$0 = this$0;
                }

                public void taskFinished(Task _tmp) {
                    listener.finished(task.result() == 0);
                }
            });
            success = true;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            if (!success) {
                listener.finished(false);
            }
        }
    }

    public boolean isActionEnabled(String command, Lookup context) throws IllegalArgumentException {
        return this.supportsCommand(command) && this.listener.getProject().equals(context.lookup(Project.class)) && this.listener.isEnabled();
    }

    private boolean isJavaScriptAvailable() {
        if (this.isJSAvailableChecked) {
            return this.isJSAvailable;
        }
        ScriptEngineManager mgr = Scripting.createManager();
        List<ScriptEngineFactory> factories = mgr.getEngineFactories();
        for (ScriptEngineFactory factory : factories) {
            List<String> engNames = factory.getNames();
            for (String name : engNames) {
                if (!name.equalsIgnoreCase("js") && !name.equalsIgnoreCase("javascript")) continue;
                this.isJSAvailableChecked = true;
                this.isJSAvailable = true;
                return this.isJSAvailable;
            }
        }
        this.isJSAvailableChecked = true;
        this.isJSAvailable = false;
        return this.isJSAvailable;
    }

    private boolean supportsCommand(@NonNull String command) {
        for (String supportedCommand : this.getSupportedActions()) {
            if (!supportedCommand.equals(command)) continue;
            return true;
        }
        return false;
    }

    @CheckForNull
    private static FileObject findBuildScript(@NonNull Project prj) {
        return prj.getProjectDirectory().getFileObject(J2SEDeployActionProvider.getBuildXmlName(prj));
    }

    @NonNull
    private static String getBuildXmlName(@NonNull Project prj) {
        String buildScriptPath;
        J2SEPropertyEvaluator evalProvider = (J2SEPropertyEvaluator)prj.getLookup().lookup(J2SEPropertyEvaluator.class);
        String string = buildScriptPath = evalProvider == null ? null : evalProvider.evaluator().getProperty(PROP_BUILD_FILE);
        if (buildScriptPath == null) {
            buildScriptPath = "build.xml";
        }
        return buildScriptPath;
    }

    private static final class Listener
    implements Runnable,
    PropertyChangeListener {
        private final Project prj;
        private final RequestProcessor.Task refresh;
        private final AtomicBoolean initialized;
        private volatile Boolean cachedEnabled;

        Listener(@NonNull Project prj) {
            Parameters.notNull((CharSequence)"prj", (Object)prj);
            this.prj = prj;
            this.initialized = new AtomicBoolean();
            this.refresh = RP.create((Runnable)this);
        }

        @Override
        public void run() {
            ProjectManager.mutex().readAccess(new Runnable(){

                @Override
                public void run() {
                    this.isEnabled();
                }
            });
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if (propName == null || "native.bundling.enabled".equals(propName)) {
                this.cachedEnabled = null;
                this.refresh.schedule(0);
            }
        }

        boolean isEnabled() {
            Boolean res = this.cachedEnabled;
            if (res != null) {
                return res;
            }
            J2SEPropertyEvaluator j2seEval = (J2SEPropertyEvaluator)this.prj.getLookup().lookup(J2SEPropertyEvaluator.class);
            if (j2seEval == null) {
                this.cachedEnabled = res = Boolean.FALSE;
            } else {
                PropertyEvaluator eval = j2seEval.evaluator();
                if (this.initialized.compareAndSet(false, true)) {
                    eval.addPropertyChangeListener((PropertyChangeListener)this);
                }
                this.cachedEnabled = res = Boolean.valueOf(Listener.isTrue(eval.getProperty("native.bundling.enabled")));
            }
            return res;
        }

        @NonNull
        Project getProject() {
            return this.prj;
        }

        private static boolean isTrue(@NullAllowed String value) {
            return "true".equals(value) || "yes".equals(value) || "on".equals(value);
        }
    }
}

