/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.execute;

import java.io.IOException;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Action;
import org.netbeans.modules.gradle.spi.GradleSettings;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public abstract class OutputTabMaintainer<T> {
    private static final Map<InputOutput, AllContext<?>> FREE_TABS = new WeakHashMap();
    protected InputOutput io;
    private final String name;

    protected abstract Class<T> tabContextType();

    protected OutputTabMaintainer(String name) {
        assert (name != null);
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void markFreeTab() {
        if (GradleSettings.getDefault().isReuseOutputTabs()) {
            Map<InputOutput, AllContext<?>> map = FREE_TABS;
            synchronized (map) {
                assert (this.io != null);
                FREE_TABS.put(this.io, new AllContext<T>(this.name, this.tabContextType(), this.createContext()));
            }
        }
    }

    protected abstract void reassignAdditionalContext(T var1);

    protected abstract T createContext();

    protected Action[] createNewTabActions() {
        return new Action[0];
    }

    public final InputOutput getInputOutput() {
        if (this.io == null) {
            this.io = this.createInputOutput();
        }
        return this.io;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final InputOutput createInputOutput() {
        if (GradleSettings.getDefault().isReuseOutputTabs()) {
            Map<InputOutput, AllContext<?>> map = FREE_TABS;
            synchronized (map) {
                for (Map.Entry<InputOutput, AllContext<?>> entry : FREE_TABS.entrySet()) {
                    InputOutput free = entry.getKey();
                    AllContext<?> allContext = entry.getValue();
                    if (this.io == null && allContext.name.equals(this.name) && allContext.tabContextType == this.tabContextType()) {
                        this.io = free;
                        this.reassignAdditionalContext(this.tabContextType().cast(allContext.tabContext));
                        try {
                            this.io.getOut().reset();
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                        continue;
                    }
                    free.closeInputOutput();
                }
                FREE_TABS.clear();
            }
        }
        if (this.io == null) {
            this.io = IOProvider.getDefault().getIO(this.name, this.createNewTabActions());
            this.io.setInputVisible(true);
        }
        return this.io;
    }

    private static class AllContext<T> {
        final String name;
        final Class<T> tabContextType;
        final T tabContext;

        AllContext(String name, Class<T> tabContextType, T tabContext) {
            this.name = name;
            this.tabContextType = tabContextType;
            this.tabContext = tabContext;
        }
    }
}

