/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl;

import java.io.Serializable;
import javax.enterprise.deploy.spi.Target;
import org.netbeans.modules.j2ee.deployment.impl.Server;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.impl.ServerTarget;

public class ServerString
implements Serializable {
    private final String plugin;
    private final String instance;
    private final String[] targets;
    private final transient ServerInstance serverInstance;
    private transient String[] theTargets;
    private static final long serialVersionUID = 923457209372L;

    protected ServerString(String plugin, String instance, String[] targets, ServerInstance serverInstance) {
        this.targets = targets == null ? new String[0] : (String[])targets.clone();
        this.plugin = plugin;
        this.instance = instance;
        this.serverInstance = serverInstance;
    }

    public ServerString(String plugin, String instance, String[] targets) {
        this(plugin, instance, targets, null);
    }

    public ServerString(ServerInstance instance) {
        this(instance.getServer().getShortName(), instance.getUrl(), null, instance);
    }

    public ServerString(ServerTarget target) {
        this(target.getInstance().getServer().getShortName(), target.getInstance().getUrl(), new String[]{target.getName()}, null);
    }

    public ServerString(ServerInstance instance, String targetName) {
        String[] stringArray;
        String string = instance.getServer().getShortName();
        String string2 = instance.getUrl();
        if (targetName != null && !"".equals(targetName.trim())) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = targetName;
        } else {
            stringArray = null;
        }
        this(string, string2, stringArray, instance);
    }

    public String getPlugin() {
        return this.plugin;
    }

    public String getUrl() {
        return this.instance;
    }

    public String[] getTargets() {
        return this.getTargets(false);
    }

    public String[] getTargets(boolean concrete) {
        if (!concrete || this.targets.length > 0) {
            return (String[])this.targets.clone();
        }
        if (this.theTargets != null) {
            return (String[])this.theTargets.clone();
        }
        ServerTarget[] serverTargets = this.getServerInstance().getTargets();
        this.theTargets = new String[serverTargets.length];
        for (int i = 0; i < this.theTargets.length; ++i) {
            this.theTargets[i] = serverTargets[i].getName();
        }
        return (String[])this.theTargets.clone();
    }

    public Server getServer() {
        return ServerRegistry.getInstance().getServer(this.plugin);
    }

    public ServerInstance getServerInstance() {
        if (this.serverInstance != null) {
            return this.serverInstance;
        }
        return ServerRegistry.getInstance().getServerInstance(this.instance);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Server ").append(this.plugin);
        buffer.append(" Instance ").append(this.instance);
        if (this.targets.length == 0) {
            buffer.append(" Targets none");
        } else {
            buffer.append(" Targets ").append(this.targets.length);
        }
        return buffer.toString();
    }

    public Target[] toTargets() {
        String[] targetNames = this.getTargets(true);
        Target[] ret = new Target[targetNames.length];
        for (int i = 0; i < targetNames.length; ++i) {
            ret[i] = this.getServerInstance().getServerTarget(targetNames[i]).getTarget();
        }
        return ret;
    }
}

