/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.completion.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.lsp.Completion;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.CodeCompletionContext;
import org.netbeans.modules.csl.api.CodeCompletionHandler;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.Documentation;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.groovy.editor.api.completion.CompletionItem;
import org.netbeans.modules.groovy.editor.api.elements.common.MethodElement;
import org.netbeans.modules.groovy.editor.api.parser.GroovyParserResult;
import org.netbeans.modules.groovy.editor.completion.provider.CompletionAccessor;
import org.netbeans.modules.groovy.editor.completion.provider.GroovyCompletionImpl;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.lsp.CompletionCollector;
import org.openide.ErrorManager;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Pair;
import org.openide.util.WeakListeners;

public class GroovyCompletionCollector
implements CompletionCollector {
    private final Lookup lkp;
    private GroovyCompletionImpl cService;
    private static final int ORDER_CONSTRUCTOR = 1550;
    private static final int ORDER_METHOD = 1500;
    private static final int ORDER_META_METHOD = 1650;
    private static int ORDER_KEYWORD = 1670;
    private static int ORDER_TYPE = 1800;
    private static int ORDER_NAMED_PARAMETER = 1300;
    private static int ORDER_FIELD = 1200;
    private static int ORDER_FIELD_DYNAMIC = 1250;
    private static int ORDER_LOCAL_VAR = 1100;
    private static int ORDER_PACKAGE = 1900;
    private static boolean caseSensitive = true;
    private static boolean autoPopup = true;
    private static boolean inited;
    private static PreferenceChangeListener settingsListener;

    public GroovyCompletionCollector() {
        this(Lookup.getDefault());
    }

    public GroovyCompletionCollector(Lookup lkp) {
        this.lkp = lkp;
    }

    private GroovyCompletionImpl impl() {
        if (this.cService == null) {
            this.cService = (GroovyCompletionImpl)this.lkp.lookup(GroovyCompletionImpl.class);
        }
        return this.cService;
    }

    public boolean collectCompletions(Document doc, int offset, Completion.Context context, Consumer<Completion> consumer) {
        try {
            CompletionTask task = this.collectCompletions2(doc, offset, context, consumer);
            if (task == null) {
                return true;
            }
            return task.complete;
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return true;
        }
    }

    public CompletionTask collectCompletions2(Document doc, int offset, Completion.Context context, Consumer<Completion> consumer) throws ParseException {
        Source src = Source.create((Document)doc);
        if (src == null) {
            return null;
        }
        CompletionTask task = new CompletionTask(offset, CodeCompletionHandler.QueryType.COMPLETION, context, consumer);
        ParserManager.parse(Collections.singleton(src), (UserTask)task);
        return task;
    }

    private static HtmlFormatter nullFormatter() {
        return new NullHtmlFormatter();
    }

    static Completion.Kind lspCompletionKind(ElementKind cslKind) {
        switch (cslKind) {
            case CONSTRUCTOR: {
                return Completion.Kind.Constructor;
            }
            case MODULE: {
                return Completion.Kind.Module;
            }
            case PACKAGE: {
                return Completion.Kind.Folder;
            }
            case CLASS: {
                return Completion.Kind.Class;
            }
            case METHOD: {
                return Completion.Kind.Method;
            }
            case FIELD: {
                return Completion.Kind.Field;
            }
            case VARIABLE: {
                return Completion.Kind.Variable;
            }
            case ATTRIBUTE: {
                return Completion.Kind.Variable;
            }
            case CONSTANT: {
                return Completion.Kind.Constant;
            }
            case KEYWORD: {
                return Completion.Kind.Keyword;
            }
            case OTHER: {
                return Completion.Kind.Snippet;
            }
            case PARAMETER: {
                return Completion.Kind.Variable;
            }
            case GLOBAL: {
                return Completion.Kind.Variable;
            }
            case PROPERTY: {
                return Completion.Kind.Property;
            }
            case FILE: {
                return Completion.Kind.File;
            }
            case INTERFACE: {
                return Completion.Kind.Interface;
            }
        }
        return null;
    }

    private static boolean isCaseSensitive() {
        GroovyCompletionCollector.lazyInit();
        return caseSensitive;
    }

    private static void setCaseSensitive(boolean b) {
        GroovyCompletionCollector.lazyInit();
        caseSensitive = b;
    }

    private static void setAutoPopup(boolean b) {
        GroovyCompletionCollector.lazyInit();
        autoPopup = b;
    }

    private static void lazyInit() {
        if (!inited) {
            inited = true;
            Preferences prefs = (Preferences)MimeLookup.getLookup((MimePath)MimePath.EMPTY).lookup(Preferences.class);
            prefs.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)settingsListener, (Object)prefs));
            GroovyCompletionCollector.setCaseSensitive(prefs.getBoolean("completion-case-sensitive", false));
            GroovyCompletionCollector.setAutoPopup(prefs.getBoolean("completion-auto-popup", false));
        }
    }

    static {
        settingsListener = new SettingsListener();
    }

    public class CompletionTask
    extends UserTask {
        final int offset;
        final Consumer<Completion> consumer;
        final Completion.Context lspContext;
        final CodeCompletionHandler.QueryType queryType;
        CompletionRequestContext cslContext;
        GroovyParserResult groovyResult;
        boolean complete = true;
        GroovyCompletionImpl.CompletionImplResult groovyCompletion;
        final List<CompletionProposal> proposals = new ArrayList<CompletionProposal>();
        CompletionCollector.Builder builder;

        public CompletionTask(int offset, CodeCompletionHandler.QueryType queryType, Completion.Context context, Consumer<Completion> consumer) {
            this.offset = offset;
            this.lspContext = context;
            this.consumer = consumer;
            this.queryType = queryType;
        }

        public void run(ResultIterator resultIterator) throws Exception {
            if ("text/x-groovy".equals(resultIterator.getSnapshot().getMimeType())) {
                this.process(resultIterator.getParserResult());
            }
            for (Embedding e : resultIterator.getEmbeddings()) {
                if (!e.containsOriginalOffset(this.offset)) continue;
                this.run(resultIterator.getResultIterator(e));
            }
        }

        public List<CompletionProposal> getOriginalProposals() {
            return this.proposals;
        }

        void process(Parser.Result r) {
            if (!(r instanceof GroovyParserResult)) {
                return;
            }
            this.groovyResult = (GroovyParserResult)r;
            this.cslContext = new CompletionRequestContext(this.offset, this.queryType, this.groovyResult, true);
            this.proposals.addAll(GroovyCompletionCollector.this.impl().makeProposals(this.cslContext).getProposals());
            for (CompletionProposal cp : this.proposals) {
                Completion.Kind k = GroovyCompletionCollector.lspCompletionKind(cp.getKind());
                if (k == null) continue;
                this.builder = CompletionCollector.newBuilder((String)cp.getName()).kind(k);
                CompletionCollector.Builder b = this.buildCompletion(cp);
                if (b == null) continue;
                b.documentation(() -> this.getDocumentation(cp));
                this.consumer.accept(b.build());
            }
        }

        String getDocumentation(final CompletionProposal cp) {
            final AtomicReference doc = new AtomicReference();
            Source s = this.groovyResult.getSnapshot().getSource();
            if (s == null) {
                return null;
            }
            final GroovyCompletionImpl impl = (GroovyCompletionImpl)Lookup.getDefault().lookup(GroovyCompletionImpl.class);
            if (impl == null) {
                return null;
            }
            try {
                ParserManager.parse(Collections.singleton(s), (UserTask)new UserTask(this){
                    final /* synthetic */ CompletionTask this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run(ResultIterator resultIterator) throws Exception {
                        GroovyParserResult gpr;
                        Documentation d;
                        Parser.Result r = resultIterator.getParserResult();
                        if (r instanceof GroovyParserResult && (d = impl.documentElement(gpr = (GroovyParserResult)r, cp.getElement(), () -> false)) != null) {
                            doc.set(d.getContent());
                            return;
                        }
                        for (Embedding e : resultIterator.getEmbeddings()) {
                            if (!e.containsOriginalOffset(cp.getAnchorOffset())) continue;
                            this.run(resultIterator.getResultIterator(e));
                        }
                    }
                });
            }
            catch (ParseException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return (String)doc.get();
        }

        CompletionCollector.Builder buildCompletion(CompletionProposal cp) {
            if (!(cp instanceof CompletionItem)) {
                return null;
            }
            CompletionItem ci = (CompletionItem)cp;
            StringBuilder sb = new StringBuilder(cp.getLhsHtml(GroovyCompletionCollector.nullFormatter()));
            String rhs = cp.getRhsHtml(GroovyCompletionCollector.nullFormatter());
            if (rhs != null && !rhs.isEmpty()) {
                sb.append(" : ");
                sb.append(rhs);
            }
            this.builder.label(sb.toString());
            this.builder.insertText(cp.getInsertPrefix());
            if (cp instanceof CompletionItem.ConstructorItem) {
                return this.nameAndParameters(ci);
            }
            if (cp instanceof CompletionItem.NamedParameter) {
                this.builder.kind(Completion.Kind.Property).insertText(cp.getCustomInsertTemplate()).sortText(String.format("%04d%s", ORDER_NAMED_PARAMETER, cp.getName()));
            } else if (cp instanceof CompletionItem.DynamicFieldItem) {
                this.builder.kind(Completion.Kind.Field);
            } else {
                if (cp instanceof CompletionItem.TypeItem) {
                    return this.buildType(ci);
                }
                if (cp instanceof CompletionItem.KeywordItem) {
                    return this.buildKeyword(ci);
                }
                if (cp instanceof CompletionItem.PackageItem) {
                    return this.buildPackage(ci);
                }
                if (cp.getKind() == ElementKind.METHOD) {
                    return this.nameAndParameters((CompletionItem)cp);
                }
                if (cp.getKind() == ElementKind.FIELD) {
                    return this.buildField(ci);
                }
                if (cp.getKind() == ElementKind.VARIABLE) {
                    return this.buildVariable(ci);
                }
            }
            return this.builder;
        }

        CompletionCollector.Builder buildField(CompletionItem item) {
            int priority = ORDER_FIELD;
            if (item instanceof CompletionItem.DynamicFieldItem) {
                priority = ORDER_FIELD_DYNAMIC;
            }
            return this.builder.sortText(String.format("%04d%s", priority, item.getName()));
        }

        CompletionCollector.Builder buildVariable(CompletionItem item) {
            return this.builder.sortText(String.format("%04d%s", ORDER_LOCAL_VAR, item.getName()));
        }

        CompletionCollector.Builder buildType(CompletionItem item) {
            CompletionItem.TypeItem ti = (CompletionItem.TypeItem)item;
            return this.builder.sortText(String.format("%04d%s#%s", ORDER_TYPE, ti.getName(), ti.getFqn()));
        }

        CompletionCollector.Builder buildKeyword(CompletionItem item) {
            return this.builder.sortText(String.format("%04d%s", ORDER_KEYWORD, item.getName()));
        }

        CompletionCollector.Builder buildPackage(CompletionItem item) {
            return this.builder.sortText(String.format("%04d%s", ORDER_PACKAGE, item.getName()));
        }

        CompletionCollector.Builder buildExecutable(CompletionItem item, String simpleName, String sortParams, int cnt) {
            int priority;
            int n = priority = item.getKind() == ElementKind.METHOD ? 1500 : 1550;
            if (item instanceof CompletionItem.MetaMethodItem) {
                this.builder.kind(Completion.Kind.Function);
                priority = 1650;
            }
            return this.builder.sortText(String.format("%04d%s#%02d%s", priority, simpleName, cnt, sortParams.toString()));
        }

        CompletionCollector.Builder nameAndParameters(CompletionItem item) {
            Pair<String, List<MethodElement.MethodParameter>> paramsAndType = CompletionAccessor.instance().getParametersAndType(item);
            List params = (List)paramsAndType.second();
            String n = item.getName();
            StringBuilder sortParams = new StringBuilder();
            sortParams.append("(");
            int paren = n.indexOf(40);
            if (paren > -1) {
                n = n.substring(0, paren);
            }
            if (params.isEmpty()) {
                return this.buildExecutable(item, n, sortParams.toString(), 0).insertText(n + "()");
            }
            StringBuilder sb = new StringBuilder(n);
            sb.append("(");
            int cnt = 0;
            for (MethodElement.MethodParameter p : params) {
                if (cnt > 0) {
                    sb.append(", ");
                    sortParams.append("#");
                }
                ++cnt;
                if (p.getName() == null) {
                    sb.append("${").append(cnt);
                } else {
                    sb.append("${").append(cnt).append(':').append(p.getName());
                }
                sb.append("}");
                sortParams.append(p.getType());
            }
            sb.append(")$0");
            return this.buildExecutable(item, n, sortParams.toString(), params.size()).insertText(sb.toString()).insertTextFormat(Completion.TextFormat.Snippet);
        }
    }

    static class NullHtmlFormatter
    extends HtmlFormatter {
        StringBuilder sb = new StringBuilder();

        NullHtmlFormatter() {
        }

        public void reset() {
            this.sb = new StringBuilder();
        }

        static String stripHtml(String htmlText) {
            if (null == htmlText) {
                return null;
            }
            return htmlText.replaceAll("<[^>]*>", "").replace("&nbsp;", " ").trim();
        }

        public void appendHtml(String html) {
            this.sb.append(NullHtmlFormatter.stripHtml(html));
        }

        public void appendText(String text, int fromInclusive, int toExclusive) {
            int l = toExclusive - fromInclusive;
            if (this.sb.length() + l < this.maxLength) {
                this.sb.append(text.subSequence(fromInclusive, toExclusive));
            } else {
                this.sb.append(text.subSequence(fromInclusive, toExclusive - (l - this.maxLength)));
                this.sb.append("...");
            }
        }

        public void emphasis(boolean start) {
        }

        public void name(ElementKind kind, boolean start) {
        }

        public void parameters(boolean start) {
        }

        public void active(boolean start) {
        }

        public void type(boolean start) {
        }

        public void deprecated(boolean start) {
        }

        public String getText() {
            return this.sb.toString();
        }
    }

    private static class SettingsListener
    implements PreferenceChangeListener {
        private SettingsListener() {
        }

        @Override
        public void preferenceChange(PreferenceChangeEvent evt) {
            if (evt.getKey() == null || "completion-case-sensitive".equals(evt.getKey())) {
                GroovyCompletionCollector.setCaseSensitive(Boolean.valueOf(evt.getNewValue()));
            } else if ("completion-auto-popup".equals(evt.getKey())) {
                GroovyCompletionCollector.setAutoPopup(Boolean.valueOf(evt.getNewValue()));
            }
        }
    }

    private static class CompletionRequestContext
    extends CodeCompletionContext {
        final ParserResult parserResult;
        final boolean prefixMatch;
        final CodeCompletionHandler.QueryType queryType;
        int offset;
        String prefix;

        public CompletionRequestContext(int offset, CodeCompletionHandler.QueryType queryType, ParserResult parserResult, boolean prefixMatch) {
            this.offset = offset;
            this.parserResult = parserResult;
            this.prefixMatch = prefixMatch;
            this.queryType = queryType;
            this.init();
        }

        void init() {
            int length;
            Source s = this.parserResult.getSnapshot().getSource();
            Document doc = s.getDocument(false);
            int n = length = doc != null ? doc.getLength() : (int)s.getFileObject().getSize();
            if (this.offset > length) {
                this.offset = length;
            }
            try {
                int start;
                int[] blk;
                if (doc != null && (blk = Utilities.getIdentifierBlock((BaseDocument)((BaseDocument)doc), (int)this.offset)) != null && (start = blk[0]) < this.offset) {
                    this.prefix = this.prefixMatch ? doc.getText(start, this.offset - start) : doc.getText(start, blk[1] - start);
                }
            }
            catch (BadLocationException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }

        public int getCaretOffset() {
            return this.offset;
        }

        public ParserResult getParserResult() {
            return this.parserResult;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public CodeCompletionHandler.QueryType getQueryType() {
            return this.queryType;
        }

        public boolean isPrefixMatch() {
            return this.prefixMatch;
        }

        public boolean isCaseSensitive() {
            return GroovyCompletionCollector.isCaseSensitive();
        }
    }
}

