/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.codegen;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.core.api.support.java.GenerationUtils;
import org.netbeans.modules.j2ee.core.api.support.java.JavaIdentifiers;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.FacadeGenerator;
import org.netbeans.modules.websvc.rest.RestUtils;
import org.netbeans.modules.websvc.rest.codegen.AbstractGenerator;
import org.netbeans.modules.websvc.rest.codegen.Constants;
import org.netbeans.modules.websvc.rest.codegen.RestFacadeMethod;
import org.netbeans.modules.websvc.rest.codegen.RestGenerationOptions;
import org.netbeans.modules.websvc.rest.codegen.model.EntityClassInfo;
import org.netbeans.modules.websvc.rest.codegen.model.EntityResourceBeanModel;
import org.netbeans.modules.websvc.rest.support.JavaSourceHelper;
import org.netbeans.modules.websvc.rest.support.PersistenceHelper;
import org.netbeans.modules.websvc.rest.wizard.Util;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public abstract class EntityResourcesGenerator
extends AbstractGenerator
implements FacadeGenerator {
    public static final String RESOURCE_FOLDER = "service";
    public static final String CONTROLLER_FOLDER = "controller";
    public static final String RESOURCE_SUFFIX = "Resource";
    protected static final String REST_FACADE_SUFFIX = "RESTFacade";
    private PersistenceHelper.PersistenceUnit persistenceUnit;
    private String targetPackageName;
    private FileObject targetFolder;
    private FileObject resourceFolder;
    private String resourcePackageName;
    private FileObject controllerFolder;
    private String controllerPackageName;
    private EntityResourceBeanModel model;
    private Project project;
    private boolean jakartaNamespace;

    public void initialize(EntityResourceBeanModel model, Project project, FileObject targetFolder, String targetPackageName, String resourcePackage, String controllerPackage, PersistenceHelper.PersistenceUnit persistenceUnit) {
        this.model = model;
        this.project = project;
        this.persistenceUnit = persistenceUnit;
        this.targetFolder = targetFolder;
        this.targetPackageName = targetPackageName;
        this.resourcePackageName = resourcePackage == null ? targetPackageName + "." + RESOURCE_FOLDER : resourcePackage;
        this.controllerPackageName = controllerPackage == null ? targetPackageName + "." + CONTROLLER_FOLDER : controllerPackage;
        ClassPath cp = ClassPath.getClassPath((FileObject)targetFolder, (String)"classpath/compile");
        boolean jakartaRSPresent = cp.findResource("jakarta/ws/rs/GET.class") != null;
        boolean javaxRSPresent = cp.findResource("javax/ws/rs/GET.class") != null;
        this.jakartaNamespace = jakartaRSPresent || !javaxRSPresent;
    }

    @Override
    public Set<FileObject> generate(ProgressHandle pHandle) throws IOException {
        if (pHandle != null) {
            this.initProgressReporting(pHandle);
        }
        this.createFolders();
        new PersistenceHelper(this.project).configure(this.model.getBuilder().getAllEntityNames(), !RestUtils.hasJTASupport(this.project));
        this.configurePersistence();
        HashSet<String> fqnEntities = new HashSet<String>();
        for (EntityClassInfo info : this.model.getEntityInfos()) {
            if (fqnEntities.contains(info.getEntityFqn())) continue;
            fqnEntities.add(info.getEntityFqn());
            Util.modifyEntity(info.getEntityFqn(), this.project);
        }
        this.preGenerate(new ArrayList<String>(fqnEntities));
        Util.generateRESTFacades(this.project, fqnEntities, this.model, this.resourceFolder, this.getResourcePackageName(), this);
        this.finishProgressReporting();
        return new HashSet<FileObject>();
    }

    public Set<FileObject> generate(Project project, Map<String, String> entityNames, FileObject targetFolder, String entityFQN, String idClass, String pkg, boolean hasRemote, boolean hasLocal, boolean overrideExisting) throws IOException {
        HashSet<FileObject> createdFiles = new HashSet<FileObject>();
        String entitySimpleName = JavaIdentifiers.unqualify((String)entityFQN);
        String resourceName = entitySimpleName + REST_FACADE_SUFFIX;
        this.reportProgress(resourceName);
        FileObject existingFO = targetFolder.getFileObject(resourceName, "java");
        if (existingFO != null) {
            if (overrideExisting) {
                existingFO.delete();
            } else {
                throw new IOException("file alerady exists exception: " + existingFO);
            }
        }
        FileObject facade = GenerationUtils.createClass((FileObject)targetFolder, (String)(entitySimpleName + REST_FACADE_SUFFIX), null);
        createdFiles.add(facade);
        if (!this.generateInfrastracture(createdFiles, entityFQN, facade)) {
            return createdFiles;
        }
        this.generateResourceMethods(facade, entityFQN, idClass);
        return createdFiles;
    }

    protected List<String> getResourceImports(String entityFqn) {
        LinkedList<String> result = new LinkedList<String>();
        result.add(entityFqn);
        result.add(URI.class.getCanonicalName());
        return result;
    }

    protected boolean generateInfrastracture(Set<FileObject> createdFiles, String entityFqn, FileObject facade) throws IOException {
        Util.generatePrimaryKeyMethod(facade, entityFqn, this.model);
        return true;
    }

    protected void preGenerate(List<String> fqnEntities) throws IOException {
    }

    protected ModifiersTree addRestMethodAnnotations(GenerationUtils genUtils, TreeMaker maker, RestGenerationOptions option, ModifiersTree modifiers) {
        String uriPath;
        String method = option.getRestMethod().getMethod(this.isJakartaNamespace());
        ModifiersTree modifiersTree = modifiers;
        if (method != null) {
            modifiersTree = maker.addModifiersAnnotation(modifiers, genUtils.createAnnotation(method));
        }
        if ((uriPath = option.getRestMethod().getUriPath()) != null) {
            LiteralTree uriValue = maker.Literal((Object)uriPath);
            modifiersTree = maker.addModifiersAnnotation(modifiersTree, genUtils.createAnnotation(this.isJakartaNamespace() ? "jakarta.ws.rs.Path" : "javax.ws.rs.Path", Collections.singletonList(uriValue)));
        }
        if (option.getRestMethod().overrides()) {
            modifiersTree = maker.addModifiersAnnotation(modifiersTree, genUtils.createAnnotation(Override.class.getCanonicalName()));
        }
        modifiersTree = this.addMimeHandlerAnnotation(genUtils, maker, modifiersTree, this.isJakartaNamespace() ? "jakarta.ws.rs.Produces" : "javax.ws.rs.Produces", option.getProduces());
        modifiersTree = this.addMimeHandlerAnnotation(genUtils, maker, modifiersTree, this.isJakartaNamespace() ? "jakarta.ws.rs.Consumes" : "javax.ws.rs.Consumes", option.getConsumes());
        return modifiersTree;
    }

    protected ModifiersTree addResourceAnnotation(String entityFQN, ClassTree classTree, GenerationUtils genUtils, TreeMaker maker) {
        LiteralTree resourcePath = maker.Literal((Object)entityFQN.toLowerCase());
        ModifiersTree modifiersTree = classTree.getModifiers();
        modifiersTree = maker.addModifiersAnnotation(modifiersTree, genUtils.createAnnotation("javax.ws.rs.Path", Collections.singletonList(resourcePath)));
        return modifiersTree;
    }

    protected List<RestGenerationOptions> getRestFacadeMethodOptions(String entityFQN, String idClass) {
        String paramArg;
        String idType = idClass;
        if (Character.class.getCanonicalName().equals(idClass)) {
            paramArg = "id.charAt(0)";
            idType = String.class.getCanonicalName();
        } else {
            paramArg = "id";
        }
        RestFacadeMethod[] methods = RestFacadeMethod.values();
        ArrayList<RestGenerationOptions> result = new ArrayList<RestGenerationOptions>(methods.length);
        for (RestFacadeMethod method : methods) {
            RestGenerationOptions options = this.getGenerationOptions(method, entityFQN, paramArg, idType);
            result.add(options);
        }
        return result;
    }

    protected void generateRestMethod(TypeElement classElement, GenerationUtils genUtils, TreeMaker maker, List<Tree> members, RestGenerationOptions option) {
        ModifiersTree paramModifier = maker.Modifiers(Collections.emptySet());
        ModifiersTree modifiers = option.getRestMethod().getMethod(true) == null ? genUtils.createModifiers(Modifier.PRIVATE) : genUtils.createModifiers(Modifier.PUBLIC);
        ModifiersTree modifiersTree = this.addRestMethodAnnotations(genUtils, maker, option, modifiers);
        List<VariableTree> vars = this.addRestArguments(classElement, genUtils, maker, option, paramModifier);
        PrimitiveTypeTree returnType = option.getReturnType() == null || option.getReturnType().equals("void") ? maker.PrimitiveType(TypeKind.VOID) : genUtils.createType(option.getReturnType(), classElement);
        members.add(maker.Method(modifiersTree, (CharSequence)option.getRestMethod().getMethodName(), (Tree)returnType, Collections.emptyList(), vars, Collections.emptyList(), "{" + option.getBody() + "}", null));
    }

    protected List<VariableTree> addRestArguments(TypeElement classElement, GenerationUtils genUtils, TreeMaker maker, RestGenerationOptions option, ModifiersTree paramModifier) {
        int paramLength;
        ArrayList<VariableTree> vars = new ArrayList<VariableTree>();
        String[] paramNames = option.getParameterNames();
        int n = paramLength = paramNames == null ? 0 : option.getParameterNames().length;
        if (paramLength > 0) {
            String[] paramTypes = option.getParameterTypes();
            String[] pathParams = option.getPathParams();
            for (int i = 0; i < paramLength; ++i) {
                ModifiersTree pathParamTree = paramModifier;
                if (pathParams != null && pathParams[i] != null) {
                    List<LiteralTree> annArguments = Collections.singletonList(maker.Literal((Object)pathParams[i]));
                    pathParamTree = maker.addModifiersAnnotation(paramModifier, genUtils.createAnnotation(this.isJakartaNamespace() ? "jakarta.ws.rs.PathParam" : "javax.ws.rs.PathParam", annArguments));
                }
                Tree paramTree = genUtils.createType(paramTypes[i], classElement);
                VariableTree var = maker.Variable(pathParamTree, (CharSequence)paramNames[i], paramTree, null);
                vars.add(var);
            }
        }
        return vars;
    }

    protected void createFolders(boolean createController) {
        FileObject sourceRootFolder = this.getSourceRootFolder(this.targetFolder, this.targetPackageName);
        File sourceRootDir = FileUtil.toFile((FileObject)sourceRootFolder);
        try {
            String resourceFolderPath = this.toFilePath(this.getResourcePackageName());
            this.resourceFolder = sourceRootFolder.getFileObject(resourceFolderPath);
            if (this.resourceFolder == null) {
                this.resourceFolder = FileUtil.createFolder((File)new File(sourceRootDir, resourceFolderPath));
            }
            if (createController) {
                String controllerFolderPath = this.toFilePath(this.controllerPackageName);
                this.controllerFolder = sourceRootFolder.getFileObject(controllerFolderPath);
                if (this.controllerFolder == null) {
                    this.controllerFolder = FileUtil.createFolder((File)new File(sourceRootDir, controllerFolderPath));
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    protected void configurePersistence() {
    }

    protected RestGenerationOptions getGenerationOptions(RestFacadeMethod method, String entityFQN, String paramArg, String idType) {
        String pathSegmentType;
        String httpResponseType;
        boolean needPathSegment = false;
        EntityClassInfo entityInfo = this.model.getEntityInfo(entityFQN);
        if (entityInfo != null) {
            EntityClassInfo.FieldInfo idFieldInfo = entityInfo.getIdFieldInfo();
            boolean bl = needPathSegment = idFieldInfo != null && idFieldInfo.isEmbeddedId() && idFieldInfo.getType() != null;
        }
        if (this.isJakartaNamespace()) {
            httpResponseType = "jakarta.ws.rs.core.Response";
            pathSegmentType = "jakarta.ws.rs.core.PathSegment";
        } else {
            httpResponseType = "javax.ws.rs.core.Response";
            pathSegmentType = "javax.ws.rs.core.PathSegment";
        }
        RestGenerationOptions options = new RestGenerationOptions();
        switch (method) {
            case CREATE: {
                options.setRestMethod(RestFacadeMethod.CREATE);
                options.setReturnType(httpResponseType);
                options.setParameterNames(new String[]{"entity"});
                options.setParameterTypes(new String[]{entityFQN});
                options.setConsumes(new String[]{Constants.MimeType.XML.value(), Constants.MimeType.JSON.value()});
                return options;
            }
            case EDIT: {
                options.setRestMethod(RestFacadeMethod.EDIT);
                options.setReturnType(httpResponseType);
                options.setParameterNames(new String[]{"entity"});
                options.setParameterTypes(new String[]{entityFQN});
                options.setConsumes(new String[]{Constants.MimeType.XML.value(), Constants.MimeType.JSON.value()});
                return options;
            }
            case REMOVE: {
                options.setRestMethod(RestFacadeMethod.REMOVE);
                options.setReturnType(httpResponseType);
                options.setParameterNames(new String[]{"id"});
                if (needPathSegment) {
                    options.setParameterTypes(new String[]{pathSegmentType});
                } else {
                    options.setParameterTypes(new String[]{idType});
                }
                options.setPathParams(new String[]{"id"});
                return options;
            }
            case FIND: {
                options.setRestMethod(RestFacadeMethod.FIND);
                options.setReturnType(entityFQN);
                options.setProduces(new String[]{Constants.MimeType.XML.value(), Constants.MimeType.JSON.value()});
                options.setParameterNames(new String[]{"id"});
                if (needPathSegment) {
                    options.setParameterTypes(new String[]{pathSegmentType});
                } else {
                    options.setParameterTypes(new String[]{idType});
                }
                options.setPathParams(new String[]{"id"});
                return options;
            }
            case FIND_ALL: {
                options.setRestMethod(RestFacadeMethod.FIND_ALL);
                options.setReturnType(List.class.getCanonicalName() + "<" + entityFQN + ">");
                options.setProduces(new String[]{Constants.MimeType.XML.value(), Constants.MimeType.JSON.value()});
                return options;
            }
            case FIND_RANGE: {
                options.setRestMethod(RestFacadeMethod.FIND_RANGE);
                options.setReturnType(List.class.getCanonicalName() + "<" + entityFQN + ">");
                options.setProduces(new String[]{Constants.MimeType.XML.value(), Constants.MimeType.JSON.value()});
                options.setParameterNames(new String[]{"max", "first"});
                options.setParameterTypes(new String[]{Integer.class.getCanonicalName(), Integer.class.getCanonicalName()});
                options.setPathParams(new String[]{"max", "first"});
                return options;
            }
            case COUNT: {
                options.setRestMethod(RestFacadeMethod.COUNT);
                options.setReturnType(String.class.getCanonicalName());
                options.setProduces(new String[]{Constants.MimeType.TEXT.value()});
                return options;
            }
        }
        return null;
    }

    protected EntityClassInfo getEntityClassInfo(String className) {
        return this.model.getBuilder().getEntityClassInfo(className);
    }

    protected Project getProject() {
        return this.project;
    }

    protected EntityResourceBeanModel getModel() {
        return this.model;
    }

    protected FileObject getTargetFolder() {
        return this.targetFolder;
    }

    protected FileObject getResourceFolder() {
        return this.resourceFolder;
    }

    protected PersistenceHelper.PersistenceUnit getPersistenceUnit() {
        return this.persistenceUnit;
    }

    protected String getResourcePackageName() {
        return this.resourcePackageName;
    }

    protected String getControllerPackageName() {
        return this.controllerPackageName;
    }

    protected FileObject getControllerFolder() {
        return this.controllerFolder;
    }

    protected int getEntitiesCount() {
        return this.getModel().getEntityInfos().size();
    }

    protected String getIdFieldToUriStmt(EntityClassInfo.FieldInfo idField) {
        String getterName = this.getGetterName(idField);
        if (idField.isEmbeddedId()) {
            Collection<EntityClassInfo.FieldInfo> fields = idField.getFieldInfos();
            StringBuilder stmt = new StringBuilder();
            int index = 0;
            for (EntityClassInfo.FieldInfo f : fields) {
                if (index++ > 0) {
                    stmt.append(" + \",\" + ");
                }
                stmt.append("entity.");
                stmt.append(getterName);
                stmt.append("().");
                stmt.append(this.getGetterName(f));
                stmt.append("()");
            }
            return stmt.toString();
        }
        return "entity." + getterName + "()";
    }

    @Override
    protected int getTotalWorkUnits() {
        return this.getEntitiesCount();
    }

    protected void createFolders() {
        this.createFolders(true);
    }

    protected boolean isJakartaNamespace() {
        return this.jakartaNamespace;
    }

    private void generateResourceMethods(FileObject fileObject, final String entityFQN, final String idClass) throws IOException {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        Task<WorkingCopy> task = new Task<WorkingCopy>(){
            final /* synthetic */ EntityResourcesGenerator this$0;
            {
                this.this$0 = this$0;
            }

            public void run(WorkingCopy workingCopy) throws Exception {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                CompilationUnitTree tree = workingCopy.getCompilationUnit();
                ClassTree classTree = (ClassTree)tree.getTypeDecls().get(0);
                TypeElement classElement = (TypeElement)workingCopy.getTrees().getElement(TreePath.getPath(tree, (Tree)classTree));
                List<String> imports = this.this$0.getResourceImports(entityFQN);
                JavaSourceHelper.addImports(workingCopy, imports.toArray(new String[0]));
                GenerationUtils genUtils = GenerationUtils.newInstance((WorkingCopy)workingCopy);
                TreeMaker maker = workingCopy.getTreeMaker();
                ArrayList<Tree> members = new ArrayList<Tree>(classTree.getMembers());
                MethodTree constructor = maker.Constructor(genUtils.createModifiers(Modifier.PUBLIC), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), "{}");
                members.add(constructor);
                List<RestGenerationOptions> restGenerationOptions = this.this$0.getRestFacadeMethodOptions(entityFQN, idClass);
                for (RestGenerationOptions option : restGenerationOptions) {
                    this.this$0.generateRestMethod(classElement, genUtils, maker, members, option);
                }
                ModifiersTree modifiersTree = this.this$0.addResourceAnnotation(entityFQN, classTree, genUtils, maker);
                ArrayList<? extends Tree> implementsClause = new ArrayList<Tree>(classTree.getImplementsClause());
                ClassTree newClassTree = maker.Class(modifiersTree, (CharSequence)classTree.getSimpleName(), classTree.getTypeParameters(), classTree.getExtendsClause(), implementsClause, classTree.getPermitsClause(), members);
                workingCopy.rewrite((Tree)classTree, (Tree)newClassTree);
            }
        };
        javaSource.runModificationTask((Task)task).commit();
    }

    private ModifiersTree addMimeHandlerAnnotation(GenerationUtils genUtils, TreeMaker maker, ModifiersTree modifiersTree, String handlerAnnotation, String[] mimes) {
        ExpressionTree annArguments;
        if (mimes == null) {
            return modifiersTree;
        }
        if (mimes.length == 1) {
            annArguments = this.mimeTypeTree(maker, mimes[0]);
        } else {
            ArrayList<ExpressionTree> mimeTypes = new ArrayList<ExpressionTree>();
            for (int i = 0; i < mimes.length; ++i) {
                mimeTypes.add(this.mimeTypeTree(maker, mimes[i]));
            }
            annArguments = maker.NewArray(null, Collections.emptyList(), mimeTypes);
        }
        return maker.addModifiersAnnotation(modifiersTree, genUtils.createAnnotation(handlerAnnotation, Collections.singletonList(annArguments)));
    }

    private ExpressionTree mimeTypeTree(TreeMaker maker, String mimeType) {
        Constants.MimeType type = Constants.MimeType.find(mimeType);
        ExpressionTree result = type == null ? maker.Literal((Object)mimeType) : type.expressionTree(maker, this.isJakartaNamespace());
        return result;
    }

    private String getGetterName(EntityClassInfo.FieldInfo fieldInfo) {
        return Util.getGetterName(fieldInfo);
    }

    private String toFilePath(String packageName) {
        return packageName.replace('.', '/');
    }

    private FileObject getSourceRootFolder(FileObject packageFolder, String packageName) {
        String[] segments = packageName.split("\\.");
        FileObject ret = packageFolder;
        for (int i = segments.length - 1; i >= 0; --i) {
            String segment = segments[i];
            if (segment.length() == 0) {
                return ret;
            }
            if (ret == null || !segments[i].equals(ret.getNameExt())) {
                throw new IllegalArgumentException("Unmatched folder: " + packageFolder.getPath() + " and package name: " + packageName);
            }
            ret = ret.getParent();
        }
        return ret;
    }
}

