/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.bindings;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.lsp.client.LSPBindings;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.CustomIndexer;
import org.netbeans.modules.parsing.spi.indexing.CustomIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class CustomIndexerImpl
extends CustomIndexer {
    private static final RequestProcessor WORKER = new RequestProcessor(CustomIndexerImpl.class.getName(), 1, false, false);
    private static final String INDEX_FILE_NAME = "index.properties";

    protected void index(Iterable<? extends Indexable> files, Context context) {
        FileObject root = context.getRoot();
        if (root == null) {
            return;
        }
        CustomIndexerImpl.handleStoredFiles(context, props -> {
            for (Indexable i : files) {
                FileObject file = root.getFileObject(i.getRelativePath());
                if (file == null) continue;
                props.setProperty(i.getRelativePath(), FileUtil.getMIMEType((FileObject)file));
            }
            HashSet<Object> mimeTypes = new HashSet<Object>(props.values());
            Project prj = FileOwnerQuery.getOwner((FileObject)root);
            if (prj != null) {
                WORKER.post(() -> {
                    for (String mimeType : mimeTypes) {
                        LSPBindings.ensureServerRunning(prj, mimeType);
                    }
                });
            }
        });
    }

    private static void handleStoredFiles(Context context, Consumer<Properties> handleProperties) {
        Properties props = new Properties();
        FileObject index = context.getIndexFolder().getFileObject(INDEX_FILE_NAME);
        if (index != null) {
            try (InputStream in = index.getInputStream();){
                props.load(in);
            }
            catch (IOException | IllegalArgumentException ex) {
                Logger.getLogger(CustomIndexerImpl.class.getName()).log(Level.WARNING, "can not load '" + String.valueOf(FileUtil.toFile((FileObject)index)) + "', resetting", ex);
            }
        }
        Properties old = (Properties)props.clone();
        handleProperties.accept(props);
        if (!old.equals(props)) {
            try {
                if (index == null) {
                    index = context.getIndexFolder().createData(INDEX_FILE_NAME);
                }
                try (OutputStream out = index.getOutputStream();){
                    props.store(out, "");
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public static final class FactoryImpl
    extends CustomIndexerFactory {
        public CustomIndexer createIndexer() {
            return new CustomIndexerImpl();
        }

        public boolean supportsEmbeddedIndexers() {
            return true;
        }

        public void filesDeleted(Iterable<? extends Indexable> deleted, Context context) {
            CustomIndexerImpl.handleStoredFiles(context, props -> {
                for (Indexable d : deleted) {
                    props.remove(d.getRelativePath());
                }
            });
        }

        public void filesDirty(Iterable<? extends Indexable> dirty, Context context) {
        }

        public String getIndexerName() {
            return "lsp-indexer";
        }

        public int getIndexVersion() {
            return 0;
        }
    }
}

