/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.repository.ui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.indexer.api.ui.ArtifactViewer;
import org.netbeans.modules.maven.indexer.spi.ui.ArtifactViewerFactory;
import org.netbeans.modules.maven.repository.ui.Bundle;
import org.openide.awt.Actions;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;

public class DependencyPanel
extends TopComponent
implements MultiViewElement,
LookupListener {
    private static final Logger LOG = Logger.getLogger(DependencyPanel.class.getName());
    private Lookup.Result<DependencyNode> result;
    private JToolBar toolbar;
    private final ExplorerManager explorerManager;
    private final ExplorerManager treeExplorerManager;
    private final boolean includeToolbar;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JLabel lblHint;
    private JLabel lblList;
    private JLabel lblTree;
    private JScrollPane tvDependencyList;
    private JScrollPane tvTree;

    DependencyPanel(Lookup lookup, boolean includeToolbar) {
        super(lookup);
        this.includeToolbar = includeToolbar;
        this.explorerManager = new ExplorerManager();
        this.treeExplorerManager = new ExplorerManager();
        this.initComponents();
        ((BeanTreeView)this.tvTree).setBorder((Border)UIManager.get("ScrollPane.border"));
        ((BeanTreeView)this.tvDependencyList).setBorder((Border)UIManager.get("ScrollPane.border"));
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            this.setBackground(UIManager.getColor("NbExplorerView.background"));
            this.jPanel1.setBackground(UIManager.getColor("NbExplorerView.background"));
            this.jPanel2.setBackground(UIManager.getColor("NbExplorerView.background"));
            this.jPanel3.setBackground(UIManager.getColor("NbExplorerView.background"));
        }
        ((BeanTreeView)this.tvTree).setRootVisible(false);
        ((BeanTreeView)this.tvDependencyList).setRootVisible(false);
        ((BeanTreeView)this.tvTree).setDefaultActionAllowed(true);
        ((BeanTreeView)this.tvDependencyList).setDefaultActionAllowed(true);
        ((BeanTreeView)this.tvDependencyList).setSelectionMode(1);
        this.explorerManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("selectedNodes".equals(evt.getPropertyName())) {
                    for (Node nd : DependencyPanel.this.explorerManager.getSelectedNodes()) {
                        DependencyNode n = (DependencyNode)nd.getLookup().lookup(DependencyNode.class);
                        if (n == null) continue;
                        Artifact a = n.getArtifact();
                        this.recursCollapse(DependencyPanel.this.treeExplorerManager.getRootContext().getChildren().getNodes(), (BeanTreeView)DependencyPanel.this.tvTree);
                        Set<Node> selectedNodes = this.recurse(a, DependencyPanel.this.treeExplorerManager.getRootContext(), (BeanTreeView)DependencyPanel.this.tvTree);
                        try {
                            DependencyPanel.this.treeExplorerManager.setSelectedNodes(selectedNodes.toArray(new Node[0]));
                        }
                        catch (PropertyVetoException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
            }

            private Set<Node> recurse(Artifact a, Node rootContext, BeanTreeView btv) {
                HashSet<Node> toRet = new HashSet<Node>();
                for (Node nd : rootContext.getChildren().getNodes(true)) {
                    DependencyNode n = (DependencyNode)nd.getLookup().lookup(DependencyNode.class);
                    if (n != null && (n.getArtifact().equals((Object)a) || n.getRelatedArtifact() != null && n.getRelatedArtifact().equals((Object)a))) {
                        btv.expandNode(rootContext);
                        toRet.add(nd);
                    }
                    toRet.addAll(this.recurse(a, nd, btv));
                }
                return toRet;
            }

            private void recursCollapse(Node[] nodes, BeanTreeView btv) {
                for (Node nn : nodes) {
                    this.recursCollapse(nn.getChildren().getNodes(true), btv);
                    ((BeanTreeView)DependencyPanel.this.tvTree).collapseNode(nn);
                }
            }
        });
    }

    public static MultiViewElement forPOM(Lookup editor) {
        class L
        extends ProxyLookup
        implements PropertyChangeListener {
            Project p;
            final /* synthetic */ Lookup val$editor;

            L(Lookup lookup) {
                this.val$editor = lookup;
                FileObject pom = (FileObject)lookup.lookup(FileObject.class);
                if (pom != null) {
                    this.p = FileOwnerQuery.getOwner((FileObject)pom);
                    if (this.p != null) {
                        NbMavenProject nbmp = (NbMavenProject)this.p.getLookup().lookup(NbMavenProject.class);
                        if (nbmp != null) {
                            nbmp.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)nbmp));
                            this.reset();
                        } else {
                            LOG.log(Level.WARNING, "not a Maven project: {0}", this.p);
                        }
                    } else {
                        LOG.log(Level.WARNING, "no owner of {0}", pom);
                    }
                } else {
                    LOG.log(Level.WARNING, "no FileObject in {0}", lookup);
                }
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("MavenProject".equals(evt.getPropertyName())) {
                    this.reset();
                }
            }

            private void reset() {
                ArtifactViewerFactory avf = (ArtifactViewerFactory)Lookup.getDefault().lookup(ArtifactViewerFactory.class);
                if (avf != null) {
                    Lookup l = avf.createLookup(this.p);
                    if (l != null) {
                        this.setLookups(new Lookup[]{l});
                    } else {
                        LOG.log(Level.WARNING, "no artifact lookup for {0}", this.p);
                    }
                } else {
                    LOG.warning("no ArtifactViewerFactory found");
                }
            }
        }
        return new DependencyPanel((Lookup)new L(editor), false);
    }

    public int getPersistenceType() {
        return 2;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.lblList = new JLabel();
        this.lblTree = new JLabel();
        this.lblHint = new JLabel();
        this.jPanel2 = new ExplorerPanel(this.treeExplorerManager);
        this.tvTree = new BeanTreeView();
        this.jPanel3 = new ExplorerPanel(this.explorerManager);
        this.tvDependencyList = new BeanTreeView();
        this.setFocusable(true);
        this.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((JLabel)this.lblList, (String)NbBundle.getMessage(DependencyPanel.class, (String)"DependencyPanel.lblList.text"));
        Mnemonics.setLocalizedText((JLabel)this.lblTree, (String)NbBundle.getMessage(DependencyPanel.class, (String)"DependencyPanel.lblTree.text"));
        this.lblHint.setText(NbBundle.getMessage(DependencyPanel.class, (String)"DependencyPanel.lblHint.text"));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.tvTree).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.tvTree, -1, 226, Short.MAX_VALUE).addContainerGap()));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.tvDependencyList).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.tvDependencyList).addContainerGap()));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.lblList).addGap(0, 43, Short.MAX_VALUE)).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.lblTree).addGap(0, 134, Short.MAX_VALUE)).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addContainerGap()).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.lblHint, -1, 455, Short.MAX_VALUE).addContainerGap())));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblTree).addComponent(this.lblList)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE)).addGap(34, 34, 34)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap(278, Short.MAX_VALUE).addComponent(this.lblHint).addContainerGap())));
        this.add(this.jPanel1, "Center");
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DependencyPanel.class, (String)"DependencyPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DependencyPanel.class, (String)"DependencyPanel.AccessibleContext.accessibleDescription"));
    }

    public JComponent getVisualRepresentation() {
        return this;
    }

    public JComponent getToolbarRepresentation() {
        if (this.toolbar == null) {
            this.toolbar = new JToolBar();
            if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
                this.toolbar.setBackground(UIManager.getColor("NbExplorerView.background"));
            }
            this.toolbar.setFloatable(false);
            if (this.includeToolbar) {
                Action[] a = new Action[1];
                Action[] actions = (Action[])this.getLookup().lookup(a.getClass());
                Dimension space = new Dimension(3, 0);
                this.toolbar.addSeparator(space);
                for (Action act : actions) {
                    JButton btn = new JButton();
                    Actions.connect((AbstractButton)btn, (Action)act);
                    this.toolbar.add(btn);
                    this.toolbar.addSeparator(space);
                }
            }
        }
        return this.toolbar;
    }

    public void componentOpened() {
        super.componentOpened();
        this.result = this.getLookup().lookupResult(DependencyNode.class);
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                DependencyPanel.this.populateFields();
            }
        });
        this.result.addLookupListener((LookupListener)this);
    }

    public void componentClosed() {
        super.componentClosed();
        this.result.removeLookupListener((LookupListener)this);
    }

    public void componentShowing() {
        super.componentShowing();
    }

    public void componentHidden() {
        super.componentHidden();
    }

    public void componentActivated() {
        super.componentActivated();
    }

    public void componentDeactivated() {
        super.componentDeactivated();
    }

    public void setMultiViewCallback(MultiViewElementCallback callback) {
    }

    public CloseOperationState canCloseElement() {
        return CloseOperationState.STATE_OK;
    }

    private void populateFields() {
        Iterator iter = this.result.allInstances().iterator();
        if (iter.hasNext()) {
            final DependencyNode root = (DependencyNode)iter.next();
            SwingUtilities.invokeLater(new Runnable(){
                final /* synthetic */ DependencyPanel this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    NodeVisitor vis = new NodeVisitor(Arrays.asList("compile", "provided", "runtime", "test"));
                    root.accept((DependencyNodeVisitor)vis);
                    vis.getListOfDependencies();
                    this.this$0.explorerManager.setRootContext((Node)new AbstractNode(DependencyPanel.createListChildren(vis.getListOfDependencies(), this.this$0.getLookup())));
                    this.this$0.treeExplorerManager.setRootContext((Node)new AbstractNode(DependencyPanel.createTreeChildren(root, this.this$0.getLookup())));
                    ((BeanTreeView)this.this$0.tvTree).expandAll();
                }
            });
        }
    }

    public void resultChanged(LookupEvent ev) {
        this.populateFields();
    }

    private static String calculateStateTipPart(DependencyNode node) {
        int s = node.getState();
        if (s == 0) {
            return Bundle.TIP_Included();
        }
        if (s == 2) {
            return Bundle.TIP_Conflict(node.getRelatedArtifact().getVersion());
        }
        if (s == 1) {
            return Bundle.TIP_Duplicate();
        }
        if (s == 3) {
            return Bundle.TIP_Cycle();
        }
        throw new IllegalStateException("illegal state:" + s);
    }

    private static Children createTreeChildren(final DependencyNode dn, final Lookup tcLookup) {
        if (!dn.hasChildren()) {
            return Children.LEAF;
        }
        return Children.create((ChildFactory)new ChildFactory<DependencyNode>(){

            protected Node createNodeForKey(DependencyNode key) {
                return new TreeNode(key, tcLookup);
            }

            protected boolean createKeys(List<DependencyNode> toPopulate) {
                toPopulate.addAll(dn.getChildren());
                return true;
            }
        }, (boolean)false);
    }

    private static Children createListChildren(final Collection<DependencyNode> dns, final Lookup tcLookup) {
        return Children.create((ChildFactory)new ChildFactory<DependencyNode>(){

            protected Node createNodeForKey(DependencyNode key) {
                return new ListNode(key, tcLookup);
            }

            protected boolean createKeys(List<DependencyNode> toPopulate) {
                toPopulate.addAll(dns);
                return true;
            }
        }, (boolean)false);
    }

    private class ExplorerPanel
    extends JPanel
    implements ExplorerManager.Provider {
        private final ExplorerManager manager;

        public ExplorerPanel(ExplorerManager manager) {
            this.manager = manager;
        }

        public ExplorerManager getExplorerManager() {
            return this.manager;
        }
    }

    private static class OpenAction
    extends AbstractAction {
        private final DependencyNode dependencyNode;
        private final Lookup lkp;

        public OpenAction(DependencyNode dn, Lookup lkp) {
            this.dependencyNode = dn;
            this.lkp = lkp;
            this.putValue("Name", Bundle.ACT_Open());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MavenProject prj;
            if (this.dependencyNode != null && (prj = (MavenProject)this.lkp.lookup(MavenProject.class)) != null) {
                ArtifactViewer.showArtifactViewer((Artifact)this.dependencyNode.getArtifact(), (List)prj.getRemoteArtifactRepositories(), (String)"dep");
            }
        }
    }

    private static class ListNode
    extends AbstractNode {
        private final DependencyNode node;
        private final Lookup tcLookup;

        public ListNode(DependencyNode node, Lookup tcLookup) {
            super(Children.LEAF, Lookups.fixed((Object[])new Object[]{node}));
            this.tcLookup = tcLookup;
            this.node = node;
            Artifact artifact = node.getArtifact();
            this.setName(artifact.getId());
            this.setDisplayName(artifact.getArtifactId() + "-" + artifact.getVersion() + "." + artifact.getArtifactHandler().getExtension());
            if (node.getDepth() > 1) {
                this.setIconBaseWithExtension("org/netbeans/modules/maven/TransitiveDependencyIcon.png");
            } else {
                this.setIconBaseWithExtension("org/netbeans/modules/maven/spi/nodes/DependencyJar.gif");
            }
            this.setShortDescription(Bundle.TIP_listNode(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), DependencyPanel.calculateStateTipPart(node)));
        }

        public Action getPreferredAction() {
            return new OpenAction(this.node, this.tcLookup);
        }

        public Action[] getActions(boolean context) {
            return new Action[]{new OpenAction(this.node, this.tcLookup)};
        }
    }

    private static class TreeNode
    extends AbstractNode {
        private final DependencyNode node;
        private final Lookup tcLookup;

        public TreeNode(DependencyNode node, Lookup tcLookup) {
            super(DependencyPanel.createTreeChildren(node, tcLookup), Lookups.fixed((Object[])new Object[]{node}));
            this.tcLookup = tcLookup;
            Artifact artifact = node.getArtifact();
            this.setName(artifact.getId());
            this.node = node;
            this.setDisplayName(artifact.getArtifactId() + "-" + artifact.getVersion() + "." + artifact.getArtifactHandler().getExtension());
            if (node.getDepth() > 1) {
                this.setIconBaseWithExtension("org/netbeans/modules/maven/TransitiveDependencyIcon.png");
            } else {
                this.setIconBaseWithExtension("org/netbeans/modules/maven/spi/nodes/DependencyJar.gif");
            }
            this.setShortDescription(Bundle.TIP_listNode(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), DependencyPanel.calculateStateTipPart(node)));
        }

        public String getHtmlDisplayName() {
            if (this.node.getState() == 1) {
                return "<html><s>" + this.getDisplayName() + "</s></html>";
            }
            if (this.node.getState() == 2) {
                return "<html><font color=\"!nb.errorForeground\"><s>" + this.getDisplayName() + "</s></font></html>";
            }
            return super.getHtmlDisplayName();
        }

        public Action getPreferredAction() {
            return new OpenAction(this.node, this.tcLookup);
        }

        public Action[] getActions(boolean context) {
            return new Action[]{new OpenAction(this.node, this.tcLookup)};
        }
    }

    private static class NodeVisitor
    implements DependencyNodeVisitor {
        private List<DependencyNode> lst;
        private final List<String> scopes;
        private DependencyNode root;

        private NodeVisitor(List<String> scopes) {
            this.scopes = scopes;
        }

        public boolean visit(DependencyNode node) {
            if (this.root == null) {
                this.root = node;
                this.lst = new ArrayList<DependencyNode>();
            }
            for (DependencyNode ch : node.getChildren()) {
                if (ch.getState() != 0 || !this.scopes.contains(ch.getArtifact().getScope())) continue;
                this.lst.add(ch);
            }
            return true;
        }

        public boolean endVisit(DependencyNode node) {
            if (this.root == node) {
                this.root = null;
                return true;
            }
            return true;
        }

        private Collection<DependencyNode> getListOfDependencies() {
            return this.lst;
        }
    }
}

