/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.axi.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.xml.axi.AXIModel;
import org.netbeans.modules.xml.axi.datatype.BinaryBase;
import org.netbeans.modules.xml.axi.datatype.CustomDatatype;
import org.netbeans.modules.xml.axi.datatype.Datatype;
import org.netbeans.modules.xml.axi.datatype.DatatypeFactory;
import org.netbeans.modules.xml.axi.datatype.NotationType;
import org.netbeans.modules.xml.axi.datatype.NumberBase;
import org.netbeans.modules.xml.axi.datatype.QNameType;
import org.netbeans.modules.xml.axi.datatype.StringBase;
import org.netbeans.modules.xml.axi.datatype.TimeBase;
import org.netbeans.modules.xml.axi.datatype.UnionType;
import org.netbeans.modules.xml.axi.impl.AXIModelImpl;
import org.netbeans.modules.xml.schema.model.AttributeReference;
import org.netbeans.modules.xml.schema.model.ElementReference;
import org.netbeans.modules.xml.schema.model.Enumeration;
import org.netbeans.modules.xml.schema.model.FractionDigits;
import org.netbeans.modules.xml.schema.model.GlobalAttribute;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalSimpleType;
import org.netbeans.modules.xml.schema.model.Length;
import org.netbeans.modules.xml.schema.model.LocalAttribute;
import org.netbeans.modules.xml.schema.model.LocalElement;
import org.netbeans.modules.xml.schema.model.LocalSimpleType;
import org.netbeans.modules.xml.schema.model.MaxExclusive;
import org.netbeans.modules.xml.schema.model.MaxInclusive;
import org.netbeans.modules.xml.schema.model.MaxLength;
import org.netbeans.modules.xml.schema.model.MinExclusive;
import org.netbeans.modules.xml.schema.model.MinInclusive;
import org.netbeans.modules.xml.schema.model.MinLength;
import org.netbeans.modules.xml.schema.model.Pattern;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SimpleRestriction;
import org.netbeans.modules.xml.schema.model.SimpleType;
import org.netbeans.modules.xml.schema.model.SimpleTypeDefinition;
import org.netbeans.modules.xml.schema.model.SimpleTypeRestriction;
import org.netbeans.modules.xml.schema.model.TotalDigits;
import org.netbeans.modules.xml.schema.model.Union;
import org.netbeans.modules.xml.schema.model.Whitespace;
import org.netbeans.modules.xml.schema.model.visitor.DeepSchemaVisitor;
import org.netbeans.modules.xml.schema.model.visitor.SchemaVisitor;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;

public class DatatypeBuilder
extends DeepSchemaVisitor {
    private Datatype datatype;
    private SimpleRestriction facetParent;
    AXIModelImpl model;

    DatatypeBuilder() {
    }

    public DatatypeBuilder(AXIModel model) {
        this.model = (AXIModelImpl)model;
    }

    public void visit(Enumeration enumeration) {
        assert (this.facetParent instanceof SimpleRestriction);
        if (this.datatype instanceof NumberBase) {
            ((NumberBase)this.datatype).addEnumeration(NumberBase.toNumber(enumeration.getValue()));
        } else if (this.datatype instanceof BinaryBase) {
            ((BinaryBase)this.datatype).addEnumeration(enumeration.getValue());
        } else if (this.datatype instanceof NotationType) {
            ((NotationType)this.datatype).addEnumeration(enumeration.getValue());
        } else if (this.datatype instanceof QNameType) {
            ((QNameType)this.datatype).addEnumeration(enumeration.getValue());
        } else if (this.datatype instanceof StringBase) {
            ((StringBase)this.datatype).addEnumeration(enumeration.getValue());
        } else if (this.datatype instanceof TimeBase) {
            ((TimeBase)this.datatype).addEnumeration(enumeration.getValue());
        }
    }

    public void visit(FractionDigits fractionDigits) {
        assert (this.facetParent instanceof SimpleRestriction);
        ArrayList<Number> removeList = new ArrayList<Number>();
        List<? extends Number> currentList = this.datatype.getFractionDigits();
        if (currentList != null && currentList.size() > 0) {
            int i;
            for (i = 0; i < currentList.size(); ++i) {
                removeList.add(currentList.get(i));
            }
            for (i = 0; i < removeList.size(); ++i) {
                this.datatype.removeFractionDigits((Number)removeList.get(i));
            }
        }
        this.datatype.addFractionDigits(fractionDigits.getValue());
    }

    public void visit(Length length) {
        assert (this.facetParent instanceof SimpleRestriction);
        ArrayList<Number> removeList = new ArrayList<Number>();
        List<? extends Number> currentList = this.datatype.getLengths();
        if (currentList != null && currentList.size() > 0) {
            int i;
            for (i = 0; i < currentList.size(); ++i) {
                removeList.add(currentList.get(i));
            }
            for (i = 0; i < removeList.size(); ++i) {
                this.datatype.removeLength((Number)removeList.get(i));
            }
        }
        this.datatype.addLength(length.getValue());
    }

    public void visit(MaxExclusive maxExclusive) {
        assert (this.facetParent instanceof SimpleRestriction);
        if (this.datatype instanceof NumberBase) {
            ArrayList<Number> removeList = new ArrayList<Number>();
            List<Number> currentList = ((NumberBase)this.datatype).getMaxExclusives();
            if (currentList != null && currentList.size() > 0) {
                int i;
                for (i = 0; i < currentList.size(); ++i) {
                    removeList.add(currentList.get(i));
                }
                for (i = 0; i < removeList.size(); ++i) {
                    ((NumberBase)this.datatype).removeMaxExclusive((Number)removeList.get(i));
                }
            }
            ((NumberBase)this.datatype).addMaxExclusive(NumberBase.toNumber(maxExclusive.getValue()));
        } else if (this.datatype instanceof TimeBase) {
            ArrayList<String> removeList = new ArrayList<String>();
            List<String> currentList = ((TimeBase)this.datatype).getMaxExclusives();
            if (currentList != null && currentList.size() > 0) {
                int i;
                for (i = 0; i < currentList.size(); ++i) {
                    removeList.add(currentList.get(i));
                }
                for (i = 0; i < removeList.size(); ++i) {
                    ((TimeBase)this.datatype).removeMaxExclusive((String)removeList.get(i));
                }
            }
            ((TimeBase)this.datatype).addMaxExclusive(maxExclusive.getValue());
        }
    }

    public void visit(MaxInclusive maxInclusive) {
        assert (this.facetParent instanceof SimpleRestriction);
        if (this.datatype instanceof NumberBase) {
            ArrayList<Number> removeList = new ArrayList<Number>();
            List<Number> currentList = ((NumberBase)this.datatype).getMaxInclusives();
            if (currentList != null && currentList.size() > 0) {
                int i;
                for (i = 0; i < currentList.size(); ++i) {
                    removeList.add(currentList.get(i));
                }
                for (i = 0; i < removeList.size(); ++i) {
                    ((NumberBase)this.datatype).removeMaxInclusive((Number)removeList.get(i));
                }
            }
            ((NumberBase)this.datatype).addMaxInclusive(NumberBase.toNumber(maxInclusive.getValue()));
        } else if (this.datatype instanceof TimeBase) {
            ArrayList<String> removeList = new ArrayList<String>();
            List<String> currentList = ((TimeBase)this.datatype).getMaxInclusives();
            if (currentList != null && currentList.size() > 0) {
                int i;
                for (i = 0; i < currentList.size(); ++i) {
                    removeList.add(currentList.get(i));
                }
                for (i = 0; i < removeList.size(); ++i) {
                    ((TimeBase)this.datatype).removeMaxInclusive((String)removeList.get(i));
                }
            }
            ((TimeBase)this.datatype).addMaxInclusive(maxInclusive.getValue());
        }
    }

    public void visit(MinExclusive minExclusive) {
        assert (this.facetParent instanceof SimpleRestriction);
        if (this.datatype instanceof NumberBase) {
            ArrayList<Number> removeList = new ArrayList<Number>();
            List<Number> currentList = ((NumberBase)this.datatype).getMinExclusives();
            if (currentList != null && currentList.size() > 0) {
                int i;
                for (i = 0; i < currentList.size(); ++i) {
                    removeList.add(currentList.get(i));
                }
                for (i = 0; i < removeList.size(); ++i) {
                    ((NumberBase)this.datatype).removeMinExclusive((Number)removeList.get(i));
                }
            }
            ((NumberBase)this.datatype).addMinExclusive(NumberBase.toNumber(minExclusive.getValue()));
        } else if (this.datatype instanceof TimeBase) {
            ArrayList<String> removeList = new ArrayList<String>();
            List<String> currentList = ((TimeBase)this.datatype).getMinExclusives();
            if (currentList != null && currentList.size() > 0) {
                int i;
                for (i = 0; i < currentList.size(); ++i) {
                    removeList.add(currentList.get(i));
                }
                for (i = 0; i < removeList.size(); ++i) {
                    ((TimeBase)this.datatype).removeMinExclusive((String)removeList.get(i));
                }
            }
            ((TimeBase)this.datatype).addMinExclusive(minExclusive.getValue());
        }
    }

    public void visit(MinInclusive minInclusive) {
        assert (this.facetParent instanceof SimpleRestriction);
        if (this.datatype instanceof NumberBase) {
            ArrayList<Number> removeList = new ArrayList<Number>();
            List<Number> currentList = ((NumberBase)this.datatype).getMinInclusives();
            if (currentList != null && currentList.size() > 0) {
                int i;
                for (i = 0; i < currentList.size(); ++i) {
                    removeList.add(currentList.get(i));
                }
                for (i = 0; i < removeList.size(); ++i) {
                    ((NumberBase)this.datatype).removeMinInclusive((Number)removeList.get(i));
                }
            }
            ((NumberBase)this.datatype).addMinInclusive(NumberBase.toNumber(minInclusive.getValue()));
        } else if (this.datatype instanceof TimeBase) {
            ArrayList<String> removeList = new ArrayList<String>();
            List<String> currentList = ((TimeBase)this.datatype).getMinInclusives();
            if (currentList != null && currentList.size() > 0) {
                int i;
                for (i = 0; i < currentList.size(); ++i) {
                    removeList.add(currentList.get(i));
                }
                for (i = 0; i < removeList.size(); ++i) {
                    ((TimeBase)this.datatype).removeMinInclusive((String)removeList.get(i));
                }
            }
            ((TimeBase)this.datatype).addMinInclusive(minInclusive.getValue());
        }
    }

    public void visit(MaxLength maxLength) {
        assert (this.facetParent instanceof SimpleRestriction);
        ArrayList<Number> removeList = new ArrayList<Number>();
        List<? extends Number> currentList = this.datatype.getMaxLengths();
        if (currentList != null && currentList.size() > 0) {
            int i;
            for (i = 0; i < currentList.size(); ++i) {
                removeList.add(currentList.get(i));
            }
            for (i = 0; i < removeList.size(); ++i) {
                this.datatype.removeMaxLength((Number)removeList.get(i));
            }
        }
        this.datatype.addMaxLength(maxLength.getValue());
    }

    public void visit(MinLength minLength) {
        assert (this.facetParent instanceof SimpleRestriction);
        ArrayList<Number> removeList = new ArrayList<Number>();
        List<? extends Number> currentList = this.datatype.getMinLengths();
        if (currentList != null && currentList.size() > 0) {
            int i;
            for (i = 0; i < currentList.size(); ++i) {
                removeList.add(currentList.get(i));
            }
            for (i = 0; i < removeList.size(); ++i) {
                this.datatype.removeMinLength((Number)removeList.get(i));
            }
        }
        this.datatype.addMinLength(minLength.getValue());
    }

    public void visit(Pattern pattern) {
        assert (this.facetParent instanceof SimpleRestriction);
        this.datatype.addPattern(pattern.getValue());
    }

    public void visit(TotalDigits totalDigits) {
        assert (this.facetParent instanceof SimpleRestriction);
        ArrayList<Number> removeList = new ArrayList<Number>();
        List<? extends Number> currentList = this.datatype.getTotalDigits();
        if (currentList != null && currentList.size() > 0) {
            int i;
            for (i = 0; i < currentList.size(); ++i) {
                removeList.add(currentList.get(i));
            }
            for (i = 0; i < removeList.size(); ++i) {
                this.datatype.removeTotalDigits((Number)removeList.get(i));
            }
        }
        this.datatype.addTotalDigits(totalDigits.getValue());
    }

    public void visit(Whitespace facet) {
        assert (this.facetParent instanceof SimpleRestriction);
        ArrayList<Whitespace.Treatment> removeList = new ArrayList<Whitespace.Treatment>();
        List<Whitespace.Treatment> currentList = this.datatype.getWhiteSpaces();
        if (currentList != null && currentList.size() > 0) {
            int i;
            for (i = 0; i < currentList.size(); ++i) {
                removeList.add(currentList.get(i));
            }
            for (i = 0; i < removeList.size(); ++i) {
                this.datatype.removeWhitespace((Whitespace.Treatment)removeList.get(i));
            }
        }
        this.datatype.addWhitespace(facet.getValue());
    }

    Datatype getDatatype(SchemaComponent component) {
        if (component instanceof LocalAttribute) {
            return this.createDatatype((LocalAttribute)component);
        }
        if (component instanceof GlobalAttribute) {
            return this.createDatatype((GlobalAttribute)component);
        }
        if (component instanceof AttributeReference) {
            return this.createDatatype((GlobalAttribute)((AttributeReference)component).getRef().get());
        }
        if (component instanceof LocalElement) {
            return this.createDatatype((LocalElement)component);
        }
        if (component instanceof GlobalElement) {
            return this.createDatatype((GlobalElement)component);
        }
        if (component instanceof ElementReference) {
            return this.createDatatype((GlobalElement)((ElementReference)component).getRef().get());
        }
        if (component instanceof GlobalSimpleType) {
            return new CustomDatatype(((GlobalSimpleType)component).getName(), this.createDatatype((SimpleType)component));
        }
        return null;
    }

    Datatype getDatatype(SimpleType st) {
        return this.createDatatype(st);
    }

    Datatype createDatatype(LocalAttribute attribute) {
        this.datatype = attribute.getType() != null ? this.createDatatype((SimpleType)attribute.getType().get()) : this.createDatatype((SimpleType)attribute.getInlineType());
        return this.datatype;
    }

    Datatype createDatatype(GlobalAttribute attribute) {
        this.datatype = attribute.getType() != null ? this.createDatatype((SimpleType)attribute.getType().get()) : this.createDatatype((SimpleType)attribute.getInlineType());
        return this.datatype;
    }

    Datatype createDatatype(LocalElement le) {
        if (le.getType() != null) {
            if (le.getType().get() instanceof SimpleType) {
                this.datatype = this.createDatatype((SimpleType)le.getType().get());
            }
        } else if (le.getInlineType() instanceof SimpleType) {
            this.datatype = this.createDatatype((SimpleType)le.getInlineType());
        }
        return this.datatype;
    }

    Datatype createDatatype(GlobalElement ge) {
        if (ge.getType() != null) {
            if (ge.getType().get() instanceof SimpleType) {
                this.datatype = this.createDatatype((SimpleType)ge.getType().get());
            }
        } else if (ge.getInlineType() instanceof SimpleType) {
            this.datatype = this.createDatatype((SimpleType)ge.getInlineType());
        }
        return this.datatype;
    }

    Datatype createDatatype(SimpleType simpleType) {
        this.datatype = null;
        try {
            this.datatype = this.doCreateDatatype(simpleType);
            if (simpleType instanceof GlobalSimpleType && this.model != null) {
                String name = ((GlobalSimpleType)simpleType).getName();
                for (GlobalSimpleType gst : this.model.getSchemaModel().getSchema().getSimpleTypes()) {
                    if (!gst.getName().equals(name)) continue;
                    return new CustomDatatype(name, this.datatype);
                }
            }
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
        return this.datatype;
    }

    Datatype doCreateDatatype(SimpleType simpleType) {
        if (simpleType == null) {
            return null;
        }
        if (simpleType instanceof GlobalSimpleType) {
            this.datatype = DatatypeFactory.getDefault().createPrimitive(((GlobalSimpleType)simpleType).getName());
        }
        if (this.datatype == null) {
            SimpleTypeDefinition def = simpleType.getDefinition();
            if (def instanceof SimpleTypeRestriction) {
                GlobalSimpleType baseType = null;
                if (((SimpleTypeRestriction)def).getBase() != null) {
                    SimpleRestriction r;
                    baseType = (GlobalSimpleType)((SimpleTypeRestriction)def).getBase().get();
                    this.datatype = this.doCreateDatatype((SimpleType)baseType);
                    this.facetParent = r = (SimpleRestriction)def;
                    this.findFacets(r);
                    Collection enums = ((SimpleTypeRestriction)def).getEnumerations();
                    for (Enumeration e : enums) {
                        this.datatype.addEnumeration(e.getValue());
                    }
                } else {
                    this.datatype = this.doCreateDatatype((SimpleType)((SimpleTypeRestriction)def).getInlineType());
                }
            } else if (def instanceof org.netbeans.modules.xml.schema.model.List) {
                org.netbeans.modules.xml.schema.model.List l = (org.netbeans.modules.xml.schema.model.List)def;
                this.datatype = l.getType() != null ? this.doCreateDatatype((SimpleType)l.getType().get()) : this.doCreateDatatype((SimpleType)l.getInlineType());
            } else if (def instanceof Union) {
                Datatype memberType;
                Union u = (Union)def;
                UnionType unionType = new UnionType();
                if (u.getMemberTypes() != null) {
                    for (NamedComponentReference gst : u.getMemberTypes()) {
                        memberType = this.doCreateDatatype((SimpleType)gst.get());
                        if (memberType == null) continue;
                        unionType.addMemberType(memberType);
                    }
                }
                if (u.getInlineTypes() != null) {
                    for (LocalSimpleType lst : u.getInlineTypes()) {
                        this.datatype = null;
                        memberType = this.doCreateDatatype((SimpleType)lst);
                        if (memberType == null) continue;
                        unionType.addMemberType(memberType);
                    }
                    if (u.getInlineTypes().size() > 0) {
                        unionType.setHasFacets(true);
                    }
                }
                return unionType;
            }
        }
        return this.datatype;
    }

    void findFacets(SimpleRestriction r) {
        this.findFacets(r.getEnumerations());
        this.findFacets(r.getFractionDigits());
        this.findFacets(r.getLengths());
        this.findFacets(r.getMaxExclusives());
        this.findFacets(r.getMaxInclusives());
        this.findFacets(r.getMaxLengths());
        this.findFacets(r.getMinExclusives());
        this.findFacets(r.getMinInclusives());
        this.findFacets(r.getMinLengths());
        this.findFacets(r.getPatterns());
        this.findFacets(r.getTotalDigits());
        this.findFacets(r.getWhitespaces());
    }

    Datatype findPrimitive(Schema schema, String typeName) {
        Collection gsts = schema.getSimpleTypes();
        for (GlobalSimpleType gst : gsts) {
            if (!gst.getName().equals(typeName)) continue;
            return this.createDatatype((SimpleType)gst);
        }
        return null;
    }

    void findFacets(Collection<? extends SchemaComponent> facets) {
        for (SchemaComponent schemaComponent : facets) {
            schemaComponent.accept((SchemaVisitor)this);
        }
    }

    Datatype getDatatype() {
        return this.datatype;
    }
}

