/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.deadlock.detector;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.deadlock.detector.Bundle;
import org.openide.util.Exceptions;

class Detector
implements Runnable {
    private static final Logger LOG = Logger.getLogger(Detector.class.getName());
    private boolean running = true;
    private static long PAUSE = 2000L;
    private static long INITIAL_PAUSE = 10000L;
    private static final String INDENT = "    ";
    private final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();

    Detector() {
        Integer initialPauseFromSysProp;
        Integer pauseFromSysProp = Integer.getInteger("org.netbeans.modules.deadlock.detector.Detector.PAUSE");
        if (pauseFromSysProp != null) {
            PAUSE = pauseFromSysProp.longValue();
        }
        if ((initialPauseFromSysProp = Integer.getInteger("org.netbeans.modules.deadlock.detector.Detector.INITIAL_PAUSE")) != null) {
            INITIAL_PAUSE = initialPauseFromSysProp.longValue();
        }
    }

    void start() {
        if (this.threadMXBean == null) {
            return;
        }
        Thread t = new Thread((Runnable)this, "Deadlock Detector");
        t.start();
    }

    synchronized void stop() {
        this.running = false;
    }

    private synchronized boolean isRunning() {
        return this.running;
    }

    @Override
    public void run() {
        try {
            Thread.sleep(INITIAL_PAUSE);
            while (this.isRunning()) {
                long time = System.currentTimeMillis();
                this.detectDeadlock();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "Deadlock detection took: {0} ms.", System.currentTimeMillis() - time);
                }
                if (!this.isRunning()) continue;
                Thread.sleep(PAUSE);
            }
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void detectDeadlock() {
        ThreadInfo[] infos;
        ThreadInfo[] deadlocked;
        PrintStream out;
        if (this.threadMXBean == null) {
            return;
        }
        long[] tids = this.threadMXBean.findDeadlockedThreads();
        if (tids == null) {
            return;
        }
        this.stop();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Deadlock detected");
        }
        File file = null;
        try {
            file = Files.createTempFile("deadlock", ".txt", new FileAttribute[0]).toFile();
            out = new PrintStream(new FileOutputStream(file));
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Temporrary file created: {0}", file);
            }
        }
        catch (IOException iOException) {
            out = System.out;
        }
        out.println("Deadlocked threads :");
        for (ThreadInfo ti : deadlocked = this.threadMXBean.getThreadInfo(tids, true, true)) {
            this.printThreadInfo(ti, out);
            this.printMonitorInfo(ti, out);
            this.printLockInfo(ti.getLockedSynchronizers(), out);
            out.println();
        }
        out.println("All threads :");
        for (ThreadInfo ti : infos = this.threadMXBean.dumpAllThreads(true, true)) {
            if (ti == null) continue;
            this.printThreadInfo(ti, out);
            this.printMonitorInfo(ti, out);
            this.printLockInfo(ti.getLockedSynchronizers(), out);
            out.println();
        }
        if (out != System.out) {
            out.close();
        }
        this.reportStackTrace(deadlocked, file);
    }

    private void printThreadInfo(ThreadInfo ti, PrintStream out) {
        this.printThread(ti, out);
        StackTraceElement[] stacktrace = ti.getStackTrace();
        MonitorInfo[] monitors = ti.getLockedMonitors();
        for (int i = 0; i < stacktrace.length; ++i) {
            StackTraceElement ste = stacktrace[i];
            out.println("    at " + ste.toString());
            for (MonitorInfo mi : monitors) {
                if (mi.getLockedStackDepth() != i) continue;
                out.println("      - locked " + mi);
            }
        }
        out.println();
    }

    private void printThread(ThreadInfo ti, PrintStream out) {
        StringBuilder sb = new StringBuilder("\"" + ti.getThreadName() + "\" Id=" + ti.getThreadId() + " in " + (Object)((Object)ti.getThreadState()));
        if (ti.getLockName() != null) {
            sb.append(" on lock=").append(ti.getLockName());
        }
        if (ti.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (ti.isInNative()) {
            sb.append(" (running in native)");
        }
        out.println(sb.toString());
        if (ti.getLockOwnerName() != null) {
            out.println("     owned by " + ti.getLockOwnerName() + " Id=" + ti.getLockOwnerId());
        }
    }

    private void printMonitorInfo(ThreadInfo ti, PrintStream out) {
        MonitorInfo[] monitors = ti.getLockedMonitors();
        out.println("    Locked monitors: count = " + monitors.length);
        for (MonitorInfo mi : monitors) {
            out.println("      - " + mi + " locked at ");
            out.println("          " + mi.getLockedStackDepth() + " " + mi.getLockedStackFrame());
        }
    }

    private void printLockInfo(LockInfo[] locks, PrintStream out) {
        out.println("    Locked synchronizers: count = " + locks.length);
        for (LockInfo li : locks) {
            out.println("      - " + li);
        }
        out.println();
    }

    private void reportStackTrace(ThreadInfo[] deadlocked, File report) {
        DeadlockDetectedException deadlockException = new DeadlockDetectedException(null);
        deadlockException.setStackTrace(deadlocked[0].getStackTrace());
        DeadlockDetectedException lastDde = deadlockException;
        for (ThreadInfo toBeReported : deadlocked) {
            DeadlockDetectedException dde = new DeadlockDetectedException(toBeReported.getThreadName());
            dde.setStackTrace(toBeReported.getStackTrace());
            lastDde.initCause(dde);
            lastDde = dde;
        }
        LOG.log(Level.SEVERE, report.getAbsolutePath(), deadlockException);
    }

    private static class DeadlockDetectedException
    extends RuntimeException {
        public DeadlockDetectedException(String threadName) {
            super(threadName);
        }

        @Override
        public String getLocalizedMessage() {
            if (this.getMessage() == null) {
                return Bundle.MSG_DeadlockDetected();
            }
            return super.getLocalizedMessage();
        }
    }
}

