/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.commons;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.bugtracking.commons.Support;
import org.openide.awt.GraphicsUtils;

public class LinkButton
extends JButton
implements MouseListener,
FocusListener {
    private static final Font BUTTON_FONT = LinkButton.getButtonFont();
    static Color linkInFocusColor = null;
    private static Color linkColor = null;
    private static Color mouseOverLinkColor = null;
    private static Color visitedLinkColor = null;
    private static final Stroke LINK_IN_FOCUS_STROKE = new BasicStroke(1.0f, 2, 2, 0.0f, new float[]{0.0f, 2.0f}, 0.0f);
    private boolean underline = false;
    private Color alternativeLinkColor;

    public LinkButton(String text, Icon icon) {
        super(text, icon);
        this.init();
    }

    public LinkButton(Action a) {
        super(a);
        this.init();
    }

    public LinkButton(String text) {
        super(text);
        this.init();
    }

    public LinkButton(Icon icon) {
        super(icon);
        this.init();
    }

    public LinkButton() {
        this.init();
    }

    public void setColors(Color linkColor, Color linkInFocusColor, Color mouseOverLinkColor, Color visitedLinkColor) {
        LinkButton.linkInFocusColor = linkInFocusColor;
        LinkButton.linkColor = linkColor;
        LinkButton.mouseOverLinkColor = mouseOverLinkColor;
        LinkButton.visitedLinkColor = visitedLinkColor;
    }

    private void init() {
        this.setForeground(this.getLinkColor());
        this.setFont(BUTTON_FONT);
        this.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setHorizontalAlignment(2);
        this.addMouseListener(this);
        this.setFocusable(true);
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setBorderPainted(false);
        this.setFocusPainted(false);
        this.setRolloverEnabled(true);
        this.setContentAreaFilled(false);
        this.addFocusListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.isEnabled()) {
            this.underline = true;
            this.setForeground(linkInFocusColor);
            this.repaint();
            this.onMouseEntered(e);
            this.setForeground(mouseOverLinkColor);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.underline = false;
        this.setForeground(this.isVisited() ? visitedLinkColor : this.getLinkColor());
        this.repaint();
        this.onMouseExited(e);
    }

    void setAlternativeLinkColor(Color c) {
        this.alternativeLinkColor = c;
    }

    Color getLinkColor() {
        Color c = this.alternativeLinkColor;
        return c != null ? c : linkColor;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        GraphicsUtils.configureDefaultRenderingHints((Graphics)g2);
        super.paintComponent(g2);
        Dimension size = this.getSize();
        if (this.hasFocus() && this.isEnabled()) {
            g2.setStroke(LINK_IN_FOCUS_STROKE);
            g2.setColor(linkInFocusColor);
            g2.drawRect(0, 0, size.width - 1, size.height - 1);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    protected void onMouseExited(MouseEvent e) {
    }

    protected void onMouseEntered(MouseEvent e) {
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.underline && this.isEnabled()) {
            Font f = this.getFont();
            FontMetrics fm = this.getFontMetrics(f);
            int iconWidth = 0;
            if (null != this.getIcon()) {
                iconWidth = this.getIcon().getIconWidth() + this.getIconTextGap();
            }
            int x1 = iconWidth;
            int y1 = fm.getHeight();
            int x2 = fm.stringWidth(this.getText()) + iconWidth;
            if (this.getText().length() > 0) {
                g.drawLine(x1, y1, x2, y1);
            }
        }
    }

    protected boolean isVisited() {
        return false;
    }

    private static Font getButtonFont() {
        Font defaultFont = UIManager.getFont("Button.font");
        if (defaultFont != null) {
            return defaultFont;
        }
        return new Font(null, 0, 12);
    }

    static {
        linkInFocusColor = UIManager.getColor("nb.html.link.foreground.focus");
        if (null == linkInFocusColor) {
            linkInFocusColor = new Color(16748032);
        }
        if (null == (linkColor = UIManager.getColor("nb.html.link.foreground"))) {
            Color labelColor = UIManager.getDefaults().getColor("Label.foreground");
            linkColor = labelColor == null || labelColor.getRed() < 192 && labelColor.getGreen() < 192 && labelColor.getBlue() < 192 ? new Color(1461115) : new Color(2191544);
        }
        if (null == (mouseOverLinkColor = UIManager.getColor("nb.html.link.foreground.hover"))) {
            mouseOverLinkColor = new Color(16748032);
        }
        if (null == (visitedLinkColor = UIManager.getColor("nb.html.link.foreground.visited"))) {
            visitedLinkColor = new Color(5607890);
        }
    }

    public static class MailtoButton
    extends LinkButton {
        public MailtoButton(String text, String accessibleCtx, String mail) {
            this(text, accessibleCtx, mail, null, null);
        }

        public MailtoButton(String text, String accessibleCtx, final String mail, final String subject, final String body) {
            super(text);
            this.addActionListener(new ActionListener(){
                final /* synthetic */ MailtoButton this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    StringBuilder mailtoURI = new StringBuilder();
                    mailtoURI.append("mailto:");
                    mailtoURI.append(mail);
                    boolean amp = false;
                    if (subject != null || body != null) {
                        mailtoURI.append("?");
                    }
                    if (subject != null) {
                        mailtoURI.append("subject=");
                        mailtoURI.append(this.encodeURI(subject));
                        amp = true;
                    }
                    if (body != null) {
                        if (amp) {
                            mailtoURI.append("&");
                        }
                        mailtoURI.append("body=");
                        mailtoURI.append(this.encodeURI(body));
                    }
                    try {
                        Desktop.getDesktop().mail(new URI(mailtoURI.toString()));
                    }
                    catch (IOException | URISyntaxException ex) {
                        Support.LOG.log(Level.INFO, "unable to invoke: \n" + mailtoURI.toString(), ex);
                    }
                }

                private String encodeURI(String text) {
                    try {
                        return URLEncoder.encode(text, "UTF-8").replaceAll("\\%28", "(").replaceAll("\\%29", ")").replaceAll("\\+", "%20").replaceAll("\\%21", "!").replaceAll("\\%27", "'").replaceAll("\\%7E", "~");
                    }
                    catch (UnsupportedEncodingException e) {
                        Support.LOG.log(Level.WARNING, null, e);
                        return text;
                    }
                }
            });
            this.getAccessibleContext().setAccessibleDescription(accessibleCtx != null ? accessibleCtx : "");
        }
    }
}

