/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.instrumentation;

import java.io.IOException;
import org.netbeans.lib.profiler.classfile.BaseClassInfo;
import org.netbeans.lib.profiler.classfile.ClassRepository;
import org.netbeans.lib.profiler.classfile.DynamicClassInfo;
import org.netbeans.lib.profiler.filters.InstrumentationFilter;
import org.netbeans.lib.profiler.global.CommonConstants;
import org.netbeans.lib.profiler.instrumentation.CPExtensionsRepository;
import org.netbeans.lib.profiler.instrumentation.ClassManager;
import org.netbeans.lib.profiler.instrumentation.ClassRewriter;
import org.netbeans.lib.profiler.instrumentation.Injector;
import org.netbeans.lib.profiler.instrumentation.ObjLivenessMethodInstrumentor;
import org.netbeans.lib.profiler.utils.MiscUtils;
import org.netbeans.lib.profiler.utils.StringUtils;
import org.netbeans.lib.profiler.utils.VMUtils;

class ObjLivenessInstrCallsInjector
extends Injector
implements CommonConstants {
    protected static byte[] injectedCode;
    protected static int injectedCodeLen;
    protected static int injectedCodeMethodIdxPos;
    protected static int injectedCodeClassIdPos;
    protected boolean[] allUnprofiledClassStatusArray;
    private final InstrumentationFilter instrFilter;
    private final boolean checkForOpcNew;
    private final boolean checkForOpcNewArray;

    public ObjLivenessInstrCallsInjector(DynamicClassInfo clazz, int baseCPoolCount, int methodIdx, boolean[] allUnprofiledClassStatusArray, InstrumentationFilter instrFilter, boolean checkForOpcNew, boolean checkForOpcNewArray) {
        super(clazz, methodIdx);
        this.baseCPoolCount = baseCPoolCount;
        this.allUnprofiledClassStatusArray = allUnprofiledClassStatusArray;
        this.instrFilter = instrFilter;
        this.checkForOpcNew = checkForOpcNew;
        this.checkForOpcNewArray = checkForOpcNewArray;
    }

    @Override
    public byte[] instrumentMethod() {
        int bci = 0;
        int nInjections = 0;
        if (ObjLivenessMethodInstrumentor.isObjectConstructor(this.clazz, this.methodIdx)) {
            this.injectTraceObjAllocObjCtor(bci);
            ++nInjections;
        } else {
            int loaderId = this.clazz.getLoaderId();
            int opcNewCount = 0;
            int opcNewToInstr = 0;
            block0: do {
                opcNewToInstr = opcNewCount + 1;
                for (bci = 0; bci < this.bytecodesLength && this.bytecodesLength + injectedCodeLen < 65535; bci += this.opcodeLength(bci)) {
                    BaseClassInfo refClazz;
                    int bc = this.bytecodes[bci] & 0xFF;
                    if ((bc != 187 || !this.checkForOpcNew) && (!this.checkForOpcNewArray || bc != 189 && bc != 188 && bc != 197) || --opcNewToInstr != 0) continue;
                    ++opcNewCount;
                    if (bc == 187 || bc == 189 || bc == 197) {
                        int classCPIdx = this.getU2(bci + 1);
                        String refClassName = this.clazz.getRefClassName(classCPIdx);
                        if (bc == 187) {
                            if (!this.instrFilter.passes(refClassName)) continue block0;
                            refClazz = ClassManager.javaClassOrPlaceholderForName(refClassName, loaderId);
                        } else if (bc == 189) {
                            if (!this.instrFilter.passes(refClassName.concat("[]"))) continue block0;
                            refClazz = ClassManager.javaClassForObjectArrayType(refClassName);
                        } else {
                            if (!this.instrFilter.passes(ObjLivenessInstrCallsInjector.getMultiArrayClassName(refClassName))) continue block0;
                            refClazz = ClassRepository.lookupSpecialClass(refClassName);
                        }
                        if (refClazz == null) continue block0;
                        int classId = refClazz.getInstrClassId();
                        if (this.allUnprofiledClassStatusArray != null && this.allUnprofiledClassStatusArray.length > classId && this.allUnprofiledClassStatusArray[classId]) continue block0;
                        if (bc == 189 || bc == 197) {
                            this.injectTraceObjAlloc(classId, bci + this.opcodeLength(bci));
                            ++nInjections;
                            continue block0;
                        }
                        if ((bc = this.bytecodes[bci += this.opcodeLength(bci)] & 0xFF) != 89 && bc != 90 && bc != 91) {
                            this.injectDup(bci);
                            bci = this.locateConstructorCallForNewOp(bci, this.bytecodesLength, refClassName);
                            this.injectTraceObjAllocNoDup(classId, bci);
                            ++nInjections;
                            continue block0;
                        }
                        if ((bci = this.locateConstructorCallForNewOp(bci, this.bytecodesLength, refClassName)) == -1) continue block0;
                        this.injectTraceObjAlloc(classId, bci);
                        ++nInjections;
                        continue block0;
                    }
                    int arrayClassId = this.getByte(bci + 1);
                    refClazz = ClassManager.javaClassForPrimitiveArrayType(arrayClassId);
                    int classId = refClazz.getInstrClassId();
                    String className = StringUtils.userFormClassName(refClazz.getName());
                    if (!this.instrFilter.passes(className) || this.allUnprofiledClassStatusArray != null && this.allUnprofiledClassStatusArray[classId]) continue block0;
                    this.injectTraceObjAlloc(classId, bci + 2);
                    ++nInjections;
                    continue block0;
                }
            } while (opcNewToInstr == 0);
            if (bci < this.bytecodesLength) {
                String methodFQN = this.clazz.getName() + "." + this.clazz.getMethodName(this.methodIdx) + this.clazz.getMethodSignature(this.methodIdx);
                MiscUtils.printWarningMessage("Method " + methodFQN + " is too big to be fully instrumented.");
            }
        }
        if (nInjections == 0) {
            ((DynamicClassInfo)this.clazz).unsetMethodInstrumented(this.methodIdx);
        } else {
            this.maxStack += 2;
        }
        return this.createPackedMethodInfo();
    }

    private static String getMultiArrayClassName(String refClassName) {
        int dimension = refClassName.lastIndexOf(91);
        String baseClass = refClassName.substring(dimension + 1);
        if (VMUtils.isVMPrimitiveType(baseClass)) {
            return StringUtils.userFormClassName(refClassName);
        }
        StringBuilder arrayClass = new StringBuilder(refClassName.length() + dimension + 1);
        arrayClass.append(refClassName.substring(dimension + 1));
        for (int i = 0; i <= dimension; ++i) {
            arrayClass.append("[]");
        }
        return arrayClass.toString();
    }

    private static void initializeInjectedCode() {
        injectedCodeLen = 8;
        injectedCode = new byte[injectedCodeLen];
        ObjLivenessInstrCallsInjector.injectedCode[0] = 89;
        ObjLivenessInstrCallsInjector.injectedCode[1] = 17;
        injectedCodeClassIdPos = 2;
        ObjLivenessInstrCallsInjector.injectedCode[4] = -72;
        injectedCodeMethodIdxPos = 5;
        ObjLivenessInstrCallsInjector.injectedCode[7] = 0;
    }

    private void injectDup(int bci) {
        byte[] injCode = new byte[]{89, 0, 0, 0};
        this.injectCodeAndRewrite(injCode, 4, bci, false);
    }

    private void injectTraceObjAlloc(int classId, int bci) {
        int targetMethodIdx = CPExtensionsRepository.memoryProfContents_TraceObjAllocMethodIdx + this.baseCPoolCount;
        ObjLivenessInstrCallsInjector.putU2(injectedCode, injectedCodeMethodIdxPos, targetMethodIdx);
        ObjLivenessInstrCallsInjector.putU2(injectedCode, injectedCodeClassIdPos, classId);
        this.injectCodeAndRewrite(injectedCode, injectedCodeLen, bci, false);
    }

    private void injectTraceObjAllocNoDup(int classId, int bci) {
        ObjLivenessInstrCallsInjector.injectedCode[0] = 0;
        int targetMethodIdx = CPExtensionsRepository.memoryProfContents_TraceObjAllocMethodIdx + this.baseCPoolCount;
        ObjLivenessInstrCallsInjector.putU2(injectedCode, injectedCodeMethodIdxPos, targetMethodIdx);
        ObjLivenessInstrCallsInjector.putU2(injectedCode, injectedCodeClassIdPos, classId);
        this.injectCodeAndRewrite(injectedCode, injectedCodeLen, bci, false);
        ObjLivenessInstrCallsInjector.injectedCode[0] = 89;
    }

    private void injectTraceObjAllocObjCtor(int bci) {
        ObjLivenessInstrCallsInjector.injectedCode[0] = 42;
        int targetMethodIdx = CPExtensionsRepository.memoryProfContents_TraceObjAllocMethodIdx + this.baseCPoolCount;
        ObjLivenessInstrCallsInjector.putU2(injectedCode, injectedCodeMethodIdxPos, targetMethodIdx);
        ObjLivenessInstrCallsInjector.putU2(injectedCode, injectedCodeClassIdPos, 0);
        this.injectCodeAndRewrite(injectedCode, injectedCodeLen, bci, true);
        ObjLivenessInstrCallsInjector.injectedCode[0] = 89;
    }

    private int locateConstructorCallForNewOp(int startBCI, int bytecodesLength, String newOpClassName) {
        int nestedNewOps = 0;
        for (int bci = startBCI; bci < bytecodesLength; bci += this.opcodeLength(bci)) {
            int bc = this.bytecodes[bci] & 0xFF;
            if (bc == 187) {
                ++nestedNewOps;
                continue;
            }
            if (bc != 183) continue;
            int index = this.getU2(bci + 1);
            String[] cms = this.clazz.getRefMethodsClassNameAndSig(index);
            if (cms == null) {
                System.err.println("Failed to locate constant pool ref in: " + this.clazz.getName());
                System.err.println("new Op class: " + newOpClassName);
                System.err.println("bci: " + bci + ", startBCI: " + startBCI);
                System.err.println("constant pool ref index: " + index);
                this.dumpClassFile();
                return -1;
            }
            String refClassName = cms[0];
            String refMethodName = cms[1];
            if (refMethodName != "<init>") continue;
            if (nestedNewOps == 0) {
                bci += this.opcodeLength(bci);
                return bci;
            }
            --nestedNewOps;
        }
        System.err.println("Profiler Warning: Failed to instrument creation of class " + newOpClassName + " in method " + this.clazz.getName() + "." + this.clazz.getMethodName(this.methodIdx));
        this.dumpClassFile();
        return -1;
    }

    private void dumpClassFile() {
        try {
            ClassRewriter.saveToDisk(this.clazz.getName(), ((DynamicClassInfo)this.clazz).getClassFileBytes());
        }
        catch (IOException e) {
            System.err.println("Caught exception while dumping class: " + this.clazz.getName() + ", " + e.getMessage());
            e.printStackTrace(System.err);
        }
    }

    static {
        ObjLivenessInstrCallsInjector.initializeInjectedCode();
    }
}

