/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.memory;

import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.client.ProfilingPointsProcessor;
import org.netbeans.lib.profiler.client.RuntimeProfilingPoint;
import org.netbeans.lib.profiler.global.TransactionalSupport;
import org.netbeans.lib.profiler.results.BaseCallGraphBuilder;
import org.netbeans.lib.profiler.results.RuntimeCCTNode;
import org.netbeans.lib.profiler.results.memory.MemoryCCTProvider;
import org.netbeans.lib.profiler.results.memory.MemoryProfilingResultsListener;
import org.netbeans.lib.profiler.results.memory.PresoObjAllocCCTNode;
import org.netbeans.lib.profiler.results.memory.PresoObjLivenessCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeMemoryCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeObjAllocTermCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeObjLivenessTermCCTNode;

public class MemoryCallGraphBuilder
extends BaseCallGraphBuilder
implements MemoryProfilingResultsListener,
MemoryCCTProvider {
    private ObjIdToCCTNodeMap objMap;
    private final TransactionalSupport transaction = new TransactionalSupport();
    private float[] avgObjectAge;
    private int[] maxSurvGen;
    private long[] nTrackedAllocObjects;
    private int[] nTrackedLiveObjects;
    private long[] objectsSizePerClass;
    private RuntimeMemoryCCTNode[] stacksForClasses;
    private boolean[] unprofiledClass;
    private int currentEpoch;
    private int nProfiledClasses;

    @Override
    public long[] getAllocObjectNumbers() {
        this.transaction.beginTrans(false);
        try {
            long[] res = new long[this.nProfiledClasses];
            System.arraycopy(this.objectsSizePerClass, 0, res, 0, res.length);
            long[] lArray = res;
            return lArray;
        }
        finally {
            this.transaction.endTrans();
        }
    }

    @Override
    public int getCurrentEpoch() {
        this.transaction.beginTrans(false);
        try {
            int n = this.currentEpoch;
            return n;
        }
        finally {
            this.transaction.endTrans();
        }
    }

    @Override
    public MemoryCCTProvider.ObjectNumbersContainer getLivenessObjectNumbers() {
        this.transaction.beginTrans(false);
        try {
            MemoryCCTProvider.ObjectNumbersContainer res;
            if (this.getClient().getCurrentInstrType() != 6) {
                throw new IllegalStateException("MemoryCallGraphBuilder must be running in TRACKING_LIVENESS mode in order to provide liveness statistics");
            }
            this.updateNumberOfClasses();
            this.calculateAverageObjectAges();
            this.calculateTotalNumberOfSurvGens();
            MemoryCCTProvider.ObjectNumbersContainer objectNumbersContainer = res = new MemoryCCTProvider.ObjectNumbersContainer(this.nTrackedAllocObjects, this.nTrackedLiveObjects, this.objectsSizePerClass, this.avgObjectAge, this.maxSurvGen, this.unprofiledClass, this.nProfiledClasses);
            return objectNumbersContainer;
        }
        finally {
            this.transaction.endTrans();
        }
    }

    @Override
    public int getNProfiledClasses() {
        this.transaction.beginTrans(false);
        try {
            this.updateNumberOfClasses();
            int n = this.nProfiledClasses;
            return n;
        }
        finally {
            this.transaction.endTrans();
        }
    }

    @Override
    public long[] getObjectsSizePerClass() {
        this.transaction.beginTrans(false);
        try {
            long[] lArray = this.objectsSizePerClass;
            return lArray;
        }
        finally {
            this.transaction.endTrans();
        }
    }

    @Override
    public RuntimeMemoryCCTNode[] getStacksForClasses() {
        this.transaction.beginTrans(false);
        try {
            RuntimeMemoryCCTNode[] runtimeMemoryCCTNodeArray = this.stacksForClasses;
            return runtimeMemoryCCTNodeArray;
        }
        finally {
            this.transaction.endTrans();
        }
    }

    @Override
    public void beginTrans(boolean mutable) {
        this.transaction.beginTrans(mutable);
    }

    @Override
    public boolean classMarkedUnprofiled(int classId) {
        this.transaction.beginTrans(false);
        try {
            boolean bl = this.unprofiledClass[classId];
            return bl;
        }
        finally {
            this.transaction.endTrans();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PresoObjAllocCCTNode createPresentationCCT(int classId, boolean dontShowZeroLiveObjAllocPaths) throws ClientUtils.TargetAppOrVMTerminated {
        this.transaction.beginTrans(false);
        try {
            PresoObjAllocCCTNode presNode = null;
            RuntimeMemoryCCTNode classNode = this.getClassNode(classId);
            String className = this.getClassName(classId);
            if (classNode == null || className == null) {
                PresoObjAllocCCTNode presoObjAllocCCTNode = null;
                return presoObjAllocCCTNode;
            }
            switch (this.getClient().getCurrentInstrType()) {
                case 6: {
                    presNode = PresoObjLivenessCCTNode.createPresentationCCTFromVM(this.getClient(), classNode, className, this.currentEpoch, dontShowZeroLiveObjAllocPaths);
                    break;
                }
                case 5: {
                    presNode = PresoObjAllocCCTNode.createPresentationCCTFromVM(this.getClient(), classNode, className);
                    break;
                }
                default: {
                    throw new IllegalStateException("MemoryCallGraphBuilder runs in an illegal mode");
                }
            }
            PresoObjAllocCCTNode presoObjAllocCCTNode = presNode;
            return presoObjAllocCCTNode;
        }
        finally {
            this.transaction.endTrans();
        }
    }

    @Override
    public void endTrans() {
        this.transaction.endTrans();
    }

    @Override
    public void markClassUnprofiled(int classId) {
        this.transaction.beginTrans(true);
        try {
            this.unprofiledClass[classId] = true;
        }
        finally {
            this.transaction.endTrans();
        }
    }

    @Override
    public void onAllocStackTrace(char classId, long objSize, int[] methodIds) {
        RuntimeObjAllocTermCCTNode termNode = (RuntimeObjAllocTermCCTNode)this.processStackTrace(classId, methodIds, false);
        if (termNode != null) {
            termNode.updateForNewObject(objSize);
            char c = classId;
            this.objectsSizePerClass[c] = this.objectsSizePerClass[c] + objSize;
        }
        this.batchNotEmpty = true;
    }

    @Override
    public void onGcPerformed(char classId, long objectId, int objEpoch) {
        if (this.currentEpoch < objEpoch) {
            this.currentEpoch = objEpoch;
        }
        RuntimeObjLivenessTermCCTNode termNode = this.objMap.getNode(objectId);
        long objSize = this.objMap.getLastRemovedObjSize();
        if (termNode == null) {
            return;
        }
        termNode.updateForRemovedObject(objSize);
        termNode.removeLiveObjectForEpoch(objEpoch);
        char c = classId;
        this.nTrackedLiveObjects[c] = this.nTrackedLiveObjects[c] - 1;
        char c2 = classId;
        this.objectsSizePerClass[c2] = this.objectsSizePerClass[c2] - objSize;
        this.batchNotEmpty = true;
    }

    @Override
    public void onLivenessStackTrace(char classId, long objectId, int objEpoch, long objSize, int[] methodIds) {
        if (this.getClient().getCurrentInstrType() != 6) {
            return;
        }
        if (this.currentEpoch < objEpoch) {
            this.currentEpoch = objEpoch;
        }
        try {
            RuntimeObjLivenessTermCCTNode termNode = (RuntimeObjLivenessTermCCTNode)this.processStackTrace(classId, methodIds, true);
            if (termNode != null) {
                termNode.updateForNewObject(objSize);
                termNode.addLiveObjectForEpoch(objEpoch);
                this.objMap.put(objectId, termNode, objSize);
                char c = classId;
                this.nTrackedAllocObjects[c] = this.nTrackedAllocObjects[c] + 1L;
                char c2 = classId;
                this.nTrackedLiveObjects[c2] = this.nTrackedLiveObjects[c2] + 1;
                char c3 = classId;
                this.objectsSizePerClass[c3] = this.objectsSizePerClass[c3] + objSize;
            }
        }
        catch (OutOfMemoryError e) {
            ProfilerLogger.warning("OOME, resetting collectors!!!");
            this.reset();
        }
        this.batchNotEmpty = true;
    }

    @Override
    public void profilingPoint(final int threadId, final int ppId, final long timeStamp) {
        ProfilerClient client = this.getClient();
        if (client == null) {
            return;
        }
        final ProfilingPointsProcessor ppp = TargetAppRunner.getDefault().getProfilingPointsProcessor();
        this.afterBatchCommands.add(new Runnable(){
            final /* synthetic */ MemoryCallGraphBuilder this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                ppp.profilingPointHit(new RuntimeProfilingPoint.HitEvent(ppId, timeStamp, threadId));
            }
        });
    }

    @Override
    public void monitorEntry(int threadId, long timeStamp0, long timeStamp1, int monitorId, int ownerThreadId) {
    }

    @Override
    public void monitorExit(int threadId, long timeStamp0, long timeStamp1, int monitorId) {
    }

    @Override
    public void newThread(int threadId, String threadName, String threadClassName) {
    }

    @Override
    public void newMonitor(int hash, String className) {
    }

    @Override
    public void timeAdjust(int threadId, long timeDiff0, long timeDiff1) {
    }

    @Override
    public void updateInternals() {
        this.loadNamesForJMethodIds();
    }

    @Override
    protected RuntimeCCTNode getAppRootNode() {
        return new RuntimeMemoryCCTNode();
    }

    @Override
    protected void doBatchStart() {
        this.transaction.beginTrans(true);
        this.updateNumberOfClasses();
    }

    @Override
    protected void doBatchStop() {
        this.transaction.endTrans();
    }

    @Override
    protected void doReset() {
        this.transaction.beginTrans(true);
        try {
            int i;
            if (this.stacksForClasses != null) {
                for (i = 0; i < this.stacksForClasses.length; ++i) {
                    this.stacksForClasses[i] = null;
                    this.objectsSizePerClass[i] = 0L;
                }
            }
            if (this.objMap != null) {
                this.objMap.clear();
            }
            if (this.nTrackedAllocObjects != null) {
                for (i = 0; i < this.nTrackedAllocObjects.length; ++i) {
                    this.nTrackedAllocObjects[i] = 0L;
                    this.objectsSizePerClass[i] = 0L;
                }
            }
            if (this.nTrackedLiveObjects != null) {
                for (i = 0; i < this.nTrackedLiveObjects.length; ++i) {
                    this.nTrackedLiveObjects[i] = 0;
                }
            }
            if (this.objectsSizePerClass != null) {
                for (i = 0; i < this.objectsSizePerClass.length; ++i) {
                    this.objectsSizePerClass[i] = 0L;
                }
            }
        }
        finally {
            this.transaction.endTrans();
        }
    }

    @Override
    protected void doShutdown() {
        this.resetInternalState();
    }

    @Override
    protected void doStartup(ProfilerClient profilerClient) {
        this.resetInternalState();
        profilerClient.registerMemoryCCTProvider(this);
    }

    private void resetInternalState() {
        this.objMap = new ObjIdToCCTNodeMap();
        this.currentEpoch = 0;
        this.nProfiledClasses = 0;
        this.stacksForClasses = null;
        this.objectsSizePerClass = null;
        this.nTrackedAllocObjects = null;
        this.nTrackedLiveObjects = null;
        this.maxSurvGen = null;
        this.avgObjectAge = null;
        this.unprofiledClass = null;
        this.currentEpoch = -1;
    }

    private String getClassName(int classId) {
        this.status.beginTrans(false);
        try {
            String string = this.status.getClassNames()[classId];
            return string;
        }
        finally {
            this.status.endTrans();
        }
    }

    private RuntimeMemoryCCTNode getClassNode(int classId) {
        return this.stacksForClasses[classId];
    }

    private boolean isInitialized() {
        return this.unprofiledClass != null && this.stacksForClasses != null;
    }

    private RuntimeMemoryCCTNode getNewTerminalNode(int methodId, boolean live) {
        return live ? new RuntimeObjLivenessTermCCTNode(methodId) : new RuntimeObjAllocTermCCTNode(methodId);
    }

    private void calculateAverageObjectAges() {
        if (!this.isInitialized()) {
            return;
        }
        int nClasses = this.nProfiledClasses;
        this.avgObjectAge = new float[nClasses];
        for (int i = 0; i < nClasses; ++i) {
            RuntimeMemoryCCTNode rootNode;
            if (this.unprofiledClass[i] || (rootNode = this.stacksForClasses[i]) == null) continue;
            float age = RuntimeObjLivenessTermCCTNode.calculateAvgObjectAgeForAllPaths(rootNode, this.currentEpoch);
            if (age < 0.0f) {
                age = 0.0f;
            }
            this.avgObjectAge[i] = age;
        }
    }

    private void calculateTotalNumberOfSurvGens() {
        if (!this.isInitialized()) {
            return;
        }
        this.maxSurvGen = new int[this.nProfiledClasses];
        for (int i = 0; i < this.maxSurvGen.length; ++i) {
            RuntimeMemoryCCTNode rootNode;
            if (this.unprofiledClass[i] || (rootNode = this.stacksForClasses[i]) == null) continue;
            this.maxSurvGen[i] = RuntimeObjLivenessTermCCTNode.calculateTotalNumberOfSurvGensForAllPaths(rootNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadNamesForJMethodIds() {
        ProfilerClient client = this.getClient();
        if (client != null) {
            ProfilerClient profilerClient = client;
            synchronized (profilerClient) {
                this.transaction.beginTrans(false);
                try {
                    PresoObjAllocCCTNode.getNamesForMethodIdsFromVM(client, this.stacksForClasses);
                }
                catch (ClientUtils.TargetAppOrVMTerminated ex) {
                    ProfilerLogger.log(ex.getMessage());
                }
                finally {
                    this.transaction.endTrans();
                }
            }
        }
    }

    private RuntimeMemoryCCTNode processStackTrace(char classId, int[] methodIds, boolean live) {
        if (classId >= this.stacksForClasses.length) {
            ProfilerLogger.severe("Received stack for non existent class Id: " + classId + ", current length: " + this.stacksForClasses.length);
            this.updateNumberOfClasses();
            ProfilerLogger.severe("Received stack for non existent class Id: " + classId + ", current length after updateNumberOfClasses: " + this.stacksForClasses.length);
            if (classId >= this.stacksForClasses.length) {
                return null;
            }
        }
        RuntimeMemoryCCTNode curNode = this.stacksForClasses[classId];
        RuntimeMemoryCCTNode parentNode = null;
        if (curNode == null) {
            this.stacksForClasses[classId] = curNode = new RuntimeMemoryCCTNode(0);
        }
        int depth = methodIds.length;
        int depthMinusOne = depth - 1;
        for (int i = 0; i < depth; ++i) {
            boolean found;
            int methodId;
            block15: {
                Object children;
                block16: {
                    methodId = methodIds[i];
                    parentNode = curNode;
                    children = curNode.children;
                    found = false;
                    if (children == null) break block15;
                    if (!(children instanceof RuntimeMemoryCCTNode)) break block16;
                    if (((RuntimeMemoryCCTNode)children).methodId != methodId) break block15;
                    curNode = (RuntimeMemoryCCTNode)children;
                    found = true;
                    break block15;
                }
                RuntimeMemoryCCTNode[] ar = (RuntimeMemoryCCTNode[])children;
                for (int j = 0; j < ar.length; ++j) {
                    if (ar[j].methodId != methodId) continue;
                    curNode = ar[j];
                    found = true;
                    break;
                }
            }
            if (found) continue;
            if (i < depthMinusOne) {
                curNode = curNode.addNewChild(methodId);
                continue;
            }
            RuntimeMemoryCCTNode newNode = this.getNewTerminalNode(methodId, live);
            curNode.attachNodeAsChild(newNode);
            curNode = newNode;
        }
        if (curNode.getClass() == RuntimeMemoryCCTNode.class) {
            RuntimeMemoryCCTNode newNode = this.getNewTerminalNode(curNode.methodId, live);
            newNode.children = curNode.children;
            if (parentNode != null) {
                Object parChildren = parentNode.children;
                assert (parChildren != null);
                if (parChildren instanceof RuntimeMemoryCCTNode) {
                    if (parChildren == curNode) {
                        parentNode.children = newNode;
                    }
                } else {
                    RuntimeMemoryCCTNode[] ar = (RuntimeMemoryCCTNode[])parChildren;
                    for (int i = 0; i < ar.length; ++i) {
                        if (ar[i] != curNode) continue;
                        ar[i] = newNode;
                        break;
                    }
                }
            } else {
                this.stacksForClasses[classId] = newNode;
            }
            curNode = newNode;
        }
        return curNode;
    }

    private void updateNumberOfClasses() {
        int newSize;
        this.status.beginTrans(false);
        try {
            this.nProfiledClasses = this.status.getNInstrClasses();
        }
        finally {
            this.status.endTrans();
        }
        if (this.stacksForClasses == null || this.stacksForClasses.length < this.nProfiledClasses) {
            newSize = this.nProfiledClasses * 3 / 2;
            RuntimeMemoryCCTNode[] newStacks = new RuntimeMemoryCCTNode[newSize];
            if (this.stacksForClasses != null) {
                System.arraycopy(this.stacksForClasses, 0, newStacks, 0, this.stacksForClasses.length);
            }
            this.stacksForClasses = newStacks;
            long[] newObjSize = new long[newSize];
            if (this.objectsSizePerClass != null) {
                System.arraycopy(this.objectsSizePerClass, 0, newObjSize, 0, this.objectsSizePerClass.length);
            }
            this.objectsSizePerClass = newObjSize;
        }
        if (this.getClient().getCurrentInstrType() == 6 && (this.nTrackedLiveObjects == null || this.nTrackedLiveObjects.length < this.nProfiledClasses)) {
            newSize = this.nProfiledClasses * 3 / 2;
            int[] tmpIOldData = this.nTrackedLiveObjects;
            int[] tmpINewData = null;
            long[] tmpLOldData = this.nTrackedAllocObjects;
            long[] tmpLNewData = null;
            boolean[] tmpBOldData = this.unprofiledClass;
            boolean[] tmpBNewData = null;
            tmpINewData = new int[newSize];
            if (tmpIOldData != null) {
                System.arraycopy(tmpIOldData, 0, tmpINewData, 0, tmpIOldData.length);
            }
            tmpLNewData = new long[newSize];
            if (tmpLOldData != null) {
                System.arraycopy(tmpLOldData, 0, tmpLNewData, 0, tmpLOldData.length);
            }
            tmpBNewData = new boolean[newSize];
            if (tmpBOldData != null) {
                System.arraycopy(tmpBOldData, 0, tmpBNewData, 0, tmpBOldData.length);
            }
            this.nTrackedLiveObjects = tmpINewData;
            this.nTrackedAllocObjects = tmpLNewData;
            this.unprofiledClass = tmpBNewData;
        }
    }

    private static class ObjIdToCCTNodeMap {
        private long[] keys;
        private long[] objSize;
        private RuntimeObjLivenessTermCCTNode[] values;
        private int capacity;
        private int k;
        private int nObjects;
        private int threshold;
        private long a = 5700357409661599241L;
        private long lastRemovedObjSize;

        ObjIdToCCTNodeMap() {
            this.init();
        }

        public long getLastRemovedObjSize() {
            return this.lastRemovedObjSize;
        }

        public RuntimeObjLivenessTermCCTNode getNode(long key) {
            int iter;
            int pos = this.hash(key);
            long keyAtPos = this.keys[pos];
            for (iter = this.capacity >> 2; keyAtPos != key && iter > 0; --iter) {
                pos = (pos + 1) % this.capacity;
                keyAtPos = this.keys[pos];
            }
            if (iter == 0) {
                return null;
            }
            this.keys[pos] = -1L;
            RuntimeObjLivenessTermCCTNode ret = this.values[pos];
            this.values[pos] = null;
            this.lastRemovedObjSize = this.objSize[pos];
            --this.nObjects;
            return ret;
        }

        public void clear() {
            this.keys = null;
            this.values = null;
            this.init();
        }

        public void put(long key, RuntimeObjLivenessTermCCTNode value, long size) {
            if (this.nObjects > this.threshold) {
                this.rehash();
            }
            int pos = this.hash(key);
            while (this.keys[pos] != -1L) {
                pos = (pos + 1) % this.capacity;
            }
            this.keys[pos] = key;
            this.values[pos] = value;
            this.objSize[pos] = size;
            ++this.nObjects;
        }

        public int sizeInBytes() {
            return this.keys.length * 8 + this.values.length * 4 + this.objSize.length * 8;
        }

        private void setThreshold() {
            this.threshold = this.capacity * 3 / 4;
        }

        private int hash(long key) {
            return (int)(key * this.a >>> 64 - this.k);
        }

        private void init() {
            this.capacity = 1024;
            this.k = 10;
            this.nObjects = 0;
            this.setThreshold();
            this.keys = new long[this.capacity];
            for (int i = 0; i < this.capacity; ++i) {
                this.keys[i] = -1L;
            }
            this.values = new RuntimeObjLivenessTermCCTNode[this.capacity];
            this.objSize = new long[this.capacity];
        }

        private void rehash() {
            int i;
            long[] oldKeys = this.keys;
            RuntimeObjLivenessTermCCTNode[] oldValues = this.values;
            long[] oldObjSize = this.objSize;
            int oldCapacity = this.capacity;
            this.capacity *= 2;
            ++this.k;
            this.keys = new long[this.capacity];
            for (i = 0; i < this.capacity; ++i) {
                this.keys[i] = -1L;
            }
            this.values = new RuntimeObjLivenessTermCCTNode[this.capacity];
            this.objSize = new long[this.capacity];
            for (i = 0; i < oldCapacity; ++i) {
                if (oldKeys[i] == -1L) continue;
                int pos = this.hash(oldKeys[i]);
                while (this.keys[pos] != -1L) {
                    pos = (pos + 1) % this.capacity;
                }
                this.keys[pos] = oldKeys[i];
                this.values[pos] = oldValues[i];
                this.objSize[pos] = oldObjSize[i];
            }
            this.setThreshold();
        }
    }
}

