/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints.ui;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import org.netbeans.lib.profiler.ui.components.ThinBevelBorder;
import org.netbeans.modules.profiler.api.EditorSupport;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.ppoints.CodeProfilingPoint;
import org.netbeans.modules.profiler.ppoints.GlobalProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPointFactory;
import org.netbeans.modules.profiler.ppoints.ProfilingPointsManager;
import org.netbeans.modules.profiler.ppoints.Utils;
import org.netbeans.modules.profiler.ppoints.ui.Bundle;
import org.netbeans.modules.profiler.ppoints.ui.ProfilingPointsWindow;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class ToggleProfilingPointAction
extends AbstractAction
implements AWTEventListener {
    private static ToggleProfilingPointAction instance;
    private ProfilingPointsSwitcher ppSwitcher;
    private ProfilingPointFactory[] ppFactories;
    private volatile boolean warningDialogOpened = false;
    private int currentFactory;
    private KeyStroke acceleratorKeyStroke;

    public ToggleProfilingPointAction() {
        this.putValue("Name", Bundle.ToggleProfilingPointAction_ActionName());
        this.putValue("ShortDescription", Bundle.ToggleProfilingPointAction_ActionDescr());
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public static synchronized ToggleProfilingPointAction getInstance() {
        if (instance == null) {
            instance = new ToggleProfilingPointAction();
        }
        return instance;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.acceleratorKeyStroke = Utilities.stringToKey((String)e.getActionCommand());
        if (this.acceleratorKeyStroke == null || this.acceleratorKeyStroke.getModifiers() == 0) {
            ProfilerDialogs.displayError((String)Bundle.ToggleProfilingPointAction_InvalidShortcutMsg(Bundle.ToggleProfilingPointAction_ActionName()));
            return;
        }
        if (this.warningDialogOpened) {
            return;
        }
        if (ProfilingPointsManager.getDefault().isProfilingSessionInProgress()) {
            this.warningDialogOpened = true;
            ProfilerDialogs.displayWarning((String)Bundle.ToggleProfilingPointAction_ProfilingProgressMsg());
            this.warningDialogOpened = false;
            return;
        }
        if (Utils.getCurrentLocation(0).equals(CodeProfilingPoint.Location.EMPTY)) {
            this.warningDialogOpened = true;
            ProfilerDialogs.displayWarning((String)Bundle.ToggleProfilingPointAction_BadSourceMsg());
            this.warningDialogOpened = false;
            return;
        }
        ProfilingPointsSwitcher chooserFrame = this.getChooserFrame();
        boolean toggleOff = false;
        CodeProfilingPoint.Location location = Utils.getCurrentLocation(Integer.MIN_VALUE);
        for (CodeProfilingPoint pp : ProfilingPointsManager.getDefault().getProfilingPoints(CodeProfilingPoint.class, Utils.getCurrentProject(), false, false)) {
            if (!location.equals(pp.getLocation())) continue;
            ProfilingPointsManager.getDefault().removeProfilingPoint(pp);
            toggleOff = true;
        }
        if (!toggleOff) {
            if (chooserFrame.isVisible()) {
                this.nextFactory();
                chooserFrame.setProfilingPointFactory(this.currentFactory == this.ppFactories.length ? null : this.ppFactories[this.currentFactory], this.currentFactory);
            } else if (EditorSupport.currentlyInJavaEditor()) {
                this.resetFactories();
                chooserFrame.setProfilingPointFactory(this.currentFactory == this.ppFactories.length ? null : this.ppFactories[this.currentFactory], this.currentFactory);
                Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
                chooserFrame.setVisible(true);
            }
        }
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        if (!(event instanceof KeyEvent)) {
            return;
        }
        KeyStroke eventKeyStroke = KeyStroke.getKeyStrokeForEvent((KeyEvent)event);
        if (this.acceleratorKeyStroke == null || eventKeyStroke == null) {
            return;
        }
        int acceleratorModifiers = this.acceleratorKeyStroke.getModifiers();
        if (acceleratorModifiers == 0) {
            return;
        }
        if (acceleratorModifiers != eventKeyStroke.getModifiers()) {
            this.modifierKeyStateChanged();
        }
    }

    private synchronized ProfilingPointsSwitcher getChooserFrame() {
        if (this.ppSwitcher == null) {
            this.ppSwitcher = new ProfilingPointsSwitcher();
            this.ppSwitcher.addWindowListener(new WindowAdapter(){

                @Override
                public void windowDeactivated(WindowEvent event) {
                    ToggleProfilingPointAction.this.ppSwitcher.setVisible(false);
                }
            });
        }
        return this.ppSwitcher;
    }

    private synchronized void modifierKeyStateChanged() {
        if (ProfilingPointsManager.getDefault().isProfilingSessionInProgress()) {
            return;
        }
        ProfilingPointsSwitcher chooserFrame = this.getChooserFrame();
        if (chooserFrame.isVisible()) {
            ProfilingPoint ppoint;
            ProfilingPointFactory ppFactory = chooserFrame.getProfilingPointFactory();
            Lookup.Provider project = Utils.getCurrentProject();
            if (ppFactory != null && project != null && (ppoint = ppFactory.create(project)) != null) {
                ProfilingPointsManager.getDefault().addProfilingPoint(ppoint);
                if (ppoint instanceof GlobalProfilingPoint) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (!ProfilingPointsWindow.getDefault().isOpened()) {
                                ProfilingPointsWindow.getDefault().open();
                                ProfilingPointsWindow.getDefault().requestVisible();
                            }
                        }
                    });
                }
                ppoint.customize(true, true);
            }
        }
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        chooserFrame.setVisible(false);
    }

    private void nextFactory() {
        ++this.currentFactory;
        if (this.currentFactory > this.ppFactories.length) {
            this.currentFactory = 0;
        }
    }

    private void resetFactories() {
        if (this.ppFactories == null) {
            this.ppFactories = ProfilingPointsManager.getDefault().getProfilingPointFactories();
            this.getChooserFrame().initPanel(this.ppFactories);
        }
        this.currentFactory = 0;
    }

    private static class ProfilingPointsSwitcher
    extends JFrame {
        private static final String NO_ACTION_NAME = Bundle.ToggleProfilingPointAction_CancelString();
        private static final Icon NO_ACTION_ICON = null;
        private Dimension size;
        private JLabel label;
        private JPanel previewPanel;
        private ProfilingPointFactory ppFactory;

        public ProfilingPointsSwitcher() {
            super(Bundle.ToggleProfilingPointAction_SwitcherWindowCaption());
            this.initProperties();
            this.initComponents();
            this.setProfilingPointFactory(null, -1);
        }

        public void setProfilingPointFactory(ProfilingPointFactory ppFactory, int index) {
            this.ppFactory = ppFactory;
            if (ppFactory != null) {
                this.label.setText(ppFactory.getType());
                this.label.setIcon(ppFactory.getIcon());
            } else {
                this.label.setText(NO_ACTION_NAME);
                this.label.setIcon(NO_ACTION_ICON);
            }
            Component selected = null;
            if (index >= 0 && index < this.previewPanel.getComponentCount()) {
                selected = this.previewPanel.getComponent(index);
            }
            for (Component c : this.previewPanel.getComponents()) {
                if (c == selected) {
                    Border empt1 = BorderFactory.createEmptyBorder(2, 2, 2, 2);
                    MatteBorder sel = BorderFactory.createMatteBorder(1, 1, 1, 1, SystemColor.textHighlight);
                    Border empt2 = BorderFactory.createEmptyBorder(0, 2, 0, 2);
                    CompoundBorder comp1 = BorderFactory.createCompoundBorder(empt2, sel);
                    CompoundBorder comp2 = BorderFactory.createCompoundBorder(comp1, empt1);
                    ((JComponent)c).setBorder(comp2);
                    continue;
                }
                ((JComponent)c).setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
            }
        }

        public ProfilingPointFactory getProfilingPointFactory() {
            return this.ppFactory;
        }

        @Override
        public void setVisible(boolean visible) {
            if (visible) {
                if (this.size == null) {
                    this.size = this.getSize();
                }
                TopComponent editor = WindowManager.getDefault().getRegistry().getActivated();
                Rectangle b = editor.getBounds();
                Point location = new Point(b.x + b.width / 2 - this.size.width / 2, b.y + b.height / 2 - this.size.height / 2);
                SwingUtilities.convertPointToScreen(location, (Component)editor);
                this.setLocation(location);
            }
            super.setVisible(visible);
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.previewPanel = new JPanel(new FlowLayout(0, 0, 3));
            this.previewPanel.setBorder(BorderFactory.createEmptyBorder(4, 7, 2, 7));
            this.label = new JLabel();
            this.label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 7, 7, 7), (Border)new ThinBevelBorder(1)));
            this.label.setBorder(BorderFactory.createCompoundBorder(this.label.getBorder(), BorderFactory.createEmptyBorder(4, 3, 4, 3)));
            this.label.setFont(this.label.getFont().deriveFont(1));
            JPanel p = new JPanel(new BorderLayout());
            p.setBorder(BorderFactory.createRaisedBevelBorder());
            p.add((Component)this.previewPanel, "North");
            p.add((Component)this.label, "Center");
            this.add((Component)p, "Center");
        }

        private void initPanel(ProfilingPointFactory[] ppFactories) {
            Dimension prefSize = new Dimension(230, 0);
            for (int i = 0; i < ppFactories.length; ++i) {
                JLabel previewIcon = new JLabel(ppFactories[i].getIcon());
                previewIcon.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
                this.previewPanel.add(previewIcon);
                this.setProfilingPointFactory(ppFactories[i], i);
                this.pack();
                Dimension currPrefSize = this.getPreferredSize();
                prefSize = new Dimension(Math.max(prefSize.width, currPrefSize.width), Math.max(prefSize.height, currPrefSize.height));
            }
            this.setProfilingPointFactory(null, ppFactories.length);
            this.setSize(prefSize);
        }

        private void initProperties() {
            this.setAlwaysOnTop(true);
            this.setUndecorated(true);
            this.setResizable(false);
            WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                @Override
                public void run() {
                    this.setIconImage(WindowManager.getDefault().getMainWindow().getIconImage());
                }
            });
        }
    }
}

