/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ddloaders.multiview.common;

import java.util.Map;
import org.netbeans.modules.j2ee.sun.dd.api.CommonDDBean;
import org.netbeans.modules.j2ee.sun.ddloaders.Utils;
import org.netbeans.modules.j2ee.sun.ddloaders.multiview.common.BeanResolver;

public class DDBinding
implements Comparable<DDBinding> {
    public static final String PROP_NAME = "Name";
    public static final String PROP_SESSION_TYPE = "SessionType";
    public static final String PROP_DESTINATION_TYPE = "DestinationType";
    public static final String PROP_PERSISTENCE_TYPE = "PersistenceType";
    public static final String PROP_ROLE_NAME = "RoleName";
    public static final String PROP_RUNAS_ROLE = "RunAsRole";
    public static final String PROP_SERVICE_REF = "ServiceRef";
    public static final String PROP_SECURITY_ROLE = "SecurityRole";
    public static final String PROP_EJB_REF = "EjbRef";
    public static final String PROP_RESOURCE_REF = "ResourceRef";
    public static final String PROP_RESOURCE_ENV_REF = "ResourceEnvRef";
    public static final String PROP_MSGDEST = "MessageDestination";
    public static final String PROP_MSGDEST_REF = "MessageDestinationRef";
    public static final String PROP_WEBSERVICE_DESC = "WebserviceDescription";
    public static final String PROP_PORTCOMPONENT = "PortComponent";
    public static final String PROP_SEI = "EndpointInterface";
    public static final String PROP_WSDLPORT = "WsdlPort";
    public static final String PROP_SERVLET_LINK = "ServletLink";
    public static final String PROP_EJB_LINK = "EjbLink";
    public static final String PROP_PORTCOMPONENT_REF = "PortComponentRef";
    public static final String PROP_PORTCOMPONENT_LINK = "PortComponentLink";
    protected final BeanResolver resolver;
    protected final CommonDDBean sunBean;
    protected final Map<String, Object> standardMap;
    protected final Map<String, Object> annotationMap;
    protected boolean virtual;

    public DDBinding(BeanResolver resolver, CommonDDBean sunBean, Map<String, Object> standardMap, Map<String, Object> annotationMap) {
        this(resolver, sunBean, standardMap, annotationMap, false);
    }

    public DDBinding(BeanResolver resolver, CommonDDBean sunBean, Map<String, Object> standardMap, Map<String, Object> annotationMap, boolean virtual) {
        this.resolver = resolver;
        this.sunBean = sunBean;
        this.standardMap = standardMap;
        this.annotationMap = annotationMap;
        this.virtual = virtual;
    }

    public String getBeanName() {
        return this.resolver.getBeanName(this.sunBean);
    }

    public String getBindingName() {
        Object value = this.getProperty(PROP_NAME);
        return value instanceof String ? (String)value : "";
    }

    public CommonDDBean getSunBean() {
        return this.sunBean;
    }

    public boolean hasStandardDDBinding() {
        return this.standardMap != null;
    }

    public boolean hasAnnotationBinding() {
        return this.annotationMap != null;
    }

    public boolean isBound() {
        return this.standardMap != null || this.annotationMap != null;
    }

    public boolean isAnnotated() {
        return this.annotationMap != null;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public void clearVirtual() {
        this.virtual = false;
    }

    public Object getProperty(String property) {
        return this.standardMap != null ? this.standardMap.get(property) : (this.annotationMap != null ? this.annotationMap.get(property) : null);
    }

    public DDBinding rebind(CommonDDBean newSunBean) {
        return new DDBinding(this.resolver, newSunBean, this.standardMap, this.annotationMap, this.virtual);
    }

    @Override
    public int compareTo(DDBinding other) {
        return Utils.strCompareTo(this.getBeanName(), other.getBeanName());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DDBinding other = (DDBinding)obj;
        if (!(this.sunBean == other.sunBean || this.sunBean != null && this.sunBean.equals((Object)other.sunBean))) {
            return false;
        }
        if (this.standardMap != other.standardMap) {
            if (this.standardMap == null || other.standardMap == null) {
                return false;
            }
            if (!DDBinding.compareMap(this.standardMap, other.standardMap)) {
                return false;
            }
        }
        if (this.annotationMap != other.annotationMap) {
            if (this.annotationMap == null || other.annotationMap == null) {
                return false;
            }
            if (!DDBinding.compareMap(this.annotationMap, other.annotationMap)) {
                return false;
            }
        }
        return true;
    }

    private static boolean compareMap(Map<String, Object> a, Map<String, Object> b) {
        if (a.size() != b.size()) {
            return false;
        }
        for (Map.Entry<String, Object> a_entry : a.entrySet()) {
            Object b_object;
            Object a_object = a_entry.getValue();
            if (a_object == (b_object = b.get(a_entry.getKey()))) continue;
            if (a_object == null || b_object == null) {
                return false;
            }
            if (a_object instanceof String) {
                if (b_object instanceof String && ((String)a_object).equals((String)b_object)) continue;
                return false;
            }
            if (a_object instanceof Map) {
                if (b_object instanceof Map && DDBinding.compareMap((Map)a_object, (Map)b_object)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (this.sunBean != null ? this.sunBean.hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(128);
        builder.append("sun DD: ");
        builder.append(this.sunBean != null ? this.getBeanName() : "(null)");
        builder.append(", Standard DD: ");
        builder.append(this.standardMap != null ? this.standardMap.get(PROP_NAME) : "(null)");
        builder.append(", Annotation: ");
        builder.append(this.annotationMap != null ? this.annotationMap.get(PROP_NAME) : "(null)");
        return builder.toString();
    }
}

