/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;

public class Files {
    public static String readFile(File file) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            String string = Files.readFile(fileInputStream);
            return string;
        }
    }

    public static String readFile(InputStream inputStream) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = bufferedReader.readLine();
        while (string != null) {
            stringBuilder.append(string + "\n");
            string = bufferedReader.readLine();
        }
        return stringBuilder.toString();
    }

    public static void writeFile(String string, File file) throws IOException {
        file.getParentFile().mkdirs();
        try (FileWriter fileWriter = new FileWriter(file);
             BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);){
            bufferedWriter.write(string);
        }
    }

    public static void copyFile(InputStream inputStream, File file) throws IOException {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            byte[] byArray = new byte[65536];
            int n = inputStream.read(byArray);
            while (n > 0) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
                n = inputStream.read(byArray);
            }
        }
    }

    public static String streamToString(InputStream inputStream) throws IOException {
        if (inputStream != null) {
            StringWriter stringWriter = new StringWriter();
            char[] cArray = new char[1024];
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                int n;
                while ((n = bufferedReader.read(cArray)) != -1) {
                    ((Writer)stringWriter).write(cArray, 0, n);
                }
            }
            return ((Object)stringWriter).toString();
        }
        return "";
    }
}

