/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.devops.model.MirrorRepositoryConfig;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Repository
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="namespace")
    private final String namespace;
    @JsonProperty(value="projectId")
    private final String projectId;
    @JsonProperty(value="projectName")
    private final String projectName;
    @JsonProperty(value="sshUrl")
    private final String sshUrl;
    @JsonProperty(value="httpUrl")
    private final String httpUrl;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="defaultBranch")
    private final String defaultBranch;
    @JsonProperty(value="repositoryType")
    private final RepositoryType repositoryType;
    @JsonProperty(value="mirrorRepositoryConfig")
    private final MirrorRepositoryConfig mirrorRepositoryConfig;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecyleDetails")
    private final String lifecyleDetails;
    @JsonProperty(value="branchCount")
    private final Integer branchCount;
    @JsonProperty(value="commitCount")
    private final Integer commitCount;
    @JsonProperty(value="sizeInBytes")
    private final Long sizeInBytes;
    @JsonProperty(value="triggerBuildEvents")
    private final List<TriggerBuildEvents> triggerBuildEvents;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;

    @Deprecated
    @ConstructorProperties(value={"id", "name", "compartmentId", "namespace", "projectId", "projectName", "sshUrl", "httpUrl", "description", "defaultBranch", "repositoryType", "mirrorRepositoryConfig", "timeCreated", "timeUpdated", "lifecycleState", "lifecyleDetails", "branchCount", "commitCount", "sizeInBytes", "triggerBuildEvents", "freeformTags", "definedTags", "systemTags"})
    public Repository(String id, String name, String compartmentId, String namespace, String projectId, String projectName, String sshUrl, String httpUrl, String description, String defaultBranch, RepositoryType repositoryType, MirrorRepositoryConfig mirrorRepositoryConfig, Date timeCreated, Date timeUpdated, LifecycleState lifecycleState, String lifecyleDetails, Integer branchCount, Integer commitCount, Long sizeInBytes, List<TriggerBuildEvents> triggerBuildEvents, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags) {
        this.id = id;
        this.name = name;
        this.compartmentId = compartmentId;
        this.namespace = namespace;
        this.projectId = projectId;
        this.projectName = projectName;
        this.sshUrl = sshUrl;
        this.httpUrl = httpUrl;
        this.description = description;
        this.defaultBranch = defaultBranch;
        this.repositoryType = repositoryType;
        this.mirrorRepositoryConfig = mirrorRepositoryConfig;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.lifecycleState = lifecycleState;
        this.lifecyleDetails = lifecyleDetails;
        this.branchCount = branchCount;
        this.commitCount = commitCount;
        this.sizeInBytes = sizeInBytes;
        this.triggerBuildEvents = triggerBuildEvents;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getSshUrl() {
        return this.sshUrl;
    }

    public String getHttpUrl() {
        return this.httpUrl;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDefaultBranch() {
        return this.defaultBranch;
    }

    public RepositoryType getRepositoryType() {
        return this.repositoryType;
    }

    public MirrorRepositoryConfig getMirrorRepositoryConfig() {
        return this.mirrorRepositoryConfig;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecyleDetails() {
        return this.lifecyleDetails;
    }

    public Integer getBranchCount() {
        return this.branchCount;
    }

    public Integer getCommitCount() {
        return this.commitCount;
    }

    public Long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public List<TriggerBuildEvents> getTriggerBuildEvents() {
        return this.triggerBuildEvents;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Repository(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", namespace=").append(String.valueOf(this.namespace));
        sb.append(", projectId=").append(String.valueOf(this.projectId));
        sb.append(", projectName=").append(String.valueOf(this.projectName));
        sb.append(", sshUrl=").append(String.valueOf(this.sshUrl));
        sb.append(", httpUrl=").append(String.valueOf(this.httpUrl));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", defaultBranch=").append(String.valueOf(this.defaultBranch));
        sb.append(", repositoryType=").append(String.valueOf((Object)this.repositoryType));
        sb.append(", mirrorRepositoryConfig=").append(String.valueOf((Object)this.mirrorRepositoryConfig));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecyleDetails=").append(String.valueOf(this.lifecyleDetails));
        sb.append(", branchCount=").append(String.valueOf(this.branchCount));
        sb.append(", commitCount=").append(String.valueOf(this.commitCount));
        sb.append(", sizeInBytes=").append(String.valueOf(this.sizeInBytes));
        sb.append(", triggerBuildEvents=").append(String.valueOf(this.triggerBuildEvents));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Repository)) {
            return false;
        }
        Repository other = (Repository)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.namespace, other.namespace) && Objects.equals(this.projectId, other.projectId) && Objects.equals(this.projectName, other.projectName) && Objects.equals(this.sshUrl, other.sshUrl) && Objects.equals(this.httpUrl, other.httpUrl) && Objects.equals(this.description, other.description) && Objects.equals(this.defaultBranch, other.defaultBranch) && Objects.equals((Object)this.repositoryType, (Object)other.repositoryType) && Objects.equals((Object)this.mirrorRepositoryConfig, (Object)other.mirrorRepositoryConfig) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecyleDetails, other.lifecyleDetails) && Objects.equals(this.branchCount, other.branchCount) && Objects.equals(this.commitCount, other.commitCount) && Objects.equals(this.sizeInBytes, other.sizeInBytes) && Objects.equals(this.triggerBuildEvents, other.triggerBuildEvents) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.systemTags, other.systemTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.namespace == null ? 43 : this.namespace.hashCode());
        result = result * 59 + (this.projectId == null ? 43 : this.projectId.hashCode());
        result = result * 59 + (this.projectName == null ? 43 : this.projectName.hashCode());
        result = result * 59 + (this.sshUrl == null ? 43 : this.sshUrl.hashCode());
        result = result * 59 + (this.httpUrl == null ? 43 : this.httpUrl.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.defaultBranch == null ? 43 : this.defaultBranch.hashCode());
        result = result * 59 + (this.repositoryType == null ? 43 : this.repositoryType.hashCode());
        result = result * 59 + (this.mirrorRepositoryConfig == null ? 43 : this.mirrorRepositoryConfig.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecyleDetails == null ? 43 : this.lifecyleDetails.hashCode());
        result = result * 59 + (this.branchCount == null ? 43 : this.branchCount.hashCode());
        result = result * 59 + (this.commitCount == null ? 43 : this.commitCount.hashCode());
        result = result * 59 + (this.sizeInBytes == null ? 43 : this.sizeInBytes.hashCode());
        result = result * 59 + (this.triggerBuildEvents == null ? 43 : this.triggerBuildEvents.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum TriggerBuildEvents implements BmcEnum
    {
        Push("PUSH"),
        CommitUpdates("COMMIT_UPDATES"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, TriggerBuildEvents> map;

        private TriggerBuildEvents(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static TriggerBuildEvents create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'TriggerBuildEvents', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(TriggerBuildEvents.class);
            map = new HashMap<String, TriggerBuildEvents>();
            for (TriggerBuildEvents v : TriggerBuildEvents.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleState implements BmcEnum
    {
        Active("ACTIVE"),
        Creating("CREATING"),
        Deleted("DELETED"),
        Deleting("DELETING"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum RepositoryType implements BmcEnum
    {
        Mirrored("MIRRORED"),
        Hosted("HOSTED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, RepositoryType> map;

        private RepositoryType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static RepositoryType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'RepositoryType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(RepositoryType.class);
            map = new HashMap<String, RepositoryType>();
            for (RepositoryType v : RepositoryType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="namespace")
        private String namespace;
        @JsonProperty(value="projectId")
        private String projectId;
        @JsonProperty(value="projectName")
        private String projectName;
        @JsonProperty(value="sshUrl")
        private String sshUrl;
        @JsonProperty(value="httpUrl")
        private String httpUrl;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="defaultBranch")
        private String defaultBranch;
        @JsonProperty(value="repositoryType")
        private RepositoryType repositoryType;
        @JsonProperty(value="mirrorRepositoryConfig")
        private MirrorRepositoryConfig mirrorRepositoryConfig;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecyleDetails")
        private String lifecyleDetails;
        @JsonProperty(value="branchCount")
        private Integer branchCount;
        @JsonProperty(value="commitCount")
        private Integer commitCount;
        @JsonProperty(value="sizeInBytes")
        private Long sizeInBytes;
        @JsonProperty(value="triggerBuildEvents")
        private List<TriggerBuildEvents> triggerBuildEvents;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            this.__explicitlySet__.add("namespace");
            return this;
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            this.__explicitlySet__.add("projectId");
            return this;
        }

        public Builder projectName(String projectName) {
            this.projectName = projectName;
            this.__explicitlySet__.add("projectName");
            return this;
        }

        public Builder sshUrl(String sshUrl) {
            this.sshUrl = sshUrl;
            this.__explicitlySet__.add("sshUrl");
            return this;
        }

        public Builder httpUrl(String httpUrl) {
            this.httpUrl = httpUrl;
            this.__explicitlySet__.add("httpUrl");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder defaultBranch(String defaultBranch) {
            this.defaultBranch = defaultBranch;
            this.__explicitlySet__.add("defaultBranch");
            return this;
        }

        public Builder repositoryType(RepositoryType repositoryType) {
            this.repositoryType = repositoryType;
            this.__explicitlySet__.add("repositoryType");
            return this;
        }

        public Builder mirrorRepositoryConfig(MirrorRepositoryConfig mirrorRepositoryConfig) {
            this.mirrorRepositoryConfig = mirrorRepositoryConfig;
            this.__explicitlySet__.add("mirrorRepositoryConfig");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecyleDetails(String lifecyleDetails) {
            this.lifecyleDetails = lifecyleDetails;
            this.__explicitlySet__.add("lifecyleDetails");
            return this;
        }

        public Builder branchCount(Integer branchCount) {
            this.branchCount = branchCount;
            this.__explicitlySet__.add("branchCount");
            return this;
        }

        public Builder commitCount(Integer commitCount) {
            this.commitCount = commitCount;
            this.__explicitlySet__.add("commitCount");
            return this;
        }

        public Builder sizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
            this.__explicitlySet__.add("sizeInBytes");
            return this;
        }

        public Builder triggerBuildEvents(List<TriggerBuildEvents> triggerBuildEvents) {
            this.triggerBuildEvents = triggerBuildEvents;
            this.__explicitlySet__.add("triggerBuildEvents");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public Repository build() {
            Repository model = new Repository(this.id, this.name, this.compartmentId, this.namespace, this.projectId, this.projectName, this.sshUrl, this.httpUrl, this.description, this.defaultBranch, this.repositoryType, this.mirrorRepositoryConfig, this.timeCreated, this.timeUpdated, this.lifecycleState, this.lifecyleDetails, this.branchCount, this.commitCount, this.sizeInBytes, this.triggerBuildEvents, this.freeformTags, this.definedTags, this.systemTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Repository model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("namespace")) {
                this.namespace(model.getNamespace());
            }
            if (model.wasPropertyExplicitlySet("projectId")) {
                this.projectId(model.getProjectId());
            }
            if (model.wasPropertyExplicitlySet("projectName")) {
                this.projectName(model.getProjectName());
            }
            if (model.wasPropertyExplicitlySet("sshUrl")) {
                this.sshUrl(model.getSshUrl());
            }
            if (model.wasPropertyExplicitlySet("httpUrl")) {
                this.httpUrl(model.getHttpUrl());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("defaultBranch")) {
                this.defaultBranch(model.getDefaultBranch());
            }
            if (model.wasPropertyExplicitlySet("repositoryType")) {
                this.repositoryType(model.getRepositoryType());
            }
            if (model.wasPropertyExplicitlySet("mirrorRepositoryConfig")) {
                this.mirrorRepositoryConfig(model.getMirrorRepositoryConfig());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecyleDetails")) {
                this.lifecyleDetails(model.getLifecyleDetails());
            }
            if (model.wasPropertyExplicitlySet("branchCount")) {
                this.branchCount(model.getBranchCount());
            }
            if (model.wasPropertyExplicitlySet("commitCount")) {
                this.commitCount(model.getCommitCount());
            }
            if (model.wasPropertyExplicitlySet("sizeInBytes")) {
                this.sizeInBytes(model.getSizeInBytes());
            }
            if (model.wasPropertyExplicitlySet("triggerBuildEvents")) {
                this.triggerBuildEvents(model.getTriggerBuildEvents());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            return this;
        }
    }
}

