/**
Provides an interface to the OpenGL ES 2.0 graphics rendering context for the drawing surface of an HTML <canvas> element.

@returns {WebGLRenderingContext}
*/
WebGLRenderingContext = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {HTMLCanvasElement}
**/
WebGLRenderingContext.prototype.canvas = new HTMLCanvasElement();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLsizei
**/
WebGLRenderingContext.prototype.drawingBufferHeight = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLsizei
**/
WebGLRenderingContext.prototype.drawingBufferWidth = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} texture GLenum
@returns {undefined}
**/
WebGLRenderingContext.prototype.activeTexture = function(texture) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {WebGLProgram} program WebGLProgram
@param {WebGLShader} shader WebGLShader
@returns {undefined}
**/
WebGLRenderingContext.prototype.attachShader = function(program, shader) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {WebGLProgram} program WebGLProgram
@param {Number} index GLuint
@param {String} name
@returns {undefined}
**/
WebGLRenderingContext.prototype.bindAttribLocation = function(program, index, name) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} target GLenum
@param {(WebGLBuffer | null)} buffer WebGLBuffer | null
@returns {undefined}
**/
WebGLRenderingContext.prototype.bindBuffer = function(target, buffer) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} target GLenum
@param {(WebGLFramebuffer | null)} framebuffer WebGLFramebuffer | null
@returns {undefined}
**/
WebGLRenderingContext.prototype.bindFramebuffer = function(target, framebuffer) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} target GLenum
@param {(WebGLRenderbuffer | null)} renderbuffer WebGLRenderbuffer | null
@returns {undefined}
**/
WebGLRenderingContext.prototype.bindRenderbuffer = function(target, renderbuffer) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} target GLenum
@param {(WebGLTexture | null)} texture WebGLTexture | null
@returns {undefined}
**/
WebGLRenderingContext.prototype.bindTexture = function(target, texture) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} red GLclampf
@param {Number} green GLclampf
@param {Number} blue GLclampf
@param {Number} alpha GLclampf
@returns {undefined}
**/
WebGLRenderingContext.prototype.blendColor = function(red, green, blue, alpha) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} mode GLenum
@returns {undefined}
**/
WebGLRenderingContext.prototype.blendEquation = function(mode) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} modeRGB GLenum
@param {Number} modeAlpha GLenum
@returns {undefined}
**/
WebGLRenderingContext.prototype.blendEquationSeparate = function(modeRGB, modeAlpha) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} sfactor GLenum
@param {Number} dfactor GLenum
@returns {undefined}
**/
WebGLRenderingContext.prototype.blendFunc = function(sfactor, dfactor) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} srcRGB GLenum
@param {Number} dstRGB GLenum
@param {Number} srcAlpha GLenum
@param {Number} dstAlpha GLenum
@returns {undefined}
**/
WebGLRenderingContext.prototype.blendFuncSeparate = function(srcRGB, dstRGB, srcAlpha, dstAlpha) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} target GLenum
@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.checkFramebufferStatus = function(target) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} mask GLbitfield
@returns {undefined}
**/
WebGLRenderingContext.prototype.clear = function(mask) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} red GLclampf
@param {Number} green GLclampf
@param {Number} blue GLclampf
@param {Number} alpha GLclampf
@returns {undefined}
**/
WebGLRenderingContext.prototype.clearColor = function(red, green, blue, alpha) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} depth GLclampf
@returns {undefined}
**/
WebGLRenderingContext.prototype.clearDepth = function(depth) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} s GLint
@returns {undefined}
**/
WebGLRenderingContext.prototype.clearStencil = function(s) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Boolean} red GLboolean
@param {Boolean} green GLboolean
@param {Boolean} blue GLboolean
@param {Boolean} alpha GLboolean
@returns {undefined}
**/
WebGLRenderingContext.prototype.colorMask = function(red, green, blue, alpha) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {WebGLShader} shader WebGLShader
@returns {undefined}
**/
WebGLRenderingContext.prototype.compileShader = function(shader) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} target GLenum
@param {Number} level GLint
@param {Number} internalformat GLenum
@param {Number} x GLint
@param {Number} y GLint
@param {Number} width GLsizei
@param {Number} height GLsizei
@param {Number} border GLint
@returns {undefined}
**/
WebGLRenderingContext.prototype.copyTexImage2D = function(target, level, internalformat, x, y, width, height, border) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} target GLenum
@param {Number} level GLint
@param {Number} xoffset GLint
@param {Number} yoffset GLint
@param {Number} x GLint
@param {Number} y GLint
@param {Number} width GLsizei
@param {Number} height GLsizei
@returns {undefined}
**/
WebGLRenderingContext.prototype.copyTexSubImage2D = function(target, level, xoffset, yoffset, x, y, width, height) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(WebGLBuffer | null)} WebGLBuffer | null
**/
WebGLRenderingContext.prototype.createBuffer = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(WebGLFramebuffer | null)} WebGLFramebuffer | null
**/
WebGLRenderingContext.prototype.createFramebuffer = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(WebGLProgram | null)} WebGLProgram | null
**/
WebGLRenderingContext.prototype.createProgram = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(WebGLRenderbuffer | null)} WebGLRenderbuffer | null
**/
WebGLRenderingContext.prototype.createRenderbuffer = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} type GLenum
@returns {(WebGLShader | null)} WebGLShader | null
**/
WebGLRenderingContext.prototype.createShader = function(type) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(WebGLTexture | null)} WebGLTexture | null
**/
WebGLRenderingContext.prototype.createTexture = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} mode GLenum
@returns {undefined}
**/
WebGLRenderingContext.prototype.cullFace = function(mode) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(WebGLBuffer | null)} buffer WebGLBuffer | null
@returns {undefined}
**/
WebGLRenderingContext.prototype.deleteBuffer = function(buffer) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(WebGLFramebuffer | null)} framebuffer WebGLFramebuffer | null
@returns {undefined}
**/
WebGLRenderingContext.prototype.deleteFramebuffer = function(framebuffer) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(WebGLProgram | null)} program WebGLProgram | null
@returns {undefined}
**/
WebGLRenderingContext.prototype.deleteProgram = function(program) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(WebGLRenderbuffer | null)} renderbuffer WebGLRenderbuffer | null
@returns {undefined}
**/
WebGLRenderingContext.prototype.deleteRenderbuffer = function(renderbuffer) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(WebGLShader | null)} shader WebGLShader | null
@returns {undefined}
**/
WebGLRenderingContext.prototype.deleteShader = function(shader) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(WebGLTexture | null)} texture WebGLTexture | null
@returns {undefined}
**/
WebGLRenderingContext.prototype.deleteTexture = function(texture) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} func GLenum
@returns {undefined}
**/
WebGLRenderingContext.prototype.depthFunc = function(func) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Boolean} flag GLboolean
@returns {undefined}
**/
WebGLRenderingContext.prototype.depthMask = function(flag) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} zNear GLclampf
@param {Number} zFar GLclampf
@returns {undefined}
**/
WebGLRenderingContext.prototype.depthRange = function(zNear, zFar) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {WebGLProgram} program WebGLProgram
@param {WebGLShader} shader WebGLShader
@returns {undefined}
**/
WebGLRenderingContext.prototype.detachShader = function(program, shader) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} cap GLenum
@returns {undefined}
**/
WebGLRenderingContext.prototype.disable = function(cap) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} index GLuint
@returns {undefined}
**/
WebGLRenderingContext.prototype.disableVertexAttribArray = function(index) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} mode GLenum
@param {Number} first GLint
@param {Number} count GLsizei
@returns {undefined}
**/
WebGLRenderingContext.prototype.drawArrays = function(mode, first, count) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} mode GLenum
@param {Number} count GLsizei
@param {Number} type GLenum
@param {Number} offset GLintptr
@returns {undefined}
**/
WebGLRenderingContext.prototype.drawElements = function(mode, count, type, offset) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} cap GLenum
@returns {undefined}
**/
WebGLRenderingContext.prototype.enable = function(cap) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} index GLuint
@returns {undefined}
**/
WebGLRenderingContext.prototype.enableVertexAttribArray = function(index) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {undefined}
**/
WebGLRenderingContext.prototype.finish = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {undefined}
**/
WebGLRenderingContext.prototype.flush = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} target GLenum
@param {Number} attachment GLenum
@param {Number} renderbuffertarget GLenum
@param {(WebGLRenderbuffer | null)} renderbuffer WebGLRenderbuffer | null
@returns {undefined}
**/
WebGLRenderingContext.prototype.framebufferRenderbuffer = function(target, attachment, renderbuffertarget, renderbuffer) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} target GLenum
@param {Number} attachment GLenum
@param {Number} textarget GLenum
@param {(WebGLTexture | null)} texture WebGLTexture | null
@param {Number} level GLint
@returns {undefined}
**/
WebGLRenderingContext.prototype.framebufferTexture2D = function(target, attachment, textarget, texture, level) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} mode GLenum
@returns {undefined}
**/
WebGLRenderingContext.prototype.frontFace = function(mode) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} target GLenum
@returns {undefined}
**/
WebGLRenderingContext.prototype.generateMipmap = function(target) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {WebGLProgram} program WebGLProgram
@param {Number} index GLuint
@returns {(WebGLActiveInfo | null)} WebGLActiveInfo | null
**/
WebGLRenderingContext.prototype.getActiveAttrib = function(program, index) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {WebGLProgram} program WebGLProgram
@param {Number} index GLuint
@returns {(WebGLActiveInfo | null)} WebGLActiveInfo | null
**/
WebGLRenderingContext.prototype.getActiveUniform = function(program, index) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {WebGLProgram} program WebGLProgram
@returns {(WebGLShader[] | null)} WebGLShader[] | null
**/
WebGLRenderingContext.prototype.getAttachedShaders = function(program) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {WebGLProgram} program WebGLProgram
@param {String} name
@returns {Number} GLint
**/
WebGLRenderingContext.prototype.getAttribLocation = function(program, name) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} target GLenum
@param {Number} pname GLenum
@returns {Object}
**/
WebGLRenderingContext.prototype.getBufferParameter = function(target, pname) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(WebGLContextAttributes | null)} WebGLContextAttributes | null
**/
WebGLRenderingContext.prototype.getContextAttributes = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.getError = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {String} name
@returns {Object}
**/
WebGLRenderingContext.prototype.getExtension = function(name) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} target GLenum
@param {Number} attachment GLenum
@param {Number} pname GLenum
@returns {Object}
**/
WebGLRenderingContext.prototype.getFramebufferAttachmentParameter = function(target, attachment, pname) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} pname GLenum
@returns {Object}
**/
WebGLRenderingContext.prototype.getParameter = function(pname) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {WebGLProgram} program WebGLProgram
@returns {(String | null)} string | null
**/
WebGLRenderingContext.prototype.getProgramInfoLog = function(program) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {WebGLProgram} program WebGLProgram
@param {Number} pname GLenum
@returns {Object}
**/
WebGLRenderingContext.prototype.getProgramParameter = function(program, pname) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} target GLenum
@param {Number} pname GLenum
@returns {Object}
**/
WebGLRenderingContext.prototype.getRenderbufferParameter = function(target, pname) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {WebGLShader} shader WebGLShader
@returns {(String | null)} string | null
**/
WebGLRenderingContext.prototype.getShaderInfoLog = function(shader) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {WebGLShader} shader WebGLShader
@param {Number} pname GLenum
@returns {Object}
**/
WebGLRenderingContext.prototype.getShaderParameter = function(shader, pname) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} shadertype GLenum
@param {Number} precisiontype GLenum
@returns {(WebGLShaderPrecisionFormat | null)} WebGLShaderPrecisionFormat | null
**/
WebGLRenderingContext.prototype.getShaderPrecisionFormat = function(shadertype, precisiontype) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {WebGLShader} shader WebGLShader
@returns {(String | null)} string | null
**/
WebGLRenderingContext.prototype.getShaderSource = function(shader) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string[] | null
**/
WebGLRenderingContext.prototype.getSupportedExtensions = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} target GLenum
@param {Number} pname GLenum
@returns {Object}
**/
WebGLRenderingContext.prototype.getTexParameter = function(target, pname) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {WebGLProgram} program WebGLProgram
@param {WebGLUniformLocation} location WebGLUniformLocation
@returns {Object}
**/
WebGLRenderingContext.prototype.getUniform = function(program, location) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {WebGLProgram} program WebGLProgram
@param {String} name
@returns {(WebGLUniformLocation | null)} WebGLUniformLocation | null
**/
WebGLRenderingContext.prototype.getUniformLocation = function(program, name) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} index GLuint
@param {Number} pname GLenum
@returns {Object}
**/
WebGLRenderingContext.prototype.getVertexAttrib = function(index, pname) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} index GLuint
@param {Number} pname GLenum
@returns {Number} GLintptr
**/
WebGLRenderingContext.prototype.getVertexAttribOffset = function(index, pname) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} target GLenum
@param {Number} mode GLenum
@returns {undefined}
**/
WebGLRenderingContext.prototype.hint = function(target, mode) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(WebGLBuffer | null)} buffer WebGLBuffer | null
@returns {Boolean} GLboolean
**/
WebGLRenderingContext.prototype.isBuffer = function(buffer) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
WebGLRenderingContext.prototype.isContextLost = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} cap GLenum
@returns {Boolean} GLboolean
**/
WebGLRenderingContext.prototype.isEnabled = function(cap) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(WebGLFramebuffer | null)} framebuffer WebGLFramebuffer | null
@returns {Boolean} GLboolean
**/
WebGLRenderingContext.prototype.isFramebuffer = function(framebuffer) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(WebGLProgram | null)} program WebGLProgram | null
@returns {Boolean} GLboolean
**/
WebGLRenderingContext.prototype.isProgram = function(program) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(WebGLRenderbuffer | null)} renderbuffer WebGLRenderbuffer | null
@returns {Boolean} GLboolean
**/
WebGLRenderingContext.prototype.isRenderbuffer = function(renderbuffer) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(WebGLShader | null)} shader WebGLShader | null
@returns {Boolean} GLboolean
**/
WebGLRenderingContext.prototype.isShader = function(shader) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(WebGLTexture | null)} texture WebGLTexture | null
@returns {Boolean} GLboolean
**/
WebGLRenderingContext.prototype.isTexture = function(texture) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} width GLfloat
@returns {undefined}
**/
WebGLRenderingContext.prototype.lineWidth = function(width) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {WebGLProgram} program WebGLProgram
@returns {undefined}
**/
WebGLRenderingContext.prototype.linkProgram = function(program) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} pname GLenum
@param {(Number | Boolean)} param GLint | GLboolean
@returns {undefined}
**/
WebGLRenderingContext.prototype.pixelStorei = function(pname, param) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} factor GLfloat
@param {Number} units GLfloat
@returns {undefined}
**/
WebGLRenderingContext.prototype.polygonOffset = function(factor, units) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} target GLenum
@param {Number} internalformat GLenum
@param {Number} width GLsizei
@param {Number} height GLsizei
@returns {undefined}
**/
WebGLRenderingContext.prototype.renderbufferStorage = function(target, internalformat, width, height) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} value GLclampf
@param {Boolean} invert GLboolean
@returns {undefined}
**/
WebGLRenderingContext.prototype.sampleCoverage = function(value, invert) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} x GLint
@param {Number} y GLint
@param {Number} width GLsizei
@param {Number} height GLsizei
@returns {undefined}
**/
WebGLRenderingContext.prototype.scissor = function(x, y, width, height) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {WebGLShader} shader WebGLShader
@param {String} source
@returns {undefined}
**/
WebGLRenderingContext.prototype.shaderSource = function(shader, source) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} func GLenum
@param {Number} ref GLint
@param {Number} mask GLuint
@returns {undefined}
**/
WebGLRenderingContext.prototype.stencilFunc = function(func, ref, mask) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} face GLenum
@param {Number} func GLenum
@param {Number} ref GLint
@param {Number} mask GLuint
@returns {undefined}
**/
WebGLRenderingContext.prototype.stencilFuncSeparate = function(face, func, ref, mask) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} mask GLuint
@returns {undefined}
**/
WebGLRenderingContext.prototype.stencilMask = function(mask) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} face GLenum
@param {Number} mask GLuint
@returns {undefined}
**/
WebGLRenderingContext.prototype.stencilMaskSeparate = function(face, mask) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} fail GLenum
@param {Number} zfail GLenum
@param {Number} zpass GLenum
@returns {undefined}
**/
WebGLRenderingContext.prototype.stencilOp = function(fail, zfail, zpass) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} face GLenum
@param {Number} fail GLenum
@param {Number} zfail GLenum
@param {Number} zpass GLenum
@returns {undefined}
**/
WebGLRenderingContext.prototype.stencilOpSeparate = function(face, fail, zfail, zpass) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} target GLenum
@param {Number} pname GLenum
@param {Number} param GLfloat
@returns {undefined}
**/
WebGLRenderingContext.prototype.texParameterf = function(target, pname, param) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} target GLenum
@param {Number} pname GLenum
@param {Number} param GLint
@returns {undefined}
**/
WebGLRenderingContext.prototype.texParameteri = function(target, pname, param) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(WebGLUniformLocation | null)} location WebGLUniformLocation | null
@param {Number} x GLfloat
@returns {undefined}
**/
WebGLRenderingContext.prototype.uniform1f = function(location, x) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(WebGLUniformLocation | null)} location WebGLUniformLocation | null
@param {Number} x GLint
@returns {undefined}
**/
WebGLRenderingContext.prototype.uniform1i = function(location, x) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(WebGLUniformLocation | null)} location WebGLUniformLocation | null
@param {Number} x GLfloat
@param {Number} y GLfloat
@returns {undefined}
**/
WebGLRenderingContext.prototype.uniform2f = function(location, x, y) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(WebGLUniformLocation | null)} location WebGLUniformLocation | null
@param {Number} x GLint
@param {Number} y GLint
@returns {undefined}
**/
WebGLRenderingContext.prototype.uniform2i = function(location, x, y) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(WebGLUniformLocation | null)} location WebGLUniformLocation | null
@param {Number} x GLfloat
@param {Number} y GLfloat
@param {Number} z GLfloat
@returns {undefined}
**/
WebGLRenderingContext.prototype.uniform3f = function(location, x, y, z) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(WebGLUniformLocation | null)} location WebGLUniformLocation | null
@param {Number} x GLint
@param {Number} y GLint
@param {Number} z GLint
@returns {undefined}
**/
WebGLRenderingContext.prototype.uniform3i = function(location, x, y, z) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(WebGLUniformLocation | null)} location WebGLUniformLocation | null
@param {Number} x GLfloat
@param {Number} y GLfloat
@param {Number} z GLfloat
@param {Number} w GLfloat
@returns {undefined}
**/
WebGLRenderingContext.prototype.uniform4f = function(location, x, y, z, w) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(WebGLUniformLocation | null)} location WebGLUniformLocation | null
@param {Number} x GLint
@param {Number} y GLint
@param {Number} z GLint
@param {Number} w GLint
@returns {undefined}
**/
WebGLRenderingContext.prototype.uniform4i = function(location, x, y, z, w) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(WebGLProgram | null)} program WebGLProgram | null
@returns {undefined}
**/
WebGLRenderingContext.prototype.useProgram = function(program) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {WebGLProgram} program WebGLProgram
@returns {undefined}
**/
WebGLRenderingContext.prototype.validateProgram = function(program) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} index GLuint
@param {Number} x GLfloat
@returns {undefined}
**/
WebGLRenderingContext.prototype.vertexAttrib1f = function(index, x) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.iterable.d.ts
/**


@param {Number} index GLuint
@param {Iterable} values Iterable
@returns {undefined}
**/
WebGLRenderingContext.prototype.vertexAttrib1fv = function(index, values) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} index GLuint
@param {Number} x GLfloat
@param {Number} y GLfloat
@returns {undefined}
**/
WebGLRenderingContext.prototype.vertexAttrib2f = function(index, x, y) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.iterable.d.ts
/**


@param {Number} index GLuint
@param {Iterable} values Iterable
@returns {undefined}
**/
WebGLRenderingContext.prototype.vertexAttrib2fv = function(index, values) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} index GLuint
@param {Number} x GLfloat
@param {Number} y GLfloat
@param {Number} z GLfloat
@returns {undefined}
**/
WebGLRenderingContext.prototype.vertexAttrib3f = function(index, x, y, z) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.iterable.d.ts
/**


@param {Number} index GLuint
@param {Iterable} values Iterable
@returns {undefined}
**/
WebGLRenderingContext.prototype.vertexAttrib3fv = function(index, values) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} index GLuint
@param {Number} x GLfloat
@param {Number} y GLfloat
@param {Number} z GLfloat
@param {Number} w GLfloat
@returns {undefined}
**/
WebGLRenderingContext.prototype.vertexAttrib4f = function(index, x, y, z, w) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.iterable.d.ts
/**


@param {Number} index GLuint
@param {Iterable} values Iterable
@returns {undefined}
**/
WebGLRenderingContext.prototype.vertexAttrib4fv = function(index, values) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} index GLuint
@param {Number} size GLint
@param {Number} type GLenum
@param {Boolean} normalized GLboolean
@param {Number} stride GLsizei
@param {Number} offset GLintptr
@returns {undefined}
**/
WebGLRenderingContext.prototype.vertexAttribPointer = function(index, size, type, normalized, stride, offset) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} x GLint
@param {Number} y GLint
@param {Number} width GLsizei
@param {Number} height GLsizei
@returns {undefined}
**/
WebGLRenderingContext.prototype.viewport = function(x, y, width, height) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.ACTIVE_ATTRIBUTES = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.ACTIVE_TEXTURE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.ACTIVE_UNIFORMS = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.ALIASED_LINE_WIDTH_RANGE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.ALIASED_POINT_SIZE_RANGE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.ALPHA = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.ALPHA_BITS = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.ALWAYS = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.ARRAY_BUFFER = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.ARRAY_BUFFER_BINDING = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.ATTACHED_SHADERS = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.BACK = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.BLEND = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.BLEND_COLOR = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.BLEND_DST_ALPHA = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.BLEND_DST_RGB = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.BLEND_EQUATION = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.BLEND_EQUATION_ALPHA = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.BLEND_EQUATION_RGB = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.BLEND_SRC_ALPHA = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.BLEND_SRC_RGB = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.BLUE_BITS = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.BOOL = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.BOOL_VEC2 = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.BOOL_VEC3 = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.BOOL_VEC4 = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.BROWSER_DEFAULT_WEBGL = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.BUFFER_SIZE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.BUFFER_USAGE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.BYTE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.CCW = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.CLAMP_TO_EDGE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.COLOR_ATTACHMENT0 = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.COLOR_BUFFER_BIT = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.COLOR_CLEAR_VALUE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.COLOR_WRITEMASK = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.COMPILE_STATUS = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.COMPRESSED_TEXTURE_FORMATS = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.CONSTANT_ALPHA = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.CONSTANT_COLOR = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.CONTEXT_LOST_WEBGL = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.CULL_FACE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.CULL_FACE_MODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.CURRENT_PROGRAM = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.CURRENT_VERTEX_ATTRIB = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.CW = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.DECR = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.DECR_WRAP = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.DELETE_STATUS = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.DEPTH_ATTACHMENT = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.DEPTH_BITS = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.DEPTH_BUFFER_BIT = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.DEPTH_CLEAR_VALUE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.DEPTH_COMPONENT = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.DEPTH_COMPONENT16 = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.DEPTH_FUNC = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.DEPTH_RANGE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.DEPTH_STENCIL = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.DEPTH_STENCIL_ATTACHMENT = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.DEPTH_TEST = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.DEPTH_WRITEMASK = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.DITHER = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.DONT_CARE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.DST_ALPHA = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.DST_COLOR = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.DYNAMIC_DRAW = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.ELEMENT_ARRAY_BUFFER = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.ELEMENT_ARRAY_BUFFER_BINDING = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.EQUAL = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.FASTEST = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.FLOAT = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.FLOAT_MAT2 = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.FLOAT_MAT3 = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.FLOAT_MAT4 = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.FLOAT_VEC2 = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.FLOAT_VEC3 = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.FLOAT_VEC4 = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.FRAGMENT_SHADER = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.FRAMEBUFFER = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.FRAMEBUFFER_ATTACHMENT_OBJECT_NAME = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.FRAMEBUFFER_BINDING = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.FRAMEBUFFER_COMPLETE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.FRAMEBUFFER_INCOMPLETE_ATTACHMENT = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.FRAMEBUFFER_INCOMPLETE_DIMENSIONS = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.FRAMEBUFFER_UNSUPPORTED = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.FRONT = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.FRONT_AND_BACK = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.FRONT_FACE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.FUNC_ADD = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.FUNC_REVERSE_SUBTRACT = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.FUNC_SUBTRACT = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.GENERATE_MIPMAP_HINT = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.GEQUAL = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.GREATER = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.GREEN_BITS = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.HIGH_FLOAT = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.HIGH_INT = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.IMPLEMENTATION_COLOR_READ_FORMAT = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.IMPLEMENTATION_COLOR_READ_TYPE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.INCR = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.INCR_WRAP = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.INT = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.INT_VEC2 = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.INT_VEC3 = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.INT_VEC4 = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.INVALID_ENUM = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.INVALID_FRAMEBUFFER_OPERATION = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.INVALID_OPERATION = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.INVALID_VALUE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.INVERT = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.KEEP = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.LEQUAL = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.LESS = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.LINEAR = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.LINEAR_MIPMAP_LINEAR = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.LINEAR_MIPMAP_NEAREST = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.LINES = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.LINE_LOOP = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.LINE_STRIP = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.LINE_WIDTH = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.LINK_STATUS = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.LOW_FLOAT = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.LOW_INT = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.LUMINANCE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.LUMINANCE_ALPHA = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.MAX_COMBINED_TEXTURE_IMAGE_UNITS = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.MAX_CUBE_MAP_TEXTURE_SIZE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.MAX_FRAGMENT_UNIFORM_VECTORS = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.MAX_RENDERBUFFER_SIZE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.MAX_TEXTURE_IMAGE_UNITS = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.MAX_TEXTURE_SIZE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.MAX_VARYING_VECTORS = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.MAX_VERTEX_ATTRIBS = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.MAX_VERTEX_TEXTURE_IMAGE_UNITS = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.MAX_VERTEX_UNIFORM_VECTORS = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.MAX_VIEWPORT_DIMS = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.MEDIUM_FLOAT = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.MEDIUM_INT = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.MIRRORED_REPEAT = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.NEAREST = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.NEAREST_MIPMAP_LINEAR = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.NEAREST_MIPMAP_NEAREST = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.NEVER = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.NICEST = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.NONE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.NOTEQUAL = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.NO_ERROR = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.ONE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.ONE_MINUS_CONSTANT_ALPHA = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.ONE_MINUS_CONSTANT_COLOR = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.ONE_MINUS_DST_ALPHA = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.ONE_MINUS_DST_COLOR = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.ONE_MINUS_SRC_ALPHA = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.ONE_MINUS_SRC_COLOR = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.OUT_OF_MEMORY = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.PACK_ALIGNMENT = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.POINTS = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.POLYGON_OFFSET_FACTOR = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.POLYGON_OFFSET_FILL = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.POLYGON_OFFSET_UNITS = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.RED_BITS = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.RENDERBUFFER = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.RENDERBUFFER_ALPHA_SIZE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.RENDERBUFFER_BINDING = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.RENDERBUFFER_BLUE_SIZE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.RENDERBUFFER_DEPTH_SIZE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.RENDERBUFFER_GREEN_SIZE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.RENDERBUFFER_HEIGHT = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.RENDERBUFFER_INTERNAL_FORMAT = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.RENDERBUFFER_RED_SIZE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.RENDERBUFFER_STENCIL_SIZE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.RENDERBUFFER_WIDTH = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.RENDERER = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.REPEAT = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.REPLACE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.RGB = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.RGB565 = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.RGB5_A1 = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.RGBA = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.RGBA4 = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.SAMPLER_2D = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.SAMPLER_CUBE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.SAMPLES = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.SAMPLE_ALPHA_TO_COVERAGE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.SAMPLE_BUFFERS = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.SAMPLE_COVERAGE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.SAMPLE_COVERAGE_INVERT = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.SAMPLE_COVERAGE_VALUE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.SCISSOR_BOX = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.SCISSOR_TEST = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.SHADER_TYPE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.SHADING_LANGUAGE_VERSION = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.SHORT = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.SRC_ALPHA = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.SRC_ALPHA_SATURATE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.SRC_COLOR = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.STATIC_DRAW = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.STENCIL_ATTACHMENT = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.STENCIL_BACK_FAIL = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.STENCIL_BACK_FUNC = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.STENCIL_BACK_PASS_DEPTH_FAIL = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.STENCIL_BACK_PASS_DEPTH_PASS = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.STENCIL_BACK_REF = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.STENCIL_BACK_VALUE_MASK = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.STENCIL_BACK_WRITEMASK = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.STENCIL_BITS = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.STENCIL_BUFFER_BIT = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.STENCIL_CLEAR_VALUE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.STENCIL_FAIL = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.STENCIL_FUNC = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.STENCIL_INDEX8 = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.STENCIL_PASS_DEPTH_FAIL = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.STENCIL_PASS_DEPTH_PASS = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.STENCIL_REF = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.STENCIL_TEST = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.STENCIL_VALUE_MASK = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.STENCIL_WRITEMASK = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.STREAM_DRAW = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.SUBPIXEL_BITS = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.TEXTURE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.TEXTURE0 = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.TEXTURE1 = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.TEXTURE10 = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.TEXTURE11 = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.TEXTURE12 = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.TEXTURE13 = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.TEXTURE14 = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.TEXTURE15 = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.TEXTURE16 = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.TEXTURE17 = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.TEXTURE18 = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.TEXTURE19 = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.TEXTURE2 = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.TEXTURE20 = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.TEXTURE21 = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.TEXTURE22 = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.TEXTURE23 = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.TEXTURE24 = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.TEXTURE25 = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.TEXTURE26 = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.TEXTURE27 = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.TEXTURE28 = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.TEXTURE29 = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.TEXTURE3 = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.TEXTURE30 = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.TEXTURE31 = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.TEXTURE4 = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.TEXTURE5 = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.TEXTURE6 = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.TEXTURE7 = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.TEXTURE8 = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.TEXTURE9 = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.TEXTURE_2D = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.TEXTURE_BINDING_2D = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.TEXTURE_BINDING_CUBE_MAP = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.TEXTURE_CUBE_MAP = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.TEXTURE_CUBE_MAP_NEGATIVE_X = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.TEXTURE_CUBE_MAP_NEGATIVE_Y = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.TEXTURE_CUBE_MAP_NEGATIVE_Z = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.TEXTURE_CUBE_MAP_POSITIVE_X = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.TEXTURE_CUBE_MAP_POSITIVE_Y = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.TEXTURE_CUBE_MAP_POSITIVE_Z = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.TEXTURE_MAG_FILTER = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.TEXTURE_MIN_FILTER = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.TEXTURE_WRAP_S = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.TEXTURE_WRAP_T = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.TRIANGLES = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.TRIANGLE_FAN = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.TRIANGLE_STRIP = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.UNPACK_ALIGNMENT = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.UNPACK_COLORSPACE_CONVERSION_WEBGL = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.UNPACK_FLIP_Y_WEBGL = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.UNPACK_PREMULTIPLY_ALPHA_WEBGL = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.UNSIGNED_BYTE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.UNSIGNED_INT = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.UNSIGNED_SHORT = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.UNSIGNED_SHORT_4_4_4_4 = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.UNSIGNED_SHORT_5_5_5_1 = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.UNSIGNED_SHORT_5_6_5 = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.VALIDATE_STATUS = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.VENDOR = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.VERSION = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.VERTEX_ATTRIB_ARRAY_BUFFER_BINDING = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.VERTEX_ATTRIB_ARRAY_ENABLED = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.VERTEX_ATTRIB_ARRAY_NORMALIZED = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.VERTEX_ATTRIB_ARRAY_POINTER = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.VERTEX_ATTRIB_ARRAY_SIZE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.VERTEX_ATTRIB_ARRAY_STRIDE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.VERTEX_ATTRIB_ARRAY_TYPE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.VERTEX_SHADER = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.VIEWPORT = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} GLenum
**/
WebGLRenderingContext.prototype.ZERO = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} target GLenum
@param {(ArrayBufferView | ArrayBuffer | null)} data BufferSource | null
@param {Number} usage GLenum
@returns {undefined}
**/
WebGLRenderingContext.prototype.bufferData = function(target, data, usage) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} target GLenum
@param {Number} offset GLintptr
@param {(ArrayBufferView | ArrayBuffer)} data BufferSource
@returns {undefined}
**/
WebGLRenderingContext.prototype.bufferSubData = function(target, offset, data) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} target GLenum
@param {Number} level GLint
@param {Number} internalformat GLenum
@param {Number} width GLsizei
@param {Number} height GLsizei
@param {Number} border GLint
@param {ArrayBufferView} data ArrayBufferView
@returns {undefined}
**/
WebGLRenderingContext.prototype.compressedTexImage2D = function(target, level, internalformat, width, height, border, data) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} target GLenum
@param {Number} level GLint
@param {Number} xoffset GLint
@param {Number} yoffset GLint
@param {Number} width GLsizei
@param {Number} height GLsizei
@param {Number} format GLenum
@param {ArrayBufferView} data ArrayBufferView
@returns {undefined}
**/
WebGLRenderingContext.prototype.compressedTexSubImage2D = function(target, level, xoffset, yoffset, width, height, format, data) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} x GLint
@param {Number} y GLint
@param {Number} width GLsizei
@param {Number} height GLsizei
@param {Number} format GLenum
@param {Number} type GLenum
@param {(ArrayBufferView | null)} pixels ArrayBufferView | null
@returns {undefined}
**/
WebGLRenderingContext.prototype.readPixels = function(x, y, width, height, format, type, pixels) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} target GLenum
@param {Number} level GLint
@param {Number} internalformat GLint
@param {Number} format GLenum
@param {Number} type GLenum
@param {(ImageBitmap | ImageData | HTMLImageElement | HTMLCanvasElement | HTMLVideoElement)} source TexImageSource
@returns {undefined}
**/
WebGLRenderingContext.prototype.texImage2D = function(target, level, internalformat, format, type, source) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} target GLenum
@param {Number} level GLint
@param {Number} xoffset GLint
@param {Number} yoffset GLint
@param {Number} format GLenum
@param {Number} type GLenum
@param {(ImageBitmap | ImageData | HTMLImageElement | HTMLCanvasElement | HTMLVideoElement)} source TexImageSource
@returns {undefined}
**/
WebGLRenderingContext.prototype.texSubImage2D = function(target, level, xoffset, yoffset, format, type, source) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.iterable.d.ts
/**


@param {(WebGLUniformLocation | null)} location WebGLUniformLocation | null
@param {Iterable} v Iterable
@returns {undefined}
**/
WebGLRenderingContext.prototype.uniform1fv = function(location, v) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.iterable.d.ts
/**


@param {(WebGLUniformLocation | null)} location WebGLUniformLocation | null
@param {Iterable} v Iterable
@returns {undefined}
**/
WebGLRenderingContext.prototype.uniform1iv = function(location, v) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.iterable.d.ts
/**


@param {(WebGLUniformLocation | null)} location WebGLUniformLocation | null
@param {Iterable} v Iterable
@returns {undefined}
**/
WebGLRenderingContext.prototype.uniform2fv = function(location, v) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.iterable.d.ts
/**


@param {(WebGLUniformLocation | null)} location WebGLUniformLocation | null
@param {Iterable} v Iterable
@returns {undefined}
**/
WebGLRenderingContext.prototype.uniform2iv = function(location, v) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.iterable.d.ts
/**


@param {(WebGLUniformLocation | null)} location WebGLUniformLocation | null
@param {Iterable} v Iterable
@returns {undefined}
**/
WebGLRenderingContext.prototype.uniform3fv = function(location, v) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.iterable.d.ts
/**


@param {(WebGLUniformLocation | null)} location WebGLUniformLocation | null
@param {Iterable} v Iterable
@returns {undefined}
**/
WebGLRenderingContext.prototype.uniform3iv = function(location, v) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.iterable.d.ts
/**


@param {(WebGLUniformLocation | null)} location WebGLUniformLocation | null
@param {Iterable} v Iterable
@returns {undefined}
**/
WebGLRenderingContext.prototype.uniform4fv = function(location, v) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.iterable.d.ts
/**


@param {(WebGLUniformLocation | null)} location WebGLUniformLocation | null
@param {Iterable} v Iterable
@returns {undefined}
**/
WebGLRenderingContext.prototype.uniform4iv = function(location, v) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.iterable.d.ts
/**


@param {(WebGLUniformLocation | null)} location WebGLUniformLocation | null
@param {Boolean} transpose GLboolean
@param {Iterable} value Iterable
@returns {undefined}
**/
WebGLRenderingContext.prototype.uniformMatrix2fv = function(location, transpose, value) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.iterable.d.ts
/**


@param {(WebGLUniformLocation | null)} location WebGLUniformLocation | null
@param {Boolean} transpose GLboolean
@param {Iterable} value Iterable
@returns {undefined}
**/
WebGLRenderingContext.prototype.uniformMatrix3fv = function(location, transpose, value) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.iterable.d.ts
/**


@param {(WebGLUniformLocation | null)} location WebGLUniformLocation | null
@param {Boolean} transpose GLboolean
@param {Iterable} value Iterable
@returns {undefined}
**/
WebGLRenderingContext.prototype.uniformMatrix4fv = function(location, transpose, value) {};

