/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import java.io.IOException;
import java.time.Instant;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.DocRequest;
import org.opensearch.ad.indices.ADIndex;
import org.opensearch.ad.model.AnomalyDetector;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;

public class PreviewAnomalyDetectorRequest
extends ActionRequest
implements DocRequest {
    private AnomalyDetector detector;
    private String detectorId;
    private Instant startTime;
    private Instant endTime;

    public PreviewAnomalyDetectorRequest(StreamInput in) throws IOException {
        super(in);
        this.detector = new AnomalyDetector(in);
        this.detectorId = in.readOptionalString();
        this.startTime = in.readInstant();
        this.endTime = in.readInstant();
    }

    public PreviewAnomalyDetectorRequest(AnomalyDetector detector, String detectorId, Instant startTime, Instant endTime) throws IOException {
        this.detector = detector;
        this.detectorId = detectorId;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public AnomalyDetector getDetector() {
        return this.detector;
    }

    public String getId() {
        return this.detectorId;
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public Instant getEndTime() {
        return this.endTime;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.detector.writeTo(out);
        out.writeOptionalString(this.detectorId);
        out.writeInstant(this.startTime);
        out.writeInstant(this.endTime);
    }

    public ActionRequestValidationException validate() {
        return null;
    }

    public String type() {
        return "anomaly-detector";
    }

    public String index() {
        return ADIndex.CONFIG.getIndexName();
    }

    public String id() {
        return this.detectorId;
    }
}

