/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.caching;

import java.time.Clock;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.timeseries.annotation.Generated;

public class PriorityTracker {
    private static final Logger LOG = LogManager.getLogger(PriorityTracker.class);
    private final ConcurrentHashMap<String, PriorityNode> key2Priority = new ConcurrentHashMap();
    private long landmarkEpoch;
    private final ConcurrentSkipListSet<PriorityNode> priorityList;
    private final Clock clock;
    private final long intervalSecs;
    private final int DECAY_CONSTANT;
    private final int maxEntities;

    public PriorityTracker(Clock clock, long intervalSecs, long landmarkEpoch, int maxEntities) {
        this.clock = clock;
        this.intervalSecs = intervalSecs;
        this.landmarkEpoch = landmarkEpoch;
        this.priorityList = new ConcurrentSkipListSet<PriorityNode>(new PriorityNodeComparator());
        this.DECAY_CONSTANT = 3;
        this.maxEntities = maxEntities;
    }

    public Optional<Map.Entry<String, Float>> getMinimumScaledPriority() {
        if (this.priorityList.isEmpty()) {
            return Optional.empty();
        }
        PriorityNode smallest = this.priorityList.first();
        return Optional.of(new AbstractMap.SimpleImmutableEntry<String, Float>(smallest.key, Float.valueOf(this.getScaledPriority(smallest.priority))));
    }

    public Optional<Map.Entry<String, Float>> getMinimumPriority() {
        if (this.priorityList.isEmpty()) {
            return Optional.empty();
        }
        PriorityNode smallest = this.priorityList.first();
        return Optional.of(new AbstractMap.SimpleImmutableEntry<String, Float>(smallest.key, Float.valueOf(smallest.priority)));
    }

    public Optional<String> getMinimumPriorityEntityId() {
        if (this.priorityList.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.priorityList).map(list -> (PriorityNode)list.first()).map(node -> node.key);
    }

    public Optional<String> getHighestPriorityEntityId() {
        if (this.priorityList.isEmpty()) {
            return Optional.empty();
        }
        String key = this.priorityList.last().key;
        return Optional.of(key);
    }

    public float updatePriority(String entityId) {
        PriorityNode node = this.key2Priority.computeIfAbsent(entityId, k -> new PriorityNode(entityId, 0.0f));
        this.priorityList.remove(node);
        node.priority = this.getUpdatedPriority(node.priority);
        this.priorityList.add(node);
        this.adjustSizeIfRequired();
        return node.priority;
    }

    public void addPriority(String entityId, float priority) {
        PriorityNode node = new PriorityNode(entityId, priority);
        this.key2Priority.put(entityId, node);
        this.priorityList.add(node);
        this.adjustSizeIfRequired();
    }

    private void adjustSizeIfRequired() {
        Optional<String> minPriorityId;
        if (this.key2Priority.size() > this.maxEntities && (minPriorityId = this.getMinimumPriorityEntityId()).isPresent()) {
            this.removePriority(minPriorityId.get());
        }
    }

    public void removePriority(String entityId) {
        this.priorityList.remove(new PriorityNode(entityId, 0.0f));
        this.key2Priority.remove(entityId);
    }

    public void clearPriority() {
        this.key2Priority.clear();
        this.priorityList.clear();
    }

    public float getUpdatedPriority(float oldPriority) {
        long increment = this.computeWeightedPriorityIncrement();
        if ((oldPriority = (float)((double)oldPriority + Math.log(1.0 + Math.exp((float)increment - oldPriority)))) == Float.POSITIVE_INFINITY) {
            oldPriority = increment;
        }
        return oldPriority;
    }

    public float getScaledPriority(float currentPriority) {
        return currentPriority - (float)this.computeWeightedPriorityIncrement();
    }

    long computeWeightedPriorityIncrement() {
        long periods = (this.clock.instant().getEpochSecond() - this.landmarkEpoch) / this.intervalSecs;
        return periods >> this.DECAY_CONSTANT;
    }

    public List<String> getTopNEntities(int n) {
        ArrayList<String> entities = new ArrayList<String>();
        Iterator<PriorityNode> entityIterator = this.priorityList.descendingIterator();
        for (int i = 0; i < n && entityIterator.hasNext(); ++i) {
            entities.add(entityIterator.next().key);
        }
        return entities;
    }

    public int size() {
        return this.key2Priority.size();
    }

    static class PriorityNodeComparator
    implements Comparator<PriorityNode> {
        PriorityNodeComparator() {
        }

        @Override
        public int compare(PriorityNode priority, PriorityNode priority2) {
            int equality = priority.key.compareTo(priority2.key);
            if (equality == 0) {
                return 0;
            }
            int cmp = Float.compare(priority.priority, priority2.priority);
            if (cmp == 0) {
                cmp = equality;
            }
            return cmp;
        }
    }

    static class PriorityNode {
        private String key;
        private float priority;

        PriorityNode(String key, float priority) {
            this.priority = priority;
            this.key = key;
        }

        @Generated
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            if (obj instanceof PriorityNode) {
                PriorityNode other = (PriorityNode)obj;
                EqualsBuilder equalsBuilder = new EqualsBuilder();
                equalsBuilder.append((Object)this.key, (Object)other.key);
                return equalsBuilder.isEquals();
            }
            return false;
        }

        @Generated
        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.key).toHashCode();
        }

        @Generated
        public String toString() {
            ToStringBuilder builder = new ToStringBuilder((Object)this);
            builder.append("key", (Object)this.key);
            builder.append("priority", this.priority);
            return builder.toString();
        }
    }
}

