"use strict";
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const MathJax = __importStar(require("@nteract/mathjax"));
const presentational_components_1 = require("@nteract/presentational-components");
const react_1 = __importDefault(require("react"));
const react_markdown_1 = __importDefault(require("react-markdown"));
const remark_math_1 = __importDefault(require("./remark-math"));
const attachment_transformer_1 = __importDefault(require("./attachment/attachment-transformer"));
const math = (props) => (react_1.default.createElement(MathJax.Node, null, props.value));
const inlineMath = (props) => (react_1.default.createElement(MathJax.Node, { inline: true }, props.value));
const code = (props) => (react_1.default.createElement(presentational_components_1.Source, { language: props.language }, props.value));
const MarkdownRender = (props) => {
    var _a;
    const newProps = Object.assign(Object.assign({}, props), { className: `markdown-body ${(_a = props.className) !== null && _a !== void 0 ? _a : ""}`, renderers: Object.assign({ code,
            inlineMath,
            math }, props.renderers), plugins: [remark_math_1.default], astPlugins: [attachment_transformer_1.default(props.attachments)].concat(props.astPlugins ? props.astPlugins : []) });
    return react_1.default.createElement(react_markdown_1.default, Object.assign({}, newProps));
};
exports.default = MarkdownRender;
