/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.plugin.search;

import java.util.Optional;
import lombok.Generated;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.knn.index.KNNSettings;
import org.opensearch.knn.index.query.KNNQueryBuilder;
import org.opensearch.search.deciders.ConcurrentSearchDecision;
import org.opensearch.search.deciders.ConcurrentSearchRequestDecider;

public class KNNConcurrentSearchRequestDecider
extends ConcurrentSearchRequestDecider {
    private static final ConcurrentSearchDecision DEFAULT_KNN_DECISION = new ConcurrentSearchDecision(ConcurrentSearchDecision.DecisionStatus.NO_OP, "Default decision");
    private static final ConcurrentSearchDecision YES = new ConcurrentSearchDecision(ConcurrentSearchDecision.DecisionStatus.YES, "Enable concurrent search for knn as Query has k-NN query in it and index is k-nn index");
    private ConcurrentSearchDecision knnDecision = DEFAULT_KNN_DECISION;

    public void evaluateForQuery(QueryBuilder queryBuilder, IndexSettings indexSettings) {
        this.knnDecision = queryBuilder instanceof KNNQueryBuilder && (Boolean)indexSettings.getValue(KNNSettings.IS_KNN_INDEX_SETTING) != false ? YES : DEFAULT_KNN_DECISION;
    }

    public ConcurrentSearchDecision getConcurrentSearchDecision() {
        return this.knnDecision;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KNNConcurrentSearchRequestDecider)) {
            return false;
        }
        KNNConcurrentSearchRequestDecider other = (KNNConcurrentSearchRequestDecider)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConcurrentSearchDecision this$knnDecision = this.knnDecision;
        ConcurrentSearchDecision other$knnDecision = other.knnDecision;
        return !(this$knnDecision == null ? other$knnDecision != null : !this$knnDecision.equals(other$knnDecision));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof KNNConcurrentSearchRequestDecider;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ConcurrentSearchDecision $knnDecision = this.knnDecision;
        result = result * 59 + ($knnDecision == null ? 43 : $knnDecision.hashCode());
        return result;
    }

    public static class Factory
    implements ConcurrentSearchRequestDecider.Factory {
        public Optional<ConcurrentSearchRequestDecider> create(IndexSettings indexSettings) {
            if (((Boolean)indexSettings.getValue(KNNSettings.IS_KNN_INDEX_SETTING)).booleanValue()) {
                return Optional.of(new KNNConcurrentSearchRequestDecider());
            }
            return Optional.empty();
        }
    }
}

