/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.tools;

import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.dataset.MLInputDataset;
import org.opensearch.ml.common.dataset.remote.RemoteInferenceInputDataSet;
import org.opensearch.ml.common.input.MLInput;
import org.opensearch.ml.common.input.remote.RemoteInferenceMLInput;
import org.opensearch.ml.common.output.model.ModelTensorOutput;
import org.opensearch.ml.common.spi.tools.Parser;
import org.opensearch.ml.common.spi.tools.Tool;
import org.opensearch.ml.common.spi.tools.ToolAnnotation;
import org.opensearch.ml.common.transport.connector.MLExecuteConnectorAction;
import org.opensearch.ml.common.transport.connector.MLExecuteConnectorRequest;
import org.opensearch.ml.common.utils.ToolUtils;
import org.opensearch.ml.engine.tools.parser.ToolParser;
import org.opensearch.transport.client.Client;

@ToolAnnotation(value="ConnectorTool")
public class ConnectorTool
implements Tool {
    @Generated
    private static final Logger log = LogManager.getLogger(ConnectorTool.class);
    public static final String TYPE = "ConnectorTool";
    public static final String CONNECTOR_ID = "connector_id";
    public static final String CONNECTOR_ACTION = "connector_action";
    private String name = "ConnectorTool";
    private Map<String, Object> attributes;
    private String description = "Invokes external service. Required: 'connector_id'. Returns: service response.";
    private String version;
    private Parser inputParser;
    private Parser outputParser;
    private Client client;
    private String connectorId;

    public ConnectorTool(Client client, String connectorId) {
        if (StringUtils.isBlank((CharSequence)connectorId)) {
            throw new IllegalArgumentException("Connector ID can't be null or empty");
        }
        this.client = client;
        this.connectorId = connectorId;
    }

    public <T> void run(Map<String, String> originalParameters, ActionListener<T> listener) {
        try {
            if (this.connectorId.isBlank()) {
                throw new IllegalArgumentException("Connector is not registered in tool");
            }
            Map parameters = ToolUtils.extractInputParameters(originalParameters, this.attributes);
            RemoteInferenceInputDataSet inputDataSet = RemoteInferenceInputDataSet.builder().parameters(parameters).build();
            MLInput mlInput = RemoteInferenceMLInput.builder().algorithm(FunctionName.CONNECTOR).inputDataset((MLInputDataset)inputDataSet).build();
            MLExecuteConnectorRequest request = new MLExecuteConnectorRequest(this.connectorId, mlInput);
            this.client.execute((ActionType)MLExecuteConnectorAction.INSTANCE, (ActionRequest)request, ActionListener.wrap(r -> {
                ModelTensorOutput modelTensorOutput = (ModelTensorOutput)r.getOutput();
                listener.onResponse(this.outputParser.parse((Object)modelTensorOutput));
            }, e -> {
                log.error("Failed to run model " + this.connectorId, (Throwable)e);
                listener.onFailure(e);
            }));
        }
        catch (Exception e2) {
            log.error("Failed to run ConnectorTool with connector: {}", (Object)this.connectorId, (Object)e2);
            listener.onFailure(e2);
        }
    }

    public String getType() {
        return TYPE;
    }

    public boolean validate(Map<String, String> parameters) {
        return parameters != null && !parameters.isEmpty();
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Generated
    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public void setInputParser(Parser inputParser) {
        this.inputParser = inputParser;
    }

    @Generated
    public void setOutputParser(Parser outputParser) {
        this.outputParser = outputParser;
    }

    public static class Factory
    implements Tool.Factory<ConnectorTool> {
        public static final String TYPE = "ConnectorTool";
        public static final String DEFAULT_DESCRIPTION = "Invokes external service. Required: 'connector_id'. Returns: service response.";
        private Client client;
        private static Factory INSTANCE;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Factory getInstance() {
            if (INSTANCE != null) {
                return INSTANCE;
            }
            Class<ConnectorTool> clazz = ConnectorTool.class;
            synchronized (ConnectorTool.class) {
                if (INSTANCE != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return INSTANCE;
                }
                INSTANCE = new Factory();
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCE;
            }
        }

        public void init(Client client) {
            this.client = client;
        }

        public ConnectorTool create(Map<String, Object> params) {
            ConnectorTool connectorTool = new ConnectorTool(this.client, (String)params.get(ConnectorTool.CONNECTOR_ID));
            connectorTool.setOutputParser(ToolParser.createFromToolParams(params));
            return connectorTool;
        }

        public String getDefaultDescription() {
            return DEFAULT_DESCRIPTION;
        }

        public String getDefaultType() {
            return "ConnectorTool";
        }

        public String getDefaultVersion() {
            return null;
        }
    }
}

