/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.ui.IconManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogParentFilter;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogIcons;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.filter.NoMergesFilterAction;
import com.intellij.vcs.log.ui.filter.ParentFilterModel;
import com.intellij.vcs.log.util.BekUtil;
import com.intellij.vcs.log.util.GraphOptionsUtil;
import com.intellij.vcs.log.visible.filters.VcsLogParentFilterImplKt;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class VcsLogGraphOptionsChooserGroup
extends DefaultActionGroup
implements DumbAware {
    @NotNull
    private final ParentFilterModel myParentFilterModel;

    public VcsLogGraphOptionsChooserGroup(@NotNull ParentFilterModel parentFilterModel) {
        if (parentFilterModel == null) {
            VcsLogGraphOptionsChooserGroup.$$$reportNull$$$0(0);
        }
        super(VcsLogBundle.message("group.Vcs.Log.GraphOptionsGroup.text", new Object[0]), VcsLogBundle.message("group.Vcs.Log.GraphOptionsGroup.description", new Object[0]), VcsLogIcons.IntelliSort);
        this.myParentFilterModel = parentFilterModel;
        this.setPopup(true);
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        if (e == null) {
            if (EMPTY_ARRAY == null) {
                VcsLogGraphOptionsChooserGroup.$$$reportNull$$$0(1);
            }
            return EMPTY_ARRAY;
        }
        VcsLogUi logUI = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        if (logUI == null) {
            if (EMPTY_ARRAY == null) {
                VcsLogGraphOptionsChooserGroup.$$$reportNull$$$0(2);
            }
            return EMPTY_ARRAY;
        }
        VcsLogUiProperties properties = (VcsLogUiProperties)e.getData(VcsLogInternalDataKeys.LOG_UI_PROPERTIES);
        if (properties == null) {
            if (EMPTY_ARRAY == null) {
                VcsLogGraphOptionsChooserGroup.$$$reportNull$$$0(3);
            }
            return EMPTY_ARRAY;
        }
        List<PermanentGraph.SortType> sortTypes = VcsLogGraphOptionsChooserGroup.getAvailableSortTypes();
        ArrayList<Object> actions2 = new ArrayList<Object>();
        actions2.add(Separator.create((String)VcsLogBundle.message("action.vcs.log.sort.type.separator", new Object[0])));
        actions2.addAll(ContainerUtil.map(sortTypes, sortType -> new SelectOptionsAction(logUI, properties, (PermanentGraph.Options)new PermanentGraph.Options.Base(sortType))));
        actions2.add(Separator.create((String)VcsLogBundle.message("action.vcs.log.graph.options.separator", new Object[0])));
        if (BekUtil.isLinearBekEnabled()) {
            actions2.add((Object)new SelectNonBaseOptionsAction(logUI, properties, (PermanentGraph.Options)PermanentGraph.Options.LinearBek.INSTANCE));
        }
        actions2.add((Object)new SelectNonBaseOptionsAction(logUI, properties, (PermanentGraph.Options)PermanentGraph.Options.FirstParent.INSTANCE));
        actions2.add((Object)new NoMergesFilterAction(this.myParentFilterModel));
        actions2.add(ActionManager.getInstance().getAction("Vcs.Log.BranchActionsGroup"));
        AnAction[] anActionArray = actions2.toArray(EMPTY_ARRAY);
        if (anActionArray == null) {
            VcsLogGraphOptionsChooserGroup.$$$reportNull$$$0(4);
        }
        return anActionArray;
    }

    public void update(@NotNull AnActionEvent e) {
        Icon icon;
        VcsLogUiProperties properties;
        if (e == null) {
            VcsLogGraphOptionsChooserGroup.$$$reportNull$$$0(5);
        }
        boolean isEnabled = (properties = (VcsLogUiProperties)e.getData(VcsLogInternalDataKeys.LOG_UI_PROPERTIES)) != null && properties.exists(MainVcsLogUiProperties.GRAPH_OPTIONS);
        e.getPresentation().setEnabled(isEnabled);
        if (isEnabled && (icon = this.getTemplatePresentation().getIcon()) != null) {
            if (this.hasNonDefaultOptions(properties)) {
                e.getPresentation().setIcon(IconManager.getInstance().withIconBadge(icon, (Paint)JBUI.CurrentTheme.IconBadge.SUCCESS));
            } else {
                e.getPresentation().setIcon(icon);
            }
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            VcsLogGraphOptionsChooserGroup.$$$reportNull$$$0(6);
        }
        return actionUpdateThread;
    }

    private boolean hasNonDefaultOptions(@NotNull VcsLogUiProperties properties) {
        VcsLogParentFilter parentFilter;
        if (properties == null) {
            VcsLogGraphOptionsChooserGroup.$$$reportNull$$$0(7);
        }
        if ((parentFilter = (VcsLogParentFilter)this.myParentFilterModel.getFilter()) != null && !VcsLogParentFilterImplKt.getMatchesAll(parentFilter)) {
            return true;
        }
        PermanentGraph.Options options = properties.get(MainVcsLogUiProperties.GRAPH_OPTIONS);
        return !PermanentGraph.Options.Default.equals((Object)options);
    }

    @NotNull
    private static List<PermanentGraph.SortType> getAvailableSortTypes() {
        ArrayList<PermanentGraph.SortType> sortTypes = new ArrayList<PermanentGraph.SortType>((Collection<PermanentGraph.SortType>)PermanentGraph.SortType.getEntries());
        if (!BekUtil.isBekEnabled()) {
            sortTypes.remove(PermanentGraph.SortType.Bek);
        }
        ArrayList<PermanentGraph.SortType> arrayList = sortTypes;
        if (arrayList == null) {
            VcsLogGraphOptionsChooserGroup.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentFilterModel";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/filter/VcsLogGraphOptionsChooserGroup";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/filter/VcsLogGraphOptionsChooserGroup";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableSortTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hasNonDefaultOptions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 6, 8 -> new IllegalStateException(string);
        };
    }

    private static class SelectNonBaseOptionsAction
    extends SelectOptionsAction {
        SelectNonBaseOptionsAction(@NotNull VcsLogUi ui, @NotNull VcsLogUiProperties properties, @NotNull PermanentGraph.Options options) {
            if (ui == null) {
                SelectNonBaseOptionsAction.$$$reportNull$$$0(0);
            }
            if (properties == null) {
                SelectNonBaseOptionsAction.$$$reportNull$$$0(1);
            }
            if (options == null) {
                SelectNonBaseOptionsAction.$$$reportNull$$$0(2);
            }
            super(ui, properties, options);
        }

        @Override
        @NotNull
        protected PermanentGraph.Options getOptionsToSet(boolean state) {
            Object object = state ? this.myGraphOptions : PermanentGraph.Options.Default;
            if (object == null) {
                SelectNonBaseOptionsAction.$$$reportNull$$$0(3);
            }
            return object;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ui";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "properties";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/filter/VcsLogGraphOptionsChooserGroup$SelectNonBaseOptionsAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/filter/VcsLogGraphOptionsChooserGroup$SelectNonBaseOptionsAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOptionsToSet";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class SelectOptionsAction
    extends ToggleAction
    implements DumbAware {
        protected final PermanentGraph.Options myGraphOptions;
        private final VcsLogUi myUI;
        private final VcsLogUiProperties myProperties;

        SelectOptionsAction(@NotNull VcsLogUi ui, @NotNull VcsLogUiProperties properties, @NotNull PermanentGraph.Options options) {
            if (ui == null) {
                SelectOptionsAction.$$$reportNull$$$0(0);
            }
            if (properties == null) {
                SelectOptionsAction.$$$reportNull$$$0(1);
            }
            if (options == null) {
                SelectOptionsAction.$$$reportNull$$$0(2);
            }
            super(() -> GraphOptionsUtil.getLocalizedName(options), () -> GraphOptionsUtil.getLocalizedDescription(options) + ".", null);
            this.myUI = ui;
            this.myProperties = properties;
            this.myGraphOptions = options;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SelectOptionsAction.$$$reportNull$$$0(3);
            }
            super.update(e);
            e.getPresentation().setEnabled(!this.myUI.getDataPack().isEmpty() && this.myProperties.exists(MainVcsLogUiProperties.GRAPH_OPTIONS));
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                SelectOptionsAction.$$$reportNull$$$0(4);
            }
            return this.myProperties.exists(MainVcsLogUiProperties.GRAPH_OPTIONS) && this.myProperties.get(MainVcsLogUiProperties.GRAPH_OPTIONS).equals(this.myGraphOptions);
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                SelectOptionsAction.$$$reportNull$$$0(5);
            }
            if (this.myProperties.exists(MainVcsLogUiProperties.GRAPH_OPTIONS)) {
                this.myProperties.set(MainVcsLogUiProperties.GRAPH_OPTIONS, this.getOptionsToSet(state));
            }
        }

        @NotNull
        protected PermanentGraph.Options getOptionsToSet(boolean state) {
            PermanentGraph.Options options = this.myGraphOptions;
            if (options == null) {
                SelectOptionsAction.$$$reportNull$$$0(6);
            }
            return options;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                SelectOptionsAction.$$$reportNull$$$0(7);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ui";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "properties";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/filter/VcsLogGraphOptionsChooserGroup$SelectOptionsAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/filter/VcsLogGraphOptionsChooserGroup$SelectOptionsAction";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOptionsToSet";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
                case 6: 
                case 7: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6, 7 -> new IllegalStateException(string);
            };
        }
    }
}

